/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeNest;
import com.powyin.scroll.widget.SwipeRefresh;

public class LoadProgressBar
extends View {
    private ValueAnimator animator;
    private Paint circlePaint = new Paint();
    private boolean mAttach = false;
    private int canvasWei;
    private int canvasHei;
    private final int ballCount = 12;
    private float divide;
    private int mVisibility = 0;

    public LoadProgressBar(Context context) {
        this(context, null);
    }

    public LoadProgressBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadProgressBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.circlePaint.setColor(-2046820353);
        this.circlePaint.setStrokeWidth(4.0f);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float scale = this.getContext().getResources().getDisplayMetrics().density;
        int target = (int)(40.0f * scale + 0.5f);
        this.setMeasuredDimension(this.getMeasuredWidth(), target);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        for (int i = 0; i < 12; ++i) {
            float wei = 4.0f * (1.0f * (float)i / 12.0f - 0.5f) + this.divide;
            wei = (float)(this.canvasWei / 2) + this.getSplit(wei) * (float)this.canvasWei * 0.08f;
            canvas.drawCircle(wei, (float)(this.canvasHei / 2), 8.0f, this.circlePaint);
        }
    }

    public void ensureAnimation(boolean forceReStart) {
        if (forceReStart) {
            if (this.animator != null) {
                this.animator.cancel();
                this.animator = null;
            }
        } else if (this.animator != null && this.animator.isStarted()) {
            return;
        }
        this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        this.animator.setDuration(2000L);
        this.animator.setRepeatCount(1);
        this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                LoadProgressBar.this.divide = (float)(8L * (System.currentTimeMillis() % 3000L - 1500L)) / 3000.0f;
                LoadProgressBar.this.invalidate();
            }
        });
        this.animator.addListener(new Animator.AnimatorListener(){
            boolean isDeprecated = false;

            public void onAnimationStart(Animator animation) {
            }

            public void onAnimationEnd(Animator animation) {
                ViewParent parent;
                if (this.isDeprecated || !LoadProgressBar.this.mAttach || LoadProgressBar.this.animator != animation || LoadProgressBar.this.mVisibility == 4 || LoadProgressBar.this.mVisibility == 8) {
                    return;
                }
                this.isDeprecated = true;
                for (parent = LoadProgressBar.this.getParent(); parent != null && !(parent instanceof ISwipe); parent = parent.getParent()) {
                }
                if (parent instanceof SwipeNest) {
                    SwipeNest swipeNest = (SwipeNest)parent;
                    if (swipeNest.getScrollY() > swipeNest.computeVerticalScrollRange() - swipeNest.computeVerticalScrollExtent()) {
                        LoadProgressBar.this.ensureAnimation(true);
                    }
                    return;
                }
                if (parent instanceof SwipeRefresh && ((SwipeRefresh)parent).getScrollY() > 0) {
                    LoadProgressBar.this.ensureAnimation(true);
                }
            }

            public void onAnimationCancel(Animator animation) {
            }

            public void onAnimationRepeat(Animator animation) {
            }
        });
        this.animator.start();
    }

    protected void onVisibilityChanged(@NonNull View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        this.mVisibility = visibility;
        if ((visibility == 8 || visibility == 4) && this.animator != null) {
            this.animator.cancel();
            this.animator = null;
        }
        if (visibility == 0) {
            this.ensureAnimation(false);
        }
    }

    private float getSplit(float value) {
        int positive = value >= 0.0f ? 1 : -1;
        if ((value = Math.abs(value)) <= 1.0f) {
            return value * (float)positive;
        }
        return (float)Math.pow(value, 2.0) * (float)positive;
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttach = true;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttach = false;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.canvasWei = right - left;
        this.canvasHei = bottom - top;
        this.ensureAnimation(false);
    }
}

