/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ScrollingView;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.NestedScrollView;
import android.support.v4.widget.ScrollerCompat;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ListView;
import android.widget.ScrollView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.EmptyController;
import com.powyin.scroll.widget.ISwipe;
import com.powyin.scroll.widget.SwipeController;
import com.powyin.scroll.widget.SwipeControllerStyleNormal;

public class SwipeNest
extends ViewGroup
implements NestedScrollingParent,
ISwipe,
ScrollingView {
    private int mTouchSlop;
    private int mActivePointerId = -1;
    private boolean mNestedScrollInProgress = false;
    private float mDragBeginY;
    private float mDragBeginDirect;
    private float mDragLastY;
    private boolean mIsTouchEventMode = false;
    private boolean mPreScroll;
    private boolean mDraggedDispatch;
    private boolean mDraggedIntercept;
    private boolean mShouldCancelMotionEvent = false;
    private int contentScroll;
    private int overScrollTop;
    private int overScrollBottom;
    private ScrollerCompat mScroller;
    private VelocityTracker mVelocityTracker;
    private SwipeController mSwipeController;
    private EmptyController mEmptyController;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private NestedScrollingParentHelper mParentHelper;
    private boolean mRefreshStatusContinueRunning = false;
    private ISwipe.FreshStatus mFreshStatus = ISwipe.FreshStatus.CONTINUE;
    private boolean mLoadedStatusContinueRunning = false;
    private ISwipe.LoadedStatus mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
    private SwipeController.SwipeModel mModel = SwipeController.SwipeModel.SWIPE_BOTH;
    private ISwipe.OnRefreshListener mOnRefreshListener;
    private boolean mShowEmptyView;
    private int mEmptyViewIndex;
    private View mViewTop;
    private View mViewBottom;
    private View mTargetView;
    private View mEmptyView;
    private View mEmptyReplaceView;

    public SwipeNest(Context context) {
        this(context, null);
    }

    public SwipeNest(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeNest(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeNest);
            int modelIndex = a.getInt(R.styleable.SwipeNest_fresh, -1);
            if (modelIndex >= 0 && modelIndex < SwipeController.SwipeModel.values().length) {
                this.mModel = SwipeController.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.mScroller = ScrollerCompat.create((Context)this.getContext(), null);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        this.initSwipeControl();
    }

    private void initSwipeControl() {
        this.mSwipeController = new SwipeControllerStyleNormal(this.getContext());
        this.mViewTop = this.mSwipeController.getSwipeHead();
        this.mViewBottom = this.mSwipeController.getSwipeFoot();
        this.addView(this.mViewTop, 0);
        this.addView(this.mViewBottom, this.getChildCount());
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        if (!(target == this.mEmptyView || target == this.mEmptyReplaceView && this.mShowEmptyView)) {
            this.mTargetView = target;
        }
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetScroll(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetScroll(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        boolean consume;
        Integer but = this.mTargetView != null ? (Integer)this.mTargetView.getTag(0x40000000) : null;
        if ((but = Integer.valueOf(but == null ? Integer.MAX_VALUE : but)) > this.getScrollY()) {
            this.fling((int)velocityY);
            return true;
        }
        boolean bl = consume = !(velocityY > 0.0f && this.canChildScrollUp() || velocityY < 0.0f && this.canChildScrollDown());
        if (consume) {
            this.fling((int)velocityY);
        }
        return consume;
    }

    private void fling(int velocityY) {
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            return;
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            return;
        }
        int scrollY = this.getScrollY();
        if (scrollY < 0 || scrollY > this.contentScroll) {
            return;
        }
        velocityY = (int)((float)velocityY * 0.5f);
        this.mScroller.fling(0, scrollY, 0, velocityY, 0, 0, 0, this.contentScroll, 0, 0);
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    public int computeHorizontalScrollRange() {
        return this.getWidth();
    }

    public int computeHorizontalScrollOffset() {
        return 0;
    }

    public int computeHorizontalScrollExtent() {
        return this.getWidth();
    }

    public int computeVerticalScrollRange() {
        return this.contentScroll + this.getHeight();
    }

    public int computeVerticalScrollOffset() {
        return this.getScrollY();
    }

    public int computeVerticalScrollExtent() {
        return this.getHeight();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        System.out.println("--------------------------------begin onMeasure");
        int widthTarget = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightTarget = View.MeasureSpec.getSize((int)heightMeasureSpec);
        int childWidMeasure = View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000);
        int spHei = View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)Integer.MIN_VALUE);
        int mTotalLength = 0;
        int normalIndex = 0;
        int childCount = this.getChildCount();
        this.mEmptyReplaceView = null;
        for (int i = 0; i < childCount; ++i) {
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
            if (child.getVisibility() != 8) {
                ViewGroup.LayoutParams lp = child.getLayoutParams();
                switch (lp.height) {
                    case -2: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0));
                        break;
                    }
                    case -1: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)heightTarget, (int)0x40000000));
                        break;
                    }
                    default: {
                        child.measure(childWidMeasure, View.MeasureSpec.makeMeasureSpec((int)lp.height, (int)0x40000000));
                    }
                }
                int childMeasureHei = child.getMeasuredHeight();
                childMeasureHei = childMeasureHei > 0 ? childMeasureHei : 0;
                mTotalLength += childMeasureHei;
                if (this.mEmptyViewIndex == normalIndex && this.mEmptyView != null) {
                    System.out.println("--------------------------------begin onMeasure  xx  " + childMeasureHei + "    " + heightTarget);
                    if (normalIndex == childCount - 3) {
                        childMeasureHei = heightTarget > mTotalLength ? childMeasureHei + (heightTarget - mTotalLength) : childMeasureHei;
                    }
                    this.mEmptyView.measure(View.MeasureSpec.makeMeasureSpec((int)widthTarget, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)childMeasureHei, (int)0x40000000));
                    this.mEmptyReplaceView = child;
                    System.out.println("--------------------------------begin onMeasure  find mEmptyReplaceView  " + this.mEmptyReplaceView);
                }
            }
            ++normalIndex;
        }
        if (this.mViewTop != null) {
            this.mViewTop.measure(childWidMeasure, spHei);
        }
        if (this.mViewBottom != null) {
            this.mViewBottom.measure(childWidMeasure, spHei);
        }
        if (this.mEmptyReplaceView == null && this.mEmptyView != null) {
            this.mEmptyView.measure(childWidMeasure, spHei);
        }
        int endHei = Math.max(mTotalLength, this.getSuggestedMinimumHeight());
        int endWid = Math.max(widthTarget, this.getSuggestedMinimumWidth());
        this.setMeasuredDimension(SwipeNest.resolveSizeAndState((int)endWid, (int)widthMeasureSpec, (int)0), SwipeNest.resolveSizeAndState((int)endHei, (int)heightMeasureSpec, (int)0));
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int currentHei = 0;
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            if (child == this.mViewTop || child == this.mViewBottom || child.getVisibility() == 8) continue;
            int itemHei = child.getMeasuredHeight();
            if (child == this.mEmptyReplaceView && this.mShowEmptyView) {
                child.layout(r - l, currentHei, 2 * (r - l), currentHei + itemHei);
                child.setTag(0x40000000, (Object)((currentHei += itemHei) - (b - t)));
                continue;
            }
            if (child == this.mEmptyView) {
                if (this.mShowEmptyView) {
                    child.layout(0, currentHei, r - l, currentHei + itemHei);
                    continue;
                }
                child.layout(r - l, currentHei, 2 * (r - l), currentHei + itemHei);
                continue;
            }
            child.layout(0, currentHei, r - l, currentHei + itemHei);
            child.setTag(0x40000000, (Object)((currentHei += itemHei) - (b - t)));
        }
        boolean canOverScrollBottom = currentHei >= b - t;
        this.contentScroll = canOverScrollBottom ? currentHei - (b - t) : 0;
        System.out.println("                   on layout " + this.contentScroll);
        this.overScrollTop = this.mViewTop.getMeasuredHeight();
        this.overScrollBottom = this.mViewBottom.getMeasuredHeight();
        this.mViewTop.layout(0, -this.overScrollTop, r - l, 0);
        this.mViewTop.setTag(0x40000000, (Object)0);
        this.mViewBottom.layout(0, b - t + this.contentScroll, r - l, b - t + this.contentScroll + this.overScrollBottom);
        this.mViewTop.setTag(0x40000000, (Object)(this.contentScroll + this.overScrollBottom));
        if (this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.overScrollTop = 0;
        }
        if (!canOverScrollBottom || this.mModel == SwipeController.SwipeModel.SWIPE_NONE || this.mModel == SwipeController.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.overScrollBottom = 0;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mDraggedIntercept = false;
            this.mPreScroll = false;
            this.mDraggedDispatch = false;
            this.mActivePointerId = ev.getPointerId(0);
            this.mDragBeginY = (int)ev.getY();
            this.mDragBeginDirect = 0.0f;
            this.mIsTouchEventMode = true;
            this.mDragLastY = this.mDragBeginY;
            this.mShouldCancelMotionEvent = false;
            this.mTargetView = null;
            int x = (int)ev.getX();
            int y = (int)ev.getY();
            for (int i = 0; i < this.getChildCount(); ++i) {
                boolean isSelect;
                int scrollY = this.getScrollY();
                View child = this.getChildAt(i);
                if (child == this.mViewTop || child == this.mViewBottom || child == this.mEmptyView) continue;
                boolean bl = isSelect = y >= child.getTop() - scrollY && y < child.getBottom() - scrollY && x >= child.getLeft() && x < child.getRight();
                if (!isSelect) continue;
                if (child == this.mEmptyReplaceView) break;
                this.mTargetView = child;
                break;
            }
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (ev.getAction() == 0 && (this.getScrollY() < 0 || this.getScrollY() > this.contentScroll)) {
            this.mPreScroll = true;
        }
        if (this.mPreScroll) {
            int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 5: {
                    int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                    this.mActivePointerId = ev.getPointerId(pointerIndex);
                    this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    break;
                }
                case 2: {
                    float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                    float yDiff = this.mDragBeginY - y;
                    if (!this.mDraggedDispatch && Math.abs(yDiff) > (float)(this.mTouchSlop / 2)) {
                        this.mDraggedDispatch = true;
                        this.mDragLastY = y;
                    }
                    if (!this.mDraggedDispatch) break;
                    this.offSetScroll((int)(this.mDragLastY - y), true);
                    if (this.getScrollY() == 0) {
                        this.mPreScroll = false;
                    }
                    this.mDragLastY = y;
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish() || this.mDraggedDispatch || this.mDraggedIntercept || this.mShouldCancelMotionEvent)) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mNestedScrollInProgress || !this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp()) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                if (!this.mScroller.computeScrollOffset() || this.mScroller.isFinished()) break;
                this.mScroller.abortAnimation();
                this.mShouldCancelMotionEvent = true;
                break;
            }
            case 5: {
                int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                float yDiff = this.mDragBeginY - y;
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mDraggedIntercept || !(yDiff > 0.0f && !this.canChildScrollUp()) && (!(yDiff < 0.0f) || this.canChildScrollDown())) break;
                this.mDraggedIntercept = true;
                this.mDragLastY = y;
                this.mDragBeginDirect = -yDiff;
                if (this.mVelocityTracker == null) {
                    this.mVelocityTracker = VelocityTracker.obtain();
                } else {
                    this.mVelocityTracker.clear();
                }
                this.mVelocityTracker.addMovement(ev);
                ViewParent parent = this.getParent();
                if (parent == null) break;
                parent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mVelocityTracker == null) break;
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
        }
        return this.mDraggedIntercept;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = ev.getPointerId(0);
                this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                if (this.mScroller.computeScrollOffset() && !this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                    this.mShouldCancelMotionEvent = true;
                }
                this.mDragLastY = (int)ev.getY();
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                this.mActivePointerId = ev.getPointerId(pointerIndex);
                this.mDragLastY = this.mDragBeginY = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                break;
            }
            case 2: {
                float y = ev.getY(ev.findPointerIndex(this.mActivePointerId));
                int deltaY = (int)this.mDragBeginY - (int)y;
                if (!this.mDraggedIntercept && Math.abs(deltaY) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mDraggedIntercept = true;
                    this.mDragBeginDirect = -deltaY;
                    if (this.mVelocityTracker == null) {
                        this.mVelocityTracker = VelocityTracker.obtain();
                    } else {
                        this.mVelocityTracker.clear();
                    }
                    this.mVelocityTracker.addMovement(ev);
                }
                if (!this.mDraggedIntercept) break;
                this.offSetScroll((int)(this.mDragLastY - y), false);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                if (this.mDraggedIntercept && this.mVelocityTracker != null) {
                    this.mVelocityTracker.computeCurrentVelocity(1000, 6000.0f);
                    this.mVelocityTracker.getYVelocity();
                    int initialVelocity = (int)this.mVelocityTracker.getYVelocity();
                    this.fling(-initialVelocity);
                }
                if (this.mVelocityTracker != null) {
                    this.mVelocityTracker.recycle();
                    this.mVelocityTracker = null;
                }
                return true;
            }
        }
        pointerIndex = ev.findPointerIndex(this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mDragLastY = ev.getY(pointerIndex);
        }
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.addMovement(ev);
        }
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept && this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    public void computeScroll() {
        int y;
        int oldY;
        if (this.mScroller.computeScrollOffset() && !this.mScroller.isFinished() && (oldY = this.getScrollY()) != (y = this.mScroller.getCurrY())) {
            this.scrollTo(0, y);
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mDragLastY = (int)ev.getY(newPointerIndex);
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private boolean canChildScrollDown() {
        return this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)-1);
    }

    private boolean canChildScrollUp() {
        return this.mTargetView != null && ViewCompat.canScrollVertically((View)this.mTargetView, (int)1);
    }

    private int offSetScroll(int deltaOriginY, boolean pre) {
        int middleHei;
        boolean progress;
        int currentScrollY = this.getScrollY();
        boolean bl = progress = !pre;
        if (pre) {
            if (currentScrollY < 0) {
                progress = true;
            } else if (currentScrollY > this.contentScroll) {
                progress = true;
            } else {
                Integer scroll = this.mTargetView != null ? (Integer)this.mTargetView.getTag(0x40000000) : null;
                if (currentScrollY < (scroll = Integer.valueOf(scroll == null ? Integer.MAX_VALUE : scroll))) {
                    progress = true;
                }
                if (currentScrollY == scroll) {
                    progress = false;
                }
                if (currentScrollY > scroll) {
                    boolean bl2 = progress = !(deltaOriginY > 0 && this.canChildScrollUp() || deltaOriginY < 0 && this.canChildScrollDown());
                }
            }
        }
        if (!progress) {
            return 0;
        }
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int n = middleHei = -this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeController.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeController.getOverScrollHei(), 2.0));
        }
        int willTo = currentScrollY + deltaY;
        willTo = Math.min(willTo, this.overScrollBottom + this.contentScroll);
        willTo = Math.max(willTo, -this.overScrollTop);
        Integer maxScroll = this.mTargetView != null ? (Integer)this.mTargetView.getTag(0x40000000) : null;
        if (currentScrollY > (maxScroll = Integer.valueOf(maxScroll == null ? Integer.MAX_VALUE : maxScroll)) && willTo < maxScroll || currentScrollY < maxScroll && willTo > maxScroll) {
            willTo = maxScroll;
        }
        if (this.mDragBeginDirect > 0.0f && willTo > this.contentScroll) {
            willTo = this.contentScroll;
        }
        if (this.mDragBeginDirect < 0.0f && willTo < 0) {
            willTo = 0;
        }
        if (willTo == currentScrollY) {
            return deltaOriginY;
        }
        this.scrollTo(0, willTo);
        if (!(0 <= willTo || willTo <= middleHei || this.mFreshStatus != ISwipe.FreshStatus.ERROR && this.mFreshStatus != ISwipe.FreshStatus.ERROR_NET && this.mFreshStatus != ISwipe.FreshStatus.SUCCESS || this.mRefreshStatusContinueRunning)) {
            this.mFreshStatus = ISwipe.FreshStatus.CONTINUE;
            if (this.mEmptyController != null) {
                this.mEmptyController.onSwipeStatue(this.mFreshStatus);
            }
        }
        if (0 > willTo) {
            int swipeViewVisibilityHei = 0 - willTo;
            switch (this.mFreshStatus) {
                case CONTINUE: {
                    if (this.mRefreshStatusContinueRunning) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    if (willTo < middleHei) {
                        this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mViewTop.getHeight());
                        break;
                    }
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    break;
                }
                case SUCCESS: {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    break;
                }
                case ERROR: {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, swipeViewVisibilityHei, this.mViewTop.getHeight());
                    break;
                }
                case ERROR_NET: {
                    this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, swipeViewVisibilityHei, this.mViewTop.getHeight());
                }
            }
        }
        if (willTo > this.contentScroll && !this.mLoadedStatusContinueRunning) {
            this.mLoadedStatusContinueRunning = true;
            if (this.mOnRefreshListener != null) {
                this.mOnRefreshListener.onLoading();
            }
        }
        if (willTo > this.contentScroll) {
            if (this.mLoadedStatus == ISwipe.LoadedStatus.NO_MORE) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, willTo - this.contentScroll, this.mViewBottom.getHeight());
            } else if (this.mLoadedStatus == ISwipe.LoadedStatus.ERROR) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, willTo - this.contentScroll, this.mViewBottom.getHeight());
            } else if (this.mLoadedStatus == ISwipe.LoadedStatus.CONTINUE) {
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, willTo - this.contentScroll, this.mViewBottom.getHeight());
            }
        }
        return deltaOriginY;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mFreshStatus == ISwipe.FreshStatus.SUCCESS || this.mFreshStatus == ISwipe.FreshStatus.ERROR || this.mFreshStatus == ISwipe.FreshStatus.ERROR_NET) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.stopAllScroll();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeNest.this.getScrollY()) {
                        SwipeNest.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        switch (SwipeNest.this.mFreshStatus) {
                            case CONTINUE: {
                                SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, SwipeNest.this.mViewTop.getHeight(), SwipeNest.this.mViewTop.getHeight());
                            }
                        }
                        if (!SwipeNest.this.mRefreshStatusContinueRunning) {
                            SwipeNest.this.mRefreshStatusContinueRunning = true;
                            if (SwipeNest.this.mOnRefreshListener != null) {
                                SwipeNest.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(550 * (middleHei - scrollY) / this.mViewTop.getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.overScrollTop != 0 ? -this.overScrollTop + this.mSwipeController.getOverScrollHei() : 0;
        if (this.mFreshStatus == ISwipe.FreshStatus.CONTINUE && scrollY == middleHei) {
            return false;
        }
        if (scrollY < 0) {
            this.stopAllScroll();
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeNest.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.addListener(new Animator.AnimatorListener(){
                boolean isCancel;

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_TOAST, 0, SwipeNest.this.mViewTop.getHeight());
                    }
                    this.isCancel = true;
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(550 * (0 - scrollY) / this.mViewTop.getHeight()));
                this.animationReBackToTop.setStartDelay(650L);
            } else {
                this.animationReBackToTop.setDuration(320L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
        if (this.mScroller != null) {
            this.mScroller.abortAnimation();
        }
    }

    @Override
    public void setOnRefreshListener(ISwipe.OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    @Override
    public void setFreshStatue(ISwipe.FreshStatus statue) {
        switch (statue) {
            case CONTINUE: {
                this.mFreshStatus = ISwipe.FreshStatus.CONTINUE;
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.mRefreshStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                this.mLoadedStatusContinueRunning = false;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onRefresh();
                }
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_LOADING, -this.getScrollY(), this.mViewTop.getHeight());
                this.tryBackToRefreshing();
                break;
            }
            case SUCCESS: {
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.SUCCESS;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_OK, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR_NET: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.ERROR_NET;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR_NET, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
                break;
            }
            case ERROR: {
                if (this.mEmptyController != null) {
                    this.mEmptyController.onSwipeStatue(this.mFreshStatus);
                }
                this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        SwipeNest.this.mFreshStatus = ISwipe.FreshStatus.ERROR;
                        if (SwipeNest.this.mEmptyController != null) {
                            SwipeNest.this.mEmptyController.onSwipeStatue(SwipeNest.this.mFreshStatus);
                        }
                        SwipeNest.this.mRefreshStatusContinueRunning = false;
                        SwipeNest.this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                        SwipeNest.this.mLoadedStatusContinueRunning = false;
                        SwipeNest.this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_HEAD_COMPLETE_ERROR, -SwipeNest.this.getScrollY(), SwipeNest.this.mViewTop.getHeight());
                        SwipeNest.this.tryBackToFreshFinish();
                    }
                }, 1000L);
            }
        }
    }

    @Override
    public void setLoadMoreStatus(ISwipe.LoadedStatus status) {
        switch (status) {
            case CONTINUE: {
                int currentScrollY = this.getScrollY() - this.contentScroll;
                if (currentScrollY > 0) {
                    if (this.mTargetView instanceof RecyclerView || this.mTargetView instanceof ListView || this.mTargetView instanceof ScrollView || this.mTargetView instanceof NestedScrollView) {
                        this.mTargetView.scrollBy(0, currentScrollY);
                    }
                    this.stopAllScroll();
                    this.scrollTo(0, this.contentScroll);
                }
                this.mLoadedStatusContinueRunning = false;
                this.mLoadedStatus = ISwipe.LoadedStatus.CONTINUE;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_LOADING, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case ERROR: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.ERROR;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_ERROR, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
                break;
            }
            case NO_MORE: {
                this.mLoadedStatusContinueRunning = true;
                this.mLoadedStatus = ISwipe.LoadedStatus.NO_MORE;
                this.mSwipeController.onSwipeStatue(SwipeController.SwipeStatus.SWIPE_LOAD_NO_MORE, this.getHeight() - this.mViewBottom.getTop(), this.mViewBottom.getHeight());
            }
        }
    }

    @Override
    public void setSwipeModel(SwipeController.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    @Override
    public void setSwipeController(SwipeController control) {
        if (control != null && this.mSwipeController != control) {
            this.removeView(this.mViewTop);
            this.removeView(this.mViewBottom);
            this.mSwipeController = control;
            this.mViewTop = this.mSwipeController.getSwipeHead();
            this.mViewBottom = this.mSwipeController.getSwipeFoot();
            this.addView(this.mViewTop);
            this.addView(this.mViewBottom);
            this.requestLayout();
        }
    }

    @Override
    public void setEmptyController(EmptyController controller) {
        if (controller != null && this.mEmptyController != controller) {
            this.mEmptyController = controller;
            if (this.mEmptyView != null) {
                this.removeView(this.mEmptyView);
            }
            this.mEmptyView = controller.getView();
            this.mEmptyViewIndex = controller.attachToViewIndex();
            this.addView(this.mEmptyView);
            this.requestLayout();
        }
    }

    @Override
    public void enableEmptyView(boolean show) {
        if (this.mShowEmptyView != show) {
            this.mShowEmptyView = show;
            this.requestLayout();
            if (this.mEmptyReplaceView == this.mTargetView && this.mShowEmptyView) {
                this.mTargetView = null;
            }
        }
    }
}

