/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.app.Activity;
import android.view.View;
import android.view.ViewGroup;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.MultipleListAdapter;
import com.powyin.scroll.adapter.MultipleRecycleAdapter;
import com.powyin.scroll.adapter.RecycleViewHolder;
import java.lang.reflect.Field;

public abstract class PowViewHolder<T> {
    final RecycleViewHolder<T> mViewHolder;
    public final View mItemView;
    protected final Activity mActivity;
    public T mData;
    MultipleRecycleAdapter<T> mMultipleAdapter;
    MultipleListAdapter<T> mMultipleListAdapter;
    private int mRegisterMainItemClickStatus = 0;
    private int mRegisterMainItemLongClickStatus = 0;
    private final View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            AdapterDelegate.OnItemClickListener onItemClickListener;
            int index;
            if (PowViewHolder.this.mMultipleAdapter != null && PowViewHolder.this.mMultipleAdapter.mOnItemClickListener != null) {
                index = PowViewHolder.this.mViewHolder.getAdapterPosition();
                if (PowViewHolder.this.mMultipleAdapter.mHasHead) {
                    --index;
                }
                onItemClickListener = PowViewHolder.this.mMultipleAdapter.mOnItemClickListener;
                if (index >= 0 && index < PowViewHolder.this.mMultipleAdapter.mDataList.size()) {
                    onItemClickListener.onClick(PowViewHolder.this, PowViewHolder.this.mData, index, v.getId());
                }
            }
            if (PowViewHolder.this.mMultipleListAdapter != null && PowViewHolder.this.mMultipleListAdapter.mOnItemClickListener != null) {
                index = PowViewHolder.this.mViewHolder.getAdapterPosition();
                if (PowViewHolder.this.mMultipleListAdapter.mHasHead) {
                    --index;
                }
                onItemClickListener = PowViewHolder.this.mMultipleListAdapter.mOnItemClickListener;
                if (index >= 0 && index < PowViewHolder.this.mMultipleListAdapter.mDataList.size()) {
                    onItemClickListener.onClick(PowViewHolder.this, PowViewHolder.this.mData, index, v.getId());
                }
            }
        }
    };
    private final View.OnLongClickListener mOnLongClickListener = new View.OnLongClickListener(){

        public boolean onLongClick(View v) {
            AdapterDelegate.OnItemLongClickListener onItemLongClickListener;
            int index;
            if (PowViewHolder.this.mMultipleAdapter != null && PowViewHolder.this.mMultipleAdapter.mOnItemLongClickListener != null) {
                index = PowViewHolder.this.mViewHolder.getAdapterPosition();
                if (PowViewHolder.this.mMultipleAdapter.mHasHead) {
                    --index;
                }
                onItemLongClickListener = PowViewHolder.this.mMultipleAdapter.mOnItemLongClickListener;
                if (index >= 0 && index < PowViewHolder.this.mMultipleAdapter.mDataList.size()) {
                    return onItemLongClickListener.onLongClick(PowViewHolder.this, PowViewHolder.this.mData, index, v.getId());
                }
            }
            if (PowViewHolder.this.mMultipleListAdapter != null && PowViewHolder.this.mMultipleListAdapter.mOnItemLongClickListener != null) {
                index = PowViewHolder.this.mViewHolder.getAdapterPosition();
                if (PowViewHolder.this.mMultipleListAdapter.mHasHead) {
                    --index;
                }
                onItemLongClickListener = PowViewHolder.this.mMultipleListAdapter.mOnItemLongClickListener;
                if (index >= 0 && index < PowViewHolder.this.mMultipleListAdapter.mDataList.size()) {
                    return onItemLongClickListener.onLongClick(PowViewHolder.this, PowViewHolder.this.mData, index, v.getId());
                }
            }
            return false;
        }
    };

    public PowViewHolder(Activity activity, ViewGroup viewGroup) {
        this.mActivity = activity;
        if (this.getItemViewRes() == 0) {
            throw new RuntimeException("must provide View by getItemView() or gitItemViewRes()");
        }
        this.mItemView = activity.getLayoutInflater().inflate(this.getItemViewRes(), viewGroup, false);
        this.mViewHolder = new RecycleViewHolder(this.mItemView, this);
    }

    final void registerAutoItemClick() {
        if (this.mRegisterMainItemClickStatus != 0) {
            return;
        }
        if (this.getItemViewOnClickListener() == null) {
            this.mItemView.setOnClickListener(this.mOnClickListener);
            this.mRegisterMainItemClickStatus = 1;
        } else {
            this.mRegisterMainItemClickStatus = -1;
        }
    }

    final void registerAutoItemLongClick() {
        if (this.mRegisterMainItemLongClickStatus != 0) {
            return;
        }
        if (this.getItemViewOnLongClickListener() == null) {
            this.mItemView.setOnLongClickListener(this.mOnLongClickListener);
            this.mRegisterMainItemLongClickStatus = 1;
        } else {
            this.mRegisterMainItemLongClickStatus = -1;
        }
    }

    private View.OnClickListener getItemViewOnClickListener() {
        if (this.mItemView.isClickable()) {
            try {
                Field mListenerInfo = View.class.getDeclaredField("mListenerInfo");
                mListenerInfo.setAccessible(true);
                Object infoObject = mListenerInfo.get(this.mItemView);
                if (infoObject == null) {
                    return null;
                }
                Field clickListener = infoObject.getClass().getDeclaredField("mOnClickListener");
                Object onClickObject = clickListener.get(infoObject);
                if (onClickObject == null) {
                    return null;
                }
                if (onClickObject instanceof View.OnClickListener) {
                    return (View.OnClickListener)onClickObject;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private View.OnLongClickListener getItemViewOnLongClickListener() {
        if (this.mItemView.isLongClickable()) {
            try {
                Field mListenerInfo = View.class.getDeclaredField("mListenerInfo");
                mListenerInfo.setAccessible(true);
                Object infoObject = mListenerInfo.get(this.mItemView);
                if (infoObject == null) {
                    return null;
                }
                Field clickListener = infoObject.getClass().getDeclaredField("mOnLongClickListener");
                Object onClickObject = clickListener.get(infoObject);
                if (onClickObject == null) {
                    return null;
                }
                if (onClickObject instanceof View.OnLongClickListener) {
                    return (View.OnLongClickListener)onClickObject;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected final void registerItemClick(int ... viewIds) {
        if (this.mRegisterMainItemClickStatus == 1 && this.mItemView.isClickable() && this.getItemViewOnClickListener() == this.mOnClickListener) {
            this.mItemView.setOnClickListener(null);
        }
        this.mRegisterMainItemClickStatus = -1;
        for (int i = 0; viewIds != null && i < viewIds.length; ++i) {
            View item = this.mItemView.findViewById(viewIds[i]);
            if (item == null) continue;
            item.setOnClickListener(this.mOnClickListener);
        }
    }

    protected final void registerItemLongClick(int ... viewIds) {
        if (this.mRegisterMainItemLongClickStatus == 1 && this.mItemView.isLongClickable() && this.getItemViewOnLongClickListener() == this.mOnLongClickListener) {
            this.mItemView.setOnLongClickListener(null);
        }
        this.mRegisterMainItemLongClickStatus = -1;
        for (int i = 0; viewIds != null && i < viewIds.length; ++i) {
            View item = this.mItemView.findViewById(viewIds[i]);
            if (item == null) continue;
            item.setOnLongClickListener(this.mOnLongClickListener);
        }
    }

    protected abstract int getItemViewRes();

    public abstract void loadData(AdapterDelegate<? super T> var1, T var2, int var3);

    protected boolean acceptData(T data) {
        return true;
    }

    protected boolean isEnableDragAndDrop() {
        return false;
    }

    public final int getItemPostion() {
        int position = this.mViewHolder.getAdapterPosition();
        return this.mMultipleAdapter.mHasHead ? position - 1 : position;
    }

    public <K extends View> K findViewById(int resId) {
        return (K)this.mItemView.findViewById(resId);
    }

    protected void onViewAttachedToWindow() {
    }

    protected void onViewDetachedFromWindow() {
    }
}

