/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.adapter;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.support.annotation.NonNull;
import android.text.TextPaint;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.powyin.scroll.R;
import com.powyin.scroll.adapter.AdapterDelegate;
import com.powyin.scroll.adapter.PowViewHolder;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class MultipleListAdapter<T>
implements ListAdapter,
AdapterDelegate<T> {
    private PowViewHolder[] mHolderInstances;
    private Class<? extends PowViewHolder>[] mHolderClasses;
    private Class[] mHolderGenericDataClass;
    private Activity mActivity;
    private List<T> mDataList = new ArrayList<T>();
    private boolean mShowError = true;
    private final int mFixedLoadMoreCount;
    private int mSpaceCount;
    private int mLoadMoreCount;
    private final DataSetObservable mDataSetObservable = new DataSetObservable();
    private boolean mLoadEnableShow = false;
    private AdapterDelegate.LoadedStatus mLoadStatus = AdapterDelegate.LoadedStatus.CONTINUE;
    private LoadMorePowViewHolder loadMorePowViewHolder;
    private String mLoadCompleteInfo = "\u6211\u662f\u6709\u5e95\u7ebf\u7684";
    AdapterDelegate.OnLoadMoreListener mOnLoadMoreListener;

    @SafeVarargs
    public static <T, N extends T> MultipleListAdapter<N> getByViewHolder(Activity activity, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleListAdapter<T>(activity, arrClass);
    }

    @SafeVarargs
    public static <T, N extends T> MultipleListAdapter<N> getByViewHolder(Activity activity, int loadMoreViewCount, Class<? extends PowViewHolder<? extends T>> ... arrClass) {
        return new MultipleListAdapter<T>(activity, loadMoreViewCount, arrClass);
    }

    @SafeVarargs
    public MultipleListAdapter(Activity activity, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        this(activity, 1, viewHolderClass);
    }

    @SafeVarargs
    public MultipleListAdapter(Activity activity, int loadMoreViewCount, Class<? extends PowViewHolder<? extends T>> ... viewHolderClass) {
        Class[] arrClass = new Class[viewHolderClass.length];
        System.arraycopy(viewHolderClass, 0, arrClass, 0, viewHolderClass.length);
        this.mActivity = activity;
        this.mFixedLoadMoreCount = loadMoreViewCount;
        this.mHolderClasses = arrClass;
        this.mHolderInstances = new PowViewHolder[arrClass.length];
        this.mHolderGenericDataClass = new Class[arrClass.length];
        for (int i = 0; i < arrClass.length; ++i) {
            Type genericType;
            Class<? extends PowViewHolder> typeClass = this.mHolderClasses[i];
            do {
                genericType = typeClass.getGenericSuperclass();
            } while ((typeClass = typeClass.getSuperclass()) != PowViewHolder.class && typeClass != Object.class);
            if (typeClass != PowViewHolder.class || genericType == PowViewHolder.class) {
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u7ee7\u627f\u6cdb\u578bViewHolder");
            }
            ParameterizedType paramType = (ParameterizedType)genericType;
            Type genericClass = paramType.getActualTypeArguments()[0];
            this.mHolderGenericDataClass[i] = (Class)genericClass;
            try {
                this.mHolderInstances[i] = this.mHolderClasses[i].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, null);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException("\u53c2\u6570\u7c7b\u5fc5\u987b\u5b9e\u73b0\uff08Activity\uff09\u5355\u4e00\u53c2\u6570\u7684\u6784\u9020\u65b9\u6cd5  \u6216\u8005  " + e.getMessage());
            }
        }
    }

    public boolean areAllItemsEnabled() {
        return true;
    }

    public boolean isEnabled(int position) {
        return true;
    }

    public int getCount() {
        return this.mDataList.size();
    }

    public Object getItem(int position) {
        return this.mDataList.get(position);
    }

    public long getItemId(int position) {
        return this.mDataList.get(position).hashCode();
    }

    public boolean hasStableIds() {
        return true;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        int typeIndex = this.getItemViewType(position);
        if (convertView == null) {
            if (typeIndex == this.mHolderClasses.length + 2) {
                if (this.loadMorePowViewHolder == null) {
                    this.loadMorePowViewHolder = new LoadMorePowViewHolder();
                }
                convertView = this.loadMorePowViewHolder.getNewInstance();
                convertView.setTag((Object)this.loadMorePowViewHolder);
                this.loadMorePowViewHolder.ensureAnimation(false);
            } else if (typeIndex == this.mHolderClasses.length + 1) {
                IncludeTypeEmpty empty = new IncludeTypeEmpty(parent);
                convertView = empty.mainItem;
                empty.mainItem.setTag((Object)empty);
            } else if (typeIndex == this.mHolderClasses.length) {
                IncludeTypeError error = new IncludeTypeError(parent);
                convertView = error.mainItem;
                error.mainItem.setTag((Object)error);
            } else {
                try {
                    PowViewHolder holder = this.mHolderClasses[typeIndex].getConstructor(Activity.class, ViewGroup.class).newInstance(this.mActivity, parent);
                    convertView.setTag((Object)holder);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e.getMessage());
                }
            }
        }
        Object object = convertView.getTag();
        if (typeIndex == this.mHolderClasses.length + 2) {
            LoadMorePowViewHolder loadMorePowViewHolder = (LoadMorePowViewHolder)object;
        } else if (typeIndex == this.mHolderClasses.length + 1) {
            IncludeTypeEmpty includeTypeEmpty = (IncludeTypeEmpty)object;
        } else if (typeIndex == this.mHolderClasses.length) {
            IncludeTypeError includeTypeError = (IncludeTypeError)object;
        } else {
            PowViewHolder holder = (PowViewHolder)convertView.getTag();
            T itemData = this.mDataList.get(position);
            holder.mData = itemData;
            holder.loadData(this, itemData, position);
        }
        return convertView;
    }

    private void ensureConfig() {
        if (!this.mLoadEnableShow) {
            this.mSpaceCount = 0;
            this.mLoadMoreCount = 0;
        } else {
            int dataSize = this.mDataList.size();
            this.mSpaceCount = dataSize % this.mFixedLoadMoreCount == 0 ? 0 : this.mFixedLoadMoreCount - dataSize % this.mFixedLoadMoreCount;
            this.mLoadMoreCount = this.mFixedLoadMoreCount;
        }
    }

    public int getItemViewType(int position) {
        if (position >= this.mDataList.size()) {
            this.ensureConfig();
            if (position >= this.mDataList.size() + this.mSpaceCount) {
                return this.mHolderInstances.length + 2;
            }
            return this.mHolderInstances.length + 1;
        }
        for (int i = 0; i < this.mHolderInstances.length; ++i) {
            T itemData = this.mDataList.get(position);
            if (itemData == null || !this.mHolderGenericDataClass[i].isAssignableFrom(itemData.getClass()) || !this.mHolderInstances[i].acceptData(itemData)) continue;
            return i;
        }
        return this.mHolderInstances.length;
    }

    public int getViewTypeCount() {
        return this.mHolderClasses.length + 3;
    }

    public boolean isEmpty() {
        return false;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    public void notifyDataSetChanged() {
        this.mDataSetObservable.notifyChanged();
    }

    public void notifyDataSetInvalidated() {
        this.mDataSetObservable.notifyInvalidated();
    }

    @Override
    public void setOnItemClickListener(AdapterDelegate.OnItemClickListener clickListener) {
    }

    @Override
    public void setHeadView(View view) {
    }

    @Override
    public void setFootView(View view) {
    }

    @Override
    public void removeHeadView() {
    }

    @Override
    public void removeFootView() {
    }

    @Override
    public void enableEmptyView(boolean show) {
    }

    @Override
    public void setEmptyView(View view) {
    }

    @Override
    public void setOnItemLongClickListener(AdapterDelegate.OnItemLongClickListener<T> clickListener) {
    }

    @Override
    @NonNull
    public List<T> getDataList() {
        return this.mDataList;
    }

    @Override
    public int getDataCount() {
        return this.mDataList.size();
    }

    @Override
    public void loadData(List<T> dataList) {
        this.mDataList.clear();
        this.mDataList.addAll(dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, T data) {
        this.mDataList.add(position, data);
        this.notifyDataSetChanged();
    }

    @Override
    public void addData(int position, List<T> dataList) {
        this.mDataList.addAll(position, dataList);
        this.notifyDataSetChanged();
    }

    @Override
    public T removeData(int position) {
        T ret = this.mDataList.remove(position);
        this.notifyDataSetChanged();
        return ret;
    }

    @Override
    public void addDataAtLast(List<T> dataList) {
        this.addDataAtLast(dataList, null, 0);
    }

    @Override
    public void addDataAtLast(final List<T> dataList, final AdapterDelegate.LoadedStatus status, int delayTime) {
        if (delayTime <= 0) {
            this.mDataList.addAll(this.mDataList.size(), dataList);
            this.notifyDataSetChanged();
            this.setLoadMoreStatus(status);
        } else {
            this.mActivity.getWindow().getDecorView().postDelayed(new Runnable(){

                @Override
                public void run() {
                    MultipleListAdapter.this.mDataList.addAll(MultipleListAdapter.this.mDataList.size(), dataList);
                    MultipleListAdapter.this.notifyDataSetChanged();
                    MultipleListAdapter.this.setLoadMoreStatus(status);
                }
            }, (long)delayTime);
        }
    }

    @Override
    public void removeData(T data) {
        if (this.mDataList.contains(data)) {
            this.mDataList.remove(data);
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void clearData() {
        if (this.mDataList.size() != 0) {
            this.mDataList.clear();
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void enableLoadMore(boolean show) {
        if (this.mLoadEnableShow != show) {
            this.mLoadEnableShow = show;
            this.notifyDataSetChanged();
        }
    }

    @Override
    public void setLoadMoreStatus(AdapterDelegate.LoadedStatus status) {
        if (status == null) {
            return;
        }
        switch (status) {
            case CONTINUE: {
                this.mLoadStatus = AdapterDelegate.LoadedStatus.CONTINUE;
                break;
            }
            case NO_MORE: {
                this.mLoadStatus = AdapterDelegate.LoadedStatus.NO_MORE;
            }
        }
        if (this.loadMorePowViewHolder != null) {
            this.loadMorePowViewHolder.ensureAnimation(false);
            for (View view : this.loadMorePowViewHolder.viewHolders) {
                view.invalidate();
            }
        }
    }

    @Override
    public void setOnLoadMoreListener(AdapterDelegate.OnLoadMoreListener loadMoreListener) {
        this.mOnLoadMoreListener = loadMoreListener;
    }

    private class LoadMorePowViewHolder {
        boolean mAttached = false;
        List<View> viewHolders = new ArrayList<View>();
        ValueAnimator animator;
        Paint circlePaint = new Paint();
        TextPaint textPaint;
        int canvasWei;
        int canvasHei;
        float canvasTextX;
        float canvasTextY;
        int ballCount = 10;
        float divide;

        LoadMorePowViewHolder() {
            this.circlePaint.setColor(-1728053248);
            this.circlePaint.setStrokeWidth(4.0f);
            this.textPaint = new TextPaint();
            this.textPaint.setColor(-1728053248);
            float fontScale = ((MultipleListAdapter)MultipleListAdapter.this).mActivity.getResources().getDisplayMetrics().scaledDensity;
            int target = (int)(13.0f * fontScale + 0.5f);
            this.textPaint.setTextSize((float)target);
            this.textPaint.setAntiAlias(true);
            this.textPaint.setStrokeWidth(1.0f);
        }

        View getNewInstance() {
            LoadProgressBar holder = new LoadProgressBar((Context)MultipleListAdapter.this.mActivity);
            this.viewHolders.add(holder);
            return holder;
        }

        private void ensureAnimation(boolean forceReStart) {
            if (!this.mAttached || MultipleListAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
                return;
            }
            if (forceReStart) {
                if (this.animator != null) {
                    this.animator.cancel();
                    this.animator = null;
                }
            } else if (this.animator != null && this.animator.isRunning()) {
                return;
            }
            this.animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
            this.animator.setDuration(2000L);
            this.animator.setRepeatCount(5);
            this.animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    LoadMorePowViewHolder.this.divide = (float)(8L * (System.currentTimeMillis() % 3000L - 1500L)) / 3000.0f;
                    for (View view : LoadMorePowViewHolder.this.viewHolders) {
                        view.invalidate();
                    }
                }
            });
            this.animator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    if (animation == LoadMorePowViewHolder.this.animator) {
                        LoadMorePowViewHolder.this.ensureAnimation(true);
                    }
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animator.start();
        }

        private float getSplit(float value) {
            int positive = value >= 0.0f ? 1 : -1;
            if ((value = Math.abs(value)) <= 1.0f) {
                return value * (float)positive;
            }
            return (float)Math.pow(value, 2.0) * (float)positive;
        }

        class LoadProgressBar
        extends View {
            int mIndex;

            public LoadProgressBar(Context context) {
                super(context);
            }

            protected void onAttachedToWindow() {
                super.onAttachedToWindow();
                LoadMorePowViewHolder.this.mAttached = true;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }

            protected void onDetachedFromWindow() {
                super.onDetachedFromWindow();
                LoadMorePowViewHolder.this.mAttached = false;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                float scale = this.getContext().getResources().getDisplayMetrics().density;
                int target = (int)(40.0f * scale + 0.5f);
                this.setMeasuredDimension(this.getMeasuredWidth(), target);
            }

            protected void onDraw(Canvas canvas) {
                super.onDraw(canvas);
                if (MultipleListAdapter.this.mLoadStatus == AdapterDelegate.LoadedStatus.NO_MORE) {
                    int diff = this.mIndex * this.getWidth();
                    canvas.drawText(MultipleListAdapter.this.mLoadCompleteInfo, LoadMorePowViewHolder.this.canvasTextX - (float)diff, LoadMorePowViewHolder.this.canvasTextY, (Paint)LoadMorePowViewHolder.this.textPaint);
                    canvas.drawLine((float)(20 - diff), (float)(LoadMorePowViewHolder.this.canvasHei / 2), LoadMorePowViewHolder.this.canvasTextX - 20.0f - (float)diff, (float)(LoadMorePowViewHolder.this.canvasHei / 2), (Paint)LoadMorePowViewHolder.this.textPaint);
                    canvas.drawLine((float)LoadMorePowViewHolder.this.canvasWei - LoadMorePowViewHolder.this.canvasTextX + 20.0f - (float)diff, (float)(LoadMorePowViewHolder.this.canvasHei / 2), (float)(LoadMorePowViewHolder.this.canvasWei - 20 - diff), (float)(LoadMorePowViewHolder.this.canvasHei / 2), (Paint)LoadMorePowViewHolder.this.textPaint);
                } else {
                    for (int i = 0; i < LoadMorePowViewHolder.this.ballCount; ++i) {
                        float wei = 4.0f * (1.0f * (float)i / (float)LoadMorePowViewHolder.this.ballCount - 0.5f) + LoadMorePowViewHolder.this.divide;
                        wei = (float)(LoadMorePowViewHolder.this.canvasWei / 2) + LoadMorePowViewHolder.this.getSplit(wei) * (float)LoadMorePowViewHolder.this.canvasWei * 0.08f;
                        canvas.drawCircle(wei -= (float)(this.mIndex * this.getWidth()), (float)(LoadMorePowViewHolder.this.canvasHei / 2), 8.0f, LoadMorePowViewHolder.this.circlePaint);
                    }
                }
            }

            protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
                super.onLayout(changed, left, top, right, bottom);
                LoadMorePowViewHolder.this.canvasHei = this.getHeight();
                LoadMorePowViewHolder.this.canvasWei = this.getWidth() * MultipleListAdapter.this.mLoadMoreCount;
                LoadMorePowViewHolder.this.canvasTextX = (float)(LoadMorePowViewHolder.this.canvasWei / 2) - LoadMorePowViewHolder.this.textPaint.measureText(MultipleListAdapter.this.mLoadCompleteInfo) / 2.0f;
                LoadMorePowViewHolder.this.canvasTextY = (float)(LoadMorePowViewHolder.this.canvasHei / 2) + LoadMorePowViewHolder.this.textPaint.getTextSize() / 2.55f;
                LoadMorePowViewHolder.this.ensureAnimation(false);
            }
        }
    }

    private class IncludeTypeError {
        View mainItem;
        TextView errorInfo;

        IncludeTypeError(ViewGroup viewGroup) {
            this.mainItem = MultipleListAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_err, viewGroup, false);
            this.errorInfo = (TextView)this.mainItem.findViewById(R.id.powyin_scroll_err_text);
        }
    }

    private class IncludeTypeEmpty {
        View mainItem;

        IncludeTypeEmpty(ViewGroup viewGroup) {
            this.mainItem = MultipleListAdapter.this.mActivity.getLayoutInflater().inflate(R.layout.powyin_scroll_multiple_adapter_empty, viewGroup, false);
        }
    }
}

