/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.support.v4.view.MotionEventCompat;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.ListView;
import com.powyin.scroll.R;
import com.powyin.scroll.widget.SwipeControl;
import com.powyin.scroll.widget.SwipeControlStyleNormal;

public class SwipeRefresh
extends ViewGroup
implements NestedScrollingParent {
    private View mTarget;
    private int mTouchSlop;
    private final NestedScrollingParentHelper mParentHelper;
    private boolean mNestedScrollInProgress;
    private int mActivePointerId = -1;
    private float mDispatchTouchEvent_InitialDownY;
    private float mInterceptTouchEvent_InitialDownY;
    private float mInterceptTouchEvent_InitialDownY_Direct;
    private float mTouchEvent_InitialDownY;
    private boolean mIsTouchEventMode = false;
    private boolean mDispatchScroll;
    private boolean mDispatchDragged;
    private boolean mInterceptDragged;
    private SwipeControl mSwipeControl;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private boolean mIsFreshContinue = false;
    private boolean mIsFreshComplete = false;
    private boolean mIsLoadContinue = false;
    private boolean mIsLoadComplete = false;
    private SwipeControl.SwipeModel mModel = SwipeControl.SwipeModel.SWIPE_BOTH;
    private int scrollY_Up;
    private int scrollY_Down;
    private OnRefreshListener mOnRefreshListener;

    public SwipeRefresh(Context context) {
        this(context, null);
    }

    public SwipeRefresh(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeRefresh(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mTouchSlop = ViewConfiguration.get((Context)context).getScaledTouchSlop();
        this.mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
        if (attrs != null) {
            TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeRefresh);
            int modelIndex = a.getInt(R.styleable.SwipeRefresh_fresh_model, -1);
            if (modelIndex >= 0 && modelIndex < SwipeControl.SwipeModel.values().length) {
                this.mModel = SwipeControl.SwipeModel.values()[modelIndex];
            }
            a.recycle();
        }
        this.initSwipeControl();
    }

    private void ensureTarget() {
        if (this.mTarget == null) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                View child = this.getChildAt(i);
                if (child == this.mSwipeControl.getSwipeHead() || child == this.mSwipeControl.getSwipeFoot()) continue;
                this.mTarget = child;
            }
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                absListView.setOverScrollMode(2);
            }
        }
    }

    private void initSwipeControl() {
        this.mSwipeControl = new SwipeControlStyleNormal(this.getContext());
        this.addView(this.mSwipeControl.getSwipeHead(), 0);
        this.addView(this.mSwipeControl.getSwipeFoot(), this.getChildCount());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = SwipeRefresh.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = SwipeRefresh.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.ensureTarget();
        if (this.getChildCount() > 3) {
            throw new RuntimeException("can not holder only one View");
        }
        this.scrollY_Up = -this.mSwipeControl.getSwipeHead().getMeasuredHeight();
        this.scrollY_Down = this.mSwipeControl.getSwipeFoot().getMeasuredHeight();
        this.mSwipeControl.getSwipeHead().layout(0, -this.mSwipeControl.getSwipeHead().getMeasuredHeight(), right - left, 0);
        this.mTarget.layout(0, 0, right - left, bottom - top);
        this.mSwipeControl.getSwipeFoot().layout(0, bottom - top, right - left, bottom - top + this.scrollY_Down);
        if (this.mModel == SwipeControl.SwipeModel.SWIPE_NONE || this.mModel == SwipeControl.SwipeModel.SWIPE_ONLY_LOADINN) {
            this.scrollY_Up = 0;
        }
        if (this.mModel == SwipeControl.SwipeModel.SWIPE_NONE || this.mModel == SwipeControl.SwipeModel.SWIPE_ONLY_REFRESH) {
            this.scrollY_Down = 0;
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0) {
            this.mInterceptDragged = false;
            this.mDispatchScroll = false;
            this.mDispatchDragged = false;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
            this.mInterceptTouchEvent_InitialDownY = 2.1474836E9f;
            this.mInterceptTouchEvent_InitialDownY_Direct = 0.0f;
            this.mIsTouchEventMode = true;
        }
        if (ev.getAction() == 1 || ev.getAction() == 3) {
            this.mIsTouchEventMode = false;
        }
        if (this.mNestedScrollInProgress) {
            return super.dispatchTouchEvent(ev);
        }
        if (ev.getAction() == 0 && this.getScrollY() != 0) {
            this.mDispatchScroll = true;
        }
        if (this.mDispatchScroll && !this.mNestedScrollInProgress) {
            int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
            switch (action) {
                case 0: {
                    this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                    this.mDispatchTouchEvent_InitialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                    break;
                }
                case 2: {
                    float y = this.getMotionEventY(ev, this.mActivePointerId);
                    if (this.mActivePointerId == -1 || this.mDispatchTouchEvent_InitialDownY == 2.1474836E9f || y == 2.1474836E9f) break;
                    float yDiff = this.mDispatchTouchEvent_InitialDownY - y;
                    if (Math.abs(yDiff) > (float)(this.mTouchSlop / 2) && !this.mDispatchDragged) {
                        this.mDispatchDragged = true;
                        yDiff /= 2.0f;
                    }
                    if (!this.mDispatchDragged) break;
                    this.offSetChildrenLocation((int)yDiff, true);
                    if (this.getScrollY() == 0) {
                        this.mDispatchScroll = false;
                    }
                    this.mDispatchTouchEvent_InitialDownY = y;
                    return true;
                }
                case 6: {
                    this.onSecondaryPointerUp(ev);
                }
            }
        }
        if ((ev.getAction() == 1 || ev.getAction() == 3) && (this.tryBackToRefreshing() || this.tryBackToFreshFinish())) {
            ev.setAction(3);
        }
        return super.dispatchTouchEvent(ev);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        this.ensureTarget();
        if (!this.isEnabled() || this.canChildScrollDown() && this.canChildScrollUp() || this.mNestedScrollInProgress) {
            return false;
        }
        int action = MotionEventCompat.getActionMasked((MotionEvent)ev);
        switch (action) {
            case 0: {
                this.mInterceptTouchEvent_InitialDownY = this.getMotionEventY(ev, this.mActivePointerId);
                break;
            }
            case 2: {
                float y = this.getMotionEventY(ev, this.mActivePointerId);
                if (y == 2.1474836E9f) {
                    return false;
                }
                if (this.mInterceptTouchEvent_InitialDownY == 2.1474836E9f) {
                    this.mInterceptTouchEvent_InitialDownY = y;
                    return false;
                }
                float yDiff = y - this.mInterceptTouchEvent_InitialDownY;
                if (yDiff == 0.0f) {
                    return false;
                }
                if (!this.isSameDirection(this.mInterceptTouchEvent_InitialDownY_Direct, yDiff)) {
                    this.mInterceptTouchEvent_InitialDownY_Direct = yDiff;
                    this.mInterceptTouchEvent_InitialDownY = y;
                    return false;
                }
                if (!(Math.abs(yDiff) > (float)this.mTouchSlop) || this.mInterceptDragged || !(yDiff < 0.0f && !this.canChildScrollUp()) && (!(yDiff > 0.0f) || this.canChildScrollDown())) break;
                this.mInterceptDragged = true;
                this.mTouchEvent_InitialDownY = y;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return this.mInterceptDragged;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int pointerIndex;
        switch (MotionEventCompat.getActionMasked((MotionEvent)ev)) {
            case 0: {
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)0);
                break;
            }
            case 2: {
                pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
                if (pointerIndex < 0 || !this.mInterceptDragged) break;
                float y = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
                if (this.mTouchEvent_InitialDownY == 2.1474836E9f) {
                    this.mTouchEvent_InitialDownY = y;
                    break;
                }
                this.offSetChildrenLocation((int)(this.mTouchEvent_InitialDownY - y), false);
                break;
            }
            case 5: {
                pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
                if (pointerIndex < 0) break;
                this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                break;
            }
            case 1: 
            case 3: {
                this.mActivePointerId = -1;
                this.mTouchEvent_InitialDownY = 2.1474836E9f;
                return true;
            }
        }
        pointerIndex = MotionEventCompat.findPointerIndex((MotionEvent)ev, (int)this.mActivePointerId);
        if (pointerIndex >= 0) {
            this.mTouchEvent_InitialDownY = MotionEventCompat.getY((MotionEvent)ev, (int)pointerIndex);
        }
        return true;
    }

    private boolean isSameDirection(float arg1, float arg2) {
        return arg1 > 0.0f && arg2 > 0.0f || arg1 < 0.0f && arg2 < 0.0f;
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = MotionEventCompat.getActionIndex((MotionEvent)ev);
        int pointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mActivePointerId = MotionEventCompat.getPointerId((MotionEvent)ev, (int)newPointerIndex);
        }
    }

    private boolean canChildScrollDown() {
        this.ensureTarget();
        if (Build.VERSION.SDK_INT < 14) {
            if (this.mTarget instanceof AbsListView) {
                AbsListView absListView = (AbsListView)this.mTarget;
                return absListView.getChildCount() > 0 && (absListView.getFirstVisiblePosition() > 0 || absListView.getChildAt(0).getTop() < absListView.getPaddingTop());
            }
            return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1) || this.mTarget.getScrollY() > 0;
        }
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)-1);
    }

    private boolean canChildScrollUp() {
        this.ensureTarget();
        return ViewCompat.canScrollVertically((View)this.mTarget, (int)1) || this.mTarget.getScrollY() < 0;
    }

    private float getMotionEventY(MotionEvent ev, int activePointerId) {
        int index = ev.findPointerIndex(activePointerId);
        if (index < 0) {
            return 2.1474836E9f;
        }
        return ev.getY(index);
    }

    public void requestDisallowInterceptTouchEvent(boolean b) {
        if (this.mTarget != null && this.mTarget instanceof NestedScrollingChild) {
            super.requestDisallowInterceptTouchEvent(b);
        }
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return this.isEnabled() && (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetChildrenLocation(dy, true);
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.tryBackToRefreshing()) {
            this.tryBackToFreshFinish();
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        this.offSetChildrenLocation(dyUnconsumed, false);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        return this.getScrollY() != 0;
    }

    private int offSetChildrenLocation(int deltaOriginY, boolean pre) {
        this.ensureTarget();
        int deltaY = deltaOriginY;
        if (deltaOriginY == 0) {
            return 0;
        }
        int middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        int currentScrollY = this.getScrollY();
        if (deltaOriginY < 0 && currentScrollY < middleHei) {
            deltaY = (int)((double)deltaY * Math.pow((float)(this.mSwipeControl.getOverScrollHei() - (middleHei - currentScrollY)) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.0));
        }
        if (pre && currentScrollY != 0 || !pre) {
            int swipeViewVisibilityHei;
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, this.scrollY_Down);
            willTo = Math.max(willTo, this.scrollY_Up);
            if (currentScrollY > 0 && willTo < 0 || currentScrollY < 0 && willTo > 0) {
                willTo = 0;
            }
            if (this.mInterceptTouchEvent_InitialDownY_Direct > 0.0f && willTo > 0) {
                willTo = 0;
            }
            if (this.mInterceptTouchEvent_InitialDownY_Direct < 0.0f && willTo < 0) {
                willTo = 0;
            }
            if (this.mInterceptTouchEvent_InitialDownY_Direct < 0.0f && willTo > 0 && !this.canChildScrollDown()) {
                willTo = 0;
            }
            if (willTo == currentScrollY) {
                return deltaOriginY;
            }
            this.scrollTo(0, willTo);
            if (willTo < 0 && willTo > middleHei && this.mIsFreshComplete && !this.mIsFreshContinue) {
                this.mIsFreshComplete = false;
            }
            if ((swipeViewVisibilityHei = 0 - willTo) > 0) {
                if (this.mIsFreshContinue) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (this.mIsFreshComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (willTo < middleHei) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                }
            }
            if (willTo > 0 && !this.mIsLoadContinue) {
                this.mIsLoadContinue = true;
                if (this.mOnRefreshListener != null) {
                    this.mOnRefreshListener.onLoading();
                }
            }
            if (willTo > 0) {
                if (this.mIsLoadComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_FOOT_COMPLETE, willTo, this.mSwipeControl.getSwipeFoot().getHeight());
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_FOOT_LOADING, willTo, this.mSwipeControl.getSwipeFoot().getHeight());
                }
            }
            return deltaOriginY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        if (this.mIsTouchEventMode || this.mIsFreshComplete) {
            return false;
        }
        int scrollY = this.getScrollY();
        int middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        this.stopAllScroll();
        boolean bl = isOverProgress = scrollY < middleHei;
        if (isOverProgress) {
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, middleHei});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeRefresh.this.getScrollY()) {
                        SwipeRefresh.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener(new Animator.AnimatorListener(){
                boolean isCancel = false;

                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeRefresh.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, SwipeRefresh.this.mSwipeControl.getSwipeHead().getHeight(), SwipeRefresh.this.mSwipeControl.getSwipeHead().getHeight());
                        if (!SwipeRefresh.this.mIsFreshContinue) {
                            SwipeRefresh.this.mIsFreshContinue = true;
                            if (SwipeRefresh.this.mOnRefreshListener != null) {
                                SwipeRefresh.this.mOnRefreshListener.onRefresh();
                            }
                        }
                    }
                }

                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(450 * (middleHei - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int middleHei;
        if (this.mIsTouchEventMode) {
            return false;
        }
        int scrollY = this.getScrollY();
        int n = middleHei = this.scrollY_Up != 0 ? this.scrollY_Up + this.mSwipeControl.getOverScrollHei() : 0;
        if (!this.mIsFreshComplete && this.getScrollY() == middleHei) {
            return false;
        }
        this.stopAllScroll();
        if (scrollY < 0) {
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeRefresh.this.scrollTo(0, value);
                }
            });
            if (scrollY == middleHei) {
                this.animationReBackToTop.setDuration((long)Math.abs(450 * (0 - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
                this.animationReBackToTop.setStartDelay(400L);
            } else {
                this.animationReBackToTop.setDuration(260L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null) {
            this.animationReBackToTop.cancel();
        }
    }

    public void setOnRefreshListener(OnRefreshListener onRefreshListener) {
        this.mOnRefreshListener = onRefreshListener;
    }

    public void finishRefresh() {
        this.mIsFreshContinue = false;
        this.mIsFreshComplete = true;
        this.mIsLoadComplete = false;
        this.mIsLoadContinue = false;
        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE, -this.getScrollY(), this.mSwipeControl.getSwipeHead().getHeight());
        this.tryBackToFreshFinish();
    }

    public void setIsLoadComplete(boolean isLoadComplete) {
        this.mIsLoadComplete = isLoadComplete;
        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_FOOT_COMPLETE, this.getHeight() - this.mSwipeControl.getSwipeFoot().getTop(), this.mSwipeControl.getSwipeFoot().getHeight());
    }

    public void hiddenLoadMore() {
        RecyclerView recyclerView;
        this.mIsLoadContinue = false;
        this.ensureTarget();
        int currentScrollY = this.getScrollY();
        if (currentScrollY <= 0) {
            return;
        }
        if (this.mTarget instanceof RecyclerView && (recyclerView = (RecyclerView)this.mTarget).getLayoutManager() instanceof LinearLayoutManager) {
            LinearLayoutManager layoutManager = (LinearLayoutManager)recyclerView.getLayoutManager();
            layoutManager.scrollVerticallyBy(currentScrollY, null, null);
        }
        if (this.mTarget instanceof ListView) {
            ListView listView = (ListView)this.mTarget;
            listView.smoothScrollBy(currentScrollY, 0);
        }
        this.scrollTo(0, 0);
    }

    public void setSwipeModel(SwipeControl.SwipeModel model) {
        if (this.mModel != model && model != null) {
            this.mModel = model;
            this.requestLayout();
        }
    }

    public void setSwipeControl(SwipeControl control) {
        if (control != null && this.mSwipeControl != control) {
            this.removeView(this.mSwipeControl.getSwipeHead());
            this.removeView(this.mSwipeControl.getSwipeFoot());
            this.mSwipeControl = control;
            this.addView(this.mSwipeControl.getSwipeHead());
            this.addView(this.mSwipeControl.getSwipeFoot());
            this.requestLayout();
        }
    }

    public static interface OnRefreshListener {
        public void onRefresh();

        public void onLoading();
    }
}

