/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import com.powyin.scroll.widget.SwipeControl;
import com.powyin.scroll.widget.SwipeControlImp;

public class SwipeNest
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = SwipeNest.class.getCanonicalName();
    private final NestedScrollingParentHelper mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final NestedScrollingChildHelper mChildHelper = new NestedScrollingChildHelper((View)this);
    private boolean mNestedScrollInProgress = false;
    private boolean isFly = false;
    private SwipeControl mSwipeControl;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    private ScrollerCompat mScroller;
    boolean isFreshContinue = false;
    boolean isFreshComplete = false;
    private int scrollY_Up;
    private int scrollY_Down;

    public SwipeNest(Context context) {
        this(context, null);
    }

    public SwipeNest(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeNest(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setNestedScrollingEnabled(true);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mScroller = ScrollerCompat.create((Context)this.getContext());
        this.mSwipeControl = new SwipeControlImp(this.getContext());
        this.addView(this.mSwipeControl.getSwipeHead(), 0);
        View lastView = this.getChildAt(this.getChildCount() - 1);
        if (lastView instanceof AbsListView) {
            AbsListView absListView = (AbsListView)lastView;
            absListView.setOverScrollMode(2);
        }
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        return (nestedScrollAxes & 2) != 0;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
        this.isFly = false;
        this.mNestedScrollInProgress = true;
        this.stopAllScroll();
    }

    public void onStopNestedScroll(View target) {
        this.mParentHelper.onStopNestedScroll(target);
        this.mNestedScrollInProgress = false;
        if (!this.isFly) {
            this.stopNestedScroll();
            if (!this.tryBackToRefreshing() && this.mNestedScrollInProgress) {
                this.tryBackToFreshFinish();
            }
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        int myConsumed = this.offSetChildrenLasLocation(dyUnconsumed);
        this.dispatchNestedScroll(0, myConsumed, 0, dyUnconsumed -= myConsumed, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta;
        consumed[1] = delta = this.offSetChildrenPreLocation(dy);
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        if (this.getScrollY() < this.scrollY_Down - this.getHeight()) {
            if (!this.tryBackToRefreshing() && !this.tryBackToFreshFinish()) {
                this.fling((int)velocityY);
                this.isFly = true;
            }
            return true;
        }
        return false;
    }

    public int getNestedScrollAxes() {
        return this.mParentHelper.getNestedScrollAxes();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = SwipeNest.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = SwipeNest.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        View child;
        int childLeft = this.getPaddingLeft();
        int childRight = right - left - this.getPaddingRight();
        int childTop = 0;
        int count = this.getChildCount();
        this.mSwipeControl.getSwipeHead().layout(childLeft, -this.mSwipeControl.getSwipeHead().getMeasuredHeight(), childRight, 0);
        this.scrollY_Up = -this.mSwipeControl.getSwipeHead().getMeasuredHeight();
        for (int i = 1; i < count - 1 && (child = this.getChildAt(i)).getVisibility() != 8; ++i) {
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(childLeft, childTop += lp.topMargin, childRight, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
        View lastIndexView = this.getChildAt(this.getChildCount() - 1);
        if (lastIndexView != null) {
            LayoutParams lp = (LayoutParams)lastIndexView.getLayoutParams();
            lastIndexView.layout(childLeft, childTop, childRight, childTop + bottom);
            childTop += bottom + lp.bottomMargin;
        }
        this.scrollY_Down = childTop;
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            this.scrollTo(0, y);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void finishRefresh() {
        this.isFreshContinue = false;
        this.isFreshComplete = true;
        this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE, -this.getScrollY(), this.mSwipeControl.getSwipeHead().getHeight());
        this.tryBackToFreshFinish();
    }

    private int offSetChildrenPreLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int minScrollY = this.scrollY_Up - this.mSwipeControl.getOverScrollHei();
        int currentScrollY = this.getScrollY();
        if (deltaY < 0 && currentScrollY < this.scrollY_Up && currentScrollY > minScrollY) {
            deltaY = (int)((double)deltaY * Math.pow((float)(currentScrollY - minScrollY) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.5));
        }
        if (currentScrollY >= minScrollY && currentScrollY < maxScrollY || this.getChildCount() == 2 && currentScrollY == 0 && !this.getChildAt(1).canScrollVertically(deltaY)) {
            int swipeViewVisibilityHei;
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            if (willTo < 0 && this.isFreshComplete && !this.isFreshContinue) {
                this.isFreshComplete = false;
            }
            if ((swipeViewVisibilityHei = 0 - willTo) > 0) {
                if (this.isFreshContinue) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (this.isFreshComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_COMPLETE, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else if (willTo < -this.mSwipeControl.getSwipeHead().getHeight()) {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_OVER, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_TOAST, swipeViewVisibilityHei, this.mSwipeControl.getSwipeHead().getHeight());
                }
            }
            return willTo - currentScrollY;
        }
        return 0;
    }

    private int offSetChildrenLasLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int currentScrollY = this.getScrollY();
        if (currentScrollY >= 0) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, 0);
            this.scrollTo(0, willTo);
            return willTo - currentScrollY;
        }
        return 0;
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        int scrollY = this.getScrollY();
        this.stopAllScroll();
        boolean bl = isOverProgress = scrollY < -this.mSwipeControl.getSwipeHead().getHeight();
        if (isOverProgress) {
            int animationTarget = -this.mSwipeControl.getSwipeHead().getHeight();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, animationTarget});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > SwipeNest.this.getScrollY()) {
                        SwipeNest.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener((Animator.AnimatorListener)new AnimationStatus(){
                boolean isCancel = false;

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        SwipeNest.this.isFreshContinue = true;
                        SwipeNest.this.mSwipeControl.onSwipeStatue(SwipeControl.SwipeStatus.SWIPE_HEAD_LOADING, SwipeNest.this.mSwipeControl.getSwipeHead().getHeight(), SwipeNest.this.mSwipeControl.getSwipeHead().getHeight());
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(400 * (animationTarget - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        this.stopAllScroll();
        int scrollY = this.getScrollY();
        if (scrollY < 0) {
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    SwipeNest.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.setDuration((long)Math.abs(250 * (0 - scrollY) / this.mSwipeControl.getSwipeHead().getHeight()));
            if (scrollY <= -this.mSwipeControl.getSwipeHead().getHeight() + 10) {
                this.animationReBackToTop.setStartDelay(350L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        return false;
    }

    private void fling(int velocityY) {
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.getScrollY(), 0, (int)((float)velocityY * 1.0f), 0, 0, 0, this.scrollY_Down - this.getHeight());
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private void stopAllScroll() {
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            this.animationReBackToTop.cancel();
        }
        if (this.mScroller != null && !this.mScroller.isFinished()) {
            this.mScroller.abortAnimation();
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    class AnimationStatus
    implements Animator.AnimatorListener {
        AnimationStatus() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

