/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.widget;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import com.powyin.scroll.widget.DefalutHeadControlerIMP;
import com.powyin.scroll.widget.SwipeHeadControl;

public class ScrollCombine
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = ScrollCombine.class.getCanonicalName();
    private final NestedScrollingParentHelper mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final NestedScrollingChildHelper mChildHelper = new NestedScrollingChildHelper((View)this);
    private ScrollerCompat mScroller;
    private SwipeHeadControl mSwipeControl;
    private int scrollY_Up;
    private int scrollY_Down;
    private ValueAnimator animationReBackToRefreshing;
    private ValueAnimator animationReBackToTop;
    boolean isFreshing = false;
    boolean isFreshComplete = false;

    public ScrollCombine(Context context) {
        this(context, null);
    }

    public ScrollCombine(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollCombine(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setNestedScrollingEnabled(true);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mScroller = ScrollerCompat.create((Context)this.getContext());
        this.mSwipeControl = new DefalutHeadControlerIMP(this.getContext());
        this.addView(this.mSwipeControl.getSwipeView(), 0);
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean tf = (nestedScrollAxes & 2) != 0;
        Log.i((String)"NestedScrollingParent", (String)("onStartNestedScroll:::::::" + tf));
        return tf;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedScrollAccepted");
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            this.animationReBackToRefreshing.cancel();
        }
    }

    public void onStopNestedScroll(View target) {
        Log.i((String)"NestedScrollingParent", (String)"onStopNestedScroll");
        this.mParentHelper.onStopNestedScroll(target);
        this.tryBackToRefreshing();
        this.stopNestedScroll();
    }

    public void reFreshCompleteUp() {
        this.isFreshing = false;
        this.isFreshComplete = true;
        this.mSwipeControl.onSwipeStatue(SwipeHeadControl.SwipeStatus.SWIPE_COMPLITE, -this.getScrollY());
        this.tryBackToFreshFinish();
    }

    private boolean tryBackToRefreshing() {
        boolean isOverProgress;
        int scrollY = this.getScrollY();
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            this.animationReBackToTop.cancel();
        }
        boolean bl = isOverProgress = scrollY < -this.mSwipeControl.getSwipeView().getHeight();
        if (isOverProgress) {
            int animationTarget = -this.mSwipeControl.getSwipeView().getHeight();
            this.animationReBackToRefreshing = ValueAnimator.ofInt((int[])new int[]{scrollY, animationTarget});
            this.animationReBackToRefreshing.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    if (value > ScrollCombine.this.getScrollY()) {
                        ScrollCombine.this.scrollTo(0, value);
                    }
                }
            });
            this.animationReBackToRefreshing.addListener((Animator.AnimatorListener)new AnimationStatus(){
                boolean isCancel = false;

                @Override
                public void onAnimationEnd(Animator animation) {
                    if (!this.isCancel) {
                        ScrollCombine.this.isFreshing = true;
                        ScrollCombine.this.mSwipeControl.onSwipeStatue(SwipeHeadControl.SwipeStatus.SWIPE_LOADING, ScrollCombine.this.mSwipeControl.getSwipeView().getHeight());
                    }
                }

                @Override
                public void onAnimationCancel(Animator animation) {
                    this.isCancel = true;
                }
            });
            this.animationReBackToRefreshing.setDuration((long)Math.abs(400 * (animationTarget - scrollY) / this.mSwipeControl.getSwipeView().getHeight()));
            this.animationReBackToRefreshing.start();
        }
        return isOverProgress;
    }

    private boolean tryBackToFreshFinish() {
        int scrollY = this.getScrollY();
        if (this.animationReBackToRefreshing != null && this.animationReBackToRefreshing.isRunning()) {
            this.animationReBackToRefreshing.cancel();
        }
        if (this.animationReBackToTop != null && this.animationReBackToTop.isRunning()) {
            this.animationReBackToTop.cancel();
        }
        if (scrollY < 0) {
            this.animationReBackToTop = ValueAnimator.ofInt((int[])new int[]{scrollY, 0});
            this.animationReBackToTop.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    ScrollCombine.this.scrollTo(0, value);
                }
            });
            this.animationReBackToTop.addListener((Animator.AnimatorListener)new AnimationStatus(){

                @Override
                public void onAnimationEnd(Animator animation) {
                    ScrollCombine.this.isFreshComplete = false;
                }
            });
            this.animationReBackToTop.setDuration((long)Math.abs(350 * (0 - scrollY) / this.mSwipeControl.getSwipeView().getHeight()));
            if (scrollY <= -this.mSwipeControl.getSwipeView().getHeight() + 10) {
                this.animationReBackToTop.setStartDelay(300L);
            }
            this.animationReBackToTop.start();
            return true;
        }
        this.isFreshComplete = false;
        return false;
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        Log.i((String)"NestedScrollingParent", (String)("onNestedScroll:  dyConsumed" + dyConsumed + "  dyUnConsumed:" + dyUnconsumed));
        int myConsumed = 0;
        myConsumed = this.offSetChildrenLasLocation(dyUnconsumed);
        this.dispatchNestedScroll(0, myConsumed, 0, dyUnconsumed -= myConsumed, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta = this.offSetChildrenPreLocation(dy);
        consumed[0] = 0;
        consumed[1] = delta;
        Log.i((String)"consumedY:", (String)(consumed[1] + ""));
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedFling");
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedPreFling");
        int scrollY = this.getScrollY();
        if (scrollY > 0 && scrollY < this.scrollY_Down - this.getHeight()) {
            this.fling((int)velocityY);
            return true;
        }
        return false;
    }

    public int getNestedScrollAxes() {
        Log.i((String)"NestedScrollingParent", (String)"getNestedScrollAxes");
        return this.mParentHelper.getNestedScrollAxes();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = ScrollCombine.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = ScrollCombine.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutVertical(left, top, right, bottom);
    }

    void layoutVertical(int left, int top, int right, int bottom) {
        View child;
        int childLeft = this.getPaddingLeft();
        int childRight = right - left - this.getPaddingRight();
        int childTop = 0;
        int count = this.getChildCount();
        this.mSwipeControl.getSwipeView().layout(childLeft, -this.mSwipeControl.getSwipeView().getMeasuredHeight(), childRight, 0);
        this.scrollY_Up = -this.mSwipeControl.getSwipeView().getMeasuredHeight();
        for (int i = 1; i < count - 1 && (child = this.getChildAt(i)).getVisibility() != 8; ++i) {
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(childLeft, childTop += lp.topMargin, childRight, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
        View lastIndexView = this.getChildAt(this.getChildCount() - 1);
        if (lastIndexView != null) {
            LayoutParams lp = (LayoutParams)lastIndexView.getLayoutParams();
            lastIndexView.layout(childLeft, childTop, childRight, childTop + bottom);
            childTop += bottom + lp.bottomMargin;
        }
        this.scrollY_Down = childTop;
    }

    public void fling(int velocityY) {
        System.out.println("velocityY" + velocityY);
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.getScrollY(), 0, (int)((float)velocityY * 1.0f), 0, 0, 0, this.scrollY_Down - this.getHeight());
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int offSetChildrenPreLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int minScrollY = this.scrollY_Up - this.mSwipeControl.getOverScrollHei();
        int currentScrollY = this.getScrollY();
        if (deltaY < 0 && currentScrollY < this.scrollY_Up && currentScrollY > minScrollY) {
            deltaY = (int)((double)deltaY * Math.pow((float)(currentScrollY - minScrollY) * 1.0f / (float)this.mSwipeControl.getOverScrollHei(), 2.5));
        }
        if (currentScrollY >= minScrollY && currentScrollY < maxScrollY || this.getChildCount() == 2 && currentScrollY == 0 && !this.getChildAt(1).canScrollVertically(deltaY)) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            int swipeViewVisibilityHei = 0 - willTo;
            if (swipeViewVisibilityHei > 0) {
                if (this.isFreshing) {
                    this.mSwipeControl.onSwipeStatue(SwipeHeadControl.SwipeStatus.SWIPE_LOADING, swipeViewVisibilityHei);
                } else if (this.isFreshComplete) {
                    this.mSwipeControl.onSwipeStatue(SwipeHeadControl.SwipeStatus.SWIPE_COMPLITE, swipeViewVisibilityHei);
                } else {
                    this.mSwipeControl.onSwipeStatue(SwipeHeadControl.SwipeStatus.SWIPE_PRE, swipeViewVisibilityHei);
                }
            }
            return willTo - currentScrollY;
        }
        return 0;
    }

    private int offSetChildrenLasLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int consumed = 0;
        int maxScrollY = this.scrollY_Down - this.getHeight();
        int minScrollY = 0;
        int currentScrollY = this.getScrollY();
        if (currentScrollY >= minScrollY) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            System.out.println("ccccccccccc:mmmmmmm:" + consumed + "---" + (deltaY -= (consumed += willTo - currentScrollY)));
        }
        return consumed;
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
    }

    public void computeScroll() {
        super.computeScroll();
        int scrollY = this.getScrollY();
        if (scrollY < 0) {
            // empty if block
        }
        if (this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            this.scrollTo(0, y);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info checkLayoutParams");
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        System.out.println("layoutParams info generateDefaultLayoutParams");
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(this.getContext(), attrs);
    }

    class AnimationStatus
    implements Animator.AnimatorListener {
        AnimationStatus() {
        }

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
        }

        public void onAnimationCancel(Animator animation) {
        }

        public void onAnimationRepeat(Animator animation) {
        }
    }

    public static interface SwipeListener {
        public void onPullProgress(ScrollCombine var1, int var2, float var3);

        public void onRefreshHeader();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }
}

