/*
 * Decompiled with CFR 0.152.
 */
package com.powyin.scroll.freshCombine;

import android.animation.Animator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.support.v4.view.NestedScrollingChild;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ScrollerCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import com.powyin.scroll.R;

public class NestScrollCombine
extends ViewGroup
implements NestedScrollingParent,
NestedScrollingChild {
    private static final String TAG = NestScrollCombine.class.getCanonicalName();
    private final NestedScrollingParentHelper mParentHelper = new NestedScrollingParentHelper((ViewGroup)this);
    private final NestedScrollingChildHelper mChildHelper = new NestedScrollingChildHelper((View)this);
    private ScrollerCompat mScroller;
    private SwipeListener mSwipeListener;
    private int scrollY_Up_Max;
    private int scrollY_Up;
    private int scrollY_Down;
    private int scrollY_Down_Max;
    private ViewHolderHeaderProgress mHeaderProgressView;
    private ValueAnimator reBackAnimator;
    boolean showButton = true;
    boolean isOverData = false;

    public NestScrollCombine(Context context) {
        this(context, null);
    }

    public NestScrollCombine(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NestScrollCombine(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.setNestedScrollingEnabled(true);
    }

    public void setSwipeListener(SwipeListener listener) {
        this.mSwipeListener = listener;
    }

    public void reFreshCompleteUp() {
        this.mHeaderProgressView.isRefreshCompleteUp = true;
        this.mHeaderProgressView.isRefreshing = false;
        this.tryReBackToCenter();
    }

    public void reFreshCompleteDo() {
        this.tryReBackToCenter();
    }

    private void init() {
        this.mScroller = ScrollerCompat.create((Context)this.getContext());
        ViewConfiguration configuration = ViewConfiguration.get((Context)this.getContext());
        this.mHeaderProgressView = new ViewHolderHeaderProgress();
        this.addView(this.mHeaderProgressView.rootView, 0);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.init();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mChildHelper.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mChildHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int axes) {
        return this.mChildHelper.startNestedScroll(axes);
    }

    public void stopNestedScroll() {
        this.mChildHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.mChildHelper.hasNestedScrollingParent();
    }

    public boolean dispatchNestedScroll(int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, offsetInWindow);
    }

    public boolean dispatchNestedPreScroll(int dx, int dy, int[] consumed, int[] offsetInWindow) {
        return this.mChildHelper.dispatchNestedPreScroll(dx, dy, consumed, offsetInWindow);
    }

    public boolean dispatchNestedFling(float velocityX, float velocityY, boolean consumed) {
        return this.mChildHelper.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public boolean dispatchNestedPreFling(float velocityX, float velocityY) {
        return this.mChildHelper.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onStartNestedScroll(View child, View target, int nestedScrollAxes) {
        boolean tf = (nestedScrollAxes & 2) != 0;
        Log.i((String)"NestedScrollingParent", (String)("onStartNestedScroll:::::::" + tf));
        return tf;
    }

    public void onNestedScrollAccepted(View child, View target, int nestedScrollAxes) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedScrollAccepted");
        this.mParentHelper.onNestedScrollAccepted(child, target, nestedScrollAxes);
        this.startNestedScroll(2);
        if (this.reBackAnimator != null && this.reBackAnimator.isRunning()) {
            this.reBackAnimator.cancel();
        }
    }

    public void onStopNestedScroll(View target) {
        Log.i((String)"NestedScrollingParent", (String)"onStopNestedScroll");
        this.mParentHelper.onStopNestedScroll(target);
        this.tryReBackToPre();
        this.stopNestedScroll();
    }

    private void tryReBackToCenter() {
        int scrollY = this.getScrollY();
        if (this.reBackAnimator != null && this.reBackAnimator.isRunning()) {
            this.reBackAnimator.cancel();
        }
        if (scrollY < this.scrollY_Up) {
            int animationTarget = this.scrollY_Up;
            this.reBackAnimator = ValueAnimator.ofInt((int[])new int[]{scrollY, animationTarget});
            this.reBackAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    int value = (Integer)animation.getAnimatedValue();
                    NestScrollCombine.this.scrollTo(0, value);
                }
            });
            this.reBackAnimator.addListener(new Animator.AnimatorListener(){

                public void onAnimationStart(Animator animation) {
                }

                public void onAnimationEnd(Animator animation) {
                    NestScrollCombine.this.mHeaderProgressView.isRefreshCompleteUp = false;
                    NestScrollCombine.this.mHeaderProgressView.isRefreshing = false;
                }

                public void onAnimationCancel(Animator animation) {
                }

                public void onAnimationRepeat(Animator animation) {
                }
            });
            this.reBackAnimator.setDuration((long)Math.abs(900 * (animationTarget - scrollY) / this.mHeaderProgressView.rootView.getHeight()));
            if (this.reBackAnimator.getDuration() > 0L) {
                this.reBackAnimator.start();
            }
        }
        if (scrollY > this.scrollY_Down) {
            // empty if block
        }
    }

    private void tryReBackToPre() {
        int scrollY = this.getScrollY();
        if (this.reBackAnimator != null && this.reBackAnimator.isRunning()) {
            this.reBackAnimator.cancel();
        }
        if (scrollY < this.scrollY_Up) {
            boolean isOverProgress;
            boolean bl = isOverProgress = scrollY < -this.mHeaderProgressView.contentView.getHeight();
            if (isOverProgress) {
                this.mHeaderProgressView.isRefreshCompleteUp = false;
                this.mHeaderProgressView.isRefreshing = true;
                int animationTarget = -this.mHeaderProgressView.contentView.getHeight();
                this.reBackAnimator = ValueAnimator.ofInt((int[])new int[]{scrollY, animationTarget});
                this.reBackAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                    public void onAnimationUpdate(ValueAnimator animation) {
                        int value = (Integer)animation.getAnimatedValue();
                        if (value > NestScrollCombine.this.getScrollY()) {
                            NestScrollCombine.this.scrollTo(0, value);
                        }
                    }
                });
                this.reBackAnimator.setDuration((long)Math.abs(900 * (animationTarget - scrollY) / this.mHeaderProgressView.rootView.getHeight()));
                this.reBackAnimator.start();
            } else {
                this.tryReBackToCenter();
            }
        }
        if (scrollY > this.scrollY_Down) {
            // empty if block
        }
    }

    public void onNestedScroll(View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        Log.i((String)"NestedScrollingParent", (String)("onNestedScroll:  dyConsumed" + dyConsumed + "  dyUnConsumed:" + dyUnconsumed));
        int myConsumed = 0;
        myConsumed = this.offSetChildrenLasLocation(dyUnconsumed);
        this.dispatchNestedScroll(0, myConsumed, 0, dyUnconsumed -= myConsumed, null);
    }

    public void onNestedPreScroll(View target, int dx, int dy, int[] consumed) {
        int delta = this.offSetChildrenPreLocation(dy);
        consumed[0] = 0;
        consumed[1] = delta;
        Log.i((String)"consumedY:", (String)(consumed[1] + ""));
    }

    public boolean onNestedFling(View target, float velocityX, float velocityY, boolean consumed) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedFling");
        return false;
    }

    public boolean onNestedPreFling(View target, float velocityX, float velocityY) {
        Log.i((String)"NestedScrollingParent", (String)"onNestedPreFling");
        int scrollY = this.getScrollY();
        if (scrollY > this.scrollY_Up && scrollY < this.scrollY_Down - this.getHeight()) {
            this.fling((int)velocityY);
            return true;
        }
        return false;
    }

    public int getNestedScrollAxes() {
        Log.i((String)"NestedScrollingParent", (String)"getNestedScrollAxes");
        return this.mParentHelper.getNestedScrollAxes();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            int speWid = NestScrollCombine.getChildMeasureSpec((int)widthMeasureSpec, (int)0, (int)-1);
            int speHei = NestScrollCombine.getChildMeasureSpec((int)heightMeasureSpec, (int)0, (int)-2);
            child.measure(speWid, speHei);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutVertical(left, top, right, bottom);
    }

    void layoutVertical(int left, int top, int right, int bottom) {
        View child;
        int childLeft = this.getPaddingLeft();
        int childRight = right - left - this.getPaddingRight();
        int childTop = 0;
        int count = this.getChildCount();
        this.mHeaderProgressView.rootView.layout(childLeft, -this.mHeaderProgressView.rootView.getMeasuredHeight(), childRight, 0);
        this.scrollY_Up_Max = -this.mHeaderProgressView.rootView.getMeasuredHeight();
        for (int i = 1; i < count - 1 && (child = this.getChildAt(i)).getVisibility() != 8; ++i) {
            int childHeight = child.getMeasuredHeight();
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            child.layout(childLeft, childTop += lp.topMargin, childRight, childTop + childHeight);
            childTop += childHeight + lp.bottomMargin;
        }
        this.scrollY_Up = 0;
        View lastIndexView = this.getChildAt(this.getChildCount() - 1);
        if (lastIndexView != null) {
            LayoutParams lp = (LayoutParams)lastIndexView.getLayoutParams();
            lastIndexView.layout(childLeft, childTop, childRight, childTop + bottom);
            childTop += bottom + lp.bottomMargin;
        }
        this.scrollY_Down = childTop;
        this.scrollY_Down_Max = childTop;
        for (int i = 0; i < this.getChildCount(); ++i) {
            System.out.println("----------------------------------------------show---------------------------------------------");
            View view = this.getChildAt(i);
            System.out.println(view.getTop() + ":::" + view.getBottom() + "::" + view.getClass());
        }
    }

    public void fling(int velocityY) {
        System.out.println("velocityY" + velocityY);
        this.mScroller.abortAnimation();
        this.mScroller.fling(0, this.getScrollY(), 0, (int)((float)velocityY * 1.0f), 0, 0, 0, this.scrollY_Down - this.getHeight());
        ViewCompat.postInvalidateOnAnimation((View)this);
    }

    private int offSetChildrenPreLocation(int deltaY) {
        int willTo;
        if (deltaY == 0) {
            return 0;
        }
        int consumed = 0;
        System.out.println("ccccccccccc:ooooooo:" + consumed + "---" + deltaY);
        int maxScrollY = 0;
        int minScrollY = this.scrollY_Up_Max;
        int currentScrollY = this.getScrollY();
        if (currentScrollY >= minScrollY && currentScrollY <= maxScrollY) {
            willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            System.out.println("ccccccccccc:uuuuuuu:" + consumed + "---" + (deltaY -= (consumed += willTo - currentScrollY)));
        }
        maxScrollY = this.scrollY_Down - this.getHeight();
        minScrollY = 0;
        currentScrollY = this.getScrollY();
        if (currentScrollY >= minScrollY && currentScrollY < maxScrollY) {
            willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            System.out.println("ccccccccccc:mmmmmmm:" + consumed + "---" + (deltaY -= (consumed += willTo - currentScrollY)));
        }
        maxScrollY = this.scrollY_Down_Max - this.getHeight();
        minScrollY = this.scrollY_Down - this.getHeight();
        currentScrollY = this.getScrollY();
        if (currentScrollY > minScrollY && currentScrollY <= maxScrollY) {
            willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            System.out.println("ccccccccccc:ddddddd:" + consumed + "---" + (deltaY -= (consumed += willTo - currentScrollY)));
        }
        return consumed;
    }

    private int offSetChildrenLasLocation(int deltaY) {
        if (deltaY == 0) {
            return 0;
        }
        int consumed = 0;
        int currentScrollY = this.getScrollY();
        int maxScrollY = this.scrollY_Down_Max - this.getHeight();
        int minScrollY = this.scrollY_Up_Max;
        if (currentScrollY >= minScrollY && currentScrollY <= maxScrollY) {
            int willTo = currentScrollY + deltaY;
            willTo = Math.min(willTo, maxScrollY);
            willTo = Math.max(willTo, minScrollY);
            this.scrollTo(0, willTo);
            consumed = willTo - currentScrollY;
        }
        System.out.println("ccccccccccc:ccccccccccc:" + consumed + ":::" + maxScrollY + ":" + minScrollY + ":::" + currentScrollY);
        return consumed;
    }

    public void scrollTo(int x, int y) {
        super.scrollTo(x, y);
    }

    public void computeScroll() {
        super.computeScroll();
        int scrollY = this.getScrollY();
        if (scrollY < this.scrollY_Up) {
            this.mHeaderProgressView.updateUI();
        }
        if (this.mScroller.computeScrollOffset()) {
            int y = this.mScroller.getCurrY();
            this.scrollTo(0, y);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info checkLayoutParams");
        return p instanceof LayoutParams;
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        System.out.println("layoutParams info generateDefaultLayoutParams");
        return new LayoutParams(-1, -1);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(p);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        System.out.println("layoutParams info generateLayoutParams");
        return new LayoutParams(this.getContext(), attrs);
    }

    public static interface SwipeListener {
        public void onPullProgress(NestScrollCombine var1, int var2, float var3);

        public void onRefreshHeader();
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }
    }

    private class ViewHolderHeaderProgress {
        private boolean isRefreshCompleteUp = false;
        private boolean isRefreshing = false;
        View rootView;
        View contentView;
        CircleViewBac circleViewBac;
        ImageView imageView;
        TextView textInfo;

        void updateUI() {
            if (this.isRefreshCompleteUp) {
                if (!"\u5237\u65b0\u6210\u529f".equals(this.textInfo.getText().toString())) {
                    this.textInfo.setText((CharSequence)"\u5237\u65b0\u6210\u529f");
                }
            } else if (this.isRefreshing) {
                if (!"\u6b63\u5728\u62fc\u547d\u5237\u65b0\u4e2d".equals(this.textInfo.getText().toString())) {
                    this.textInfo.setText((CharSequence)"\u6b63\u5728\u62fc\u547d\u5237\u65b0\u4e2d");
                }
            } else if (!"\u4e0a\u62c9\u5237\u65b0".equals(this.textInfo.getText().toString())) {
                this.textInfo.setText((CharSequence)"\u4e0a\u62c9\u5237\u65b0");
            }
            int scrollY = Math.abs(NestScrollCombine.this.getScrollY());
            scrollY = (int)(1.6f * (float)(scrollY - (int)((float)this.contentView.getHeight() * 0.68f)));
            scrollY = Math.max(0, scrollY);
            float progress = Math.abs(1.0f * (float)scrollY / (float)this.contentView.getHeight());
            this.circleViewBac.setProgress(progress, true, true);
        }

        ViewHolderHeaderProgress() {
            LinearLayout content = new LinearLayout(NestScrollCombine.this.getContext());
            content.setOrientation(1);
            content.setGravity(17);
            LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(12, 12);
            Space space1 = new Space(NestScrollCombine.this.getContext());
            content.addView((View)space1, (ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams(80, 80);
            CircleViewBac progressBar = new CircleViewBac(NestScrollCombine.this.getContext());
            content.addView((View)progressBar, (ViewGroup.LayoutParams)params);
            this.circleViewBac = progressBar;
            params = new LinearLayout.LayoutParams(80, 80);
            params.setMargins(0, -80, 0, 0);
            ImageView imageView = new ImageView(NestScrollCombine.this.getContext());
            imageView.setPadding(10, 10, 10, 10);
            imageView.setImageResource(R.drawable.progress_update);
            content.addView((View)imageView, (ViewGroup.LayoutParams)params);
            this.imageView = imageView;
            params = new LinearLayout.LayoutParams(8, 8);
            Space space2 = new Space(NestScrollCombine.this.getContext());
            content.addView((View)space2, (ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams(-2, -2);
            TextView textView = new TextView(NestScrollCombine.this.getContext());
            textView.setText((CharSequence)"\u8f7d\u5165\u4e2d...");
            textView.setTextSize(11.0f);
            content.addView((View)textView, (ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams(8, 8);
            Space space3 = new Space(NestScrollCombine.this.getContext());
            content.addView((View)space3, (ViewGroup.LayoutParams)params);
            this.textInfo = textView;
            this.contentView = content;
            LinearLayout root = new LinearLayout(NestScrollCombine.this.getContext());
            root.setOrientation(1);
            root.setGravity(17);
            params = new LinearLayout.LayoutParams(150, 150);
            Space topSpace = new Space(NestScrollCombine.this.getContext());
            root.addView((View)topSpace, (ViewGroup.LayoutParams)params);
            params = new LinearLayout.LayoutParams(-1, -2);
            root.addView((View)content, (ViewGroup.LayoutParams)params);
            this.rootView = root;
        }

        private class CircleViewBac
        extends View {
            float progress;
            boolean isFreshComplete;
            boolean isFreshing;
            Paint arcPaint;
            RectF arcRectF;
            int padding;

            public CircleViewBac(Context context) {
                super(context);
                this.padding = 2;
            }

            public void setProgress(float progress, boolean isFreshComplete, boolean isFreshing) {
                this.progress = progress;
                this.isFreshComplete = isFreshComplete;
                this.isFreshing = isFreshing;
                this.invalidate();
            }

            protected void onDraw(Canvas canvas) {
                super.onDraw(canvas);
                this.drawCircle(canvas);
                this.drawTag(canvas);
            }

            protected void onSizeChanged(int w, int h, int oldw, int oldh) {
                super.onSizeChanged(w, h, oldw, oldh);
                this.arcRectF = new RectF((float)this.padding, (float)this.padding, (float)(w - this.padding), (float)(h - this.padding));
                this.arcPaint = new Paint();
                this.arcPaint.setStrokeWidth(2.0f);
                this.arcPaint.setStyle(Paint.Style.STROKE);
                this.arcPaint.setColor(-65536);
                this.arcPaint.setAntiAlias(true);
            }

            private void drawCircle(Canvas canvas) {
                int sweepAngle = this.progress >= 0.0f && this.progress <= 1.0f ? (int)(360.0f * this.progress) : 360;
                canvas.drawArc(this.arcRectF, 90.0f, (float)sweepAngle, false, this.arcPaint);
                ViewHolderHeaderProgress.this.imageView.setRotation((float)sweepAngle);
                Object view = null;
                System.out.println(this.progress + "xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx");
            }

            private void drawTag(Canvas canvas) {
                if (this.progress < 0.9f) {
                    return;
                }
            }
        }
    }
}

