/*
 * Decompiled with CFR 0.152.
 */
package com.poovam.pinedittextfield;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.text.Editable;
import android.util.AttributeSet;
import com.poovam.pinedittextfield.PinField;
import com.poovam.pinedittextfield.R;
import com.poovam.pinedittextfield.Util;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ:\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u001c\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014R\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/poovam/pinedittextfield/SquarePinField;", "Lcom/poovam/pinedittextfield/PinField;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attr", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyle", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "value", "", "cornerRadius", "setCornerRadius", "(F)V", "cursorPadding", "drawRect", "", "canvas", "Landroid/graphics/Canvas;", "paddedX1", "paddedY1", "paddedX2", "paddedY2", "paint", "Landroid/graphics/Paint;", "initParams", "onDraw", "app_release"})
public final class SquarePinField
extends PinField {
    private float cornerRadius;
    private final float cursorPadding;

    private final void setCornerRadius(float value) {
        this.cornerRadius = value;
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void initParams(AttributeSet attr) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        TypedArray a = context.getTheme().obtainStyledAttributes(attr, R.styleable.SquarePinField, 0, 0);
        try {
            this.setCornerRadius(a.getDimension(R.styleable.SquarePinField_cornerRadius, this.cornerRadius));
        }
        finally {
            a.recycle();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void onDraw(@Nullable Canvas canvas) {
        int n = 0;
        int n2 = this.getNumberOfFields();
        while (n < n2) {
            void i;
            void x1 = i * this.getSingleFieldWidth();
            float padding = (this.getDistanceInBetween() != -1.0f ? this.getDistanceInBetween() : this.getDefaultDistanceInBetween()) / (float)2;
            float paddedX1 = (float)x1 + padding;
            float paddedX2 = (float)(x1 + this.getSingleFieldWidth()) - padding;
            float squareHeight = paddedX2 - paddedX1;
            float paddedY1 = (float)(this.getHeight() / 2) - squareHeight / (float)2;
            float paddedY2 = (float)(this.getHeight() / 2) + squareHeight / (float)2;
            float textX = (paddedX2 - paddedX1) / (float)2 + paddedX1;
            float textY = (paddedY2 - paddedY1) / (float)2 + paddedY1 + this.getLineThickness() + this.getTextPaint().getTextSize() / (float)4;
            Character character = this.getCharAt((int)i);
            this.drawRect(canvas, paddedX1, paddedY1, paddedX2, paddedY2, this.getFieldBgPaint());
            if (this.highlightAllFields() && this.hasFocus()) {
                this.drawRect(canvas, paddedX1, paddedY1, paddedX2, paddedY2, this.getHighlightPaint());
            } else {
                this.drawRect(canvas, paddedX1, paddedY1, paddedX2, paddedY2, this.getFieldPaint());
            }
            if (character != null) {
                Canvas canvas2 = canvas;
                if (canvas2 != null) {
                    canvas2.drawText(String.valueOf(character.charValue()), textX, textY, this.getTextPaint());
                }
            }
            if (this.shouldDrawHint()) {
                CharSequence charSequence = this.getHint();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"hint");
                Character hintChar = StringsKt.getOrNull((CharSequence)charSequence, (int)i);
                if (hintChar != null) {
                    Canvas canvas3 = canvas;
                    if (canvas3 != null) {
                        canvas3.drawText(String.valueOf(hintChar.charValue()), textX, textY, this.getHintPaint());
                    }
                }
            }
            if (this.hasFocus()) {
                Editable editable = this.getText();
                if (i == (editable != null ? editable.length() : 0) && this.isCursorEnabled()) {
                    float cursorPadding = this.cursorPadding + this.getHighLightThickness();
                    float cursorY1 = paddedY1 + cursorPadding;
                    float cursorY2 = paddedY2 - cursorPadding;
                    this.drawCursor(canvas, textX, cursorY1, cursorY2, this.getHighlightPaint());
                }
            }
            Editable editable = this.getText();
            this.highlightLogic((int)i, editable != null ? Integer.valueOf(editable.length()) : null, (Function0<Unit>)((Function0)new Function0<Unit>(this, canvas, paddedX1, paddedY1, paddedX2, paddedY2){
                final /* synthetic */ SquarePinField this$0;
                final /* synthetic */ Canvas $canvas;
                final /* synthetic */ float $paddedX1;
                final /* synthetic */ float $paddedY1;
                final /* synthetic */ float $paddedX2;
                final /* synthetic */ float $paddedY2;

                public final void invoke() {
                    SquarePinField.access$drawRect(this.this$0, this.$canvas, this.$paddedX1, this.$paddedY1, this.$paddedX2, this.$paddedY2, this.this$0.getHighlightPaint());
                }
                {
                    this.this$0 = squarePinField;
                    this.$canvas = canvas;
                    this.$paddedX1 = f;
                    this.$paddedY1 = f2;
                    this.$paddedX2 = f3;
                    this.$paddedY2 = f4;
                    super(0);
                }
            }));
            ++i;
        }
    }

    private final void drawRect(Canvas canvas, float paddedX1, float paddedY1, float paddedX2, float paddedY2, Paint paint) {
        block1: {
            block0: {
                if (!(this.cornerRadius > 0.0f) || Build.VERSION.SDK_INT < 21) break block0;
                Canvas canvas2 = canvas;
                if (canvas2 == null) break block1;
                canvas2.drawRoundRect(paddedX1, paddedY1, paddedX2, paddedY2, this.cornerRadius, this.cornerRadius, paint);
                break block1;
            }
            Canvas canvas3 = canvas;
            if (canvas3 == null) break block1;
            canvas3.drawRect(paddedX1, paddedY1, paddedX2, paddedY2, paint);
        }
    }

    public SquarePinField(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.cursorPadding = Util.dpToPx(5.0f);
    }

    public SquarePinField(@NotNull Context context, @NotNull AttributeSet attr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        super(context, attr);
        this.cursorPadding = Util.dpToPx(5.0f);
        this.initParams(attr);
    }

    public SquarePinField(@NotNull Context context, @NotNull AttributeSet attr, int defStyle) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        super(context, attr, defStyle);
        this.cursorPadding = Util.dpToPx(5.0f);
        this.initParams(attr);
    }

    public static final /* synthetic */ void access$drawRect(SquarePinField $this, Canvas canvas, float paddedX1, float paddedY1, float paddedX2, float paddedY2, Paint paint) {
        $this.drawRect(canvas, paddedX1, paddedY1, paddedX2, paddedY2, paint);
    }
}

