/*
 * Decompiled with CFR 0.152.
 */
package wigzo.android.sdk;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import java.lang.reflect.Method;
import wigzo.android.sdk.DeviceId;

public class MessagingAdapter {
    private static final String TAG = "MessagingAdapter";
    private static final String MESSAGING_CLASS_NAME = "wigzo.android.sdk.messaging.WigzoMessaging";

    public static boolean isMessagingAvailable() {
        boolean messagingAvailable = false;
        try {
            Class.forName(MESSAGING_CLASS_NAME);
            messagingAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return messagingAvailable;
    }

    public static boolean init(Activity activity, Class<? extends Activity> activityClass, String sender, String[] buttonNames) {
        try {
            Class<?> cls = Class.forName(MESSAGING_CLASS_NAME);
            Method method = cls.getMethod("init", Activity.class, Class.class, String.class, String[].class);
            method.invoke(null, activity, activityClass, sender, buttonNames);
            return true;
        }
        catch (Throwable logged) {
            Log.e((String)TAG, (String)"Couldn't init Wigzo Messaging", (Throwable)logged);
            return false;
        }
    }

    public static boolean storeConfiguration(Context context, String serverURL, String appKey, String deviceID, DeviceId.Type idMode, String orgId) {
        try {
            Class<?> cls = Class.forName(MESSAGING_CLASS_NAME);
            Method method = cls.getMethod("storeConfiguration", Context.class, String.class, String.class, String.class, DeviceId.Type.class, String.class);
            method.invoke(null, new Object[]{context, serverURL, appKey, deviceID, idMode, orgId});
            return true;
        }
        catch (Throwable logged) {
            Log.e((String)TAG, (String)"Couldn't store configuration in Wigzo Messaging", (Throwable)logged);
            return false;
        }
    }
}

