/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.CommentsTableBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBackedCommentsTable
extends CommentsTableBase {
    private static Logger log = LoggerFactory.getLogger(MapBackedCommentsTable.class);

    public MapBackedCommentsTable() {
        this(false);
    }

    public MapBackedCommentsTable(boolean fullFormat) {
        super(fullFormat);
        this.comments = new ConcurrentHashMap();
        this.authors = new ConcurrentHashMap();
    }

    public MapBackedCommentsTable(OPCPackage pkg) throws IOException {
        this(pkg, false);
    }

    public MapBackedCommentsTable(OPCPackage pkg, boolean fullFormat) throws IOException {
        this(fullFormat);
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.SHEET_COMMENTS.getContentType());
        if (!parts.isEmpty()) {
            PackagePart sstPart = (PackagePart)parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Iterator<Integer> authorsKeyIterator() {
        return this.authors.keySet().iterator();
    }

    @Override
    protected Iterator<String> commentsKeyIterator() {
        return this.comments.keySet().iterator();
    }

    @Override
    public void close() {
        this.comments.clear();
        this.authors.clear();
    }
}

