/*
 * Decompiled with CFR 0.152.
 */
package com.github.piasy.biv.loader.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.SimpleTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.github.piasy.biv.loader.ImageLoader;
import com.github.piasy.biv.loader.glide.GlideLoaderException;
import com.github.piasy.biv.loader.glide.GlideProgressSupport;
import com.github.piasy.biv.loader.glide.ImageDownloadTarget;
import com.github.piasy.biv.loader.glide.R;
import com.github.piasy.biv.view.BigImageView;
import java.io.File;
import okhttp3.OkHttpClient;

public final class GlideImageLoader
implements ImageLoader {
    private final RequestManager mRequestManager;

    private GlideImageLoader(Context context, OkHttpClient okHttpClient) {
        GlideProgressSupport.init(Glide.get((Context)context), okHttpClient);
        this.mRequestManager = Glide.with((Context)context);
    }

    public static GlideImageLoader with(Context context) {
        return GlideImageLoader.with(context, null);
    }

    public static GlideImageLoader with(Context context, OkHttpClient okHttpClient) {
        return new GlideImageLoader(context, okHttpClient);
    }

    public void loadImage(Uri uri, final ImageLoader.Callback callback) {
        this.mRequestManager.downloadOnly().load(uri).into((Target)new ImageDownloadTarget(uri.toString()){

            public void onResourceReady(File resource, Transition<? super File> transition) {
                callback.onCacheHit(resource);
                callback.onSuccess(resource);
            }

            @Override
            public void onLoadFailed(Drawable errorDrawable) {
                callback.onFail((Exception)new GlideLoaderException(errorDrawable));
            }

            @Override
            public void onDownloadStart() {
                callback.onStart();
            }

            @Override
            public void onProgress(int progress) {
                callback.onProgress(progress);
            }

            @Override
            public void onDownloadFinish() {
                callback.onFinish();
            }
        });
    }

    public View showThumbnail(BigImageView parent, Uri thumbnail, int scaleType) {
        ImageView thumbnailView = (ImageView)LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.ui_glide_thumbnail, (ViewGroup)parent, false);
        switch (scaleType) {
            case 2: {
                thumbnailView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                break;
            }
            case 1: {
                thumbnailView.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            }
        }
        this.mRequestManager.load((Object)thumbnail).into(thumbnailView);
        return thumbnailView;
    }

    public void prefetch(Uri uri) {
        this.mRequestManager.downloadOnly().load(uri).into((Target)new SimpleTarget<File>(){

            public void onResourceReady(File resource, Transition<? super File> transition) {
            }
        });
    }
}

