/*
 * Decompiled with CFR 0.152.
 */
package com.github.phillipkruger.profiling.repository;

import com.github.phillipkruger.profiling.UserEvent;
import com.github.phillipkruger.profiling.UserEventConverter;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.json.JsonObject;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestStatus;

@Dependent
public class EventLoggerFallbackHandler
implements FallbackHandler<Future<Void>> {
    private static final Logger log = Logger.getLogger(EventLoggerFallbackHandler.class.getName());
    @Inject
    private Client client;
    @Inject
    private UserEventConverter converter;

    public Future<Void> handle(ExecutionContext context) {
        UserEvent event = (UserEvent)context.getParameters()[1];
        log.log(Level.SEVERE, ">>> Save error: log event [{0}] ...", event);
        JsonObject json = this.converter.toJsonObject(event);
        IndexResponse response = (IndexResponse)this.client.prepareIndex("failure", "event").setSource(json.toString(), XContentType.JSON).get();
        RestStatus status = response.status();
        log.log(Level.SEVERE, ">>> Status [{0}] ...", status.getStatus());
        return CompletableFuture.completedFuture(null);
    }
}

