/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;

final class FastIntegerFixed
implements Comparable<FastIntegerFixed> {
    private int smallValue;
    private EInteger largeValue;
    private int integerMode;
    public static final FastIntegerFixed Zero = new FastIntegerFixed(0);
    public static final FastIntegerFixed One = new FastIntegerFixed(1);
    private static final EInteger ValueInt32MinValue = EInteger.FromInt64(Integer.MIN_VALUE);
    private static final EInteger ValueNegativeInt32MinValue = ValueInt32MinValue.Negate();

    FastIntegerFixed(int value) {
        this.smallValue = value;
    }

    public boolean equals(Object obj) {
        FastIntegerFixed fi;
        FastIntegerFixed fastIntegerFixed = fi = obj instanceof FastIntegerFixed ? (FastIntegerFixed)obj : null;
        if (fi == null) {
            return false;
        }
        if (this.integerMode != fi.integerMode) {
            return false;
        }
        return !(this.integerMode == 0 ? this.smallValue != fi.smallValue : this.integerMode == 1 && !this.largeValue.equals(fi.largeValue));
    }

    public int hashCode() {
        int hash = 31 + this.integerMode;
        if (this.integerMode == 0) {
            hash = hash * 31 + this.smallValue;
        } else if (this.integerMode == 1) {
            hash = hash * 31 + this.largeValue.hashCode();
        }
        return hash;
    }

    static FastIntegerFixed FromLong(long longVal) {
        if (longVal >= Integer.MIN_VALUE && longVal <= Integer.MAX_VALUE) {
            return new FastIntegerFixed((int)longVal);
        }
        FastIntegerFixed fi = new FastIntegerFixed(0);
        fi.integerMode = 2;
        fi.largeValue = EInteger.FromInt64(longVal);
        return fi;
    }

    static FastIntegerFixed FromBig(EInteger bigintVal) {
        if (bigintVal.CanFitInInt32()) {
            return new FastIntegerFixed(bigintVal.ToInt32Unchecked());
        }
        FastIntegerFixed fi = new FastIntegerFixed(0);
        fi.integerMode = 2;
        fi.largeValue = bigintVal;
        return fi;
    }

    int AsInt32() {
        return this.integerMode == 0 ? this.smallValue : this.largeValue.ToInt32Unchecked();
    }

    public static FastIntegerFixed FromFastInteger(FastInteger fi) {
        if (fi.CanFitInInt32()) {
            return new FastIntegerFixed(fi.AsInt32());
        }
        return FastIntegerFixed.FromBig(fi.AsEInteger());
    }

    public FastInteger ToFastInteger() {
        if (this.integerMode == 0) {
            return new FastInteger(this.smallValue);
        }
        return FastInteger.FromBig(this.largeValue);
    }

    public FastIntegerFixed Increment() {
        if (this.integerMode == 0 && this.smallValue != Integer.MAX_VALUE) {
            return new FastIntegerFixed(this.smallValue + 1);
        }
        return FastIntegerFixed.Add(this, One);
    }

    public int Mod(int value) {
        if (value < 0) {
            throw new UnsupportedOperationException();
        }
        if (this.integerMode == 0 && this.smallValue >= 0) {
            return this.smallValue % value;
        }
        EInteger retval = this.ToEInteger().Remainder(EInteger.FromInt32(value));
        return retval.ToInt32Checked();
    }

    public static FastIntegerFixed Add(FastIntegerFixed a, FastIntegerFixed b) {
        if (a.integerMode == 0 && b.integerMode == 0) {
            if (a.smallValue == 0) {
                return b;
            }
            if (b.smallValue == 0) {
                return a;
            }
            if (a.smallValue < 0 && b.smallValue >= Integer.MIN_VALUE - a.smallValue || a.smallValue > 0 && b.smallValue <= Integer.MAX_VALUE - a.smallValue) {
                return new FastIntegerFixed(a.smallValue + b.smallValue);
            }
        }
        EInteger bigA = a.ToEInteger();
        EInteger bigB = b.ToEInteger();
        return FastIntegerFixed.FromBig(bigA.Add(bigB));
    }

    public static FastIntegerFixed Subtract(FastIntegerFixed a, FastIntegerFixed b) {
        if (a.integerMode == 0 && b.integerMode == 0) {
            if (b.smallValue == 0) {
                return a;
            }
            if (b.smallValue < 0 && Integer.MAX_VALUE + b.smallValue >= a.smallValue || b.smallValue > 0 && Integer.MIN_VALUE + b.smallValue <= a.smallValue) {
                return new FastIntegerFixed(a.smallValue - b.smallValue);
            }
        }
        EInteger bigA = a.ToEInteger();
        EInteger bigB = b.ToEInteger();
        return FastIntegerFixed.FromBig(bigA.Subtract(bigB));
    }

    @Override
    public int compareTo(FastIntegerFixed val) {
        switch (this.integerMode << 2 | val.integerMode) {
            case 0: {
                int vsv = val.smallValue;
                return this.smallValue == vsv ? 0 : (this.smallValue < vsv ? -1 : 1);
            }
            case 2: {
                return this.ToEInteger().compareTo(val.largeValue);
            }
            case 8: 
            case 10: {
                return this.largeValue.compareTo(val.ToEInteger());
            }
        }
        throw new IllegalStateException();
    }

    FastIntegerFixed Negate() {
        switch (this.integerMode) {
            case 0: {
                if (this.smallValue == Integer.MIN_VALUE) {
                    return FastIntegerFixed.FromBig(ValueNegativeInt32MinValue);
                }
                return new FastIntegerFixed(-this.smallValue);
            }
            case 2: {
                return FastIntegerFixed.FromBig(this.largeValue.Negate());
            }
        }
        throw new IllegalStateException();
    }

    final boolean isEvenNumber() {
        switch (this.integerMode) {
            case 0: {
                return (this.smallValue & 1) == 0;
            }
            case 2: {
                return this.largeValue.isEven();
            }
        }
        throw new IllegalStateException();
    }

    boolean CanFitInInt32() {
        return this.integerMode == 0 || this.largeValue.CanFitInInt32();
    }

    public String toString() {
        switch (this.integerMode) {
            case 0: {
                return FastInteger.IntToString(this.smallValue);
            }
            case 2: {
                return this.largeValue.toString();
            }
        }
        return "";
    }

    final int signum() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0 ? 0 : (this.smallValue < 0 ? -1 : 1);
            }
            case 2: {
                return this.largeValue.signum();
            }
        }
        return 0;
    }

    final boolean isValueZero() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue == 0;
            }
            case 2: {
                return this.largeValue.isZero();
            }
        }
        return false;
    }

    boolean CanFitInInt64() {
        switch (this.integerMode) {
            case 0: {
                return true;
            }
            case 2: {
                return this.largeValue.CanFitInInt64();
            }
        }
        throw new IllegalStateException();
    }

    long AsInt64() {
        switch (this.integerMode) {
            case 0: {
                return this.smallValue;
            }
            case 2: {
                return this.largeValue.ToInt64Unchecked();
            }
        }
        throw new IllegalStateException();
    }

    int CompareToInt(int val) {
        switch (this.integerMode) {
            case 0: {
                return val == this.smallValue ? 0 : (this.smallValue < val ? -1 : 1);
            }
            case 2: {
                return this.largeValue.compareTo(EInteger.FromInt32(val));
            }
        }
        return 0;
    }

    EInteger ToEInteger() {
        switch (this.integerMode) {
            case 0: {
                return EInteger.FromInt32(this.smallValue);
            }
            case 2: {
                return this.largeValue;
            }
        }
        throw new IllegalStateException();
    }
}

