/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.BitShiftAccumulator;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.ExtendedOrSimpleRadixMath;
import com.upokecenter.numbers.Extras;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.FastIntegerFixed;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;
import com.upokecenter.numbers.NumberUtility;
import com.upokecenter.numbers.TrappableRadixMath;

public final class EFloat
implements Comparable<EFloat> {
    public static final EFloat NaN = EFloat.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 4);
    public static final EFloat NegativeInfinity = EFloat.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 3);
    public static final EFloat NegativeZero = EFloat.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 1);
    public static final EFloat One = EFloat.Create(EInteger.FromInt32(1), EInteger.FromInt32(0));
    public static final EFloat PositiveInfinity = EFloat.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 2);
    public static final EFloat SignalingNaN = EFloat.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(0), 8);
    public static final EFloat Ten = EFloat.Create(EInteger.FromInt32(10), EInteger.FromInt32(0));
    public static final EFloat Zero = EFloat.Create(EInteger.FromInt32(0), EInteger.FromInt32(0));
    private static final IRadixMath<EFloat> MathValue = new TrappableRadixMath<EFloat>(new ExtendedOrSimpleRadixMath<EFloat>(new BinaryMathHelper()));
    private final EInteger exponent;
    private final int flags;
    private final EInteger unsignedMantissa;

    private EFloat(EInteger unsignedMantissa, EInteger exponent, int flags) {
        this.unsignedMantissa = unsignedMantissa;
        this.exponent = exponent;
        this.flags = flags;
    }

    public final EInteger getExponent() {
        return this.exponent;
    }

    public final boolean isFinite() {
        return (this.flags & 0xE) == 0;
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isZero();
    }

    public final EInteger getMantissa() {
        return this.isNegative() ? this.unsignedMantissa.Negate() : this.unsignedMantissa;
    }

    public final int signum() {
        return (this.flags & 0xE) == 0 && this.unsignedMantissa.isZero() ? 0 : ((this.flags & 1) != 0 ? -1 : 1);
    }

    public final EInteger getUnsignedMantissa() {
        return this.unsignedMantissa;
    }

    public static EFloat Create(int mantissaSmall, int exponentSmall) {
        return EFloat.Create(EInteger.FromInt32(mantissaSmall), EInteger.FromInt32(exponentSmall));
    }

    public static EFloat Create(EInteger mantissa, EInteger exponent) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa.signum();
        return new EFloat(sign < 0 ? mantissa.Negate() : mantissa, exponent, sign < 0 ? 1 : 0);
    }

    public static EFloat CreateNaN(EInteger diag) {
        return EFloat.CreateNaN(diag, false, false, null);
    }

    public static EFloat CreateNaN(EInteger diag, boolean signaling, boolean negative, EContext ctx) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        if (ctx != null && ctx.getHasMaxPrecision()) {
            EFloat ef = EFloat.CreateWithFlags(diag, EInteger.FromInt32(0), flags |= 4).RoundToPrecision(ctx);
            int newFlags = ef.flags;
            newFlags &= 0xFFFFFFFB;
            return new EFloat(ef.unsignedMantissa, ef.exponent, newFlags |= signaling ? 8 : 4);
        }
        return EFloat.CreateWithFlags(diag, EInteger.FromInt32(0), flags |= signaling ? 8 : 4);
    }

    public static EFloat FromDouble(double dbl) {
        boolean neg;
        int[] value = Extras.DoubleToIntegers(dbl);
        int floatExponent = value[1] >> 20 & 0x7FF;
        boolean bl = neg = value[1] >> 31 != 0;
        if (floatExponent == 2047) {
            if ((value[1] & 0xFFFFF) == 0 && value[0] == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (value[1] & 0x80000) != 0;
            value[1] = value[1] & 0x7FFFF;
            long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
            if (lvalue == 0L) {
                return quiet ? NaN : SignalingNaN;
            }
            value[0] = (neg ? 1 : 0) | (quiet ? 4 : 8);
            return EFloat.CreateWithFlags(EInteger.FromInt64(lvalue), EInteger.FromInt32(0), value[0]);
        }
        value[1] = value[1] & 0xFFFFF;
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            value[1] = value[1] | 0x100000;
        }
        if ((value[1] | value[0]) == 0) {
            return neg ? NegativeZero : Zero;
        }
        long lvalue = (long)value[0] & 0xFFFFFFFFL | (long)value[1] << 32;
        return EFloat.CreateWithFlags(EInteger.FromInt64(lvalue), EInteger.FromInt64((floatExponent += NumberUtility.ShiftAwayTrailingZerosTwoElements(value)) - 1075), neg ? 1 : 0);
    }

    public static EFloat FromEInteger(EInteger bigint) {
        return EFloat.Create(bigint, EInteger.FromInt32(0));
    }

    public static EFloat FromSingle(float flt) {
        int value = Float.floatToRawIntBits(flt);
        boolean neg = value >> 31 != 0;
        int floatExponent = value >> 23 & 0xFF;
        int valueFpMantissa = value & 0x7FFFFF;
        if (floatExponent == 255) {
            if (valueFpMantissa == 0) {
                return neg ? NegativeInfinity : PositiveInfinity;
            }
            boolean quiet = (valueFpMantissa & 0x400000) != 0;
            EInteger bigmant = EInteger.FromInt32(valueFpMantissa &= 0x3FFFFF);
            value = (neg ? 1 : 0) | (quiet ? 4 : 8);
            if (bigmant.isZero()) {
                return quiet ? NaN : SignalingNaN;
            }
            return EFloat.CreateWithFlags(bigmant, EInteger.FromInt32(0), value);
        }
        if (floatExponent == 0) {
            ++floatExponent;
        } else {
            valueFpMantissa |= 0x800000;
        }
        if (valueFpMantissa == 0) {
            return neg ? NegativeZero : Zero;
        }
        while ((valueFpMantissa & 1) == 0) {
            ++floatExponent;
            valueFpMantissa >>= 1;
        }
        if (neg) {
            valueFpMantissa = -valueFpMantissa;
        }
        EInteger bigmant = EInteger.FromInt32(valueFpMantissa);
        return EFloat.Create(bigmant, EInteger.FromInt64(floatExponent - 150));
    }

    public static EFloat FromString(String str, int offset, int length, EContext ctx) {
        if (str == null) {
            throw new NullPointerException("str");
        }
        return EDecimal.FromString(str, offset, length, EContext.Unlimited.WithSimplified(ctx != null && ctx.isSimplified())).ToEFloat(ctx);
    }

    public static EFloat FromString(String str) {
        return EFloat.FromString(str, 0, str == null ? 0 : str.length(), null);
    }

    public static EFloat FromString(String str, EContext ctx) {
        return EFloat.FromString(str, 0, str == null ? 0 : str.length(), ctx);
    }

    public static EFloat FromString(String str, int offset, int length) {
        return EFloat.FromString(str, offset, length, null);
    }

    public static EFloat Max(EFloat first, EFloat second, EContext ctx) {
        return MathValue.Max(first, second, ctx);
    }

    public static EFloat Max(EFloat first, EFloat second) {
        return EFloat.Max(first, second, null);
    }

    public static EFloat MaxMagnitude(EFloat first, EFloat second, EContext ctx) {
        return MathValue.MaxMagnitude(first, second, ctx);
    }

    public static EFloat MaxMagnitude(EFloat first, EFloat second) {
        return EFloat.MaxMagnitude(first, second, null);
    }

    public static EFloat Min(EFloat first, EFloat second, EContext ctx) {
        return MathValue.Min(first, second, ctx);
    }

    public static EFloat Min(EFloat first, EFloat second) {
        return EFloat.Min(first, second, null);
    }

    public static EFloat MinMagnitude(EFloat first, EFloat second, EContext ctx) {
        return MathValue.MinMagnitude(first, second, ctx);
    }

    public static EFloat MinMagnitude(EFloat first, EFloat second) {
        return EFloat.MinMagnitude(first, second, null);
    }

    public static EFloat PI(EContext ctx) {
        return MathValue.Pi(ctx);
    }

    public EFloat Abs() {
        if (this.isNegative()) {
            EFloat er = new EFloat(this.unsignedMantissa, this.exponent, this.flags & 0xFFFFFFFE);
            return er;
        }
        return this;
    }

    public EFloat Abs(EContext context) {
        return MathValue.Abs(this, context);
    }

    public EFloat Add(int intValue) {
        return this.Add(EFloat.FromInt32(intValue));
    }

    public EFloat Subtract(int intValue) {
        return intValue == Integer.MIN_VALUE ? this.Subtract(EFloat.FromInt32(intValue)) : this.Add(-intValue);
    }

    public EFloat Multiply(int intValue) {
        return this.Multiply(EFloat.FromInt32(intValue));
    }

    public EFloat Divide(int intValue) {
        return this.Divide(EFloat.FromInt32(intValue));
    }

    public EFloat Add(EFloat otherValue) {
        return this.Add(otherValue, EContext.UnlimitedHalfEven);
    }

    public EFloat Add(EFloat otherValue, EContext ctx) {
        return MathValue.Add(this, otherValue, ctx);
    }

    @Override
    public int compareTo(EFloat other) {
        return MathValue.compareTo(this, other);
    }

    public EFloat CompareToSignal(EFloat other, EContext ctx) {
        return MathValue.CompareToWithContext(this, other, true, ctx);
    }

    public int CompareToTotal(EFloat other, EContext ctx) {
        if (other == null) {
            return -1;
        }
        if (this.IsSignalingNaN() || other.IsSignalingNaN()) {
            return this.CompareToTotal(other);
        }
        if (ctx != null && ctx.isSimplified()) {
            return this.RoundToPrecision(ctx).CompareToTotal(other.RoundToPrecision(ctx));
        }
        return this.CompareToTotal(other);
    }

    public int CompareToTotal(EFloat other) {
        boolean neg2;
        if (other == null) {
            return -1;
        }
        boolean neg1 = this.isNegative();
        if (neg1 != (neg2 = other.isNegative())) {
            return neg1 ? -1 : 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return neg1 ? -1 : 1;
        }
        if (valueIThis < valueIOther) {
            return neg1 ? 1 : -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return neg1 ? -cmp : cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.compareTo(other);
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return neg1 ? -cmp : cmp;
        }
        return cmp;
    }

    public int CompareToTotalMagnitude(EFloat other) {
        if (other == null) {
            return -1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return 1;
        }
        if (valueIThis < valueIOther) {
            return -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedMantissa.compareTo(other.unsignedMantissa);
            return cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.Abs().compareTo(other.Abs());
        if (cmp == 0) {
            cmp = this.exponent.compareTo(other.exponent);
            return cmp;
        }
        return cmp;
    }

    public EFloat CompareToWithContext(EFloat other, EContext ctx) {
        return MathValue.CompareToWithContext(this, other, false, ctx);
    }

    public EFloat CopySign(EFloat other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.isNegative()) {
            return other.isNegative() ? this : this.Negate();
        }
        return other.isNegative() ? this.Negate() : this;
    }

    public EFloat Divide(EFloat divisor) {
        return this.Divide(divisor, EContext.ForRounding(ERounding.None));
    }

    public EFloat Divide(EFloat divisor, EContext ctx) {
        return MathValue.Divide(this, divisor, ctx);
    }

    @Deprecated
    public EFloat[] DivideAndRemainderNaturalScale(EFloat divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    @Deprecated
    public EFloat[] DivideAndRemainderNaturalScale(EFloat divisor, EContext ctx) {
        return this.DivRemNaturalScale(divisor, ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, long desiredExponentSmall, EContext ctx) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, long desiredExponentSmall, ERounding rounding) {
        return this.DivideToExponent(divisor, EInteger.FromInt64(desiredExponentSmall), EContext.ForRounding(rounding));
    }

    public EFloat DivideToExponent(EFloat divisor, EInteger exponent, EContext ctx) {
        return MathValue.DivideToExponent(this, divisor, exponent, ctx);
    }

    public EFloat DivideToExponent(EFloat divisor, EInteger desiredExponent, ERounding rounding) {
        return this.DivideToExponent(divisor, desiredExponent, EContext.ForRounding(rounding));
    }

    public EFloat DivideToIntegerNaturalScale(EFloat divisor) {
        return this.DivideToIntegerNaturalScale(divisor, EContext.ForRounding(ERounding.Down));
    }

    public EFloat DivideToIntegerNaturalScale(EFloat divisor, EContext ctx) {
        return MathValue.DivideToIntegerNaturalScale(this, divisor, ctx);
    }

    public EFloat DivideToIntegerZeroScale(EFloat divisor, EContext ctx) {
        return MathValue.DivideToIntegerZeroScale(this, divisor, ctx);
    }

    public EFloat DivideToSameExponent(EFloat divisor, ERounding rounding) {
        return this.DivideToExponent(divisor, this.exponent, EContext.ForRounding(rounding));
    }

    public EFloat[] DivRemNaturalScale(EFloat divisor) {
        return this.DivRemNaturalScale(divisor, null);
    }

    public EFloat[] DivRemNaturalScale(EFloat divisor, EContext ctx) {
        EFloat[] result;
        result = new EFloat[]{this.DivideToIntegerNaturalScale(divisor, null), this.Subtract(result[0].Multiply(divisor, null), ctx)};
        result[0] = result[0].RoundToPrecision(ctx);
        return result;
    }

    public boolean equals(EFloat other) {
        return this.EqualsInternal(other);
    }

    public boolean equals(Object obj) {
        return this.EqualsInternal(obj instanceof EFloat ? (EFloat)obj : null);
    }

    public boolean EqualsInternal(EFloat otherValue) {
        if (otherValue == null) {
            return false;
        }
        return this.exponent.equals(otherValue.exponent) && this.unsignedMantissa.equals(otherValue.unsignedMantissa) && this.flags == otherValue.flags;
    }

    public EFloat Exp(EContext ctx) {
        return MathValue.Exp(this, ctx);
    }

    public int hashCode() {
        int valueHashCode = 403796923;
        valueHashCode += 403797019 * this.exponent.hashCode();
        valueHashCode += 403797059 * this.unsignedMantissa.hashCode();
        return valueHashCode += 403797127 * this.flags;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public EFloat Log(EContext ctx) {
        return MathValue.Ln(this, ctx);
    }

    public EFloat Log10(EContext ctx) {
        return MathValue.Log10(this, ctx);
    }

    public EFloat MovePointLeft(int places) {
        return this.MovePointLeft(EInteger.FromInt32(places), null);
    }

    public EFloat MovePointLeft(int places, EContext ctx) {
        return this.MovePointLeft(EInteger.FromInt32(places), ctx);
    }

    public EFloat MovePointLeft(EInteger bigPlaces) {
        return this.MovePointLeft(bigPlaces, null);
    }

    public EFloat MovePointLeft(EInteger bigPlaces, EContext ctx) {
        return !this.isFinite() ? this.RoundToPrecision(ctx) : this.MovePointRight(bigPlaces.Negate(), ctx);
    }

    public EFloat MovePointRight(int places) {
        return this.MovePointRight(EInteger.FromInt32(places), null);
    }

    public EFloat MovePointRight(int places, EContext ctx) {
        return this.MovePointRight(EInteger.FromInt32(places), ctx);
    }

    public EFloat MovePointRight(EInteger bigPlaces) {
        return this.MovePointRight(bigPlaces, null);
    }

    public EFloat MovePointRight(EInteger bigPlaces, EContext ctx) {
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        if ((bigExp = bigExp.Add(bigPlaces)).signum() > 0) {
            EInteger mant = NumberUtility.ShiftLeft(this.unsignedMantissa, bigExp);
            return EFloat.CreateWithFlags(mant, EInteger.FromInt32(0), this.flags).RoundToPrecision(ctx);
        }
        return EFloat.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public EFloat Multiply(EFloat otherValue) {
        if (this.isFinite() && otherValue.isFinite()) {
            EInteger exp = this.exponent.Add(otherValue.exponent);
            int newflags = otherValue.flags ^ this.flags;
            if (this.unsignedMantissa.CanFitInInt32() && otherValue.unsignedMantissa.CanFitInInt32()) {
                int integerA = this.unsignedMantissa.ToInt32Unchecked();
                int integerB = otherValue.unsignedMantissa.ToInt32Unchecked();
                long longA = (long)integerA * (long)integerB;
                return EFloat.CreateWithFlags(EInteger.FromInt64(longA), exp, newflags);
            }
            EInteger eintA = this.unsignedMantissa.Multiply(otherValue.unsignedMantissa);
            return EFloat.CreateWithFlags(eintA, exp, newflags);
        }
        return this.Multiply(otherValue, EContext.UnlimitedHalfEven);
    }

    public EFloat Multiply(EFloat op, EContext ctx) {
        return MathValue.Multiply(this, op, ctx);
    }

    public EFloat MultiplyAndAdd(EFloat multiplicand, EFloat augend) {
        return this.MultiplyAndAdd(multiplicand, augend, null);
    }

    public EFloat MultiplyAndAdd(EFloat op, EFloat augend, EContext ctx) {
        return MathValue.MultiplyAndAdd(this, op, augend, ctx);
    }

    public EFloat MultiplyAndSubtract(EFloat op, EFloat subtrahend, EContext ctx) {
        if (op == null) {
            throw new NullPointerException("op");
        }
        if (subtrahend == null) {
            throw new NullPointerException("subtrahend");
        }
        EFloat negated = subtrahend;
        if ((subtrahend.flags & 0xC) == 0) {
            int newflags = subtrahend.flags ^ 1;
            negated = EFloat.CreateWithFlags(subtrahend.unsignedMantissa, subtrahend.exponent, newflags);
        }
        return MathValue.MultiplyAndAdd(this, op, negated, ctx);
    }

    public EFloat Negate() {
        return new EFloat(this.unsignedMantissa, this.exponent, this.flags ^ 1);
    }

    public EFloat Negate(EContext context) {
        return MathValue.Negate(this, context);
    }

    public EFloat NextMinus(EContext ctx) {
        return MathValue.NextMinus(this, ctx);
    }

    public EFloat NextPlus(EContext ctx) {
        return MathValue.NextPlus(this, ctx);
    }

    public EFloat NextToward(EFloat otherValue, EContext ctx) {
        return MathValue.NextToward(this, otherValue, ctx);
    }

    public EFloat Plus(EContext ctx) {
        return MathValue.Plus(this, ctx);
    }

    public EFloat Pow(EFloat exponent, EContext ctx) {
        return MathValue.Power(this, exponent, ctx);
    }

    public EFloat Pow(int exponentSmall, EContext ctx) {
        return this.Pow(EFloat.FromInt64(exponentSmall), ctx);
    }

    public EFloat Pow(int exponentSmall) {
        return this.Pow(EFloat.FromInt64(exponentSmall), null);
    }

    public EInteger Precision() {
        if (!this.isFinite()) {
            return EInteger.FromInt32(0);
        }
        return this.isZero() ? EInteger.FromInt32(1) : this.unsignedMantissa.GetSignedBitLengthAsEInteger();
    }

    public EFloat Quantize(EInteger desiredExponent, EContext ctx) {
        return this.Quantize(EFloat.Create(EInteger.FromInt32(1), desiredExponent), ctx);
    }

    public EFloat Quantize(int desiredExponentInt, EContext ctx) {
        return this.Quantize(EFloat.Create(EInteger.FromInt32(1), EInteger.FromInt32(desiredExponentInt)), ctx);
    }

    public EFloat Quantize(EFloat otherValue, EContext ctx) {
        return MathValue.Quantize(this, otherValue, ctx);
    }

    public EFloat Reduce(EContext ctx) {
        return MathValue.Reduce(this, ctx);
    }

    public EFloat Remainder(EFloat divisor, EContext ctx) {
        return MathValue.Remainder(this, divisor, ctx, true);
    }

    public EFloat RemainderNoRoundAfterDivide(EFloat divisor, EContext ctx) {
        return MathValue.Remainder(this, divisor, ctx, false);
    }

    public EFloat RemainderNaturalScale(EFloat divisor) {
        return this.RemainderNaturalScale(divisor, null);
    }

    public EFloat RemainderNaturalScale(EFloat divisor, EContext ctx) {
        return this.Subtract(this.DivideToIntegerNaturalScale(divisor, null).Multiply(divisor, null), ctx);
    }

    public EFloat RemainderNear(EFloat divisor, EContext ctx) {
        return MathValue.RemainderNear(this, divisor, ctx);
    }

    public EFloat RoundToExponent(EInteger exponent, EContext ctx) {
        return MathValue.RoundToExponentSimple(this, exponent, ctx);
    }

    public EFloat RoundToExponent(int exponentSmall, EContext ctx) {
        return this.RoundToExponent(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EFloat RoundToExponentExact(EInteger exponent, EContext ctx) {
        return MathValue.RoundToExponentExact(this, exponent, ctx);
    }

    public EFloat RoundToExponentExact(EInteger exponent, ERounding rounding) {
        return MathValue.RoundToExponentExact(this, exponent, EContext.Unlimited.WithRounding(rounding));
    }

    public EFloat RoundToExponentExact(int exponentSmall, EContext ctx) {
        return this.RoundToExponentExact(EInteger.FromInt32(exponentSmall), ctx);
    }

    public EFloat RoundToIntegerExact(EContext ctx) {
        return MathValue.RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    public EFloat RoundToIntegerNoRoundedFlag(EContext ctx) {
        return MathValue.RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EFloat RoundToIntegralExact(EContext ctx) {
        return MathValue.RoundToExponentExact(this, EInteger.FromInt32(0), ctx);
    }

    @Deprecated
    public EFloat RoundToIntegralNoRoundedFlag(EContext ctx) {
        return MathValue.RoundToExponentNoRoundedFlag(this, EInteger.FromInt32(0), ctx);
    }

    public EFloat RoundToPrecision(EContext ctx) {
        return MathValue.RoundToPrecision(this, ctx);
    }

    public EFloat ScaleByPowerOfTwo(int places) {
        return this.ScaleByPowerOfTwo(EInteger.FromInt32(places), null);
    }

    public EFloat ScaleByPowerOfTwo(int places, EContext ctx) {
        return this.ScaleByPowerOfTwo(EInteger.FromInt32(places), ctx);
    }

    public EFloat ScaleByPowerOfTwo(EInteger bigPlaces) {
        return this.ScaleByPowerOfTwo(bigPlaces, null);
    }

    public EFloat ScaleByPowerOfTwo(EInteger bigPlaces, EContext ctx) {
        if (bigPlaces.isZero()) {
            return this.RoundToPrecision(ctx);
        }
        if (!this.isFinite()) {
            return this.RoundToPrecision(ctx);
        }
        EInteger bigExp = this.getExponent();
        bigExp = bigExp.Add(bigPlaces);
        return EFloat.CreateWithFlags(this.unsignedMantissa, bigExp, this.flags).RoundToPrecision(ctx);
    }

    public EFloat Sqrt(EContext ctx) {
        return MathValue.SquareRoot(this, ctx);
    }

    @Deprecated
    public EFloat SquareRoot(EContext ctx) {
        return MathValue.SquareRoot(this, ctx);
    }

    public EFloat Subtract(EFloat otherValue) {
        return this.Subtract(otherValue, null);
    }

    public EFloat Subtract(EFloat otherValue, EContext ctx) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        EFloat negated = otherValue;
        if ((otherValue.flags & 0xC) == 0) {
            int newflags = otherValue.flags ^ 1;
            negated = EFloat.CreateWithFlags(otherValue.unsignedMantissa, otherValue.exponent, newflags);
        }
        return this.Add(negated, ctx);
    }

    public double ToDouble() {
        if (this.IsPositiveInfinity()) {
            return Double.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Double.NEGATIVE_INFINITY;
        }
        if (this.IsNaN()) {
            int[] nan = new int[]{0, 0x7FF00000};
            if (this.isNegative()) {
                nan[1] = nan[1] | Integer.MIN_VALUE;
            }
            if (this.IsQuietNaN()) {
                nan[1] = nan[1] | 0x80000;
            } else if (this.getUnsignedMantissa().isZero()) {
                nan[1] = nan[1] | 0x40000;
            }
            if (!this.getUnsignedMantissa().isZero()) {
                int[] words = FastInteger.GetLastWords(this.getUnsignedMantissa(), 2);
                nan[0] = words[0];
                nan[1] = nan[1] | words[1] & 0x7FFFF;
                if ((words[0] | words[1] & 0x7FFFF) == 0 && !this.IsQuietNaN()) {
                    nan[1] = nan[1] | 0x40000;
                }
            }
            return Extras.IntegersToDouble(nan);
        }
        EFloat thisValue = this.RoundToPrecision(EContext.Binary64);
        if (!thisValue.isFinite()) {
            return thisValue.ToDouble();
        }
        EInteger mant = thisValue.unsignedMantissa;
        if (thisValue.isNegative() && mant.isZero()) {
            return Extras.IntegersToDouble(new int[]{0, Integer.MIN_VALUE});
        }
        if (mant.isZero()) {
            return 0.0;
        }
        EInteger bitLength = mant.GetUnsignedBitLengthAsEInteger();
        int expo = thisValue.exponent.ToInt32Checked();
        boolean subnormal = false;
        if (bitLength.compareTo(53) < 0) {
            int diff = 53 - bitLength.ToInt32Checked();
            if ((expo -= diff) < -1074) {
                diff -= -1074 - expo;
                expo = -1074;
                subnormal = true;
            }
            mant = mant.ShiftLeft(diff);
            bitLength = bitLength.Add(diff);
        }
        int[] mantissaBits = FastInteger.GetLastWords(mant, 2);
        mantissaBits[1] = mantissaBits[1] & 0xFFFFF;
        if (!subnormal) {
            int smallexponent = expo + 1075 << 20;
            mantissaBits[1] = mantissaBits[1] | smallexponent;
        }
        if (this.isNegative()) {
            mantissaBits[1] = mantissaBits[1] | Integer.MIN_VALUE;
        }
        return Extras.IntegersToDouble(mantissaBits);
    }

    public EDecimal ToEDecimal() {
        return EDecimal.FromEFloat(this);
    }

    public EInteger ToEInteger() {
        return this.ToEIntegerInternal(false);
    }

    @Deprecated
    public EInteger ToEIntegerExact() {
        return this.ToEIntegerInternal(true);
    }

    public EInteger ToEIntegerIfExact() {
        return this.ToEIntegerInternal(true);
    }

    public String ToEngineeringString() {
        return this.ToEDecimal().ToEngineeringString();
    }

    @Deprecated
    public EDecimal ToExtendedDecimal() {
        return EDecimal.FromEFloat(this);
    }

    public String ToPlainString() {
        return this.ToEDecimal().ToPlainString();
    }

    private String ToDebugString() {
        return "[" + this.getMantissa().ToRadixString(2) + "," + this.getMantissa().GetUnsignedBitLengthAsEInteger() + "," + this.getExponent() + "]";
    }

    public String ToShortestString(EContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return this.toString();
        }
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.getUnsignedMantissa(), this.IsSignalingNaN(), this.isNegative(), ctx).toString();
        }
        if (this.IsInfinity()) {
            return this.RoundToPrecision(ctx).toString();
        }
        EContext ctx2 = ctx.WithNoFlags();
        EFloat valueEfRnd = this.RoundToPrecision(ctx);
        if (valueEfRnd.IsInfinity()) {
            return valueEfRnd.toString();
        }
        boolean mantissaIsPowerOfTwo = this.unsignedMantissa.isPowerOfTwo();
        EDecimal dec = this.ToEDecimal();
        if (ctx.getPrecision().compareTo(EInteger.FromInt32(10)) >= 0) {
            EInteger roundedPrec = ctx.getPrecision().ShiftRight(1).Add(EInteger.FromInt32(3));
            dec = dec.RoundToPrecision(ctx2.WithRounding(ERounding.Odd).WithBigPrecision(roundedPrec));
        }
        EInteger eprecision = EInteger.FromInt32(0);
        while (true) {
            EInteger nextPrecision;
            EContext nextCtx;
            EDecimal nextDec;
            EFloat newFloat;
            if ((newFloat = (nextDec = dec.RoundToPrecision(nextCtx = ctx2.WithBigPrecision(nextPrecision = eprecision.Add(EInteger.FromInt32(1))))).ToEFloat(ctx2)).compareTo(valueEfRnd) == 0) {
                if (mantissaIsPowerOfTwo) {
                    nextPrecision = eprecision;
                    nextCtx = ctx2.WithBigPrecision(nextPrecision);
                    EDecimal nextDec2 = dec.RoundToPrecision(nextCtx);
                    newFloat = (nextDec2 = nextDec2.NextPlus(nextCtx)).ToEFloat(ctx2);
                    if (newFloat.compareTo(valueEfRnd) == 0) {
                        nextDec = nextDec2;
                    }
                }
                return nextDec.getExponent().signum() > 0 && nextDec.Abs().compareTo(EDecimal.FromInt32(10000000)) < 0 ? nextDec.ToPlainString() : nextDec.toString();
            }
            eprecision = nextPrecision;
        }
    }

    public float ToSingle() {
        if (this.IsPositiveInfinity()) {
            return Float.POSITIVE_INFINITY;
        }
        if (this.IsNegativeInfinity()) {
            return Float.NEGATIVE_INFINITY;
        }
        if (this.IsNaN()) {
            int nan = 2139095040;
            if (this.isNegative()) {
                nan |= Integer.MIN_VALUE;
            }
            if (this.IsQuietNaN()) {
                nan |= 0x400000;
            } else if (this.getUnsignedMantissa().isZero()) {
                nan |= 0x200000;
            }
            if (!this.getUnsignedMantissa().isZero()) {
                EInteger bigdata = this.getUnsignedMantissa().Remainder(EInteger.FromInt64(0x400000L));
                int intData = bigdata.ToInt32Checked();
                nan |= intData;
                if (intData == 0 && !this.IsQuietNaN()) {
                    nan |= 0x200000;
                }
            }
            return Float.intBitsToFloat(nan);
        }
        EFloat thisValue = this.RoundToPrecision(EContext.Binary32);
        if (!thisValue.isFinite()) {
            return thisValue.ToSingle();
        }
        EInteger mant = thisValue.unsignedMantissa;
        if (thisValue.isNegative() && mant.isZero()) {
            return Float.intBitsToFloat(Integer.MIN_VALUE);
        }
        if (mant.isZero()) {
            return 0.0f;
        }
        EInteger bitLength = mant.GetUnsignedBitLengthAsEInteger();
        int expo = thisValue.exponent.ToInt32Checked();
        boolean subnormal = false;
        if (bitLength.compareTo(24) < 0) {
            int diff = 24 - bitLength.ToInt32Checked();
            if ((expo -= diff) < -149) {
                diff -= -149 - expo;
                expo = -149;
                subnormal = true;
            }
            mant = mant.ShiftLeft(diff);
        }
        int smallmantissa = mant.ToInt32Checked() & 0x7FFFFF;
        if (!subnormal) {
            smallmantissa |= expo + 150 << 23;
        }
        if (this.isNegative()) {
            smallmantissa |= Integer.MIN_VALUE;
        }
        return Float.intBitsToFloat(smallmantissa);
    }

    public String toString() {
        return EDecimal.FromEFloat(this).toString();
    }

    public EFloat Ulp() {
        return !this.isFinite() ? One : EFloat.Create(EInteger.FromInt32(1), this.exponent);
    }

    static EFloat CreateWithFlags(EInteger mantissa, EInteger exponent, int flags) {
        if (mantissa == null) {
            throw new NullPointerException("mantissa");
        }
        if (exponent == null) {
            throw new NullPointerException("exponent");
        }
        int sign = mantissa == null ? 0 : mantissa.signum();
        return new EFloat(sign < 0 ? mantissa.Negate() : mantissa, exponent, flags);
    }

    private EInteger ToEIntegerInternal(boolean exact) {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        if (this.isZero()) {
            return EInteger.FromInt32(0);
        }
        int expsign = this.getExponent().signum();
        if (expsign == 0) {
            return this.getMantissa();
        }
        if (expsign > 0) {
            boolean neg;
            EInteger curexp = this.getExponent();
            EInteger bigmantissa = this.getMantissa();
            if (bigmantissa.isZero()) {
                return bigmantissa;
            }
            boolean bl = neg = bigmantissa.signum() < 0;
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            bigmantissa = NumberUtility.ShiftLeft(bigmantissa, curexp);
            if (neg) {
                bigmantissa = bigmantissa.Negate();
            }
            return bigmantissa;
        }
        if (exact && !this.unsignedMantissa.isEven()) {
            throw new ArithmeticException("Not an exact integer");
        }
        FastInteger bigexponent = FastInteger.FromBig(this.getExponent()).Negate();
        EInteger bigmantissa = this.unsignedMantissa;
        BitShiftAccumulator acc = new BitShiftAccumulator(bigmantissa, 0, 0);
        acc.ShiftRight(bigexponent);
        if (exact && (acc.getLastDiscardedDigit() != 0 || acc.getOlderDiscardedDigits() != 0)) {
            throw new ArithmeticException("Not an exact integer");
        }
        bigmantissa = acc.getShiftedInt();
        if (this.isNegative()) {
            bigmantissa = bigmantissa.Negate();
        }
        return bigmantissa;
    }

    public byte ToByteChecked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        return this.isFinite() ? this.ToEInteger().ToByteUnchecked() : (byte)0;
    }

    public byte ToByteIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEIntegerIfExact().ToByteChecked();
    }

    public static EFloat FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return EFloat.FromInt32(val);
    }

    public short ToInt16Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt16Unchecked() : (short)0;
    }

    public short ToInt16IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static EFloat FromInt16(short inputInt16) {
        short val = inputInt16;
        return EFloat.FromInt32(val);
    }

    public int ToInt32Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt32Unchecked() : 0;
    }

    public int ToInt32IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEIntegerIfExact().ToInt32Checked();
    }

    public static EFloat FromBoolean(boolean boolValue) {
        return boolValue ? Zero : One;
    }

    public static EFloat FromInt32(int inputInt32) {
        return EFloat.FromEInteger(EInteger.FromInt32(inputInt32));
    }

    public long ToInt64Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt64Unchecked() : 0L;
    }

    public long ToInt64IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEIntegerIfExact().ToInt64Checked();
    }

    public static EFloat FromInt64(long inputInt64) {
        return EFloat.FromEInteger(EInteger.FromInt64(inputInt64));
    }

    private static final class BinaryMathHelper
    implements IRadixMathHelper<EFloat> {
        private BinaryMathHelper() {
        }

        @Override
        public int GetRadix() {
            return 2;
        }

        @Override
        public int GetSign(EFloat value) {
            return value.signum();
        }

        @Override
        public EInteger GetMantissa(EFloat value) {
            return value.unsignedMantissa;
        }

        @Override
        public EInteger GetExponent(EFloat value) {
            return value.exponent;
        }

        @Override
        public FastIntegerFixed GetMantissaFastInt(EFloat value) {
            return FastIntegerFixed.FromBig(value.unsignedMantissa);
        }

        @Override
        public FastIntegerFixed GetExponentFastInt(EFloat value) {
            return FastIntegerFixed.FromBig(value.exponent);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigits(EInteger bigint, int lastDigit, int olderDigits) {
            return new BitShiftAccumulator(bigint, lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulatorWithDigitsFastInt(FastIntegerFixed fastInt, int lastDigit, int olderDigits) {
            if (fastInt.CanFitInInt32()) {
                return new BitShiftAccumulator(fastInt.AsInt32(), lastDigit, olderDigits);
            }
            return new BitShiftAccumulator(fastInt.ToEInteger(), lastDigit, olderDigits);
        }

        @Override
        public IShiftAccumulator CreateShiftAccumulator(EInteger bigint) {
            return new BitShiftAccumulator(bigint, 0, 0);
        }

        @Override
        public FastInteger DivisionShift(EInteger num, EInteger den) {
            if (den.isZero()) {
                return null;
            }
            if (den.GetUnsignedBit(0) && den.compareTo(EInteger.FromInt32(1)) != 0) {
                return null;
            }
            EInteger valueELowBit = den.GetLowBitAsEInteger();
            return den.GetUnsignedBitLengthAsEInteger().equals(valueELowBit.Add(1)) ? FastInteger.FromBig(valueELowBit) : null;
        }

        @Override
        public EInteger MultiplyByRadixPower(EInteger bigint, FastInteger power) {
            EInteger tmpbigint = bigint;
            if (power.signum() <= 0) {
                return tmpbigint;
            }
            if (tmpbigint.signum() < 0) {
                tmpbigint = tmpbigint.Negate();
                if (power.CanFitInInt32()) {
                    tmpbigint = NumberUtility.ShiftLeftInt(tmpbigint, power.AsInt32());
                    tmpbigint = tmpbigint.Negate();
                } else {
                    tmpbigint = NumberUtility.ShiftLeft(tmpbigint, power.AsEInteger());
                    tmpbigint = tmpbigint.Negate();
                }
                return tmpbigint;
            }
            return power.CanFitInInt32() ? NumberUtility.ShiftLeftInt(tmpbigint, power.AsInt32()) : NumberUtility.ShiftLeft(tmpbigint, power.AsEInteger());
        }

        @Override
        public int GetFlags(EFloat value) {
            return value.flags;
        }

        @Override
        public EFloat CreateNewWithFlags(EInteger mantissa, EInteger exponent, int flags) {
            return EFloat.CreateWithFlags(mantissa, exponent, flags);
        }

        @Override
        public EFloat CreateNewWithFlagsFastInt(FastIntegerFixed fmantissa, FastIntegerFixed fexponent, int flags) {
            return EFloat.CreateWithFlags(fmantissa.ToEInteger(), fexponent.ToEInteger(), flags);
        }

        @Override
        public int GetArithmeticSupport() {
            return 1;
        }

        @Override
        public EFloat ValueOf(int val) {
            return EFloat.FromInt64(val);
        }
    }
}

