/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EDecimal;
import com.upokecenter.numbers.EFloat;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.NumberUtility;

public final class ERational
implements Comparable<ERational> {
    private static final int MaxSafeInt = 0xCCCCCCB;
    public static final ERational NaN = ERational.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(1), 4);
    public static final ERational NegativeInfinity = ERational.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(1), 3);
    public static final ERational NegativeZero = ERational.FromEInteger(EInteger.FromInt32(0)).ChangeSign(false);
    public static final ERational One = ERational.FromEInteger(EInteger.FromInt32(1));
    public static final ERational PositiveInfinity = ERational.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(1), 2);
    public static final ERational SignalingNaN = ERational.CreateWithFlags(EInteger.FromInt32(0), EInteger.FromInt32(1), 8);
    public static final ERational Ten = ERational.FromEInteger(EInteger.FromInt32(10));
    public static final ERational Zero = ERational.FromEInteger(EInteger.FromInt32(0));
    private EInteger denominator;
    private int flags;
    private EInteger unsignedNumerator;

    private ERational() {
    }

    private void Initialize(EInteger numerator, EInteger denominator) {
        if (numerator == null) {
            throw new NullPointerException("numerator");
        }
        if (denominator == null) {
            throw new NullPointerException("denominator");
        }
        if (denominator.isZero()) {
            throw new IllegalArgumentException("denominator is zero");
        }
        boolean numNegative = numerator.signum() < 0;
        boolean denNegative = denominator.signum() < 0;
        int n = this.flags = numNegative != denNegative ? 1 : 0;
        if (numNegative) {
            numerator = numerator.Negate();
        }
        if (denNegative) {
            denominator = denominator.Negate();
        }
        this.unsignedNumerator = numerator;
        this.denominator = denominator;
    }

    @Deprecated
    public ERational(EInteger numerator, EInteger denominator) {
        this.Initialize(numerator, denominator);
    }

    public final EInteger getDenominator() {
        return this.denominator;
    }

    public final boolean isFinite() {
        return !this.IsNaN() && !this.IsInfinity();
    }

    public final boolean isNegative() {
        return (this.flags & 1) != 0;
    }

    public final boolean isZero() {
        return (this.flags & 0xE) == 0 && this.unsignedNumerator.isZero();
    }

    public final EInteger getNumerator() {
        return this.isNegative() ? this.unsignedNumerator.Negate() : this.unsignedNumerator;
    }

    public final int signum() {
        return (this.flags & 0xE) != 0 ? (this.isNegative() ? -1 : 1) : (this.unsignedNumerator.isZero() ? 0 : (this.isNegative() ? -1 : 1));
    }

    public final EInteger getUnsignedNumerator() {
        return this.unsignedNumerator;
    }

    public static ERational Create(int numeratorSmall, int denominatorSmall) {
        return ERational.Create(EInteger.FromInt32(numeratorSmall), EInteger.FromInt32(denominatorSmall));
    }

    public static ERational Create(EInteger numerator, EInteger denominator) {
        ERational er = new ERational();
        er.Initialize(numerator, denominator);
        return er;
    }

    public static ERational CreateNaN(EInteger diag) {
        return ERational.CreateNaN(diag, false, false);
    }

    public static ERational CreateNaN(EInteger diag, boolean signaling, boolean negative) {
        if (diag == null) {
            throw new NullPointerException("diag");
        }
        if (diag.signum() < 0) {
            throw new IllegalArgumentException("Diagnostic information must be 0 or greater, was: " + diag);
        }
        if (diag.isZero() && !negative) {
            return signaling ? SignalingNaN : NaN;
        }
        int flags = 0;
        if (negative) {
            flags |= 1;
        }
        int n = signaling ? 8 : 4;
        ERational er = ERational.Create(diag, EInteger.FromInt32(1));
        er.flags = flags |= n;
        return er;
    }

    public static ERational FromDouble(double flt) {
        return ERational.FromEFloat(EFloat.FromDouble(flt));
    }

    @Deprecated
    public static ERational FromExtendedDecimal(EDecimal ef) {
        return ERational.FromEDecimal(ef);
    }

    @Deprecated
    public static ERational FromExtendedFloat(EFloat ef) {
        return ERational.FromEFloat(ef);
    }

    public static ERational FromEDecimal(EDecimal ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        if (!ef.isFinite()) {
            ERational er = ERational.Create(ef.getMantissa(), EInteger.FromInt32(1));
            int flags = 0;
            if (ef.isNegative()) {
                flags |= 1;
            }
            if (ef.IsInfinity()) {
                flags |= 2;
            }
            if (ef.IsSignalingNaN()) {
                flags |= 8;
            }
            if (ef.IsQuietNaN()) {
                flags |= 4;
            }
            er.flags = flags;
            return er;
        }
        EInteger num = ef.getMantissa();
        EInteger exp = ef.getExponent();
        if (exp.isZero()) {
            return ERational.FromEInteger(num);
        }
        boolean neg = num.signum() < 0;
        num = num.Abs();
        EInteger den = EInteger.FromInt32(1);
        if (exp.signum() < 0) {
            exp = exp.Negate();
            den = NumberUtility.FindPowerOfTenFromBig(exp);
        } else {
            EInteger powerOfTen = NumberUtility.FindPowerOfTenFromBig(exp);
            num = num.Multiply(powerOfTen);
        }
        if (neg) {
            num = num.Negate();
        }
        return ERational.Create(num, den);
    }

    public static ERational FromEFloat(EFloat ef) {
        if (ef == null) {
            throw new NullPointerException("ef");
        }
        if (!ef.isFinite()) {
            ERational er = ERational.Create(ef.getMantissa(), EInteger.FromInt32(1));
            int flags = 0;
            if (ef.isNegative()) {
                flags |= 1;
            }
            if (ef.IsInfinity()) {
                flags |= 2;
            }
            if (ef.IsSignalingNaN()) {
                flags |= 8;
            }
            if (ef.IsQuietNaN()) {
                flags |= 4;
            }
            er.flags = flags;
            return er;
        }
        EInteger num = ef.getMantissa();
        EInteger exp = ef.getExponent();
        if (exp.isZero()) {
            return ERational.FromEInteger(num);
        }
        boolean neg = num.signum() < 0;
        num = num.Abs();
        EInteger den = EInteger.FromInt32(1);
        if (exp.signum() < 0) {
            exp = exp.Negate();
            den = NumberUtility.ShiftLeft(den, exp);
        } else {
            num = NumberUtility.ShiftLeft(num, exp);
        }
        if (neg) {
            num = num.Negate();
        }
        return ERational.Create(num, den);
    }

    public static ERational FromEInteger(EInteger bigint) {
        return ERational.Create(bigint, EInteger.FromInt32(1));
    }

    public static ERational FromSingle(float flt) {
        return ERational.FromEFloat(EFloat.FromSingle(flt));
    }

    public static ERational FromString(String str) {
        return ERational.FromString(str, 0, str == null ? 0 : str.length());
    }

    public static ERational FromString(String str, int offset, int length) {
        int tmpoffset = offset;
        if (str == null) {
            throw new NullPointerException("str");
        }
        if (tmpoffset < 0) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is less than 0");
        }
        if (tmpoffset > str.length()) {
            throw new NumberFormatException("offset (" + tmpoffset + ") is more than " + str.length());
        }
        if (length < 0) {
            throw new NumberFormatException("length (" + length + ") is less than 0");
        }
        if (length > str.length()) {
            throw new NumberFormatException("length (" + length + ") is more than " + str.length());
        }
        if (str.length() - tmpoffset < length) {
            throw new NumberFormatException("str's length minus " + tmpoffset + " (" + (str.length() - tmpoffset) + ") is less than " + length);
        }
        if (length == 0) {
            throw new NumberFormatException();
        }
        boolean negative = false;
        int endStr = tmpoffset + length;
        if (str.charAt(0) == '+' || str.charAt(0) == '-') {
            negative = str.charAt(0) == '-';
            ++tmpoffset;
        }
        int numerInt = 0;
        FastInteger numer = null;
        int numerBuffer = 0;
        int numerBufferMult = 1;
        int denomBuffer = 0;
        int denomBufferMult = 1;
        boolean haveDigits = false;
        boolean haveDenominator = false;
        int ndenomInt = 0;
        FastInteger ndenom = null;
        int i = tmpoffset;
        if (!(i + 8 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f' || str.charAt(i + 3) != 'I' && str.charAt(i + 3) != 'i' || str.charAt(i + 4) != 'N' && str.charAt(i + 4) != 'n' || str.charAt(i + 5) != 'I' && str.charAt(i + 5) != 'i' || str.charAt(i + 6) != 'T' && str.charAt(i + 6) != 't' || str.charAt(i + 7) != 'Y' && str.charAt(i + 7) != 'y')) {
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 != endStr || str.charAt(i) != 'I' && str.charAt(i) != 'i' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'F' && str.charAt(i + 2) != 'f')) {
            return negative ? NegativeInfinity : PositiveInfinity;
        }
        if (!(i + 3 > endStr || str.charAt(i) != 'N' && str.charAt(i) != 'n' || str.charAt(i + 1) != 'A' && str.charAt(i + 1) != 'a' || str.charAt(i + 2) != 'N' && str.charAt(i + 2) != 'n')) {
            if (i + 3 == endStr) {
                return !negative ? NaN : NaN.Negate();
            }
            i += 3;
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (numerInt > 0xCCCCCCB) {
                        if (numer == null) {
                            numer = new FastInteger(numerInt);
                            numerBuffer = thisdigit;
                            numerBufferMult = 10;
                        } else if (numerBufferMult >= 1000000000) {
                            numer.Multiply(numerBufferMult).AddInt(numerBuffer);
                            numerBuffer = thisdigit;
                            numerBufferMult = 10;
                        } else {
                            numerBufferMult *= 10;
                            numerBuffer = (numerBuffer << 3) + (numerBuffer << 1);
                            numerBuffer += thisdigit;
                        }
                    } else {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (numer != null && (numerBufferMult != 1 || numerBuffer != 0)) {
                numer.Multiply(numerBufferMult).AddInt(numerBuffer);
            }
            EInteger bignumer = numer == null ? EInteger.FromInt32(numerInt) : numer.AsEInteger();
            return ERational.CreateNaN(bignumer, false, negative);
        }
        if (!(i + 4 > endStr || str.charAt(i) != 'S' && str.charAt(i) != 's' || str.charAt(i + 1) != 'N' && str.charAt(i + 1) != 'n' || str.charAt(i + 2) != 'A' && str.charAt(i + 2) != 'a' || str.charAt(i + 3) != 'N' && str.charAt(i + 3) != 'n')) {
            if (i + 4 == endStr) {
                return !negative ? SignalingNaN : SignalingNaN.Negate();
            }
            i += 4;
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    int thisdigit = str.charAt(i) - 48;
                    boolean bl = haveDigits = haveDigits || thisdigit != 0;
                    if (numerInt > 0xCCCCCCB) {
                        if (numer == null) {
                            numer = new FastInteger(numerInt);
                            numerBuffer = thisdigit;
                            numerBufferMult = 10;
                        } else if (numerBufferMult >= 1000000000) {
                            numer.Multiply(numerBufferMult).AddInt(numerBuffer);
                            numerBuffer = thisdigit;
                            numerBufferMult = 10;
                        } else {
                            numerBufferMult *= 10;
                            numerBuffer = (numerBuffer << 3) + (numerBuffer << 1);
                            numerBuffer += thisdigit;
                        }
                    } else {
                        numerInt *= 10;
                        numerInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (numer != null && (numerBufferMult != 1 || numerBuffer != 0)) {
                numer.Multiply(numerBufferMult).AddInt(numerBuffer);
            }
            int flags3 = (negative ? 1 : 0) | 8;
            EInteger bignumer = numer == null ? EInteger.FromInt32(numerInt) : numer.AsEInteger();
            return ERational.CreateWithFlags(bignumer, EInteger.FromInt32(1), flags3);
        }
        while (i < endStr) {
            if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                int thisdigit = str.charAt(i) - 48;
                if (numerInt > 0xCCCCCCB) {
                    if (numer == null) {
                        numer = new FastInteger(numerInt);
                        numerBuffer = thisdigit;
                        numerBufferMult = 10;
                    } else if (numerBufferMult >= 1000000000) {
                        numer.Multiply(numerBufferMult).AddInt(numerBuffer);
                        numerBuffer = thisdigit;
                        numerBufferMult = 10;
                    } else {
                        numerBufferMult = (numerBufferMult << 3) + (numerBufferMult << 1);
                        numerBuffer = (numerBuffer << 3) + (numerBuffer << 1);
                        numerBuffer += thisdigit;
                    }
                } else {
                    numerInt *= 10;
                    numerInt += thisdigit;
                }
            } else {
                if (str.charAt(i) == '/') {
                    haveDenominator = true;
                    ++i;
                    break;
                }
                throw new NumberFormatException();
            }
            haveDigits = true;
            ++i;
        }
        if (!haveDigits) {
            throw new NumberFormatException();
        }
        if (numer != null && (numerBufferMult != 1 || numerBuffer != 0)) {
            numer.Multiply(numerBufferMult).AddInt(numerBuffer);
        }
        if (haveDenominator) {
            FastInteger denom = null;
            int denomInt = 0;
            tmpoffset = 1;
            haveDigits = false;
            if (i == endStr) {
                throw new NumberFormatException();
            }
            while (i < endStr) {
                if (str.charAt(i) >= '0' && str.charAt(i) <= '9') {
                    haveDigits = true;
                    int thisdigit = str.charAt(i) - 48;
                    if (denomInt > 0xCCCCCCB) {
                        if (denom == null) {
                            denom = new FastInteger(denomInt);
                            denomBuffer = thisdigit;
                            denomBufferMult = 10;
                        } else if (denomBufferMult >= 1000000000) {
                            denom.Multiply(denomBufferMult).AddInt(denomBuffer);
                            denomBuffer = thisdigit;
                            denomBufferMult = 10;
                        } else {
                            denomBufferMult = (denomBufferMult << 3) + (denomBufferMult << 1);
                            denomBuffer = (denomBuffer << 3) + (denomBuffer << 1);
                            denomBuffer += thisdigit;
                        }
                    } else {
                        denomInt *= 10;
                        denomInt += thisdigit;
                    }
                } else {
                    throw new NumberFormatException();
                }
                ++i;
            }
            if (!haveDigits) {
                throw new NumberFormatException();
            }
            if (denom != null && (denomBufferMult != 1 || denomBuffer != 0)) {
                denom.Multiply(denomBufferMult).AddInt(denomBuffer);
            }
            if (denom == null) {
                ndenomInt = denomInt;
            } else {
                ndenom = denom;
            }
        } else {
            ndenomInt = 1;
        }
        if (i != endStr) {
            throw new NumberFormatException();
        }
        if (ndenom == null ? ndenomInt == 0 : ndenom.isValueZero()) {
            throw new NumberFormatException();
        }
        ERational erat = ERational.Create(numer == null ? EInteger.FromInt32(numerInt) : numer.AsEInteger(), ndenom == null ? EInteger.FromInt32(ndenomInt) : ndenom.AsEInteger());
        return negative ? erat.Negate() : erat;
    }

    public int CompareToTotalMagnitude(ERational other) {
        if (other == null) {
            return -1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return 1;
        }
        if (valueIThis < valueIOther) {
            return -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedNumerator.compareTo(other.unsignedNumerator);
            return cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.Abs().compareTo(other.Abs());
        if (cmp == 0) {
            cmp = this.denominator.compareTo(other.denominator);
            return cmp;
        }
        return cmp;
    }

    public int CompareToTotal(ERational other) {
        boolean neg2;
        if (other == null) {
            return -1;
        }
        boolean neg1 = this.isNegative();
        if (neg1 != (neg2 = other.isNegative())) {
            return neg1 ? -1 : 1;
        }
        int valueIThis = 0;
        int valueIOther = 0;
        if (this.IsSignalingNaN()) {
            valueIThis = 2;
        } else if (this.IsNaN()) {
            valueIThis = 3;
        } else if (this.IsInfinity()) {
            valueIThis = 1;
        }
        if (other.IsSignalingNaN()) {
            valueIOther = 2;
        } else if (other.IsNaN()) {
            valueIOther = 3;
        } else if (other.IsInfinity()) {
            valueIOther = 1;
        }
        if (valueIThis > valueIOther) {
            return neg1 ? -1 : 1;
        }
        if (valueIThis < valueIOther) {
            return neg1 ? 1 : -1;
        }
        if (valueIThis >= 2) {
            int cmp = this.unsignedNumerator.compareTo(other.unsignedNumerator);
            return neg1 ? -cmp : cmp;
        }
        if (valueIThis == 1) {
            return 0;
        }
        int cmp = this.compareTo(other);
        if (cmp == 0) {
            cmp = this.denominator.compareTo(other.denominator);
            return neg1 ? -cmp : cmp;
        }
        return cmp;
    }

    public ERational Abs() {
        if (this.isNegative()) {
            ERational er = ERational.Create(this.unsignedNumerator, this.denominator);
            er.flags = this.flags & 0xFFFFFFFE;
            return er;
        }
        return this;
    }

    public ERational Add(ERational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ERational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ERational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        if (this.IsInfinity()) {
            return otherValue.IsInfinity() ? (this.isNegative() == otherValue.isNegative() ? this : NaN) : this;
        }
        if (otherValue.IsInfinity()) {
            return otherValue;
        }
        EInteger ad = this.getNumerator().Multiply(otherValue.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherValue.getNumerator());
        EInteger bd = this.getDenominator().Multiply(otherValue.getDenominator());
        ad = ad.Add(bc);
        return ERational.Create(ad, bd);
    }

    @Override
    public int compareTo(ERational other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this == other) {
            return 0;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        if (other.IsNaN()) {
            return -1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        int dencmp = this.denominator.compareTo(other.denominator);
        int numcmp = this.unsignedNumerator.compareTo(other.unsignedNumerator);
        if (signA < 0) {
            numcmp = -numcmp;
        }
        if (numcmp == 0) {
            return signA < 0 ? dencmp : -dencmp;
        }
        if (dencmp == 0) {
            return numcmp;
        }
        EInteger ad = this.getNumerator().Multiply(other.getDenominator());
        EInteger bc = this.getDenominator().Multiply(other.getNumerator());
        return ad.compareTo(bc);
    }

    public int CompareToBinary(EFloat other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        EInteger bigExponent = other.getExponent();
        if (bigExponent.isZero()) {
            EInteger otherMant = other.getMantissa();
            EInteger bcx = this.getDenominator().Multiply(otherMant);
            return this.getNumerator().compareTo(bcx);
        }
        if (bigExponent.Abs().compareTo(EInteger.FromInt64(1000L)) > 0) {
            EInteger[] divrem = this.getUnsignedNumerator().DivRem(this.getDenominator());
            EInteger thisInt = divrem[0];
            EInteger thisRem = divrem[1];
            EFloat otherAbs = other.Abs();
            EFloat thisIntDec = EFloat.FromEInteger(thisInt);
            if (thisRem.isZero()) {
                int ret = thisIntDec.compareTo(otherAbs);
                return this.isNegative() ? -ret : ret;
            }
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            thisIntDec = EFloat.FromEInteger(thisInt = thisInt.Add(EInteger.FromInt32(1)));
            if (thisIntDec.compareTo(otherAbs) < 0) {
                return this.isNegative() ? 1 : -1;
            }
            thisIntDec = EFloat.FromEInteger(this.getUnsignedNumerator()).Divide(EFloat.FromEInteger(this.getDenominator()), EContext.ForPrecisionAndRounding(256, ERounding.Down));
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            if (other.getExponent().signum() > 0) {
                EInteger bigDigitCount;
                int digitCount = this.getUnsignedNumerator().GetSignedBitLength();
                if ((bigDigitCount = EInteger.FromInt32(--digitCount)).compareTo(other.getExponent()) < 0) {
                    return this.isNegative() ? 1 : -1;
                }
            }
        }
        ERational otherRational = ERational.FromEFloat(other);
        EInteger ad = this.getNumerator().Multiply(otherRational.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherRational.getNumerator());
        return ad.compareTo(bc);
    }

    public int CompareToDecimal(EDecimal other) {
        int signB;
        if (other == null) {
            return 1;
        }
        if (this.IsNaN()) {
            return other.IsNaN() ? 0 : 1;
        }
        int signA = this.signum();
        if (signA != (signB = other.signum())) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        if (this.IsInfinity()) {
            if (other.IsInfinity()) {
                return 0;
            }
            return this.isNegative() ? -1 : 1;
        }
        if (other.IsInfinity()) {
            return other.isNegative() ? 1 : -1;
        }
        if (other.getExponent().isZero()) {
            EInteger otherMant = other.getMantissa();
            EInteger bcx = this.getDenominator().Multiply(otherMant);
            return this.getNumerator().compareTo(bcx);
        }
        if (other.getExponent().Abs().compareTo(EInteger.FromInt64(50L)) > 0) {
            EInteger[] divrem = this.getUnsignedNumerator().DivRem(this.getDenominator());
            EInteger thisInt = divrem[0];
            EInteger thisRem = divrem[1];
            EDecimal otherAbs = other.Abs();
            EDecimal thisIntDec = EDecimal.FromEInteger(thisInt);
            if (thisRem.isZero()) {
                int ret = thisIntDec.compareTo(otherAbs);
                return this.isNegative() ? -ret : ret;
            }
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            thisIntDec = EDecimal.FromEInteger(thisInt = thisInt.Add(EInteger.FromInt32(1)));
            if (thisIntDec.compareTo(otherAbs) < 0) {
                return this.isNegative() ? 1 : -1;
            }
            thisIntDec = EDecimal.FromEInteger(this.getUnsignedNumerator()).Divide(EDecimal.FromEInteger(this.getDenominator()), EContext.ForPrecisionAndRounding(20, ERounding.Down));
            if (thisIntDec.compareTo(otherAbs) > 0) {
                return this.isNegative() ? -1 : 1;
            }
            if (other.getExponent().signum() > 0) {
                EInteger bigDigitCount;
                int digitCount = this.getUnsignedNumerator().GetDigitCount();
                if ((bigDigitCount = EInteger.FromInt32(--digitCount)).compareTo(other.getExponent()) < 0) {
                    return this.isNegative() ? 1 : -1;
                }
            }
        }
        ERational otherRational = ERational.FromEDecimal(other);
        EInteger ad = this.getNumerator().Multiply(otherRational.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherRational.getNumerator());
        return ad.compareTo(bc);
    }

    public ERational CopySign(ERational other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        if (this.isNegative()) {
            return other.isNegative() ? this : this.Negate();
        }
        return other.isNegative() ? this.Negate() : this;
    }

    public ERational Divide(ERational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ERational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ERational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return otherValue.IsInfinity() ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (otherValue.IsInfinity()) {
            return resultNeg ? NegativeZero : Zero;
        }
        if (otherValue.isZero()) {
            return this.isZero() ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (this.isZero()) {
            return resultNeg ? NegativeZero : Zero;
        }
        EInteger ad = this.getNumerator().Multiply(otherValue.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherValue.getNumerator());
        return ERational.Create(ad, bc).ChangeSign(resultNeg);
    }

    public boolean equals(Object obj) {
        ERational other;
        ERational eRational = other = obj instanceof ERational ? (ERational)obj : null;
        return other != null && (this.unsignedNumerator == null ? other.unsignedNumerator == null : this.unsignedNumerator.equals(other.unsignedNumerator)) && (this.denominator == null ? other.denominator == null : this.denominator.equals(other.denominator)) && this.flags == other.flags;
    }

    public boolean equals(ERational other) {
        return this.equals((Object)other);
    }

    public int hashCode() {
        int valueHashCode = 1857066527;
        if (this.unsignedNumerator != null) {
            valueHashCode += 1857066539 * this.unsignedNumerator.hashCode();
        }
        if (this.denominator != null) {
            valueHashCode += 1857066551 * this.denominator.hashCode();
        }
        return valueHashCode += 1857066623 * this.flags;
    }

    public boolean IsInfinity() {
        return (this.flags & 2) != 0;
    }

    public boolean IsNaN() {
        return (this.flags & 0xC) != 0;
    }

    public boolean IsNegativeInfinity() {
        return (this.flags & 3) == 3;
    }

    public boolean IsPositiveInfinity() {
        return (this.flags & 3) == 2;
    }

    public boolean IsQuietNaN() {
        return (this.flags & 4) != 0;
    }

    public boolean IsSignalingNaN() {
        return (this.flags & 8) != 0;
    }

    public ERational Multiply(ERational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ERational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ERational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return otherValue.isZero() ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        if (otherValue.IsInfinity()) {
            return this.isZero() ? NaN : (resultNeg ? NegativeInfinity : PositiveInfinity);
        }
        EInteger ac = this.getNumerator().Multiply(otherValue.getNumerator());
        EInteger bd = this.getDenominator().Multiply(otherValue.getDenominator());
        return ac.isZero() ? (resultNeg ? NegativeZero : Zero) : ERational.Create(ac, bd).ChangeSign(resultNeg);
    }

    public ERational Negate() {
        ERational er = ERational.Create(this.unsignedNumerator, this.denominator);
        er.flags = this.flags ^ 1;
        return er;
    }

    public ERational Remainder(ERational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ERational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ERational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        boolean resultNeg = this.isNegative() ^ otherValue.isNegative();
        if (this.IsInfinity()) {
            return NaN;
        }
        if (otherValue.IsInfinity()) {
            return this;
        }
        if (otherValue.isZero()) {
            return NaN;
        }
        if (this.isZero()) {
            return this;
        }
        EInteger ad = this.getNumerator().Multiply(otherValue.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherValue.getNumerator());
        EInteger quo = ad.Divide(bc);
        EInteger tnum = quo.Multiply(otherValue.getNumerator());
        EInteger tden = otherValue.getDenominator();
        EInteger thisDen = this.getDenominator();
        ad = this.getNumerator().Multiply(tden);
        bc = thisDen.Multiply(tnum);
        tden = tden.Multiply(thisDen);
        ad = ad.Subtract(bc);
        return ERational.Create(ad, tden).ChangeSign(resultNeg);
    }

    public ERational Subtract(ERational otherValue) {
        if (otherValue == null) {
            throw new NullPointerException("otherValue");
        }
        if (this.IsSignalingNaN()) {
            return ERational.CreateNaN(this.unsignedNumerator, false, this.isNegative());
        }
        if (otherValue.IsSignalingNaN()) {
            return ERational.CreateNaN(otherValue.unsignedNumerator, false, otherValue.isNegative());
        }
        if (this.IsQuietNaN()) {
            return this;
        }
        if (otherValue.IsQuietNaN()) {
            return otherValue;
        }
        if (this.IsInfinity()) {
            if (otherValue.IsInfinity()) {
                return this.isNegative() != otherValue.isNegative() ? (this.isNegative() ? PositiveInfinity : NegativeInfinity) : NaN;
            }
            return this.isNegative() ? PositiveInfinity : NegativeInfinity;
        }
        if (otherValue.IsInfinity()) {
            return otherValue.isNegative() ? PositiveInfinity : NegativeInfinity;
        }
        EInteger ad = this.getNumerator().Multiply(otherValue.getDenominator());
        EInteger bc = this.getDenominator().Multiply(otherValue.getNumerator());
        EInteger bd = this.getDenominator().Multiply(otherValue.getDenominator());
        ad = ad.Subtract(bc);
        return ERational.Create(ad, bd);
    }

    public double ToDouble() {
        if (!this.isFinite()) {
            return this.ToEFloat(EContext.Binary64).ToDouble();
        }
        if (this.isNegative() && this.isZero()) {
            return EFloat.NegativeZero.ToDouble();
        }
        return EFloat.FromEInteger(this.getNumerator()).Divide(EFloat.FromEInteger(this.denominator), EContext.Binary64).ToDouble();
    }

    public EInteger ToEInteger() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.getNumerator().Divide(this.denominator);
    }

    @Deprecated
    public EInteger ToEIntegerExact() {
        return this.ToEIntegerIfExact();
    }

    public EInteger ToEIntegerIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        EInteger[] divrem = this.getNumerator().DivRem(this.denominator);
        EInteger quo = divrem[0];
        EInteger rem = divrem[1];
        if (!rem.isZero()) {
            throw new ArithmeticException("Value is not an integral value");
        }
        return quo;
    }

    public EDecimal ToEDecimal() {
        return this.ToEDecimal(null);
    }

    public EDecimal ToEDecimal(EContext ctx) {
        if (this.IsNaN()) {
            return EDecimal.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return EDecimal.PositiveInfinity.RoundToPrecision(ctx);
        }
        if (this.IsNegativeInfinity()) {
            return EDecimal.NegativeInfinity.RoundToPrecision(ctx);
        }
        EDecimal ef = this.isNegative() && this.isZero() ? EDecimal.NegativeZero : EDecimal.FromEInteger(this.getNumerator());
        return ef.Divide(EDecimal.FromEInteger(this.getDenominator()), ctx);
    }

    public EDecimal ToEDecimalExactIfPossible(EContext ctx) {
        EDecimal valueEdDen;
        if (ctx == null) {
            return this.ToEDecimal(null);
        }
        if (this.IsNaN()) {
            return EDecimal.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return EDecimal.PositiveInfinity.RoundToPrecision(ctx);
        }
        if (this.IsNegativeInfinity()) {
            return EDecimal.NegativeInfinity.RoundToPrecision(ctx);
        }
        if (this.isNegative() && this.isZero()) {
            return EDecimal.NegativeZero;
        }
        EDecimal valueEdNum = this.isNegative() && this.isZero() ? EDecimal.NegativeZero : EDecimal.FromEInteger(this.getNumerator());
        EDecimal ed = valueEdNum.Divide(valueEdDen = EDecimal.FromEInteger(this.getDenominator()), null);
        if (ed.IsNaN()) {
            ed = valueEdNum.Divide(valueEdDen, ctx);
        }
        return ed;
    }

    @Deprecated
    public EDecimal ToExtendedDecimal() {
        return this.ToEDecimal();
    }

    @Deprecated
    public EDecimal ToExtendedDecimal(EContext ctx) {
        return this.ToEDecimal(ctx);
    }

    @Deprecated
    public EDecimal ToExtendedDecimalExactIfPossible(EContext ctx) {
        return this.ToEDecimalExactIfPossible(ctx);
    }

    public EFloat ToEFloat() {
        return this.ToEFloat(null);
    }

    public EFloat ToEFloat(EContext ctx) {
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return EFloat.PositiveInfinity.RoundToPrecision(ctx);
        }
        if (this.IsNegativeInfinity()) {
            return EFloat.NegativeInfinity.RoundToPrecision(ctx);
        }
        EFloat ef = this.isNegative() && this.isZero() ? EFloat.NegativeZero : EFloat.FromEInteger(this.getNumerator());
        return ef.Divide(EFloat.FromEInteger(this.getDenominator()), ctx);
    }

    public EFloat ToEFloatExactIfPossible(EContext ctx) {
        EFloat valueEdDen;
        if (ctx == null) {
            return this.ToEFloat(null);
        }
        if (this.IsNaN()) {
            return EFloat.CreateNaN(this.unsignedNumerator, this.IsSignalingNaN(), this.isNegative(), ctx);
        }
        if (this.IsPositiveInfinity()) {
            return EFloat.PositiveInfinity.RoundToPrecision(ctx);
        }
        if (this.IsNegativeInfinity()) {
            return EFloat.NegativeInfinity.RoundToPrecision(ctx);
        }
        if (this.isZero()) {
            return this.isNegative() ? EFloat.NegativeZero : EFloat.Zero;
        }
        EFloat valueEdNum = this.isNegative() && this.isZero() ? EFloat.NegativeZero : EFloat.FromEInteger(this.getNumerator());
        EFloat ed = valueEdNum.Divide(valueEdDen = EFloat.FromEInteger(this.getDenominator()), null);
        if (ed.IsNaN()) {
            ed = valueEdNum.Divide(valueEdDen, ctx);
        }
        return ed;
    }

    @Deprecated
    public EFloat ToExtendedFloat() {
        return this.ToEFloat();
    }

    @Deprecated
    public EFloat ToExtendedFloat(EContext ctx) {
        return this.ToEFloat(ctx);
    }

    @Deprecated
    public EFloat ToExtendedFloatExactIfPossible(EContext ctx) {
        return this.ToEFloatExactIfPossible(ctx);
    }

    public float ToSingle() {
        return this.ToEFloat(EContext.Binary32.WithRounding(ERounding.Odd)).ToSingle();
    }

    public String toString() {
        if (!this.isFinite()) {
            if (this.IsSignalingNaN()) {
                if (this.unsignedNumerator.isZero()) {
                    return this.isNegative() ? "-sNaN" : "sNaN";
                }
                return this.isNegative() ? "-sNaN" + this.unsignedNumerator : "sNaN" + this.unsignedNumerator;
            }
            if (this.IsQuietNaN()) {
                if (this.unsignedNumerator.isZero()) {
                    return this.isNegative() ? "-NaN" : "NaN";
                }
                return this.isNegative() ? "-NaN" + this.unsignedNumerator : "NaN" + this.unsignedNumerator;
            }
            if (this.IsInfinity()) {
                return this.isNegative() ? "-Infinity" : "Infinity";
            }
        }
        return this.getNumerator().isZero() && this.isNegative() ? "-0/" + this.getDenominator() : this.getNumerator() + "/" + this.getDenominator();
    }

    private static ERational CreateWithFlags(EInteger numerator, EInteger denominator, int flags) {
        ERational er = ERational.Create(numerator, denominator);
        er.flags = flags;
        return er;
    }

    private ERational ChangeSign(boolean negative) {
        this.flags = negative ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
        return this;
    }

    public byte ToByteChecked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEInteger().ToByteChecked();
    }

    public byte ToByteUnchecked() {
        return this.isFinite() ? this.ToEInteger().ToByteUnchecked() : (byte)0;
    }

    public byte ToByteIfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (byte)0 : this.ToEIntegerIfExact().ToByteChecked();
    }

    public static ERational FromByte(byte inputByte) {
        int val = inputByte & 0xFF;
        return ERational.FromInt32(val);
    }

    public short ToInt16Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEInteger().ToInt16Checked();
    }

    public short ToInt16Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt16Unchecked() : (short)0;
    }

    public short ToInt16IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? (short)0 : this.ToEIntegerIfExact().ToInt16Checked();
    }

    public static ERational FromInt16(short inputInt16) {
        short val = inputInt16;
        return ERational.FromInt32(val);
    }

    public int ToInt32Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEInteger().ToInt32Checked();
    }

    public int ToInt32Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt32Unchecked() : 0;
    }

    public int ToInt32IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0 : this.ToEIntegerIfExact().ToInt32Checked();
    }

    public static ERational FromInt32(int inputInt32) {
        return ERational.FromEInteger(EInteger.FromInt32(inputInt32));
    }

    public long ToInt64Checked() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEInteger().ToInt64Checked();
    }

    public long ToInt64Unchecked() {
        return this.isFinite() ? this.ToEInteger().ToInt64Unchecked() : 0L;
    }

    public long ToInt64IfExact() {
        if (!this.isFinite()) {
            throw new ArithmeticException("Value is infinity or NaN");
        }
        return this.isZero() ? 0L : this.ToEIntegerIfExact().ToInt64Checked();
    }

    public static ERational FromInt64(long inputInt64) {
        return ERational.FromEInteger(EInteger.FromInt64(inputInt64));
    }
}

