/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.DecimalUtility;
import com.upokecenter.numbers.EContext;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.ERounding;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IRadixMath;
import com.upokecenter.numbers.IRadixMathHelper;
import com.upokecenter.numbers.IShiftAccumulator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RadixMath<T>
implements IRadixMath<T> {
    private static final int IntegerModeFixedScale = 1;
    private static final int IntegerModeRegular = 0;
    private static final EInteger ValueMinusOne = EInteger.FromInt64(0L).Subtract(EInteger.FromInt64(1L));
    private final IRadixMathHelper<T> helper;
    private final int support;
    private final int thisRadix;
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    private static final int[] OverflowMaxes = new int[]{Integer.MAX_VALUE, 0xCCCCCCC, 21474836, 2147483, 214748, 21474, 2147, 214, 21, 2};
    private static final int[] BitMasks = new int[]{Integer.MAX_VALUE, 0x3FFFFFFF, 0x1FFFFFFF, 0xFFFFFFF, 0x7FFFFFF, 0x3FFFFFF, 0x1FFFFFF, 0xFFFFFF, 0x7FFFFF, 0x3FFFFF, 0x1FFFFF, 1048575, 524287, 262143, 131071, 65535, Short.MAX_VALUE, 16383, 8191, 4095, 2047, 1023, 511, 255, 127, 63, 31, 15, 7, 3, 1};
    private static EInteger valueMaxDigits = EInteger.FromInt64(0x155555552L);

    public RadixMath(IRadixMathHelper<T> helper) {
        this.helper = helper;
        this.support = helper.GetArithmeticSupport();
        this.thisRadix = helper.GetRadix();
    }

    @Override
    public T Abs(T value, EContext ctx) {
        int flags = this.helper.GetFlags(value);
        return (flags & 8) != 0 ? this.SignalingNaNInvalid(value, ctx) : ((flags & 4) != 0 ? this.ReturnQuietNaN(value, ctx) : ((flags & 1) != 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(this.helper.GetMantissa(value), this.helper.GetExponent(value), flags & 0xFFFFFFFE), ctx) : this.RoundToPrecision(value, ctx)));
    }

    @Override
    public T Add(T thisValue, T other, EContext ctx) {
        if (thisValue == null) {
            throw new NullPointerException("thisValue");
        }
        if (other == null) {
            throw new NullPointerException("other");
        }
        return this.AddEx(thisValue, other, ctx, false);
    }

    private T AddExDiffExp(T thisValue, T other, int thisFlags, int otherFlags, EContext ctx, int expcmp, boolean roundToOperandPrecision) {
        EInteger resultExponent;
        T retval = null;
        T op1 = thisValue;
        T op2 = other;
        EInteger op1MantAbs = this.helper.GetMantissa(thisValue);
        EInteger op2MantAbs = this.helper.GetMantissa(other);
        EInteger op1Exponent = this.helper.GetExponent(op1);
        EInteger op2Exponent = this.helper.GetExponent(op2);
        EInteger eInteger = resultExponent = expcmp < 0 ? op1Exponent : op2Exponent;
        if (ctx != null && ctx.getHasMaxPrecision() && ctx.getPrecision().signum() > 0) {
            FastInteger fastPrecision;
            FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
            FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
            FastInteger expdiff = FastInteger.Copy(fastOp1Exp).Subtract(fastOp2Exp).Abs();
            if (expdiff.compareTo(fastPrecision = FastInteger.FromBig(ctx.getPrecision())) > 0) {
                int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                if (expcmp2 < 0) {
                    if (!op2MantAbs.isZero()) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                        if (FastInteger.Copy(fastOp1Exp).Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp2Exp).SubtractInt(4).Subtract(digitLength1).SubtractBig(ctx.getPrecision())).Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                            boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                            boolean oneOpIsZero = op1MantAbs.isZero();
                            FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                            if (digitLength2.compareTo(fastPrecision) < 0) {
                                FastInteger precisionDiff = FastInteger.Copy(fastPrecision).Subtract(digitLength2);
                                if (!oneOpIsZero && !sameSign) {
                                    precisionDiff.AddInt(2);
                                }
                                if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, precisionDiff)) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                EInteger bigintTemp = precisionDiff.AsBigInteger();
                                op2Exponent = op2Exponent.Subtract(bigintTemp);
                                if (!oneOpIsZero && !sameSign) {
                                    op2MantAbs = op2MantAbs.Subtract(EInteger.FromInt64(1L));
                                }
                                other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                    ctx.setFlags(ctx.getFlags() | 2);
                                }
                                return this.RoundToPrecisionInternal(other, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false, ctx);
                            }
                            if (!oneOpIsZero && !sameSign) {
                                if ((op2MantAbs = this.TryMultiplyByRadixPower(op2MantAbs, new FastInteger(2))) == null) {
                                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                                }
                                op2Exponent = op2Exponent.Subtract(EInteger.FromInt64(2L));
                                op2MantAbs = op2MantAbs.Subtract(EInteger.FromInt64(1L));
                                other = this.helper.CreateNewWithFlags(op2MantAbs, op2Exponent, this.helper.GetFlags(other));
                                FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                                return this.RoundToPrecisionInternal(other, 0, 0, shift, false, ctx);
                            }
                            FastInteger shift2 = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                            if (!sameSign && ctx != null && ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 2);
                            }
                            return this.RoundToPrecisionInternal(other, 0, sameSign ? 1 : 0, shift2, false, ctx);
                        }
                    }
                } else if (expcmp2 > 0 && !op1MantAbs.isZero()) {
                    FastInteger tmp;
                    FastInteger newDiff;
                    FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                    if (FastInteger.Copy(fastOp2Exp).Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp1Exp).SubtractInt(4).Subtract(digitLength2).SubtractBig(ctx.getPrecision())).Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                        boolean sameSign = this.helper.GetSign(thisValue) == this.helper.GetSign(other);
                        boolean oneOpIsZero = op2MantAbs.isZero();
                        digitLength2 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                        if (digitLength2.compareTo(fastPrecision) < 0) {
                            FastInteger precisionDiff = FastInteger.Copy(fastPrecision).Subtract(digitLength2);
                            if (!oneOpIsZero && !sameSign) {
                                precisionDiff.AddInt(2);
                            }
                            if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, precisionDiff)) == null) {
                                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                            }
                            EInteger bigintTemp = precisionDiff.AsBigInteger();
                            op1Exponent = op1Exponent.Subtract(bigintTemp);
                            if (!oneOpIsZero && !sameSign) {
                                op1MantAbs = op1MantAbs.Subtract(EInteger.FromInt64(1L));
                            }
                            thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                            FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                            if (oneOpIsZero && ctx != null && ctx.getHasFlags()) {
                                ctx.setFlags(ctx.getFlags() | 2);
                            }
                            return this.RoundToPrecisionInternal(thisValue, oneOpIsZero || sameSign ? 0 : 1, oneOpIsZero && !sameSign ? 0 : 1, shift, false, ctx);
                        }
                        if (!oneOpIsZero && !sameSign) {
                            if ((op1MantAbs = this.TryMultiplyByRadixPower(op1MantAbs, new FastInteger(2))) == null) {
                                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                            }
                            op1Exponent = op1Exponent.Subtract(EInteger.FromInt64(2L));
                            op1MantAbs = op1MantAbs.Subtract(EInteger.FromInt64(1L));
                            thisValue = this.helper.CreateNewWithFlags(op1MantAbs, op1Exponent, this.helper.GetFlags(thisValue));
                            FastInteger shift = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                            return this.RoundToPrecisionInternal(thisValue, 0, 0, shift, false, ctx);
                        }
                        FastInteger shift2 = FastInteger.Copy(digitLength2).Subtract(fastPrecision);
                        if (!sameSign && ctx != null && ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 2);
                        }
                        return this.RoundToPrecisionInternal(thisValue, 0, sameSign ? 1 : 0, shift2, false, ctx);
                    }
                }
                EInteger eInteger2 = resultExponent = (expcmp = op1Exponent.compareTo(op2Exponent)) < 0 ? op1Exponent : op2Exponent;
            }
        }
        if (expcmp > 0) {
            if ((op1MantAbs = this.RescaleByExponentDiff(op1MantAbs, op1Exponent, op2Exponent)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
        } else {
            if ((op2MantAbs = this.RescaleByExponentDiff(op2MantAbs, op1Exponent, op2Exponent)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            retval = this.AddCore(op1MantAbs, op2MantAbs, resultExponent, thisFlags, otherFlags, ctx);
        }
        if (roundToOperandPrecision && ctx != null && ctx.getHasMaxPrecision()) {
            FastInteger digitLength2;
            FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
            FastInteger maxDigitLength = digitLength1.compareTo(digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength()) > 0 ? digitLength1 : digitLength2;
            maxDigitLength.SubtractBig(ctx.getPrecision());
            return maxDigitLength.signum() > 0 ? this.RoundToPrecisionInternal(retval, 0, 0, maxDigitLength, false, ctx) : this.RoundToPrecision(retval, ctx);
        }
        return (T)(RadixMath.IsNullOrSimpleContext(ctx) ? retval : this.RoundToPrecision(retval, ctx));
    }

    @Override
    public T AddEx(T thisValue, T other, EContext ctx, boolean roundToOperandPrecision) {
        int e2int;
        int e1int;
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                if ((otherFlags & 2) != 0 && (thisFlags & 1) != (otherFlags & 1)) {
                    return this.SignalInvalid(ctx);
                }
                return thisValue;
            }
            if ((otherFlags & 2) != 0) {
                return other;
            }
        }
        EInteger op1Exponent = this.helper.GetExponent(thisValue);
        EInteger op2Exponent = this.helper.GetExponent(other);
        EInteger op1Mantissa = this.helper.GetMantissa(thisValue);
        EInteger op2Mantissa = this.helper.GetMantissa(other);
        int expcmp = op1Exponent.compareTo(op2Exponent);
        EInteger resultExponent = expcmp < 0 ? op1Exponent : op2Exponent;
        Object retval = null;
        if ((thisFlags & 1) == 0 && (otherFlags & 1) == 0) {
            if (expcmp < 0 && op2Mantissa.isZero()) {
                return RadixMath.IsNullOrSimpleContext(ctx) ? thisValue : this.RoundToPrecision(thisValue, ctx);
            }
            if (expcmp >= 0 && op1Mantissa.isZero()) {
                return RadixMath.IsNullOrSimpleContext(ctx) ? other : this.RoundToPrecision(other, ctx);
            }
        }
        if ((expcmp == 0 || op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32()) && op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32() && (thisFlags & 1) == 0 && (otherFlags & 1) == 0) {
            e1int = 0;
            e2int = 0;
            if (expcmp != 0) {
                e1int = op1Exponent.AsInt32Unchecked();
                e2int = op2Exponent.AsInt32Unchecked();
            }
            boolean haveRetval = false;
            if (expcmp == 0 || e1int >= -100 && e1int < 100 && e2int >= -100 && e2int < 100) {
                int m2;
                int m1;
                int ediff = expcmp == 0 ? 0 : Math.abs(e1int - e2int);
                int radix = this.thisRadix;
                if (expcmp == 0) {
                    m1 = op1Mantissa.AsInt32Unchecked();
                    m2 = op2Mantissa.AsInt32Unchecked();
                    if (m2 <= Integer.MAX_VALUE - m1) {
                        retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m1 += m2), resultExponent, 0);
                        haveRetval = true;
                    }
                } else if (ediff <= 9 && radix == 10) {
                    int power = ValueTenPowers[ediff];
                    int maxoverflow = OverflowMaxes[ediff];
                    if (expcmp > 0) {
                        m1 = op1Mantissa.AsInt32Unchecked();
                        m2 = op2Mantissa.AsInt32Unchecked();
                        if (m1 == 0) {
                            retval = other;
                        } else if (m1 <= maxoverflow && m2 <= Integer.MAX_VALUE - (m1 *= power)) {
                            retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m1 += m2), resultExponent, 0);
                            haveRetval = true;
                        }
                    } else {
                        m1 = op1Mantissa.AsInt32Unchecked();
                        m2 = op2Mantissa.AsInt32Unchecked();
                        if (m2 == 0) {
                            retval = thisValue;
                        }
                        if (m2 <= maxoverflow && m1 <= Integer.MAX_VALUE - (m2 *= power)) {
                            retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m2 += m1), resultExponent, 0);
                            haveRetval = true;
                        }
                    }
                } else if (ediff <= 30 && radix == 2) {
                    int mask = BitMasks[ediff];
                    if (expcmp > 0) {
                        m1 = op1Mantissa.AsInt32Unchecked();
                        m2 = op2Mantissa.AsInt32Unchecked();
                        if (m1 == 0) {
                            retval = other;
                        } else if ((m1 & mask) == m1 && m2 <= Integer.MAX_VALUE - (m1 <<= ediff)) {
                            retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m1 += m2), resultExponent, 0);
                            haveRetval = true;
                        }
                    } else {
                        m1 = op1Mantissa.AsInt32Unchecked();
                        m2 = op2Mantissa.AsInt32Unchecked();
                        if (m2 == 0) {
                            retval = thisValue;
                        } else if ((m2 & mask) == m2 && m1 <= Integer.MAX_VALUE - (m2 <<= ediff)) {
                            retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m2 += m1), resultExponent, 0);
                            haveRetval = true;
                        }
                    }
                }
            }
            if (haveRetval) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
        }
        if ((expcmp == 0 || op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32()) && op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32() && (thisFlags & 1) == 0 && (otherFlags & 1) != 0 && !op2Mantissa.isZero() && !op1Mantissa.isZero()) {
            e1int = 0;
            e2int = 0;
            int result = 0;
            if (expcmp != 0) {
                e1int = op1Exponent.AsInt32Unchecked();
                e2int = op2Exponent.AsInt32Unchecked();
            }
            boolean haveRetval = false;
            if (expcmp == 0 || e1int >= -100 && e1int < 100 && e2int >= -100 && e2int < 100) {
                int ediff = expcmp == 0 ? 0 : Math.abs(e1int - e2int);
                int radix = this.thisRadix;
                if (expcmp == 0) {
                    int m1 = op1Mantissa.AsInt32Unchecked();
                    int m2 = op2Mantissa.AsInt32Unchecked();
                    if (Integer.MIN_VALUE + m2 <= m1 && m1 >= m2) {
                        result = m1 -= m2;
                        retval = this.helper.CreateNewWithFlags(EInteger.FromInt32(m1), resultExponent, 0);
                        haveRetval = true;
                    }
                }
            }
            if (haveRetval && result != 0) {
                if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                    retval = this.RoundToPrecision(retval, ctx);
                }
                return retval;
            }
        }
        if (expcmp == 0) {
            retval = this.AddCore(op1Mantissa, op2Mantissa, op1Exponent, thisFlags, otherFlags, ctx);
            if (!RadixMath.IsNullOrSimpleContext(ctx)) {
                retval = this.RoundToPrecision(retval, ctx);
            }
        } else {
            retval = this.AddExDiffExp(thisValue, other, thisFlags, otherFlags, ctx, expcmp, roundToOperandPrecision);
        }
        return retval;
    }

    @Override
    public int compareTo(T thisValue, T otherValue) {
        return this.CompareToInternal(thisValue, otherValue, true);
    }

    @Override
    public T CompareToWithContext(T thisValue, T otherValue, boolean treatQuietNansAsSignaling, EContext ctx) {
        if (otherValue == null) {
            return this.SignalInvalid(ctx);
        }
        T result = this.CompareToHandleSpecial(thisValue, otherValue, treatQuietNansAsSignaling, ctx);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.CompareToInternal(thisValue, otherValue, false);
        return cmp == -2 ? this.SignalInvalidWithMessage(ctx, "Out of memory ") : this.ValueOf(this.compareTo(thisValue, otherValue), null);
    }

    @Override
    public T Divide(T thisValue, T divisor, EContext ctx) {
        return this.DivideInternal(thisValue, divisor, ctx, 0, EInteger.FromInt64(0L));
    }

    @Override
    public T DivideToExponent(T thisValue, T divisor, EInteger desiredExponent, EContext ctx) {
        if (ctx != null && !ctx.ExponentWithinRange(desiredExponent)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + desiredExponent);
        }
        EContext ctx2 = ctx == null ? EContext.ForRounding(ERounding.HalfDown) : ctx.WithUnlimitedExponents().WithPrecision(0);
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, desiredExponent);
        if (!ctx2.getHasMaxPrecision() && this.IsFinite(ret)) {
            ret = this.Quantize(ret, ret, ctx2);
            if ((ctx2.getFlags() & 0x40) != 0) {
                ctx2.setFlags(64);
            }
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T DivideToIntegerNaturalScale(T thisValue, T divisor, EContext ctx) {
        FastInteger desiredScale = FastInteger.FromBig(this.helper.GetExponent(thisValue)).SubtractBig(this.helper.GetExponent(divisor));
        EContext ctx2 = EContext.ForRounding(ERounding.Down).WithBigPrecision(ctx == null ? EInteger.FromInt64(0L) : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt64(0L));
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx != null && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0xC0);
            }
            return ret;
        }
        boolean neg = this.helper.GetSign(thisValue) < 0 ^ this.helper.GetSign(divisor) < 0;
        if (this.helper.GetMantissa(ret).isZero()) {
            EInteger dividendExp = this.helper.GetExponent(thisValue);
            EInteger divisorExp = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), dividendExp.Subtract(divisorExp), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() < 0) {
            desiredScale.Negate();
            EInteger bigmantissa = this.helper.GetMantissa(ret);
            bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, desiredScale);
            if (bigmantissa == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger exponentDivisor = this.helper.GetExponent(divisor);
            ret = this.helper.CreateNewWithFlags(bigmantissa, this.helper.GetExponent(thisValue).Subtract(exponentDivisor), this.helper.GetFlags(ret));
        } else if (desiredScale.signum() > 0) {
            EInteger bigmantissa = this.helper.GetMantissa(ret);
            FastInteger fastexponent = FastInteger.FromBig(this.helper.GetExponent(ret));
            EInteger bigradix = EInteger.FromInt64(this.thisRadix);
            while (desiredScale.compareTo(fastexponent) != 0) {
                EInteger[] divrem = bigmantissa.DivRem(bigradix);
                EInteger bigquo = divrem[0];
                EInteger bigrem = divrem[1];
                if (!bigrem.isZero()) break;
                bigmantissa = bigquo;
                fastexponent.Increment();
            }
            ret = this.helper.CreateNewWithFlags(bigmantissa, fastexponent.AsBigInteger(), this.helper.GetFlags(ret));
        }
        if (ctx != null) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        ret = this.EnsureSign(ret, neg);
        return ret;
    }

    @Override
    public T DivideToIntegerZeroScale(T thisValue, T divisor, EContext ctx) {
        EContext ctx2 = EContext.ForRounding(ERounding.Down).WithBigPrecision(ctx == null ? EInteger.FromInt64(0L) : ctx.getPrecision()).WithBlankFlags();
        T ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt64(0L));
        if ((ctx2.getFlags() & 0xC0) != 0) {
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctx2.getFlags() & 0xC0);
            }
            return ret;
        }
        if (ctx != null) {
            ctx2 = ctx.WithBlankFlags().WithUnlimitedExponents();
            ret = this.RoundToPrecision(ret, ctx2);
            if ((ctx2.getFlags() & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
        }
        return ret;
    }

    @Override
    public T Exp(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                T retval = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0);
                retval = this.RoundToPrecision(retval, ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return retval;
            }
            return thisValue;
        }
        int sign = this.helper.GetSign(thisValue);
        T one = this.helper.ValueOf(1);
        EInteger guardDigits = this.thisRadix == 2 ? ctx.getPrecision().Add(EInteger.FromInt64(10L)) : EInteger.FromInt64(10L);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(guardDigits)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        if (sign == 0) {
            thisValue = this.RoundToPrecision(one, ctxCopy);
        } else if (sign > 0 && this.compareTo(thisValue, one) <= 0) {
            thisValue = this.ExpInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else if (sign < 0) {
            T val = this.Exp(this.NegateRaw(thisValue), ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0 || !this.IsFinite(val)) {
                ctxdiv.setFlags(0);
                EInteger newMax = ctx.getEMax();
                EInteger expdiff = ctx.getEMin();
                expdiff = newMax.Subtract(expdiff);
                newMax = newMax.Add(expdiff);
                ctxdiv = ctxdiv.WithBigExponentRange(ctxdiv.getEMin(), newMax);
                thisValue = this.Exp(this.NegateRaw(thisValue), ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0xF);
                    }
                    EInteger ctxdivPrec = ctxdiv.getPrecision();
                    newMax = ctx.getEMin();
                    if (ctx.getAdjustExponent()) {
                        newMax = newMax.Subtract(ctxdivPrec);
                        newMax = newMax.Add(EInteger.FromInt64(1L));
                    }
                    thisValue = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), newMax, 0);
                    return this.RoundToPrecisionInternal(thisValue, 0, 1, null, false, ctx);
                }
            } else {
                thisValue = val;
            }
            thisValue = this.Divide(one, thisValue, ctxCopy);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
        } else {
            T intpart = this.Quantize(thisValue, one, EContext.ForRounding(ERounding.Down));
            if (!this.GetHelper().GetExponent(intpart).isZero()) {
                throw new IllegalArgumentException("integer part not zero, as expected");
            }
            if (this.compareTo(thisValue, this.helper.ValueOf(50000)) > 0 && ctx.getHasExponentRange()) {
                this.PowerIntegral(this.helper.ValueOf(2), EInteger.FromInt64(50000L), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, false);
                }
                ctxCopy.setFlags(0);
                this.PowerIntegral(this.helper.ValueOf(2), this.helper.GetMantissa(intpart), ctxCopy);
                if ((ctxCopy.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, false);
                }
                ctxCopy.setFlags(0);
            }
            T fracpart = this.Add(thisValue, this.NegateRaw(intpart), null);
            ctxdiv = RadixMath.SetPrecisionIfLimited(ctxdiv, ctxdiv.getPrecision().Add(guardDigits)).WithBlankFlags();
            fracpart = this.Add(one, this.Divide(fracpart, intpart, ctxdiv), null);
            ctxdiv.setFlags(0);
            EInteger workingPrec = ctxdiv.getPrecision();
            workingPrec = workingPrec.Add(EInteger.FromInt64(17L));
            thisValue = this.ExpInternal(fracpart, workingPrec, ctxdiv);
            if ((ctxdiv.getFlags() & 8) != 0 && ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
            }
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 3);
            }
            thisValue = this.PowerIntegral(thisValue, this.helper.GetMantissa(intpart), ctxCopy);
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public IRadixMathHelper<T> GetHelper() {
        return this.helper;
    }

    @Override
    public T Ln(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 3);
        }
        int cmpOne = this.compareTo(thisValue, one);
        EContext ctxdiv = null;
        if (cmpOne == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), ctxCopy);
        } else if (cmpOne < 0) {
            FastInteger error = new FastInteger(10);
            EInteger bigError = error.AsBigInteger();
            ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
            T quarter = this.Divide(one, this.helper.ValueOf(4), ctxCopy);
            if (this.compareTo(thisValue, quarter) <= 0) {
                T half = this.Multiply(quarter, this.helper.ValueOf(2), null);
                FastInteger roots = new FastInteger(0);
                while (this.compareTo(thisValue, half) < 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
                EInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt64(0L), 0), ctxCopy);
            } else {
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, this.NegateRaw(smallfrac), null);
                if (this.compareTo(thisValue, closeToOne) >= 0) {
                    error = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue)).GetDigitLength();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsBigInteger();
                    thisValue = this.LnInternal(thisValue, error.AsBigInteger(), ctxCopy);
                } else {
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        } else {
            T two = this.helper.ValueOf(2);
            if (this.compareTo(thisValue, two) >= 0) {
                FastInteger roots = new FastInteger(0);
                FastInteger error = new FastInteger(10);
                EInteger bigError = error.AsBigInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
                T smallfrac = this.Divide(one, this.helper.ValueOf(10), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                while (this.compareTo(thisValue, closeToOne) >= 0) {
                    thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
                    roots.Increment();
                }
                thisValue = this.Divide(one, thisValue, ctxdiv);
                thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
                thisValue = this.NegateRaw(thisValue);
                EInteger bigintRoots = RadixMath.PowerOfTwo(roots);
                thisValue = this.Multiply(thisValue, this.helper.CreateNewWithFlags(bigintRoots, EInteger.FromInt64(0L), 0), ctxCopy);
            } else {
                FastInteger error = new FastInteger(10);
                EInteger bigError = error.AsBigInteger();
                ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
                T smallfrac = this.Divide(one, this.helper.ValueOf(16), ctxdiv);
                T closeToOne = this.Add(one, smallfrac, null);
                if (this.compareTo(thisValue, closeToOne) < 0) {
                    error = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue)).GetDigitLength();
                    error.AddInt(6);
                    error.AddBig(ctx.getPrecision());
                    bigError = error.AsBigInteger();
                    thisValue = this.LnInternal(thisValue, error.AsBigInteger(), ctxCopy);
                } else {
                    thisValue = this.Divide(one, thisValue, ctxdiv);
                    thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxCopy);
                    thisValue = this.NegateRaw(thisValue);
                }
            }
            if (ctx.getHasFlags()) {
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T Log10(T thisValue, EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        int sign = this.helper.GetSign(thisValue);
        if (sign < 0) {
            return this.SignalInvalid(ctx);
        }
        if ((flags & 2) != 0) {
            return thisValue;
        }
        EContext ctxCopy = ctx.WithBlankFlags();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 3), ctxCopy);
        } else if (this.compareTo(thisValue, one) == 0) {
            thisValue = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), ctxCopy);
        } else {
            EInteger exp = this.helper.GetExponent(thisValue);
            EInteger mant = this.helper.GetMantissa(thisValue);
            if (mant.equals(EInteger.FromInt64(1L)) && this.thisRadix == 10) {
                thisValue = this.helper.CreateNewWithFlags(exp, EInteger.FromInt64(0L), exp.signum() < 0 ? 1 : 0);
                thisValue = this.RoundToPrecision(thisValue, ctxCopy);
            } else {
                EInteger mantissa = this.helper.GetMantissa(thisValue);
                FastInteger expTmp = FastInteger.FromBig(exp);
                EInteger tenBig = EInteger.FromInt64(10L);
                while (true) {
                    EInteger[] divrem = mantissa.DivRem(tenBig);
                    EInteger bigquo = divrem[0];
                    EInteger bigrem = divrem[1];
                    if (!bigrem.isZero()) break;
                    mantissa = bigquo;
                    expTmp.Increment();
                }
                if (mantissa.compareTo(EInteger.FromInt64(1L)) == 0 && (this.thisRadix == 10 || expTmp.signum() == 0 || exp.isZero())) {
                    thisValue = this.helper.CreateNewWithFlags(expTmp.AsBigInteger(), EInteger.FromInt64(0L), expTmp.signum() < 0 ? 1 : 0);
                    thisValue = this.RoundToPrecision(thisValue, ctxCopy);
                } else {
                    EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(EInteger.FromInt64(10L))).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
                    T logNatural = this.Ln(thisValue, ctxdiv);
                    T logTen = this.LnTenConstant(ctxdiv);
                    thisValue = this.Divide(logNatural, logTen, ctx);
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                }
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
        }
        return thisValue;
    }

    @Override
    public T Max(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, false);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp < 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int flagNegA = this.helper.GetFlags(a) & 1;
        return flagNegA != (this.helper.GetFlags(b) & 1) ? (flagNegA != 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (flagNegA == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)));
    }

    @Override
    public T MaxMagnitude(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, false, true);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Max(a, b, ctx) : (cmp > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T Min(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, false);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(a, b);
        if (cmp != 0) {
            return cmp > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx);
        }
        int signANeg = this.helper.GetFlags(a) & 1;
        return signANeg != (this.helper.GetFlags(b) & 1) ? (signANeg != 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)) : (signANeg == 0 ? (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(b, ctx) : this.RoundToPrecision(a, ctx)) : (this.helper.GetExponent(a).compareTo(this.helper.GetExponent(b)) > 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx)));
    }

    @Override
    public T MinMagnitude(T a, T b, EContext ctx) {
        if (a == null) {
            throw new NullPointerException("a");
        }
        if (b == null) {
            throw new NullPointerException("b");
        }
        T result = this.MinMaxHandleSpecial(a, b, ctx, true, true);
        if (result != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(this.AbsRaw(a), this.AbsRaw(b));
        return cmp == 0 ? this.Min(a, b, ctx) : (cmp < 0 ? this.RoundToPrecision(a, ctx) : this.RoundToPrecision(b, ctx));
    }

    @Override
    public T Multiply(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                boolean negflag = (thisFlags & 1) != 0 ^ (otherFlags & 1) != 0;
                return (otherFlags & 0xE) == 0 && this.helper.GetMantissa(other).isZero() ? this.SignalInvalid(ctx) : this.EnsureSign(thisValue, negflag);
            }
            if ((otherFlags & 2) != 0) {
                boolean negflag = (thisFlags & 1) != 0 ^ (otherFlags & 1) != 0;
                return (thisFlags & 0xE) == 0 && this.helper.GetMantissa(thisValue).isZero() ? this.SignalInvalid(ctx) : this.EnsureSign(other, negflag);
            }
        }
        EInteger bigintOp2 = this.helper.GetExponent(other);
        EInteger newexp = this.helper.GetExponent(thisValue).Add(bigintOp2);
        EInteger mantissaOp2 = this.helper.GetMantissa(other);
        thisFlags = thisFlags & 1 ^ otherFlags & 1;
        T ret = this.helper.CreateNewWithFlags(this.helper.GetMantissa(thisValue).Multiply(mantissaOp2), newexp, thisFlags);
        if (ctx != null && ctx != EContext.Unlimited) {
            ret = this.RoundToPrecision(ret, ctx);
        }
        return ret;
    }

    private static boolean IsNullOrSimpleContext(EContext ctx) {
        return ctx == null || ctx == EContext.Unlimited || !ctx.getHasExponentRange() && !ctx.getHasMaxPrecision() && ctx.getTraps() == 0 && !ctx.getHasFlags();
    }

    private static boolean IsSimpleContext(EContext ctx) {
        return ctx != null && (ctx == EContext.Unlimited || !ctx.getHasExponentRange() && !ctx.getHasMaxPrecision() && ctx.getTraps() == 0 && !ctx.getHasFlags());
    }

    @Override
    public T MultiplyAndAdd(T thisValue, T multiplicand, T augend, EContext ctx) {
        if (multiplicand == null) {
            throw new NullPointerException("multiplicand");
        }
        if (augend == null) {
            throw new NullPointerException("augend");
        }
        EContext ctx2 = EContext.Unlimited.WithBlankFlags();
        T ret = this.MultiplyAddHandleSpecial(thisValue, multiplicand, augend, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        ret = this.Add(this.Multiply(thisValue, multiplicand, ctx2), augend, ctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return ret;
    }

    @Override
    public T Negate(T value, EContext ctx) {
        int flags = this.helper.GetFlags(value);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(value, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(value, ctx);
        }
        EInteger mant = this.helper.GetMantissa(value);
        if ((flags & 2) == 0 && mant.isZero()) {
            if ((flags & 1) == 0) {
                T zero = this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags & 0xFFFFFFFE);
                return this.RoundToPrecision(zero, ctx);
            }
            T zero = ctx != null && ctx.getRounding() == ERounding.Floor ? this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags | 1) : this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags & 0xFFFFFFFE);
            return this.RoundToPrecision(zero, ctx);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, this.helper.GetExponent(value), flags ^= 1), ctx);
    }

    @Override
    public T NextMinus(T thisValue, EContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            EInteger overflowMant;
            if ((flags & 1) != 0) {
                return thisValue;
            }
            EInteger bigexp2 = ctx.getEMax();
            EInteger bigprec = ctx.getPrecision();
            if (ctx.getAdjustExponent()) {
                bigexp2 = bigexp2.Add(EInteger.FromInt64(1L));
                bigexp2 = bigexp2.Subtract(bigprec);
            }
            if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 0);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), minexp.AsBigInteger(), 1);
        EContext ctx2 = ctx.WithRounding(ERounding.Floor);
        return this.Add(thisValue, quantum, ctx2);
    }

    @Override
    public T NextPlus(T thisValue, EContext ctx) {
        FastInteger bigexp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int flags = this.helper.GetFlags(thisValue);
        if ((flags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((flags & 4) != 0) {
            return this.ReturnQuietNaN(thisValue, ctx);
        }
        if ((flags & 2) != 0) {
            if ((flags & 1) != 0) {
                EInteger overflowMant;
                EInteger bigexp2 = ctx.getEMax();
                EInteger bigprec = ctx.getPrecision();
                if (ctx.getAdjustExponent()) {
                    bigexp2 = bigexp2.Add(EInteger.FromInt64(1L));
                    bigexp2 = bigexp2.Subtract(bigprec);
                }
                if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
                return this.helper.CreateNewWithFlags(overflowMant, bigexp2, 1);
            }
            return thisValue;
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) <= 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), minexp.AsBigInteger(), 0);
        T val = thisValue;
        EContext ctx2 = ctx.WithRounding(ERounding.Ceiling);
        return this.Add(val, quantum, ctx2);
    }

    @Override
    public T NextToward(T thisValue, T otherValue, EContext ctx) {
        FastInteger bigexp;
        T result;
        int otherFlags;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        if (!ctx.getHasExponentRange()) {
            return this.SignalInvalidWithMessage(ctx, "doesn't satisfy ctx.getHasExponentRange()");
        }
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0 && (result = this.HandleNotANumber(thisValue, otherValue, ctx)) != (Object)null) {
            return result;
        }
        int cmp = this.compareTo(thisValue, otherValue);
        if (cmp == 0) {
            return this.RoundToPrecision(this.EnsureSign(thisValue, (otherFlags & 1) != 0), ctx.WithNoFlags());
        }
        if ((thisFlags & 2) != 0) {
            EInteger overflowMant;
            if ((thisFlags & 3) == (otherFlags & 3)) {
                return thisValue;
            }
            EInteger bigexp2 = ctx.getEMax();
            EInteger bigprec = ctx.getPrecision();
            if (ctx.getAdjustExponent()) {
                bigexp2 = bigexp2.Add(EInteger.FromInt64(1L));
                bigexp2 = bigexp2.Subtract(bigprec);
            }
            if ((overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), FastInteger.FromBig(ctx.getPrecision()))) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
            return this.helper.CreateNewWithFlags(overflowMant, bigexp2, thisFlags & 1);
        }
        FastInteger minexp = FastInteger.FromBig(ctx.getEMin());
        if (ctx.getAdjustExponent()) {
            minexp.SubtractBig(ctx.getPrecision()).Increment();
        }
        if ((bigexp = FastInteger.FromBig(this.helper.GetExponent(thisValue))).compareTo(minexp) < 0) {
            minexp = FastInteger.Copy(bigexp).SubtractInt(2);
        } else {
            minexp.SubtractInt(2);
        }
        T quantum = this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), minexp.AsBigInteger(), cmp > 0 ? 1 : 0);
        T val = thisValue;
        EContext ctx2 = ctx.WithRounding(cmp > 0 ? ERounding.Floor : ERounding.Ceiling).WithBlankFlags();
        val = this.Add(val, quantum, ctx2);
        if ((ctx2.getFlags() & 0x18) == 0) {
            ctx2.setFlags(0);
        }
        if ((ctx2.getFlags() & 8) != 0) {
            EInteger bigmant = this.helper.GetMantissa(val);
            EInteger maxmant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), FastInteger.FromBig(ctx.getPrecision()).Decrement());
            if (maxmant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (bigmant.compareTo(maxmant) >= 0 || ctx.getPrecision().compareTo(EInteger.FromInt64(1L)) == 0) {
                ctx2.setFlags(0);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctx2.getFlags());
        }
        return val;
    }

    @Override
    public T Pi(EContext ctx) {
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T a = this.helper.ValueOf(1);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(EInteger.FromInt64(10L))).WithRounding(ERounding.OddOrZeroFiveUp);
        T two = this.helper.ValueOf(2);
        T b = this.Divide(a, this.SquareRoot(two, ctxdiv), ctxdiv);
        T four = this.helper.ValueOf(4);
        T half = (this.thisRadix & 1) == 0 ? (T)this.helper.CreateNewWithFlags(EInteger.FromInt64(this.thisRadix / 2), ValueMinusOne, 0) : null;
        T t = this.Divide(a, four, ctxdiv);
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        T lastGuess = null;
        T guess = null;
        EInteger powerTwo = EInteger.FromInt64(1L);
        while (more) {
            lastGuess = guess;
            T aplusB = this.Add(a, b, null);
            T newA = half == null ? this.Divide(aplusB, two, ctxdiv) : this.Multiply(aplusB, half, null);
            T valueAMinusNewA = this.Add(a, this.NegateRaw(newA), null);
            if (!a.equals(b)) {
                T atimesB = this.Multiply(a, b, ctxdiv);
                b = this.SquareRoot(atimesB, ctxdiv);
            }
            a = newA;
            guess = this.Multiply(aplusB, aplusB, null);
            T newGuess = guess = this.Divide(guess, this.Multiply(t, four, null), ctxdiv);
            if (lastGuess != (Object)null) {
                int guessCmp = this.compareTo(lastGuess, newGuess);
                if (guessCmp == 0) {
                    more = false;
                } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                    more &= ++vacillations <= 3 || guessCmp <= 0;
                }
                lastCompare = guessCmp;
            }
            if (more) {
                T tmpT = this.Multiply(valueAMinusNewA, valueAMinusNewA, null);
                tmpT = this.Multiply(tmpT, this.helper.CreateNewWithFlags(powerTwo, EInteger.FromInt64(0L), 0), null);
                t = this.Add(t, this.NegateRaw(tmpT), ctxdiv);
                powerTwo = powerTwo.ShiftLeft(1);
            }
            guess = newGuess;
        }
        return this.RoundToPrecision(guess, ctx);
    }

    @Override
    public T Plus(T thisValue, EContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, true, context);
    }

    @Override
    public T Power(T thisValue, T pow, EContext ctx) {
        boolean isResultNegative;
        T ret = this.HandleNotANumber(thisValue, pow, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        int thisSign = this.helper.GetSign(thisValue);
        int powSign = this.helper.GetSign(pow);
        int thisFlags = this.helper.GetFlags(thisValue);
        int powFlags = this.helper.GetFlags(pow);
        if (thisSign == 0 && powSign == 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign < 0 && (powFlags & 2) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (thisSign > 0 && (thisFlags & 2) == 0 && (powFlags & 2) != 0) {
            int cmp = this.compareTo(thisValue, this.helper.ValueOf(1));
            if (cmp < 0) {
                if (powSign < 0) {
                    return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 2);
                }
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), ctx);
            }
            if (cmp == 0) {
                return this.ExtendPrecision(this.helper.ValueOf(1), ctx);
            }
            if (powSign > 0) {
                return pow;
            }
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), ctx);
        }
        EInteger powExponent = this.helper.GetExponent(pow);
        boolean isPowIntegral = powExponent.signum() > 0;
        boolean isPowOdd = false;
        Object powInt = null;
        if (!isPowIntegral) {
            powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), EContext.ForRounding(ERounding.Down));
            isPowIntegral = this.compareTo(powInt, pow) == 0;
            isPowOdd = !this.helper.GetMantissa(powInt).isEven();
        } else {
            isPowOdd = powExponent.equals(EInteger.FromInt64(0L)) ? !this.helper.GetMantissa(powInt).isEven() : (this.thisRadix % 2 == 0 ? false : !this.helper.GetMantissa(powInt = (Object)this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), EContext.ForRounding(ERounding.Down))).isEven());
        }
        boolean bl = isResultNegative = (thisFlags & 1) != 0 && (powFlags & 2) == 0 && isPowIntegral && isPowOdd;
        if (thisSign == 0 && powSign != 0) {
            int infinityFlags;
            int n = infinityFlags = powSign < 0 ? 2 : 0;
            if (isResultNegative) {
                infinityFlags |= 1;
            }
            thisValue = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), infinityFlags);
            if ((infinityFlags & 2) == 0) {
                thisValue = this.RoundToPrecision(thisValue, ctx);
            }
            return thisValue;
        }
        if (!(isPowIntegral && powSign >= 0 || ctx != null && ctx.getHasMaxPrecision())) {
            String ValueOutputMessage = "ctx is null or has unlimited precision, and pow's exponent is not an integer or is negative";
            return this.SignalInvalidWithMessage(ctx, ValueOutputMessage);
        }
        if (thisSign < 0 && !isPowIntegral) {
            return this.SignalInvalid(ctx);
        }
        if ((thisFlags & 2) != 0) {
            int negflag;
            int n = negflag = isResultNegative ? 1 : 0;
            return powSign > 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), negflag | 2), ctx) : (powSign < 0 ? this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), negflag), ctx) : this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), EInteger.FromInt64(0L), 0), ctx));
        }
        if (powSign == 0) {
            return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), EInteger.FromInt64(0L), 0), ctx);
        }
        if (isPowIntegral) {
            if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0) {
                return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.helper.ValueOf(1);
            }
            if (powInt == (Object)null) {
                powInt = this.Quantize(pow, this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 0), EContext.ForRounding(ERounding.Down));
            }
            EInteger signedMant = this.helper.GetMantissa(powInt);
            if (powSign < 0) {
                signedMant = signedMant.Negate();
            }
            return this.PowerIntegral(thisValue, signedMant, ctx);
        }
        if (this.compareTo(thisValue, this.helper.ValueOf(1)) == 0 && powSign > 0) {
            return !this.IsWithinExponentRangeForPow(pow, ctx) ? this.SignalInvalid(ctx) : this.ExtendPrecision(this.helper.ValueOf(1), ctx);
        }
        if (this.thisRadix == 10 || this.thisRadix == 2) {
            T half;
            T t = half = this.thisRadix == 10 ? this.helper.CreateNewWithFlags(EInteger.FromInt64(5L), ValueMinusOne, 0) : this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), ValueMinusOne, 0);
            if (this.compareTo(pow, half) == 0 && this.IsWithinExponentRangeForPow(pow, ctx) && this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                EContext ctxCopy = ctx.WithBlankFlags();
                thisValue = this.SquareRoot(thisValue, ctxCopy);
                ctxCopy.setFlags(ctxCopy.getFlags() | 1);
                ctxCopy.setFlags(ctxCopy.getFlags() | 2);
                if ((ctxCopy.getFlags() & 4) != 0) {
                    ctxCopy.setFlags(ctxCopy.getFlags() | 8);
                }
                thisValue = this.ExtendPrecision(thisValue, ctxCopy);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxCopy.getFlags());
                }
                return thisValue;
            }
        }
        int guardDigitCount = this.thisRadix == 2 ? 32 : 10;
        EInteger guardDigits = EInteger.FromInt64(guardDigitCount);
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(guardDigits));
        ctxdiv = ctxdiv.WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        T lnresult = this.Ln(thisValue, ctxdiv);
        lnresult = this.Multiply(lnresult, pow, ctxdiv);
        ctxdiv = ctx.WithBlankFlags();
        lnresult = this.Exp(lnresult, ctxdiv);
        if ((ctxdiv.getFlags() & 0x30) != 0) {
            if (!this.IsWithinExponentRangeForPow(thisValue, ctx)) {
                return this.SignalInvalid(ctx);
            }
            if (!this.IsWithinExponentRangeForPow(pow, ctx)) {
                return this.SignalInvalid(ctx);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | ctxdiv.getFlags());
        }
        return lnresult;
    }

    @Override
    public T Quantize(T thisValue, T otherValue, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, otherValue, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            return this.SignalInvalid(ctx);
        }
        EInteger expOther = this.helper.GetExponent(otherValue);
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        EContext tmpctx = (ctx == null ? EContext.ForRounding(ERounding.HalfEven) : ctx.Copy()).WithBlankFlags();
        EInteger mantThis = this.helper.GetMantissa(thisValue);
        EInteger expThis = this.helper.GetExponent(thisValue);
        int expcmp = expThis.compareTo(expOther);
        int negativeFlag = this.helper.GetFlags(thisValue) & 1;
        Object ret = null;
        if (expcmp == 0) {
            ret = this.RoundToPrecision(thisValue, tmpctx);
        } else if (mantThis.isZero()) {
            ret = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else if (expcmp > 0) {
            FastInteger radixPower = FastInteger.FromBig(expThis).SubtractBig(expOther);
            if (tmpctx.getPrecision().signum() > 0 && radixPower.compareTo(FastInteger.FromBig(tmpctx.getPrecision()).AddInt(10)) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result too high for current precision");
            }
            if ((mantThis = this.TryMultiplyByRadixPower(mantThis, radixPower)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            ret = this.helper.CreateNewWithFlags(mantThis, expOther, negativeFlag);
            ret = this.RoundToPrecision(ret, tmpctx);
        } else {
            FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(expThis);
            ret = this.RoundToPrecisionInternal(thisValue, 0, 0, shift, false, tmpctx);
        }
        if ((tmpctx.getFlags() & 0x10) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (ret == null || !this.helper.GetExponent(ret).equals(expOther)) {
            return this.SignalInvalid(ctx);
        }
        ret = this.EnsureSign(ret, negativeFlag != 0);
        if (ctx != null && ctx.getHasFlags()) {
            int flags = tmpctx.getFlags();
            ctx.setFlags(ctx.getFlags() | (flags &= 0xFFFFFFF7));
        }
        return ret;
    }

    @Override
    public T Reduce(T thisValue, EContext ctx) {
        return this.ReduceToPrecisionAndIdealExponent(thisValue, ctx, null, null);
    }

    @Override
    public T Remainder(T thisValue, T divisor, EContext ctx) {
        EContext ctx2 = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != (Object)null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideToIntegerZeroScale(thisValue, divisor, ctx2);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ret = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        ret = this.EnsureSign(ret, (this.helper.GetFlags(thisValue) & 1) != 0);
        RadixMath.TransferFlags(ctx, ctx2);
        return ret;
    }

    @Override
    public T RemainderNear(T thisValue, T divisor, EContext ctx) {
        EContext ctx2 = ctx == null ? EContext.ForRounding(ERounding.HalfEven).WithBlankFlags() : ctx.WithRounding(ERounding.HalfEven).WithBlankFlags();
        T ret = this.RemainderHandleSpecial(thisValue, divisor, ctx2);
        if (ret != (Object)null) {
            RadixMath.TransferFlags(ctx, ctx2);
            return ret;
        }
        ret = this.DivideInternal(thisValue, divisor, ctx2, 1, EInteger.FromInt64(0L));
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx2.WithBlankFlags();
        ret = this.RoundToPrecision(ret, ctx2);
        if ((ctx2.getFlags() & 0x42) != 0) {
            return this.SignalInvalid(ctx);
        }
        ctx2 = ctx == null ? EContext.Unlimited.WithBlankFlags() : ctx.WithBlankFlags();
        T ret2 = this.Add(thisValue, this.NegateRaw(this.Multiply(ret, divisor, null)), ctx2);
        if ((ctx2.getFlags() & 0x40) != 0) {
            return this.SignalInvalid(ctx);
        }
        if (this.helper.GetFlags(ret2) == 0 && this.helper.GetMantissa(ret2).isZero()) {
            ret2 = this.EnsureSign(ret2, (this.helper.GetFlags(thisValue) & 1) != 0);
        }
        RadixMath.TransferFlags(ctx, ctx2);
        return ret2;
    }

    @Override
    public T RoundAfterConversion(T thisValue, EContext ctx) {
        return this.RoundToPrecision(thisValue, ctx);
    }

    @Override
    public T RoundToExponentExact(T thisValue, EInteger expOther, EContext ctx) {
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        EContext pctx = ctx == null ? null : ctx.WithPrecision(0).WithBlankFlags();
        T ret = this.Quantize(thisValue, this.helper.CreateNewWithFlags(EInteger.FromInt64(1L), expOther, 0), pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags());
        }
        return ret;
    }

    @Override
    public T RoundToExponentNoRoundedFlag(T thisValue, EInteger exponent, EContext ctx) {
        EContext pctx = ctx == null ? null : ctx.WithBlankFlags();
        T ret = this.RoundToExponentExact(thisValue, exponent, pctx);
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | pctx.getFlags() & 0xFFFFFFFC);
        }
        return ret;
    }

    @Override
    public T RoundToExponentSimple(T thisValue, EInteger expOther, EContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, thisValue, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        if (this.helper.GetExponent(thisValue).compareTo(expOther) >= 0) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (ctx != null && !ctx.ExponentWithinRange(expOther)) {
            return this.SignalInvalidWithMessage(ctx, "Exponent not within exponent range: " + expOther);
        }
        FastInteger shift = FastInteger.FromBig(expOther).SubtractBig(this.helper.GetExponent(thisValue));
        if (shift.signum() == 0 && RadixMath.IsSimpleContext(ctx)) {
            return thisValue;
        }
        EInteger bigmantissa = this.helper.GetMantissa(thisValue);
        IShiftAccumulator accum = this.helper.CreateShiftAccumulator(bigmantissa);
        if (RadixMath.IsSimpleContext(ctx) && ctx.getRounding() == ERounding.Down) {
            accum.TruncateRight(shift);
            return this.helper.CreateNewWithFlags(accum.getShiftedInt(), expOther, thisFlags);
        }
        accum.ShiftRight(shift);
        bigmantissa = accum.getShiftedInt();
        thisValue = this.helper.CreateNewWithFlags(bigmantissa, expOther, thisFlags);
        return this.RoundToPrecisionInternal(thisValue, accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), null, false, ctx);
    }

    @Override
    public T RoundToPrecision(T thisValue, EContext context) {
        return this.RoundToPrecisionInternal(thisValue, 0, 0, null, false, context);
    }

    @Override
    public T SquareRoot(T thisValue, EContext ctx) {
        int expcmp;
        EInteger currentExp;
        if (ctx == null) {
            return this.SignalInvalidWithMessage(ctx, "ctx is null");
        }
        if (!ctx.getHasMaxPrecision()) {
            return this.SignalInvalidWithMessage(ctx, "ctx has unlimited precision");
        }
        T ret = this.SquareRootHandleSpecial(thisValue, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        EContext ctxtmp = ctx.WithBlankFlags();
        EInteger origExp = currentExp = this.helper.GetExponent(thisValue);
        EInteger idealExp = currentExp;
        idealExp = idealExp.Divide(EInteger.FromInt64(2L));
        if (currentExp.signum() < 0 && !currentExp.isEven()) {
            idealExp = idealExp.Subtract(EInteger.FromInt64(1L));
        }
        if (this.helper.GetSign(thisValue) == 0) {
            ret = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), idealExp, this.helper.GetFlags(thisValue)), ctxtmp);
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
            }
            return ret;
        }
        EInteger mantissa = this.helper.GetMantissa(thisValue);
        IShiftAccumulator accum = this.helper.CreateShiftAccumulator(mantissa);
        FastInteger digitCount = accum.GetDigitLength();
        FastInteger targetPrecision = FastInteger.FromBig(ctx.getPrecision());
        FastInteger precision = FastInteger.Copy(targetPrecision).Multiply(2).AddInt(2);
        boolean rounded = false;
        boolean inexact = false;
        if (digitCount.compareTo(precision) < 0) {
            FastInteger diff = FastInteger.Copy(precision).Subtract(digitCount);
            if (!diff.isEvenNumber() ^ !origExp.isEven()) {
                diff.Increment();
            }
            EInteger bigdiff = diff.AsBigInteger();
            currentExp = currentExp.Subtract(bigdiff);
            if ((mantissa = this.TryMultiplyByRadixPower(mantissa, diff)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
        }
        EInteger[] sr = mantissa.SqrtRem();
        digitCount = this.helper.CreateShiftAccumulator(sr[0]).GetDigitLength();
        EInteger squareRootRemainder = sr[1];
        mantissa = sr[0];
        if (!squareRootRemainder.isZero()) {
            rounded = true;
            inexact = true;
        }
        EInteger oldexp = currentExp;
        currentExp = currentExp.Divide(EInteger.FromInt64(2L));
        if (oldexp.signum() < 0 && !oldexp.isEven()) {
            currentExp = currentExp.Subtract(EInteger.FromInt64(1L));
        }
        T retval = this.helper.CreateNewWithFlags(mantissa, currentExp, 0);
        retval = this.RoundToPrecisionInternal(retval, 0, inexact ? 1 : 0, null, false, ctxtmp);
        currentExp = this.helper.GetExponent(retval);
        if (!((ctxtmp.getFlags() & 8) != 0 || (expcmp = currentExp.compareTo(idealExp)) > 0 && this.IsFinite(retval))) {
            retval = this.ReduceToPrecisionAndIdealExponent(retval, ctx.getHasExponentRange() ? ctxtmp : null, inexact ? targetPrecision : null, FastInteger.FromBig(idealExp));
        }
        if (ctx.getHasFlags()) {
            if (ctx.getClampNormalExponents() && !this.helper.GetExponent(retval).equals(idealExp) && (ctxtmp.getFlags() & 1) == 0) {
                ctx.setFlags(ctx.getFlags() | 0x20);
            }
            boolean bl = (ctxtmp.getFlags() & 0x10) != 0;
            currentExp = this.helper.GetExponent(retval);
            if (rounded |= bl) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
            } else if (currentExp.compareTo(idealExp) > 0) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
            } else {
                ctxtmp.setFlags(ctxtmp.getFlags() & 0xFFFFFFFD);
            }
            if (inexact) {
                ctxtmp.setFlags(ctxtmp.getFlags() | 2);
                ctxtmp.setFlags(ctxtmp.getFlags() | 1);
            }
            ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags());
        }
        return retval;
    }

    private static EInteger PowerOfTwo(FastInteger fi) {
        if (fi.signum() <= 0) {
            return EInteger.FromInt64(1L);
        }
        if (fi.CanFitInInt32()) {
            int val = fi.AsInt32();
            if (val <= 30) {
                val = 1 << val;
                return EInteger.FromInt64(val);
            }
            return EInteger.FromInt64(1L).ShiftLeft(val);
        }
        EInteger bi = EInteger.FromInt64(1L);
        FastInteger fi2 = FastInteger.Copy(fi);
        while (fi2.signum() > 0) {
            int count = 1000000;
            if (fi2.CompareToInt(1000000) < 0) {
                count = bi.AsInt32Checked();
            }
            bi = bi.ShiftLeft(count);
            fi2.SubtractInt(count);
        }
        return bi;
    }

    private static EContext SetPrecisionIfLimited(EContext ctx, EInteger bigPrecision) {
        return ctx == null || !ctx.getHasMaxPrecision() ? ctx : ctx.WithBigPrecision(bigPrecision);
    }

    private static void TransferFlags(EContext ctxDst, EContext ctxSrc) {
        if (ctxDst != null && ctxDst.getHasFlags()) {
            if ((ctxSrc.getFlags() & 0xC0) != 0) {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags() & 0xC0);
            } else {
                ctxDst.setFlags(ctxDst.getFlags() | ctxSrc.getFlags());
            }
        }
    }

    private T AbsRaw(T value) {
        return this.EnsureSign(value, false);
    }

    private T AddCore(EInteger mant1, EInteger mant2, EInteger exponent, int flags1, int flags2, EContext ctx) {
        boolean neg1 = (flags1 & 1) != 0;
        boolean neg2 = (flags2 & 1) != 0;
        boolean negResult = false;
        if (neg1 != neg2) {
            int mant1Sign = (mant1 = mant1.Subtract(mant2)).signum();
            negResult = neg1 ^ (mant1Sign == 0 ? neg2 : mant1Sign < 0);
        } else {
            mant1 = mant1.Add(mant2);
            negResult = neg1;
        }
        if (negResult && mant1.isZero()) {
            negResult &= neg1 && neg2 || neg1 ^ neg2 && ctx != null && ctx.getRounding() == ERounding.Floor;
        }
        return this.helper.CreateNewWithFlags(mant1, exponent, negResult ? 1 : 0);
    }

    private T CompareToHandleSpecial(T thisValue, T other, boolean treatQuietNansAsSignaling, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(other, ctx);
            }
            if (treatQuietNansAsSignaling) {
                if ((thisFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.SignalingNaNInvalid(other, ctx);
                }
            } else {
                if ((thisFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(other, ctx);
                }
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((thisFlags & 1) == 0 ? this.ValueOf(1, null) : this.ValueOf(-1, null));
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? this.ValueOf(0, null) : ((otherFlags & 1) == 0 ? this.ValueOf(-1, null) : this.ValueOf(1, null));
            }
        }
        return null;
    }

    private int CompareToHandleSpecial(T thisValue, T other) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            if ((thisFlags & 0xC) != 0) {
                if ((otherFlags & 0xC) != 0) {
                    return 0;
                }
                return 1;
            }
            if ((otherFlags & 0xC) != 0) {
                return -1;
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((thisFlags & 1) == 0 ? 1 : -1);
            }
            if ((otherFlags & 2) != 0) {
                return (thisFlags & 3) == (otherFlags & 3) ? 0 : ((otherFlags & 1) == 0 ? -1 : 1);
            }
        }
        return 2;
    }

    private static int CompareToFast(int e1int, int e2int, int expcmp, int signA, EInteger op1Mantissa, EInteger op2Mantissa, int radix) {
        if (e1int >= -100 && e1int < 100 && e2int >= -100 && e2int < 100) {
            int ediff = Math.abs(e1int - e2int);
            if (ediff <= 9 && radix == 10) {
                int power = ValueTenPowers[ediff];
                int maxoverflow = OverflowMaxes[ediff];
                if (expcmp > 0) {
                    int m1 = op1Mantissa.AsInt32Unchecked();
                    int m2 = op2Mantissa.AsInt32Unchecked();
                    if (m1 <= maxoverflow) {
                        int mantcmp = (m1 *= power) == m2 ? 0 : (m1 < m2 ? -1 : 1);
                        return signA < 0 ? -mantcmp : mantcmp;
                    }
                } else {
                    int m1 = op1Mantissa.AsInt32Unchecked();
                    int m2 = op2Mantissa.AsInt32Unchecked();
                    if (m2 <= maxoverflow) {
                        int mantcmp = m1 == (m2 *= power) ? 0 : (m1 < m2 ? -1 : 1);
                        return signA < 0 ? -mantcmp : mantcmp;
                    }
                }
            } else if (ediff <= 30 && radix == 2) {
                int mask = BitMasks[ediff];
                if (expcmp > 0) {
                    int m1 = op1Mantissa.AsInt32Unchecked();
                    int m2 = op2Mantissa.AsInt32Unchecked();
                    if ((m1 & mask) == m1) {
                        int mantcmp = (m1 <<= ediff) == m2 ? 0 : (m1 < m2 ? -1 : 1);
                        return signA < 0 ? -mantcmp : mantcmp;
                    }
                } else {
                    int m1 = op1Mantissa.AsInt32Unchecked();
                    int m2 = op2Mantissa.AsInt32Unchecked();
                    if ((m2 & mask) == m2) {
                        int mantcmp = m1 == (m2 <<= ediff) ? 0 : (m1 < m2 ? -1 : 1);
                        return signA < 0 ? -mantcmp : mantcmp;
                    }
                }
            }
        }
        return 2;
    }

    private int CompareToInternal(T thisValue, T otherValue, boolean reportOOM) {
        EInteger newmant;
        int e2int;
        int e1int;
        int c;
        int signB;
        if (otherValue == null) {
            return 1;
        }
        int signA = this.CompareToHandleSpecial(thisValue, otherValue);
        if (signA <= 1) {
            return signA;
        }
        signA = this.helper.GetSign(thisValue);
        if (signA != (signB = this.helper.GetSign(otherValue))) {
            return signA < signB ? -1 : 1;
        }
        if (signB == 0 || signA == 0) {
            return 0;
        }
        EInteger op1Exponent = this.helper.GetExponent(thisValue);
        EInteger op2Exponent = this.helper.GetExponent(otherValue);
        EInteger op1Mantissa = this.helper.GetMantissa(thisValue);
        EInteger op2Mantissa = this.helper.GetMantissa(otherValue);
        int expcmp = op1Exponent.compareTo(op2Exponent);
        int mantcmp = op1Mantissa.compareTo(op2Mantissa);
        if (mantcmp == 0) {
            return signA < 0 ? -expcmp : expcmp;
        }
        if (signA < 0) {
            mantcmp = -mantcmp;
        }
        if (expcmp == 0) {
            return mantcmp;
        }
        if (op1Exponent.CanFitInInt32() && op2Exponent.CanFitInInt32() && op1Mantissa.CanFitInInt32() && op2Mantissa.CanFitInInt32() && (c = RadixMath.CompareToFast(e1int = op1Exponent.AsInt32Unchecked(), e2int = op2Exponent.AsInt32Unchecked(), expcmp, signA, op1Mantissa, op2Mantissa, this.thisRadix)) <= 1) {
            return c;
        }
        FastInteger fastOp1Exp = FastInteger.FromBig(op1Exponent);
        FastInteger fastOp2Exp = FastInteger.FromBig(op2Exponent);
        FastInteger expdiff = FastInteger.Copy(fastOp1Exp).Subtract(fastOp2Exp).Abs();
        if (expdiff.CompareToInt(100) >= 0) {
            EInteger op1MantAbs = this.helper.GetMantissa(thisValue);
            EInteger op2MantAbs = this.helper.GetMantissa(otherValue);
            FastInteger precision1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
            FastInteger precision2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
            FastInteger maxPrecision = null;
            FastInteger fastInteger = maxPrecision = precision1.compareTo(precision2) > 0 ? precision1 : precision2;
            if (FastInteger.Copy(expdiff).compareTo(maxPrecision) > 0) {
                int expcmp2 = fastOp1Exp.compareTo(fastOp2Exp);
                if (expcmp2 < 0) {
                    if (!op2MantAbs.isZero()) {
                        FastInteger tmp;
                        FastInteger newDiff;
                        FastInteger digitLength1 = this.helper.CreateShiftAccumulator(op1MantAbs).GetDigitLength();
                        if (FastInteger.Copy(fastOp1Exp).Add(digitLength1).AddInt(2).compareTo(fastOp2Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp2Exp).SubtractInt(8).Subtract(digitLength1).Subtract(maxPrecision)).Subtract(fastOp2Exp).Abs()).compareTo(expdiff) < 0) {
                            return signA < 0 ? 1 : -1;
                        }
                    }
                } else if (expcmp2 > 0 && !op1MantAbs.isZero()) {
                    FastInteger tmp;
                    FastInteger newDiff;
                    FastInteger digitLength2 = this.helper.CreateShiftAccumulator(op2MantAbs).GetDigitLength();
                    if (FastInteger.Copy(fastOp2Exp).Add(digitLength2).AddInt(2).compareTo(fastOp1Exp) < 0 && (newDiff = FastInteger.Copy(tmp = FastInteger.Copy(fastOp1Exp).SubtractInt(8).Subtract(digitLength2).Subtract(maxPrecision)).Subtract(fastOp1Exp).Abs()).compareTo(expdiff) < 0) {
                        return signA < 0 ? -1 : 1;
                    }
                }
                expcmp = op1Exponent.compareTo(op2Exponent);
            }
        }
        if (expcmp > 0) {
            newmant = this.RescaleByExponentDiff(op1Mantissa, op1Exponent, op2Exponent);
            if (newmant == null) {
                if (reportOOM) {
                    throw new OutOfMemoryError("Result requires too much memory");
                }
                return -2;
            }
            mantcmp = newmant.compareTo(op2Mantissa);
            return signA < 0 ? -mantcmp : mantcmp;
        }
        newmant = this.RescaleByExponentDiff(op2Mantissa, op1Exponent, op2Exponent);
        if (newmant == null) {
            if (reportOOM) {
                throw new OutOfMemoryError("Result requires too much memory");
            }
            return -2;
        }
        mantcmp = op1Mantissa.compareTo(newmant);
        return signA < 0 ? -mantcmp : mantcmp;
    }

    private T DivideInternal(T thisValue, T divisor, EContext ctx, int integerMode, EInteger desiredExponent) {
        int mantcmp;
        T ret = this.DivisionHandleSpecial(thisValue, divisor, ctx);
        if (ret != (Object)null) {
            return ret;
        }
        int signA = this.helper.GetSign(thisValue);
        int signB = this.helper.GetSign(divisor);
        if (signB == 0) {
            if (signA == 0) {
                return this.SignalInvalid(ctx);
            }
            boolean flagsNeg = (this.helper.GetFlags(thisValue) & 1) != 0 ^ (this.helper.GetFlags(divisor) & 1) != 0;
            return this.SignalDivideByZero(ctx, flagsNeg);
        }
        int radix = this.thisRadix;
        if (signA == 0) {
            T retval = null;
            if (integerMode == 1) {
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), desiredExponent, newflags);
            } else {
                EInteger dividendExp = this.helper.GetExponent(thisValue);
                EInteger divisorExp = this.helper.GetExponent(divisor);
                int newflags = this.helper.GetFlags(thisValue) & 1 ^ this.helper.GetFlags(divisor) & 1;
                retval = this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), dividendExp.Subtract(divisorExp), newflags), ctx);
            }
            return retval;
        }
        EInteger mantissaDividend = this.helper.GetMantissa(thisValue);
        EInteger mantissaDivisor = this.helper.GetMantissa(divisor);
        FastInteger expDividend = FastInteger.FromBig(this.helper.GetExponent(thisValue));
        FastInteger expDivisor = FastInteger.FromBig(this.helper.GetExponent(divisor));
        FastInteger expdiff = FastInteger.Copy(expDividend).Subtract(expDivisor);
        FastInteger adjust = new FastInteger(0);
        FastInteger result = new FastInteger(0);
        FastInteger naturalExponent = FastInteger.Copy(expdiff);
        boolean hasPrecision = ctx != null && ctx.getPrecision().signum() != 0;
        boolean resultNeg = (this.helper.GetFlags(thisValue) & 1) != (this.helper.GetFlags(divisor) & 1);
        FastInteger fastPrecision = !hasPrecision ? new FastInteger(0) : FastInteger.FromBig(ctx.getPrecision());
        FastInteger dividendPrecision = null;
        FastInteger divisorPrecision = null;
        if (integerMode == 1) {
            FastInteger fastDesiredExponent = FastInteger.FromBig(desiredExponent);
            if (ctx != null && ctx.getHasFlags() && fastDesiredExponent.compareTo(naturalExponent) > 0) {
                ctx.setFlags(ctx.getFlags() | 2);
            }
            if (expdiff.compareTo(fastDesiredExponent) <= 0) {
                FastInteger shift = FastInteger.Copy(fastDesiredExponent).Subtract(expdiff);
                EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
                EInteger quo = divrem[0];
                EInteger rem = divrem[1];
                return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, shift, resultNeg, ctx);
            }
            if (ctx != null && ctx.getPrecision().signum() != 0 && FastInteger.Copy(expdiff).SubtractInt(8).compareTo(fastPrecision) > 0) {
                return this.SignalInvalidWithMessage(ctx, "Result can't fit the precision");
            }
            FastInteger shift = FastInteger.Copy(expdiff).Subtract(fastDesiredExponent);
            if ((mantissaDividend = this.TryMultiplyByRadixPower(mantissaDividend, shift)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
            EInteger quo = divrem[0];
            EInteger rem = divrem[1];
            return this.RoundToScale(quo, rem, mantissaDivisor, desiredExponent, new FastInteger(0), resultNeg, ctx);
        }
        if (integerMode == 0) {
            EInteger rem = null;
            EInteger quo = null;
            EInteger[] divrem = mantissaDividend.DivRem(mantissaDivisor);
            quo = divrem[0];
            rem = divrem[1];
            if (rem.isZero()) {
                if (resultNeg) {
                    quo = quo.Negate();
                }
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(quo, naturalExponent.AsBigInteger(), resultNeg ? 1 : 0), ctx);
            }
            rem = null;
            quo = null;
            if (hasPrecision) {
                int[] digitStatus;
                EInteger divid = mantissaDividend;
                FastInteger shift = FastInteger.FromBig(ctx.getPrecision());
                dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
                if (dividendPrecision.compareTo(divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength()) <= 0) {
                    divisorPrecision.Subtract(dividendPrecision);
                    divisorPrecision.Increment();
                    shift.Add(divisorPrecision);
                    divid = this.TryMultiplyByRadixPower(divid, shift);
                    if (divid == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                } else {
                    dividendPrecision.Subtract(divisorPrecision);
                    if (dividendPrecision.compareTo(shift) <= 0) {
                        shift.Subtract(dividendPrecision);
                        shift.Increment();
                        divid = this.TryMultiplyByRadixPower(divid, shift);
                        if (divid == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                    } else {
                        shift.SetInt(0);
                    }
                }
                dividendPrecision = this.helper.CreateShiftAccumulator(divid).GetDigitLength();
                divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
                if (shift.signum() != 0 || quo == null) {
                    EInteger[] divrem2 = divid.DivRem(mantissaDivisor);
                    quo = divrem2[0];
                    rem = divrem2[1];
                }
                if ((digitStatus = this.RoundToScaleStatus(rem, mantissaDivisor, ctx)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                FastInteger natexp = FastInteger.Copy(naturalExponent).Subtract(shift);
                EContext ctxcopy = ctx.WithBlankFlags();
                T retval2 = this.helper.CreateNewWithFlags(quo, natexp.AsBigInteger(), resultNeg ? 1 : 0);
                retval2 = this.RoundToPrecisionInternal(retval2, digitStatus[0], digitStatus[1], null, false, ctxcopy);
                if ((ctxcopy.getFlags() & 1) != 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags());
                    }
                    return retval2;
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxcopy.getFlags());
                    ctx.setFlags(ctx.getFlags() & 0xFFFFFFFD);
                }
                return this.ReduceToPrecisionAndIdealExponent(retval2, ctx, rem.isZero() ? null : fastPrecision, expdiff);
            }
        }
        if ((mantcmp = mantissaDividend.compareTo(mantissaDivisor)) < 0) {
            dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
            divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
            divisorPrecision.Subtract(dividendPrecision);
            if (divisorPrecision.isValueZero()) {
                divisorPrecision.Increment();
            }
            if ((mantissaDividend = this.TryMultiplyByRadixPower(mantissaDividend, divisorPrecision)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            adjust.Add(divisorPrecision);
            if (mantissaDividend.compareTo(mantissaDivisor) < 0) {
                mantissaDividend = radix == 2 ? mantissaDividend.ShiftLeft(1) : mantissaDividend.Multiply(EInteger.FromInt64(radix));
                adjust.Increment();
            }
        } else if (mantcmp > 0) {
            dividendPrecision = this.helper.CreateShiftAccumulator(mantissaDividend).GetDigitLength();
            divisorPrecision = this.helper.CreateShiftAccumulator(mantissaDivisor).GetDigitLength();
            dividendPrecision.Subtract(divisorPrecision);
            EInteger oldMantissaB = mantissaDivisor;
            mantissaDivisor = this.TryMultiplyByRadixPower(mantissaDivisor, dividendPrecision);
            if (mantissaDivisor == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            adjust.Subtract(dividendPrecision);
            if (mantissaDividend.compareTo(mantissaDivisor) < 0) {
                if (dividendPrecision.CompareToInt(1) == 0) {
                    mantissaDivisor = oldMantissaB;
                } else {
                    EInteger bigpow = EInteger.FromInt64(radix);
                    mantissaDivisor = mantissaDivisor.Divide(bigpow);
                }
                adjust.Increment();
            }
        }
        if (mantcmp == 0) {
            result = new FastInteger(1);
            mantissaDividend = EInteger.FromInt64(0L);
        } else {
            if (!this.helper.HasTerminatingRadixExpansion(mantissaDividend, mantissaDivisor)) {
                return this.SignalInvalidWithMessage(ctx, "Result would have a nonterminating expansion");
            }
            FastInteger divs = FastInteger.FromBig(mantissaDivisor);
            FastInteger divd = FastInteger.FromBig(mantissaDividend);
            boolean divisorFits = divs.CanFitInInt32();
            int smallDivisor = divisorFits ? divs.AsInt32() : 0;
            int halfRadix = radix / 2;
            FastInteger divsHalfRadix = null;
            if (radix != 2) {
                divsHalfRadix = FastInteger.FromBig(mantissaDivisor).Multiply(halfRadix);
            }
            while (true) {
                boolean remainderZero = false;
                int count = 0;
                if (divd.CanFitInInt32()) {
                    if (divisorFits) {
                        int smallDividend = divd.AsInt32();
                        count = smallDividend / smallDivisor;
                        divd.SetInt(smallDividend % smallDivisor);
                    } else {
                        count = 0;
                    }
                } else {
                    if (divsHalfRadix != null) {
                        count += halfRadix * divd.RepeatedSubtract(divsHalfRadix);
                    }
                    count += divd.RepeatedSubtract(divs);
                }
                result.AddInt(count);
                remainderZero = divd.isValueZero();
                if (remainderZero && adjust.signum() >= 0) {
                    mantissaDividend = divd.AsBigInteger();
                    break;
                }
                adjust.Increment();
                result.Multiply(radix);
                divd.Multiply(radix);
            }
        }
        FastInteger exp = FastInteger.Copy(expdiff).Subtract(adjust);
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!mantissaDividend.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfEven || rounding == ERounding.HalfUp) {
                EInteger halfDivisor = mantissaDivisor.ShiftRight(1);
                int cmpHalf = mantissaDividend.compareTo(halfDivisor);
                if (cmpHalf == 0 && mantissaDivisor.isEven()) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = radix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        EInteger bigResult = result.AsBigInteger();
        if (ctx != null && ctx.getHasFlags() && exp.compareTo(expdiff) > 0) {
            ctx.setFlags(ctx.getFlags() | 2);
        }
        EInteger bigexp = exp.AsBigInteger();
        T retval = this.helper.CreateNewWithFlags(bigResult, bigexp, resultNeg ? 1 : 0);
        return this.RoundToPrecisionInternal(retval, lastDiscarded, olderDiscarded, null, false, ctx);
    }

    private T DivisionHandleSpecial(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0 && (otherFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((thisFlags & 2) != 0) {
                return this.EnsureSign(thisValue, ((thisFlags ^ otherFlags) & 1) != 0);
            }
            if ((otherFlags & 2) != 0) {
                if (ctx != null && ctx.getHasExponentRange() && ctx.getPrecision().signum() > 0) {
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | 0x20);
                    }
                    EInteger bigexp = ctx.getEMin();
                    EInteger bigprec = ctx.getPrecision();
                    if (ctx.getAdjustExponent()) {
                        bigexp = bigexp.Subtract(bigprec);
                        bigexp = bigexp.Add(EInteger.FromInt64(1L));
                    }
                    thisFlags = (thisFlags ^ otherFlags) & 1;
                    return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), bigexp, thisFlags);
                }
                thisFlags = (thisFlags ^ otherFlags) & 1;
                return this.RoundToPrecision(this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), thisFlags), ctx);
            }
        }
        return null;
    }

    private T EnsureSign(T val, boolean negative) {
        if (val == null) {
            return val;
        }
        int flags = this.helper.GetFlags(val);
        if (negative && (flags & 1) == 0 || !negative && (flags & 1) != 0) {
            flags &= 0xFFFFFFFE;
            return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), flags |= negative ? 1 : 0);
        }
        return val;
    }

    private T ExpInternal(T thisValue, EInteger workingPrecision, EContext ctx) {
        T guess;
        T one = this.helper.ValueOf(1);
        int precisionAdd = this.thisRadix == 2 ? 18 : 12;
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.Add(EInteger.FromInt64(precisionAdd))).WithRounding(ERounding.OddOrZeroFiveUp);
        EInteger bigintN = EInteger.FromInt64(2L);
        EInteger facto = EInteger.FromInt64(1L);
        T lastGuess = guess = this.Add(one, thisValue, null);
        T pow = thisValue;
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(pow = this.Multiply(pow, thisValue, ctxdiv), this.helper.CreateNewWithFlags(facto = facto.Multiply(bigintN), EInteger.FromInt64(0L), 0), ctxdiv);
            T newGuess = this.Add(guess, tmp, ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            bigintN = bigintN.Add(EInteger.FromInt64(1L));
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T ExtendPrecision(T thisValue, EContext ctx) {
        if (ctx == null || !ctx.getHasMaxPrecision()) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        EInteger mant = this.helper.GetMantissa(thisValue);
        FastInteger digits = this.helper.CreateShiftAccumulator(mant).GetDigitLength();
        FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
        EInteger exponent = this.helper.GetExponent(thisValue);
        if (digits.compareTo(fastPrecision) < 0) {
            fastPrecision.Subtract(digits);
            mant = this.TryMultiplyByRadixPower(mant, fastPrecision);
            if (mant == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            EInteger bigPrec = fastPrecision.AsBigInteger();
            exponent = exponent.Subtract(bigPrec);
        }
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 2);
            ctx.setFlags(ctx.getFlags() | 1);
        }
        return this.RoundToPrecision(this.helper.CreateNewWithFlags(mant, exponent, 0), ctx);
    }

    private T HandleNotANumber(T thisValue, T other, EContext ctx) {
        int thisFlags = this.helper.GetFlags(thisValue);
        int otherFlags = this.helper.GetFlags(other);
        if ((thisFlags & 8) != 0) {
            return this.SignalingNaNInvalid(thisValue, ctx);
        }
        if ((otherFlags & 8) != 0) {
            return this.SignalingNaNInvalid(other, ctx);
        }
        return (T)((thisFlags & 4) != 0 ? this.ReturnQuietNaN(thisValue, ctx) : ((otherFlags & 4) != 0 ? this.ReturnQuietNaN(other, ctx) : null));
    }

    private boolean IsFinite(T val) {
        return (this.helper.GetFlags(val) & 0xE) == 0;
    }

    private boolean IsNegative(T val) {
        return (this.helper.GetFlags(val) & 1) != 0;
    }

    private boolean IsWithinExponentRangeForPow(T thisValue, EContext ctx) {
        if (ctx == null || !ctx.getHasExponentRange()) {
            return true;
        }
        FastInteger digits = this.helper.CreateShiftAccumulator(this.helper.GetMantissa(thisValue)).GetDigitLength();
        EInteger exp = this.helper.GetExponent(thisValue);
        FastInteger fi = FastInteger.FromBig(exp);
        if (ctx.getAdjustExponent()) {
            fi.Add(digits);
            fi.Decrement();
        }
        if (fi.signum() < 0) {
            fi.Negate().Divide(2).Negate();
        }
        return (exp = fi.AsBigInteger()).compareTo(ctx.getEMin()) >= 0 && exp.compareTo(ctx.getEMax()) <= 0;
    }

    private T LnInternal(T thisValue, EInteger workingPrecision, EContext ctx) {
        boolean more = true;
        int lastCompare = 0;
        int vacillations = 0;
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, workingPrecision.Add(EInteger.FromInt64(6L))).WithRounding(ERounding.OddOrZeroFiveUp);
        T z = this.Add(this.NegateRaw(thisValue), this.helper.ValueOf(1), null);
        T zpow = this.Multiply(z, z, ctxdiv);
        T guess = this.NegateRaw(z);
        T lastGuess = null;
        EInteger denom = EInteger.FromInt64(2L);
        while (more) {
            lastGuess = guess;
            T tmp = this.Divide(zpow, this.helper.CreateNewWithFlags(denom, EInteger.FromInt64(0L), 0), ctxdiv);
            T newGuess = this.Add(guess, this.NegateRaw(tmp), ctxdiv);
            int guessCmp = this.compareTo(lastGuess, newGuess);
            if (guessCmp == 0) {
                more = false;
            } else if (guessCmp > 0 && lastCompare < 0 || lastCompare > 0 && guessCmp < 0) {
                more &= ++vacillations <= 3 || guessCmp <= 0;
            }
            lastCompare = guessCmp;
            guess = newGuess;
            if (!more) continue;
            zpow = this.Multiply(zpow, z, ctxdiv);
            denom = denom.Add(EInteger.FromInt64(1L));
        }
        return this.RoundToPrecision(guess, ctx);
    }

    private T LnTenConstant(EContext ctx) {
        T thisValue = this.helper.ValueOf(10);
        FastInteger error = new FastInteger(10);
        EInteger bigError = error.AsBigInteger();
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        for (int i = 0; i < 9; ++i) {
            thisValue = this.SquareRoot(thisValue, ctxdiv.WithUnlimitedExponents());
        }
        thisValue = this.Divide(this.helper.ValueOf(1), thisValue, ctxdiv);
        thisValue = this.LnInternal(thisValue, ctxdiv.getPrecision(), ctxdiv);
        thisValue = this.NegateRaw(thisValue);
        thisValue = this.Multiply(thisValue, this.helper.ValueOf(512), ctx);
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 1);
            ctx.setFlags(ctx.getFlags() | 2);
        }
        return thisValue;
    }

    private T MinMaxHandleSpecial(T thisValue, T otherValue, EContext ctx, boolean isMinOp, boolean compareAbs) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(otherValue))) & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((otherFlags & 8) != 0) {
                return this.SignalingNaNInvalid(otherValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                if ((otherFlags & 4) != 0) {
                    return this.ReturnQuietNaN(thisValue, ctx);
                }
                return this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 4) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                if (compareAbs && (otherFlags & 2) == 0) {
                    return isMinOp ? this.RoundToPrecision(otherValue, ctx) : thisValue;
                }
                if (isMinOp) {
                    return (thisFlags & 1) != 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
                }
                return (thisFlags & 1) == 0 ? thisValue : this.RoundToPrecision(otherValue, ctx);
            }
            if ((otherFlags & 2) != 0) {
                if (compareAbs) {
                    return isMinOp ? this.RoundToPrecision(thisValue, ctx) : otherValue;
                }
                return isMinOp ? ((otherFlags & 1) == 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue) : ((otherFlags & 1) != 0 ? this.RoundToPrecision(thisValue, ctx) : otherValue);
            }
        }
        return null;
    }

    private T MultiplyAddHandleSpecial(T op1, T op2, T op3, EContext ctx) {
        int op1Flags = this.helper.GetFlags(op1);
        if ((op1Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op1, ctx);
        }
        int op2Flags = this.helper.GetFlags(op2);
        if ((op2Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op2, ctx);
        }
        int op3Flags = this.helper.GetFlags(op3);
        if ((op3Flags & 8) != 0) {
            return this.SignalingNaNInvalid(op3, ctx);
        }
        if ((op1Flags & 4) != 0) {
            return this.ReturnQuietNaN(op1, ctx);
        }
        if ((op2Flags & 4) != 0) {
            return this.ReturnQuietNaN(op2, ctx);
        }
        if ((op1Flags & 2) != 0 && (op2Flags & 0xE) == 0 && this.helper.GetMantissa(op2).isZero()) {
            return this.SignalInvalid(ctx);
        }
        if ((op2Flags & 2) != 0 && (op1Flags & 0xE) == 0 && this.helper.GetMantissa(op1).isZero()) {
            return this.SignalInvalid(ctx);
        }
        return (op3Flags & 4) != 0 ? (T)this.ReturnQuietNaN(op3, ctx) : null;
    }

    private T NegateRaw(T val) {
        if (val == null) {
            return val;
        }
        int sign = this.helper.GetFlags(val) & 1;
        return this.helper.CreateNewWithFlags(this.helper.GetMantissa(val), this.helper.GetExponent(val), sign == 0 ? 1 : 0);
    }

    private T PowerIntegral(T thisValue, EInteger powIntBig, EContext ctx) {
        int sign = powIntBig.signum();
        T one = this.helper.ValueOf(1);
        if (sign == 0) {
            return this.RoundToPrecision(one, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt64(1L))) {
            return this.RoundToPrecision(thisValue, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt64(2L))) {
            return this.Multiply(thisValue, thisValue, ctx);
        }
        if (powIntBig.equals(EInteger.FromInt64(3L))) {
            return this.Multiply(thisValue, this.Multiply(thisValue, thisValue, null), ctx);
        }
        boolean retvalNeg = this.IsNegative(thisValue) && !powIntBig.isEven();
        FastInteger error = this.helper.CreateShiftAccumulator(powIntBig.Abs()).GetDigitLength();
        error.AddInt(18);
        EInteger bigError = error.AsBigInteger();
        EContext ctxdiv = RadixMath.SetPrecisionIfLimited(ctx, ctx.getPrecision().Add(bigError)).WithRounding(ERounding.OddOrZeroFiveUp).WithBlankFlags();
        if (sign < 0) {
            thisValue = this.Divide(one, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow2(ctx, retvalNeg);
            }
            powIntBig = powIntBig.Negate();
        }
        T r = one;
        while (!powIntBig.isZero()) {
            if (!powIntBig.isEven()) {
                r = this.Multiply(r, thisValue, ctxdiv);
                if ((ctxdiv.getFlags() & 0x10) != 0) {
                    return this.SignalOverflow2(ctx, retvalNeg);
                }
            }
            if ((powIntBig = powIntBig.ShiftRight(1)).isZero()) continue;
            ctxdiv.setFlags(0);
            T tmp = this.Multiply(thisValue, thisValue, ctxdiv);
            if ((ctxdiv.getFlags() & 0x10) != 0) {
                return this.SignalOverflow2(ctx, retvalNeg);
            }
            thisValue = tmp;
        }
        return this.RoundToPrecision(r, ctx);
    }

    private T ReduceToPrecisionAndIdealExponent(T thisValue, EContext ctx, FastInteger precision, FastInteger idealExp) {
        T ret = this.RoundToPrecision(thisValue, ctx);
        if (ret != null && (this.helper.GetFlags(ret) & 0xE) == 0) {
            EInteger bigmant = this.helper.GetMantissa(ret);
            FastInteger exp = FastInteger.FromBig(this.helper.GetExponent(ret));
            int radix = this.thisRadix;
            if (bigmant.isZero()) {
                exp = new FastInteger(0);
            } else {
                FastInteger digits = precision == null ? null : this.helper.CreateShiftAccumulator(bigmant).GetDigitLength();
                bigmant = DecimalUtility.ReduceTrailingZeros(bigmant, exp, radix, digits, precision, idealExp);
            }
            int flags = this.helper.GetFlags(thisValue);
            ret = this.helper.CreateNewWithFlags(bigmant, exp.AsBigInteger(), flags);
            if (ctx != null && ctx.getClampNormalExponents()) {
                EContext ctxtmp = ctx.WithBlankFlags();
                ret = this.RoundToPrecision(ret, ctxtmp);
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | ctxtmp.getFlags() & 0xFFFFFFDF);
                }
            }
            ret = this.EnsureSign(ret, (flags & 1) != 0);
        }
        return ret;
    }

    private T RemainderHandleSpecial(T thisValue, T other, EContext ctx) {
        int otherFlags;
        int thisFlags = this.helper.GetFlags(thisValue);
        if (((thisFlags | (otherFlags = this.helper.GetFlags(other))) & 0xE) != 0) {
            T result = this.HandleNotANumber(thisValue, other, ctx);
            if (result != (Object)null) {
                return result;
            }
            if ((thisFlags & 2) != 0) {
                return this.SignalInvalid(ctx);
            }
            if ((otherFlags & 2) != 0) {
                return this.RoundToPrecision(thisValue, ctx);
            }
        }
        return this.helper.GetMantissa(other).isZero() ? (T)this.SignalInvalid(ctx) : null;
    }

    private EInteger RescaleByExponentDiff(EInteger mantissa, EInteger e1, EInteger e2) {
        if (mantissa.signum() == 0) {
            return EInteger.FromInt64(0L);
        }
        FastInteger diff = FastInteger.FromBig(e1).SubtractBig(e2).Abs();
        return this.TryMultiplyByRadixPower(mantissa, diff);
    }

    private static EInteger AbsInt(EInteger ei) {
        return ei.Abs();
    }

    private T ReturnQuietNaN(T thisValue, EContext ctx) {
        EInteger mant = this.helper.GetMantissa(thisValue);
        boolean mantChanged = false;
        if (!mant.isZero() && ctx != null && ctx.getHasMaxPrecision()) {
            FastInteger compPrecision = FastInteger.FromBig(ctx.getPrecision());
            if (this.helper.CreateShiftAccumulator(mant).GetDigitLength().compareTo(compPrecision) >= 0) {
                EInteger limit = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), compPrecision);
                if (limit == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (mant.compareTo(limit) >= 0) {
                    mant = mant.Remainder(limit);
                    mantChanged = true;
                }
            }
        }
        int flags = this.helper.GetFlags(thisValue);
        if (!mantChanged && (flags & 4) != 0) {
            return thisValue;
        }
        flags &= 1;
        return this.helper.CreateNewWithFlags(mant, EInteger.FromInt64(0L), flags |= 4);
    }

    private boolean Round(IShiftAccumulator accum, ERounding rounding, boolean neg, FastInteger fastint) {
        boolean incremented = false;
        if (rounding == ERounding.HalfEven) {
            int radix = this.thisRadix;
            if (accum.getLastDiscardedDigit() >= radix / 2) {
                incremented = accum.getLastDiscardedDigit() > radix / 2 || accum.getOlderDiscardedDigits() != 0 ? true : (incremented |= !fastint.isEvenNumber());
            }
        } else if (rounding == ERounding.ZeroFiveUp || rounding == ERounding.OddOrZeroFiveUp && this.thisRadix != 2) {
            int radix = this.thisRadix;
            if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                if (radix == 2) {
                    incremented = true;
                } else {
                    int lastDigit = FastInteger.Copy(fastint).Remainder(radix).AsInt32();
                    if (lastDigit == 0 || lastDigit == radix / 2) {
                        incremented = true;
                    }
                }
            }
        } else if (rounding != ERounding.Down) {
            incremented = this.RoundGivenDigits(accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), rounding, neg, EInteger.FromInt64(0L));
        }
        return incremented;
    }

    private boolean RoundGivenBigInt(IShiftAccumulator accum, ERounding rounding, boolean neg, EInteger bigval) {
        return this.RoundGivenDigits(accum.getLastDiscardedDigit(), accum.getOlderDiscardedDigits(), rounding, neg, bigval);
    }

    private boolean RoundGivenDigits(int lastDiscarded, int olderDiscarded, ERounding rounding, boolean neg, EInteger bigval) {
        boolean incremented = false;
        int radix = this.thisRadix;
        if (rounding == ERounding.OddOrZeroFiveUp) {
            ERounding eRounding = rounding = radix == 2 ? ERounding.Odd : ERounding.ZeroFiveUp;
        }
        if (rounding == ERounding.HalfUp) {
            incremented |= lastDiscarded >= radix / 2;
        } else if (rounding == ERounding.HalfEven) {
            if (lastDiscarded >= radix / 2) {
                incremented = lastDiscarded > radix / 2 || olderDiscarded != 0 ? true : (incremented |= !bigval.isEven());
            }
        } else if (rounding == ERounding.Ceiling) {
            incremented |= !neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.Floor) {
            incremented |= neg && (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.HalfDown) {
            incremented |= lastDiscarded > radix / 2 || lastDiscarded == radix / 2 && olderDiscarded != 0;
        } else if (rounding == ERounding.Up) {
            incremented |= (lastDiscarded | olderDiscarded) != 0;
        } else if (rounding == ERounding.Odd) {
            incremented |= (lastDiscarded | olderDiscarded) != 0 && bigval.isEven();
        } else if (rounding == ERounding.ZeroFiveUp && (lastDiscarded | olderDiscarded) != 0) {
            if (radix == 2) {
                incremented = true;
            } else {
                EInteger bigdigit = bigval.Remainder(EInteger.FromInt64(radix));
                int lastDigit = bigdigit.AsInt32Checked();
                if (lastDigit == 0 || lastDigit == radix / 2) {
                    incremented = true;
                }
            }
        }
        return incremented;
    }

    private T RoundToPrecisionInternal(T thisValue, int lastDiscarded, int olderDiscarded, FastInteger shift, boolean adjustNegativeZero, EContext ctx) {
        EInteger bigmantissa;
        boolean unlimitedPrecisionExp = ctx == null || !ctx.getHasMaxPrecision() && !ctx.getHasExponentRange();
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                if (ctx != null && ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x40);
                }
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return thisValue;
            }
        }
        if (unlimitedPrecisionExp && (lastDiscarded | olderDiscarded) == 0 && (shift == null || shift.isValueZero())) {
            return thisValue;
        }
        if (unlimitedPrecisionExp && (ctx == null || !ctx.getHasFlags() && ctx.getTraps() == 0) && (shift == null || shift.isValueZero())) {
            boolean negzero;
            ERounding er = ctx == null ? ERounding.HalfDown : ctx.getRounding();
            boolean negative = (thisFlags & 1) != 0;
            boolean bl = negzero = adjustNegativeZero && negative && this.helper.GetMantissa(thisValue).isZero() && er != ERounding.Floor;
            if (!negzero) {
                if (er == ERounding.Down) {
                    return thisValue;
                }
                if (this.thisRadix == 10 && er == ERounding.HalfEven && lastDiscarded < 5) {
                    return thisValue;
                }
                if (this.thisRadix == 10 && er == ERounding.HalfEven && (lastDiscarded > 5 || olderDiscarded != 0)) {
                    EInteger bm = this.helper.GetMantissa(thisValue);
                    bm = bm.Add(EInteger.FromInt64(1L));
                    return this.helper.CreateNewWithFlags(bm, this.helper.GetExponent(thisValue), thisFlags);
                }
                if (this.thisRadix == 2 && er == ERounding.HalfEven && lastDiscarded == 0) {
                    return thisValue;
                }
                if (!this.RoundGivenDigits(lastDiscarded, olderDiscarded, er, negative, this.helper.GetMantissa(thisValue))) {
                    return thisValue;
                }
                EInteger bm = this.helper.GetMantissa(thisValue);
                bm = bm.Add(EInteger.FromInt64(1L));
                return this.helper.CreateNewWithFlags(bm, this.helper.GetExponent(thisValue), thisFlags);
            }
        }
        ctx = ctx == null ? EContext.Unlimited.WithRounding(ERounding.HalfEven) : ctx;
        boolean binaryPrec = ctx.isPrecisionInBits();
        FastInteger fastPrecision = ctx.getPrecision().CanFitInInt32() ? new FastInteger(ctx.getPrecision().AsInt32Checked()) : FastInteger.FromBig(ctx.getPrecision());
        binaryPrec &= this.thisRadix != 2 && !fastPrecision.isValueZero();
        IShiftAccumulator accum = null;
        FastInteger fastEMin = null;
        FastInteger fastEMax = null;
        if (ctx != null && ctx.getHasExponentRange()) {
            fastEMax = ctx.getEMax().CanFitInInt32() ? new FastInteger(ctx.getEMax().AsInt32Checked()) : FastInteger.FromBig(ctx.getEMax());
            fastEMin = ctx.getEMin().CanFitInInt32() ? new FastInteger(ctx.getEMin().AsInt32Checked()) : FastInteger.FromBig(ctx.getEMin());
        }
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        boolean unlimitedPrec = fastPrecision.isValueZero();
        if (!binaryPrec && fastPrecision.signum() > 0 && (shift == null || shift.isValueZero()) && (thisFlags & 0xE) == 0) {
            FastInteger digitCount;
            EInteger mantabs = this.helper.GetMantissa(thisValue);
            if (adjustNegativeZero && (thisFlags & 1) != 0 && mantabs.isZero() && ctx.getRounding() != ERounding.Floor) {
                thisValue = this.EnsureSign(thisValue, false);
                thisFlags = 0;
            }
            if ((digitCount = (accum = this.helper.CreateShiftAccumulatorWithDigits(mantabs, lastDiscarded, olderDiscarded)).GetDigitLength()).compareTo(fastPrecision) <= 0) {
                if (!this.RoundGivenDigits(lastDiscarded, olderDiscarded, ctx.getRounding(), (thisFlags & 1) != 0, mantabs)) {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    if (!ctx.getHasExponentRange()) {
                        return thisValue;
                    }
                    EInteger bigexp = this.helper.GetExponent(thisValue);
                    FastInteger fastExp = bigexp.CanFitInInt32() ? new FastInteger(bigexp.AsInt32Checked()) : FastInteger.FromBig(bigexp);
                    FastInteger fastAdjustedExp = FastInteger.Copy(fastExp);
                    FastInteger fastNormalMin = FastInteger.Copy(fastEMin);
                    if (ctx == null || ctx.getAdjustExponent()) {
                        fastAdjustedExp.Add(fastPrecision).Decrement();
                        fastNormalMin.Add(fastPrecision).Decrement();
                    }
                    if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                        return thisValue;
                    }
                } else {
                    if (ctx.getHasFlags() && (lastDiscarded | olderDiscarded) != 0) {
                        ctx.setFlags(ctx.getFlags() | 3);
                    }
                    boolean stillWithinPrecision = false;
                    mantabs = mantabs.Add(EInteger.FromInt64(1L));
                    if (digitCount.compareTo(fastPrecision) < 0) {
                        stillWithinPrecision = true;
                    } else {
                        EInteger radixPower = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), fastPrecision);
                        if (radixPower == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        boolean bl = stillWithinPrecision = mantabs.compareTo(radixPower) < 0;
                    }
                    if (stillWithinPrecision) {
                        EInteger bigexp = this.helper.GetExponent(thisValue);
                        if (!ctx.getHasExponentRange()) {
                            return this.helper.CreateNewWithFlags(mantabs, bigexp, thisFlags);
                        }
                        FastInteger fastExp = bigexp.CanFitInInt32() ? new FastInteger(bigexp.AsInt32Checked()) : FastInteger.FromBig(bigexp);
                        FastInteger fastAdjustedExp = FastInteger.Copy(fastExp);
                        FastInteger fastNormalMin = FastInteger.Copy(fastEMin);
                        if (ctx == null || ctx.getAdjustExponent()) {
                            fastAdjustedExp.Add(fastPrecision).Decrement();
                            fastNormalMin.Add(fastPrecision).Decrement();
                        }
                        if (fastAdjustedExp.compareTo(fastEMax) <= 0 && fastAdjustedExp.compareTo(fastNormalMin) >= 0) {
                            return this.helper.CreateNewWithFlags(mantabs, bigexp, thisFlags);
                        }
                    }
                }
            }
        }
        if (adjustNegativeZero && (thisFlags & 1) != 0 && this.helper.GetMantissa(thisValue).isZero() && rounding != ERounding.Floor) {
            thisValue = this.EnsureSign(thisValue, false);
            thisFlags = 0;
        }
        boolean neg = (thisFlags & 1) != 0;
        EInteger oldmantissa = bigmantissa = this.helper.GetMantissa(thisValue);
        boolean mantissaWasZero = oldmantissa.isZero() && (lastDiscarded | olderDiscarded) == 0;
        EInteger maxMantissa = EInteger.FromInt64(1L);
        FastInteger exp = FastInteger.FromBig(this.helper.GetExponent(thisValue));
        int flags = 0;
        IShiftAccumulator iShiftAccumulator = accum = accum == null ? this.helper.CreateShiftAccumulatorWithDigits(bigmantissa, lastDiscarded, olderDiscarded) : accum;
        if (binaryPrec) {
            FastInteger prec = FastInteger.Copy(fastPrecision);
            while (prec.signum() > 0) {
                int bitShift = prec.CompareToInt(1000000) >= 0 ? 1000000 : prec.AsInt32();
                maxMantissa = maxMantissa.ShiftLeft(bitShift);
                prec.SubtractInt(bitShift);
            }
            maxMantissa = maxMantissa.Subtract(EInteger.FromInt64(1L));
            IShiftAccumulator accumMaxMant = this.helper.CreateShiftAccumulator(maxMantissa);
            fastPrecision = accumMaxMant.GetDigitLength();
        }
        if (shift != null && shift.signum() != 0) {
            accum.ShiftRight(shift);
        }
        if (!unlimitedPrec) {
            accum.ShiftToDigits(fastPrecision);
        } else {
            fastPrecision = accum.GetDigitLength();
        }
        if (binaryPrec) {
            while (accum.getShiftedInt().compareTo(maxMantissa) > 0) {
                accum.ShiftRightInt(1);
            }
        }
        FastInteger discardedBits = FastInteger.Copy(accum.getDiscardedDigitCount());
        exp.Add(discardedBits);
        FastInteger adjExponent = FastInteger.Copy(exp);
        if (ctx.getAdjustExponent()) {
            adjExponent = adjExponent.Add(accum.GetDigitLength()).Decrement();
        }
        FastInteger newAdjExponent = adjExponent;
        FastInteger clamp = null;
        EInteger earlyRounded = EInteger.FromInt64(0L);
        if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
            FastInteger expdiff = FastInteger.Copy(fastPrecision).Subtract(accum.GetDigitLength());
            EInteger currMantissa = accum.getShiftedInt();
            if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff)) == null) {
                return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
            }
            if (currMantissa.compareTo(maxMantissa) > 0) {
                adjExponent.Increment();
            }
        }
        if (ctx.getHasFlags() && fastEMin != null && adjExponent.compareTo(fastEMin) < 0 && this.RoundGivenBigInt(accum, rounding, neg, earlyRounded = accum.getShiftedInt())) {
            earlyRounded = earlyRounded.Add(EInteger.FromInt64(1L));
            if (!unlimitedPrec && (earlyRounded.isEven() || (this.thisRadix & 1) != 0)) {
                IShiftAccumulator accum2 = this.helper.CreateShiftAccumulator(earlyRounded);
                FastInteger newDigitLength = accum2.GetDigitLength();
                if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                    newDigitLength = FastInteger.Copy(fastPrecision);
                }
                newAdjExponent = FastInteger.Copy(exp);
                if (ctx.getAdjustExponent()) {
                    newAdjExponent = newAdjExponent.Add(newDigitLength).Decrement();
                }
            }
        }
        if (fastEMax != null && adjExponent.compareTo(fastEMax) > 0) {
            if (mantissaWasZero) {
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | (flags | 0x20));
                }
                if (ctx.getClampNormalExponents()) {
                    if (binaryPrec && this.thisRadix != 2) {
                        fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
                    }
                    FastInteger clampExp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clampExp.Increment().Subtract(fastPrecision);
                    }
                    if (fastEMax.compareTo(clampExp) > 0) {
                        if (ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 0x20);
                        }
                        fastEMax = clampExp;
                    }
                }
                return this.helper.CreateNewWithFlags(oldmantissa, fastEMax.AsBigInteger(), thisFlags);
            }
            flags |= 0x13;
            if (rounding == ERounding.None) {
                return this.SignalInvalidWithMessage(ctx, "Rounding was required");
            }
            if (!unlimitedPrec && (rounding == ERounding.Down || rounding == ERounding.ZeroFiveUp || rounding == ERounding.OddOrZeroFiveUp && this.thisRadix != 2 || rounding == ERounding.Ceiling && neg || rounding == ERounding.Floor && !neg)) {
                EInteger overflowMant = EInteger.FromInt64(0L);
                if (binaryPrec) {
                    overflowMant = maxMantissa;
                } else {
                    overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), fastPrecision);
                    if (overflowMant == null) {
                        return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                    }
                    overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                clamp = FastInteger.Copy(fastEMax);
                if (ctx.getAdjustExponent()) {
                    clamp.Increment().Subtract(fastPrecision);
                }
                return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
            }
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | flags);
            }
            return this.SignalOverflow(neg);
        }
        if (fastEMin != null && adjExponent.compareTo(fastEMin) < 0) {
            FastInteger subExp;
            FastInteger fastETiny = FastInteger.Copy(fastEMin);
            if (ctx.getAdjustExponent()) {
                fastETiny = fastETiny.Subtract(fastPrecision).Increment();
            }
            if (ctx.getHasFlags() && !earlyRounded.isZero() && newAdjExponent.compareTo(fastEMin) < 0) {
                flags |= 4;
            }
            if ((subExp = FastInteger.Copy(exp)).compareTo(fastETiny) < 0) {
                FastInteger expdiff = FastInteger.Copy(fastETiny).Subtract(exp);
                expdiff.Add(discardedBits);
                accum = this.helper.CreateShiftAccumulatorWithDigits(oldmantissa, lastDiscarded, olderDiscarded);
                accum.ShiftRight(expdiff);
                FastInteger newmantissa = accum.getShiftedIntFast();
                if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0 && rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                    if (ctx.getHasFlags()) {
                        if (!mantissaWasZero) {
                            flags |= 2;
                        }
                        if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                            flags |= 3;
                        }
                    }
                    if (this.Round(accum, rounding, neg, newmantissa)) {
                        newmantissa.Increment();
                    }
                }
                if (ctx.getHasFlags()) {
                    if (newmantissa.isValueZero()) {
                        flags |= 0x20;
                    }
                    if ((flags & 5) == 5) {
                        flags |= 0xA;
                    }
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                bigmantissa = newmantissa.AsBigInteger();
                if (ctx.getClampNormalExponents()) {
                    if (binaryPrec && this.thisRadix != 2) {
                        fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
                    }
                    FastInteger clampExp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clampExp.Increment().Subtract(fastPrecision);
                    }
                    if (fastETiny.compareTo(clampExp) > 0) {
                        if (!bigmantissa.isZero() && (bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, expdiff = FastInteger.Copy(fastETiny).Subtract(clampExp))) == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        if (ctx.getHasFlags()) {
                            ctx.setFlags(ctx.getFlags() | 0x20);
                        }
                        fastETiny = clampExp;
                    }
                }
                return this.helper.CreateNewWithFlags(bigmantissa, fastETiny.AsBigInteger(), neg ? 1 : 0);
            }
        }
        boolean recheckOverflow = false;
        if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
            if (!bigmantissa.isZero()) {
                flags |= 2;
            }
            bigmantissa = accum.getShiftedInt();
            if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                flags |= 3;
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
            }
            if (this.RoundGivenBigInt(accum, rounding, neg, bigmantissa)) {
                FastInteger oldDigitLength = accum.GetDigitLength();
                bigmantissa = bigmantissa.Add(EInteger.FromInt64(1L));
                recheckOverflow |= binaryPrec;
                if (!(unlimitedPrec || !bigmantissa.isEven() && (this.thisRadix & 1) == 0 || !binaryPrec && oldDigitLength.compareTo(fastPrecision) < 0)) {
                    accum = this.helper.CreateShiftAccumulator(bigmantissa);
                    FastInteger newDigitLength = accum.GetDigitLength();
                    if (binaryPrec || newDigitLength.compareTo(fastPrecision) > 0) {
                        FastInteger neededShift = FastInteger.Copy(newDigitLength).Subtract(fastPrecision);
                        accum.ShiftRight(neededShift);
                        if (binaryPrec) {
                            while (accum.getShiftedInt().compareTo(maxMantissa) > 0) {
                                accum.ShiftRightInt(1);
                            }
                        }
                        if (accum.getDiscardedDigitCount().signum() != 0) {
                            exp.Add(accum.getDiscardedDigitCount());
                            discardedBits.Add(accum.getDiscardedDigitCount());
                            bigmantissa = accum.getShiftedInt();
                            recheckOverflow |= !binaryPrec;
                        }
                    }
                }
            }
        }
        if (recheckOverflow && fastEMax != null) {
            adjExponent = FastInteger.Copy(exp);
            if (ctx.getAdjustExponent()) {
                adjExponent.Add(accum.GetDigitLength()).Decrement();
            }
            if (binaryPrec && fastEMax != null && adjExponent.compareTo(fastEMax) == 0) {
                FastInteger expdiff = FastInteger.Copy(fastPrecision).Subtract(accum.GetDigitLength());
                EInteger currMantissa = accum.getShiftedInt();
                if ((currMantissa = this.TryMultiplyByRadixPower(currMantissa, expdiff)) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (currMantissa.compareTo(maxMantissa) > 0) {
                    adjExponent.Increment();
                }
            }
            if (adjExponent.compareTo(fastEMax) > 0) {
                flags |= 0x13;
                if (!unlimitedPrec && (rounding == ERounding.Down || rounding == ERounding.ZeroFiveUp || rounding == ERounding.OddOrZeroFiveUp || rounding == ERounding.Odd || rounding == ERounding.Ceiling && neg || rounding == ERounding.Floor && !neg)) {
                    EInteger overflowMant = EInteger.FromInt64(0L);
                    if (binaryPrec) {
                        overflowMant = maxMantissa;
                    } else {
                        overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), fastPrecision);
                        if (overflowMant == null) {
                            return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                        }
                        overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
                    }
                    if (ctx.getHasFlags()) {
                        ctx.setFlags(ctx.getFlags() | flags);
                    }
                    clamp = FastInteger.Copy(fastEMax);
                    if (ctx.getAdjustExponent()) {
                        clamp.Increment().Subtract(fastPrecision);
                    }
                    return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | flags);
                }
                return this.SignalOverflow(neg);
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        if (ctx.getClampNormalExponents()) {
            if (binaryPrec && this.thisRadix != 2) {
                fastPrecision = this.helper.CreateShiftAccumulator(maxMantissa).GetDigitLength();
            }
            FastInteger clampExp = FastInteger.Copy(fastEMax);
            if (ctx.getAdjustExponent()) {
                clampExp.Increment().Subtract(fastPrecision);
            }
            if (exp.compareTo(clampExp) > 0) {
                FastInteger expdiff;
                if (!bigmantissa.isZero() && (bigmantissa = this.TryMultiplyByRadixPower(bigmantissa, expdiff = FastInteger.Copy(exp).Subtract(clampExp))) == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                if (ctx.getHasFlags()) {
                    ctx.setFlags(ctx.getFlags() | 0x20);
                }
                exp = clampExp;
            }
        }
        return this.helper.CreateNewWithFlags(bigmantissa, exp.AsBigInteger(), neg ? 1 : 0);
    }

    private T RoundToScale(EInteger mantissa, EInteger remainder, EInteger divisor, EInteger desiredExponent, FastInteger shift, boolean neg, EContext ctx) {
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!remainder.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfUp || rounding == ERounding.HalfEven) {
                EInteger halfDivisor = divisor.ShiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && divisor.isEven()) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        int flags = 0;
        EInteger newmantissa = mantissa;
        if (shift.isValueZero()) {
            if (lastDiscarded | olderDiscarded) {
                flags |= 3;
                if (rounding == ERounding.None) {
                    return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                }
                if (this.RoundGivenDigits(lastDiscarded, olderDiscarded, rounding, neg, newmantissa)) {
                    newmantissa = newmantissa.Add(EInteger.FromInt64(1L));
                }
            }
        } else {
            IShiftAccumulator accum = this.helper.CreateShiftAccumulatorWithDigits(mantissa, lastDiscarded, olderDiscarded);
            accum.ShiftRight(shift);
            newmantissa = accum.getShiftedInt();
            if (accum.getDiscardedDigitCount().signum() != 0 || (accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                if (!mantissa.isZero()) {
                    flags |= 2;
                }
                if ((accum.getLastDiscardedDigit() | accum.getOlderDiscardedDigits()) != 0) {
                    flags |= 3;
                    if (rounding == ERounding.None) {
                        return this.SignalInvalidWithMessage(ctx, "Rounding was required");
                    }
                }
                if (this.RoundGivenBigInt(accum, rounding, neg, newmantissa)) {
                    newmantissa = newmantissa.Add(EInteger.FromInt64(1L));
                }
            }
        }
        if (ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | flags);
        }
        return this.helper.CreateNewWithFlags(newmantissa, desiredExponent, neg ? 1 : 0);
    }

    private int[] RoundToScaleStatus(EInteger remainder, EInteger divisor, EContext ctx) {
        ERounding rounding = ctx == null ? ERounding.HalfEven : ctx.getRounding();
        int lastDiscarded = 0;
        int olderDiscarded = 0;
        if (!remainder.isZero()) {
            if (rounding == ERounding.HalfDown || rounding == ERounding.HalfUp || rounding == ERounding.HalfEven) {
                EInteger halfDivisor = divisor.ShiftRight(1);
                int cmpHalf = remainder.compareTo(halfDivisor);
                if (cmpHalf == 0 && divisor.isEven()) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 0;
                } else if (cmpHalf > 0) {
                    lastDiscarded = this.thisRadix / 2;
                    olderDiscarded = 1;
                } else {
                    lastDiscarded = 0;
                    olderDiscarded = 1;
                }
            } else {
                if (rounding == ERounding.None) {
                    return null;
                }
                lastDiscarded = 1;
                olderDiscarded = 1;
            }
        }
        return new int[]{lastDiscarded, olderDiscarded};
    }

    private T SignalDivideByZero(EContext ctx, boolean neg) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x80);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Division by zero");
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 2 | (neg ? 1 : 0));
    }

    private T SignalingNaNInvalid(T value, EContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        return this.ReturnQuietNaN(value, ctx);
    }

    private T SignalInvalid(EContext ctx) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException("Invalid operation");
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 4);
    }

    private T SignalInvalidWithMessage(EContext ctx, String str) {
        if (ctx != null && ctx.getHasFlags()) {
            ctx.setFlags(ctx.getFlags() | 0x40);
        }
        if (this.support == 0) {
            throw new ArithmeticException(str);
        }
        return this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), 4);
    }

    private T SignalOverflow(boolean neg) {
        return this.support == 0 ? null : (T)this.helper.CreateNewWithFlags(EInteger.FromInt64(0L), EInteger.FromInt64(0L), (neg ? 1 : 0) | 2);
    }

    private T SignalOverflow2(EContext ctx, boolean neg) {
        if (ctx != null) {
            ERounding roundingOnOverflow = ctx.getRounding();
            if (ctx.getHasFlags()) {
                ctx.setFlags(ctx.getFlags() | 0x13);
            }
            if (ctx.getHasMaxPrecision() && ctx.getHasExponentRange() && (roundingOnOverflow == ERounding.Down || roundingOnOverflow == ERounding.ZeroFiveUp || roundingOnOverflow == ERounding.OddOrZeroFiveUp || roundingOnOverflow == ERounding.Odd || roundingOnOverflow == ERounding.Ceiling && neg || roundingOnOverflow == ERounding.Floor && !neg)) {
                EInteger overflowMant = EInteger.FromInt64(0L);
                FastInteger fastPrecision = FastInteger.FromBig(ctx.getPrecision());
                overflowMant = this.TryMultiplyByRadixPower(EInteger.FromInt64(1L), fastPrecision);
                if (overflowMant == null) {
                    return this.SignalInvalidWithMessage(ctx, "Result requires too much memory");
                }
                overflowMant = overflowMant.Subtract(EInteger.FromInt64(1L));
                FastInteger clamp = FastInteger.FromBig(ctx.getEMax());
                if (ctx.getAdjustExponent()) {
                    clamp.Increment().Subtract(fastPrecision);
                }
                return this.helper.CreateNewWithFlags(overflowMant, clamp.AsBigInteger(), neg ? 1 : 0);
            }
        }
        return this.SignalOverflow(neg);
    }

    private T SquareRootHandleSpecial(T thisValue, EContext ctx) {
        int sign;
        int thisFlags = this.helper.GetFlags(thisValue);
        if ((thisFlags & 0xE) != 0) {
            if ((thisFlags & 8) != 0) {
                return this.SignalingNaNInvalid(thisValue, ctx);
            }
            if ((thisFlags & 4) != 0) {
                return this.ReturnQuietNaN(thisValue, ctx);
            }
            if ((thisFlags & 2) != 0) {
                return (thisFlags & 1) != 0 ? this.SignalInvalid(ctx) : thisValue;
            }
        }
        return (sign = this.helper.GetSign(thisValue)) < 0 ? (T)this.SignalInvalid(ctx) : null;
    }

    private EInteger TryMultiplyByRadixPower(EInteger bi, FastInteger radixPower) {
        if (bi.isZero()) {
            return bi;
        }
        if (!radixPower.CanFitInInt32()) {
            FastInteger fastBI = FastInteger.FromBig(valueMaxDigits);
            if (this.thisRadix != 10 || radixPower.compareTo(fastBI) > 0) {
                return null;
            }
        }
        return this.helper.MultiplyByRadixPower(bi, radixPower);
    }

    private T ValueOf(int value, EContext ctx) {
        return ctx == null || !ctx.getHasExponentRange() || ctx.ExponentWithinRange(EInteger.FromInt64(0L)) ? this.helper.ValueOf(value) : this.RoundToPrecision(this.helper.ValueOf(value), ctx);
    }
}

