/*
 * Decompiled with CFR 0.152.
 */
package com.upokecenter.numbers;

import com.upokecenter.numbers.DecimalUtility;
import com.upokecenter.numbers.EInteger;
import com.upokecenter.numbers.FastInteger;
import com.upokecenter.numbers.IShiftAccumulator;

final class DigitShiftAccumulator
implements IShiftAccumulator {
    private int bitLeftmost;
    private int bitsAfterLeftmost;
    private EInteger shiftedBigInt;
    private FastInteger knownBitLength;
    private int shiftedSmall;
    private boolean isSmall;
    private FastInteger discardedBitCount;
    private static final EInteger ValueTen = EInteger.FromInt64(10L);
    private static final int[] ValueTenPowers = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000};

    public final int getLastDiscardedDigit() {
        return this.bitLeftmost;
    }

    public final int getOlderDiscardedDigits() {
        return this.bitsAfterLeftmost;
    }

    public FastInteger GetDigitLength() {
        this.knownBitLength = this.knownBitLength == null ? this.CalcKnownDigitLength() : this.knownBitLength;
        return FastInteger.Copy(this.knownBitLength);
    }

    public final FastInteger getDiscardedDigitCount() {
        this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
        return this.discardedBitCount;
    }

    public final EInteger getShiftedInt() {
        return this.isSmall ? EInteger.FromInt64(this.shiftedSmall) : this.shiftedBigInt;
    }

    public DigitShiftAccumulator(EInteger bigint, int lastDiscarded, int olderDiscarded) {
        if (bigint.CanFitInInt32()) {
            this.shiftedSmall = bigint.AsInt32Checked();
            if (this.shiftedSmall < 0) {
                throw new IllegalArgumentException("shiftedSmall (" + this.shiftedSmall + ") is less than 0");
            }
            this.isSmall = true;
        } else {
            this.shiftedBigInt = bigint;
            this.isSmall = false;
        }
        this.bitsAfterLeftmost = olderDiscarded != 0 ? 1 : 0;
        this.bitLeftmost = lastDiscarded;
    }

    private static int FastParseLong(String str, int offset, int length) {
        if (length > 9) {
            throw new IllegalArgumentException("length (" + length + ") is more than " + "9 ");
        }
        int ret = 0;
        for (int i = 0; i < length; ++i) {
            int digit = str.charAt(offset + i) - 48;
            ret *= 10;
            ret += digit;
        }
        return ret;
    }

    public final FastInteger getShiftedIntFast() {
        return this.isSmall ? new FastInteger(this.shiftedSmall) : FastInteger.FromBig(this.shiftedBigInt);
    }

    public void ShiftRight(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (fastint.CanFitInInt32()) {
            int fi = fastint.AsInt32();
            if (fi < 0) {
                return;
            }
            this.ShiftRightInt(fi);
        } else {
            if (fastint.signum() <= 0) {
                return;
            }
            EInteger bi = fastint.AsBigInteger();
            while (bi.signum() > 0) {
                int count = 1000000;
                if (bi.compareTo(EInteger.FromInt64(1000000L)) < 0) {
                    count = bi.AsInt32Checked();
                }
                this.ShiftRightInt(count);
                bi = bi.Subtract(EInteger.FromInt64(count));
                if (!(this.isSmall ? this.shiftedSmall == 0 : this.shiftedBigInt.isZero())) continue;
                break;
            }
        }
    }

    public void TruncateRight(FastInteger fastint) {
        if (fastint == null) {
            throw new NullPointerException("fastint");
        }
        if (!this.isSmall) {
            this.ShiftRight(fastint);
        }
        if (fastint.CanFitInInt32()) {
            int fi = fastint.AsInt32();
            if (fi < 0) {
                return;
            }
            this.TruncateRightSmall(fi);
        } else {
            this.ShiftRight(fastint);
        }
    }

    private void ShiftRightBig(int digits) {
        EInteger bigrem;
        if (digits <= 0) {
            return;
        }
        if (this.shiftedBigInt.isZero()) {
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        if (digits == 1) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(EInteger.FromInt64(10L));
            EInteger bigquo = divrem[0];
            EInteger bigrem2 = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem2.AsInt32Checked();
            this.shiftedBigInt = bigquo;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(digits);
            if (this.knownBitLength != null) {
                if (bigquo.isZero()) {
                    this.knownBitLength.SetInt(0);
                } else {
                    this.knownBitLength.Decrement();
                }
            }
            return;
        }
        int startCount = Math.min(4, digits - 1);
        if (startCount > 0) {
            EInteger radixPower = DecimalUtility.FindPowerOfTen(startCount);
            EInteger[] divrem = this.shiftedBigInt.DivRem(radixPower);
            EInteger bigquo = divrem[0];
            bigrem = divrem[1];
            if (!bigrem.isZero()) {
                this.bitsAfterLeftmost |= 1;
            }
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.shiftedBigInt = bigquo;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(startCount);
            digits -= startCount;
            if (this.shiftedBigInt.isZero()) {
                this.isSmall = true;
                this.shiftedSmall = 0;
                this.knownBitLength = new FastInteger(1);
                this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
                this.bitLeftmost = 0;
                return;
            }
        }
        if (digits == 1) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(ValueTen);
            EInteger bigquo = divrem[0];
            bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.AsInt32Checked();
            this.shiftedBigInt = bigquo;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.Increment();
            this.knownBitLength = this.knownBitLength != null ? this.knownBitLength.Decrement() : this.GetDigitLength();
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        FastInteger fastInteger = this.knownBitLength = this.knownBitLength == null ? this.GetDigitLength() : this.knownBitLength;
        if (new FastInteger(digits).Decrement().compareTo(this.knownBitLength) >= 0) {
            this.bitsAfterLeftmost |= this.shiftedBigInt.isZero() ? 0 : 1;
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            return;
        }
        if (this.shiftedBigInt.CanFitInInt32()) {
            this.isSmall = true;
            this.shiftedSmall = this.shiftedBigInt.AsInt32Checked();
            this.ShiftRightSmall(digits);
            return;
        }
        String str = this.shiftedBigInt.toString();
        int digitLength = str.length();
        int bitDiff = 0;
        if (digits > digitLength) {
            bitDiff = digits - digitLength;
        }
        this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
        this.discardedBitCount.AddInt(digits);
        this.bitsAfterLeftmost |= this.bitLeftmost;
        int digitShift = Math.min(digitLength, digits);
        if (digits >= digitLength) {
            this.isSmall = true;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
        } else {
            int newLength = digitLength - digitShift;
            this.knownBitLength = new FastInteger(newLength);
            if (newLength <= 9) {
                this.isSmall = true;
                this.shiftedSmall = DigitShiftAccumulator.FastParseLong(str, 0, newLength);
            } else {
                this.shiftedBigInt = EInteger.FromSubstring(str, 0, newLength);
            }
        }
        for (int i = str.length() - 1; i >= 0; --i) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = str.charAt(i) - 48;
            if (--digitShift <= 0) break;
        }
        int n = this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        if (bitDiff > 0) {
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
        }
    }

    private void ShiftToBitsBig(int digits) {
        if (this.knownBitLength != null && this.knownBitLength.CompareToInt(digits) <= 0) {
            return;
        }
        FastInteger fastInteger = this.knownBitLength = this.knownBitLength == null ? this.GetDigitLength() : this.knownBitLength;
        if (this.knownBitLength.CompareToInt(digits) <= 0) {
            return;
        }
        FastInteger digitDiff = FastInteger.Copy(this.knownBitLength).SubtractInt(digits);
        if (digitDiff.CompareToInt(1) == 0) {
            EInteger[] divrem = this.shiftedBigInt.DivRem(ValueTen);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = bigrem.AsInt32Checked();
            this.shiftedBigInt = bigquo;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        if (digitDiff.CompareToInt(9) <= 0) {
            int diffInt = digitDiff.AsInt32();
            EInteger radixPower = DecimalUtility.FindPowerOfTen(diffInt);
            EInteger[] divrem = this.shiftedBigInt.DivRem(radixPower);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            int rem = bigrem.AsInt32Checked();
            this.bitsAfterLeftmost |= this.bitLeftmost;
            for (int i = 0; i < diffInt; ++i) {
                if (i == diffInt - 1) {
                    this.bitLeftmost = rem % 10;
                    continue;
                }
                this.bitsAfterLeftmost |= rem % 10;
                rem /= 10;
            }
            this.shiftedBigInt = bigquo;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        if (digitDiff.CompareToInt(Integer.MAX_VALUE) <= 0) {
            EInteger radixPower = DecimalUtility.FindPowerOfTen(digitDiff.AsInt32() - 1);
            EInteger[] divrem = this.shiftedBigInt.DivRem(radixPower);
            EInteger bigquo = divrem[0];
            EInteger bigrem = divrem[1];
            this.bitsAfterLeftmost |= this.bitLeftmost;
            if (!bigrem.isZero()) {
                this.bitsAfterLeftmost |= 1;
            }
            EInteger[] divrem2 = bigquo.DivRem(ValueTen);
            EInteger bigquo2 = divrem2[0];
            bigrem = divrem2[1];
            this.bitLeftmost = bigrem.AsInt32Checked();
            this.shiftedBigInt = bigquo2;
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.Add(digitDiff);
            this.knownBitLength.Subtract(digitDiff);
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
            return;
        }
        String str = this.shiftedBigInt.toString();
        int digitLength = str.length();
        this.knownBitLength = new FastInteger(digitLength);
        if (digitLength > digits) {
            int digitShift = digitLength - digits;
            this.knownBitLength.SubtractInt(digitShift);
            int newLength = digitLength - digitShift;
            FastInteger fastInteger2 = this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            if (digitShift <= Integer.MAX_VALUE) {
                this.discardedBitCount.AddInt(digitShift);
            } else {
                this.discardedBitCount.AddBig(EInteger.FromInt64(digitShift));
            }
            for (int i = str.length() - 1; i >= 0; --i) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = str.charAt(i) - 48;
                if (--digitShift <= 0) break;
            }
            if (newLength <= 9) {
                this.isSmall = true;
                this.shiftedSmall = DigitShiftAccumulator.FastParseLong(str, 0, newLength);
            } else {
                this.shiftedBigInt = EInteger.FromSubstring(str, 0, newLength);
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }

    public void ShiftRightInt(int digits) {
        if (this.isSmall) {
            this.ShiftRightSmall(digits);
        } else {
            this.ShiftRightBig(digits);
        }
    }

    private void ShiftRightSmall(int digits) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0) {
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        if (digits >= 2 && digits <= 8) {
            if (this.shiftedSmall >= ValueTenPowers[digits]) {
                int rem2;
                int bigPower = ValueTenPowers[digits];
                int smallPower = ValueTenPowers[digits - 1];
                this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
                this.discardedBitCount.AddInt(digits);
                int div = this.shiftedSmall / bigPower;
                int rem = this.shiftedSmall - div * bigPower;
                this.bitLeftmost = rem2 = rem / smallPower;
                this.bitsAfterLeftmost |= rem - rem2 * smallPower;
                this.shiftedSmall = div;
                this.knownBitLength = div < 10 ? new FastInteger(1) : this.CalcKnownDigitLength();
                return;
            }
            if (this.shiftedSmall >= ValueTenPowers[digits - 1]) {
                int rem2;
                int smallPower = ValueTenPowers[digits - 1];
                if (this.discardedBitCount != null) {
                    this.discardedBitCount.AddInt(digits);
                } else {
                    this.discardedBitCount = new FastInteger(digits);
                }
                int rem = this.shiftedSmall;
                this.bitLeftmost = rem2 = rem / smallPower;
                this.bitsAfterLeftmost |= rem - rem2 * smallPower;
                this.shiftedSmall = 0;
                this.knownBitLength = new FastInteger(1);
                return;
            }
            if (this.discardedBitCount != null) {
                this.discardedBitCount.AddInt(digits);
            } else {
                this.discardedBitCount = new FastInteger(digits);
            }
            int rem = this.shiftedSmall;
            this.bitLeftmost = 0;
            this.bitsAfterLeftmost |= rem;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        int kb = 0;
        for (int tmp = this.shiftedSmall; tmp > 0; tmp /= 10) {
            ++kb;
        }
        if (kb == 0) {
            ++kb;
        }
        this.knownBitLength = new FastInteger(kb);
        if (this.discardedBitCount != null) {
            this.discardedBitCount.AddInt(digits);
        } else {
            this.discardedBitCount = new FastInteger(digits);
        }
        while (digits > 0) {
            if (this.shiftedSmall == 0) {
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = 0;
                this.knownBitLength = new FastInteger(0);
                break;
            }
            int digit = this.shiftedSmall % 10;
            this.bitsAfterLeftmost |= this.bitLeftmost;
            this.bitLeftmost = digit;
            --digits;
            this.shiftedSmall /= 10;
            this.knownBitLength.Decrement();
        }
        this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
    }

    private void TruncateRightSmall(int digits) {
        if (digits <= 0) {
            return;
        }
        if (this.shiftedSmall == 0 || digits >= 11) {
            this.discardedBitCount = this.discardedBitCount == null ? new FastInteger(0) : this.discardedBitCount;
            this.discardedBitCount.AddInt(digits);
            this.bitsAfterLeftmost = 0;
            this.bitLeftmost = 0;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        if (digits >= 1 && digits <= 8) {
            if (this.shiftedSmall >= ValueTenPowers[digits]) {
                int bigPower = ValueTenPowers[digits];
                int smallPower = ValueTenPowers[digits - 1];
                if (this.discardedBitCount != null) {
                    this.discardedBitCount.AddInt(digits);
                } else {
                    this.discardedBitCount = new FastInteger(digits);
                }
                this.shiftedSmall /= bigPower;
                this.bitsAfterLeftmost = 0;
                this.bitLeftmost = 0;
                this.knownBitLength = this.shiftedSmall < 10 ? new FastInteger(1) : this.CalcKnownDigitLength();
                return;
            }
            int smallPower = ValueTenPowers[digits - 1];
            if (this.discardedBitCount != null) {
                this.discardedBitCount.AddInt(digits);
            } else {
                this.discardedBitCount = new FastInteger(digits);
            }
            this.bitLeftmost = 0;
            this.bitsAfterLeftmost = 0;
            this.shiftedSmall = 0;
            this.knownBitLength = new FastInteger(1);
            return;
        }
        this.ShiftRightSmall(digits);
    }

    public void ShiftToDigits(FastInteger bits) {
        if (bits.CanFitInInt32()) {
            int intval = bits.AsInt32();
            if (intval < 0) {
                throw new IllegalArgumentException("intval (" + intval + ") is less than " + "0");
            }
            this.ShiftToDigitsInt(intval);
        } else {
            if (bits.signum() < 0) {
                throw new IllegalArgumentException("bits's sign (" + bits.signum() + ") is less than 0");
            }
            this.knownBitLength = this.CalcKnownDigitLength();
            EInteger bigintDiff = this.knownBitLength.AsBigInteger();
            EInteger bitsBig = bits.AsBigInteger();
            if ((bigintDiff = bigintDiff.Subtract(bitsBig)).signum() > 0) {
                this.ShiftRight(FastInteger.FromBig(bigintDiff));
            }
        }
    }

    public void ShiftToDigitsInt(int digits) {
        if (this.isSmall) {
            this.ShiftToBitsSmall(digits);
        } else {
            this.ShiftToBitsBig(digits);
        }
    }

    private FastInteger CalcKnownDigitLength() {
        if (this.isSmall) {
            int kb = 0;
            int v2 = this.shiftedSmall;
            kb = v2 < 100000 ? (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1)))) : (v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : 6))));
            return new FastInteger(kb);
        }
        return new FastInteger(this.shiftedBigInt.GetDigitCount());
    }

    private void ShiftToBitsSmall(int digits) {
        int kb = 0;
        int v2 = this.shiftedSmall;
        kb = v2 >= 1000000000 ? 10 : (v2 >= 100000000 ? 9 : (v2 >= 10000000 ? 8 : (v2 >= 1000000 ? 7 : (v2 >= 100000 ? 6 : (v2 >= 10000 ? 5 : (v2 >= 1000 ? 4 : (v2 >= 100 ? 3 : (v2 >= 10 ? 2 : 1))))))));
        this.knownBitLength = new FastInteger(kb);
        if (kb > digits) {
            int digitShift = kb - digits;
            int newLength = kb - digitShift;
            this.knownBitLength = new FastInteger(Math.max(1, newLength));
            this.discardedBitCount = this.discardedBitCount != null ? this.discardedBitCount.AddInt(digitShift) : new FastInteger(digitShift);
            for (int i = 0; i < digitShift; ++i) {
                int digit = this.shiftedSmall % 10;
                this.shiftedSmall /= 10;
                this.bitsAfterLeftmost |= this.bitLeftmost;
                this.bitLeftmost = digit;
            }
            this.bitsAfterLeftmost = this.bitsAfterLeftmost != 0 ? 1 : 0;
        }
    }
}

