/*
 * Decompiled with CFR 0.152.
 */
package permissions.dispatcher.processor.util;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.NoSuchElementException;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import permissions.dispatcher.OnNeverAskAgain;
import permissions.dispatcher.processor.PermissionsProcessorKt;
import permissions.dispatcher.processor.ProcessorUnit;
import permissions.dispatcher.processor.RuntimePermissionsElement;
import permissions.dispatcher.processor.exception.DuplicatedMethodNameException;
import permissions.dispatcher.processor.exception.DuplicatedValueException;
import permissions.dispatcher.processor.exception.MixPermissionTypeException;
import permissions.dispatcher.processor.exception.NoAnnotatedMethodsException;
import permissions.dispatcher.processor.exception.NoParametersAllowedException;
import permissions.dispatcher.processor.exception.NoThrowsAllowedException;
import permissions.dispatcher.processor.exception.PrivateMethodException;
import permissions.dispatcher.processor.exception.SpecialPermissionsWithNeverAskAgainException;
import permissions.dispatcher.processor.exception.WrongClassException;
import permissions.dispatcher.processor.exception.WrongParametersException;
import permissions.dispatcher.processor.exception.WrongReturnTypeException;
import permissions.dispatcher.processor.util.ExtensionsKt;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000T\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a,\u0010\b\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a(\u0010\r\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u001a\u0014\u0010\u0012\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u001a,\u0010\u0013\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a4\u0010\u0014\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a,\u0010\u0017\u001a\u00020\u0004\"\b\b\u0000\u0010\t*\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\t0\f\u001a$\u0010\u0018\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00190\f\u001a.\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u001c0\u001b\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\u001b0\u00062\u0006\u0010\u001e\u001a\u00020\u001f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"SYSTEM_ALERT_WINDOW", "", "WRITE_SETTINGS", "checkDuplicatedMethodName", "", "items", "", "Ljavax/lang/model/element/ExecutableElement;", "checkDuplicatedValue", "A", "", "annotationClass", "Ljava/lang/Class;", "checkMethodParameters", "numParams", "", "requiredType", "Ljavax/lang/model/type/TypeMirror;", "checkMethodSignature", "checkMixPermissionType", "checkNotEmpty", "rpe", "Lpermissions/dispatcher/processor/RuntimePermissionsElement;", "checkPrivateMethods", "checkSpecialPermissionsWithNeverAskAgain", "Lpermissions/dispatcher/OnNeverAskAgain;", "findAndValidateProcessorUnit", "Lpermissions/dispatcher/processor/ProcessorUnit;", "K", "units", "element", "Ljavax/lang/model/element/Element;", "processor"})
public final class ValidatorsKt {
    @NotNull
    private static final String WRITE_SETTINGS = "android.permission.WRITE_SETTINGS";
    @NotNull
    private static final String SYSTEM_ALERT_WINDOW = "android.permission.SYSTEM_ALERT_WINDOW";

    @NotNull
    public static final <K> ProcessorUnit<K> findAndValidateProcessorUnit(@NotNull List<? extends ProcessorUnit<? extends K>> units, @NotNull Element element) {
        Intrinsics.checkNotNullParameter(units, (String)"units");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        TypeMirror type = element.asType();
        try {
            Object element$iv2;
            block3: {
                Iterable $this$first$iv = units;
                boolean $i$f$first = false;
                for (Object element$iv2 : $this$first$iv) {
                    ProcessorUnit it = (ProcessorUnit)element$iv2;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
                    if (!ExtensionsKt.isSubtypeOf(type, it.getTargetType())) continue;
                    break block3;
                }
                throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            return (ProcessorUnit)element$iv2;
        }
        catch (NoSuchElementException ex) {
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            throw new WrongClassException(type);
        }
    }

    public static final <A extends Annotation> void checkDuplicatedValue(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        boolean bl = false;
        HashSet<List> allItems = new HashSet<List>();
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl2 = false;
            A a = it.getAnnotation(annotationClass);
            Intrinsics.checkNotNullExpressionValue(a, (String)"it.getAnnotation(annotationClass)");
            List permissionValue = CollectionsKt.sorted((Iterable)ExtensionsKt.permissionValue(a));
            if (allItems.contains(permissionValue)) {
                throw new DuplicatedValueException(permissionValue, it, annotationClass);
            }
            allItems.add(permissionValue);
        }
    }

    public static final <A extends Annotation> void checkNotEmpty(@NotNull List<? extends ExecutableElement> items, @NotNull RuntimePermissionsElement rpe, @NotNull Class<A> annotationClass) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter((Object)rpe, (String)"rpe");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        if (items.isEmpty()) {
            throw new NoAnnotatedMethodsException(rpe, annotationClass);
        }
    }

    public static final <A extends Annotation> void checkPrivateMethods(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl = false;
            if (!it.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
            throw new PrivateMethodException(it, annotationClass);
        }
    }

    public static final void checkMethodSignature(@NotNull List<? extends ExecutableElement> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl = false;
            if (it.getReturnType().getKind() != TypeKind.VOID) {
                throw new WrongReturnTypeException(it);
            }
            Collection<TypeMirror> collection = it.getThrownTypes();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"it.thrownTypes");
            collection = collection;
            boolean bl2 = false;
            if (!(!collection.isEmpty())) continue;
            throw new NoThrowsAllowedException(it);
        }
    }

    public static final void checkMethodParameters(@NotNull List<? extends ExecutableElement> items, int numParams, @Nullable TypeMirror requiredType) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl = false;
            List<? extends VariableElement> params = it.getParameters();
            if (numParams == 0) {
                Intrinsics.checkNotNullExpressionValue(params, (String)"params");
                Collection collection = params;
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    throw new NoParametersAllowedException(it);
                }
            }
            if (requiredType == null) {
                return;
            }
            if (numParams < params.size()) {
                throw new WrongParametersException(it, numParams, requiredType);
            }
            Intrinsics.checkNotNullExpressionValue(params, (String)"params");
            Iterable $this$forEach$iv2 = params;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                VariableElement param = (VariableElement)element$iv2;
                boolean bl3 = false;
                if (PermissionsProcessorKt.getTYPE_UTILS().isSameType(param.asType(), requiredType)) continue;
                throw new WrongParametersException(it, numParams, requiredType);
            }
        }
    }

    public static /* synthetic */ void checkMethodParameters$default(List list, int n, TypeMirror typeMirror, int n2, Object object) {
        if ((n2 & 4) != 0) {
            typeMirror = null;
        }
        ValidatorsKt.checkMethodParameters(list, n, typeMirror);
    }

    public static final <A extends Annotation> void checkMixPermissionType(@NotNull List<? extends ExecutableElement> items, @NotNull Class<A> annotationClass) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl = false;
            A a = it.getAnnotation(annotationClass);
            Intrinsics.checkNotNullExpressionValue(a, (String)"it.getAnnotation(annotationClass)");
            List<String> permissionValue = ExtensionsKt.permissionValue(a);
            if (permissionValue.size() <= 1) continue;
            if (permissionValue.contains(WRITE_SETTINGS)) {
                throw new MixPermissionTypeException(it, WRITE_SETTINGS);
            }
            if (!permissionValue.contains(SYSTEM_ALERT_WINDOW)) continue;
            throw new MixPermissionTypeException(it, SYSTEM_ALERT_WINDOW);
        }
    }

    public static final void checkSpecialPermissionsWithNeverAskAgain(@NotNull List<? extends ExecutableElement> items, @NotNull Class<OnNeverAskAgain> annotationClass) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Intrinsics.checkNotNullParameter(annotationClass, (String)"annotationClass");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ExecutableElement it = (ExecutableElement)element$iv;
            boolean bl = false;
            OnNeverAskAgain onNeverAskAgain = it.getAnnotation(annotationClass);
            Intrinsics.checkNotNullExpressionValue((Object)onNeverAskAgain, (String)"it.getAnnotation(annotationClass)");
            List<String> permissionValue = ExtensionsKt.permissionValue((Annotation)onNeverAskAgain);
            if (!permissionValue.contains(WRITE_SETTINGS) && !permissionValue.contains(SYSTEM_ALERT_WINDOW)) continue;
            throw new SpecialPermissionsWithNeverAskAgainException();
        }
    }

    public static /* synthetic */ void checkSpecialPermissionsWithNeverAskAgain$default(List list, Class clazz, int n, Object object) {
        if ((n & 2) != 0) {
            clazz = OnNeverAskAgain.class;
        }
        ValidatorsKt.checkSpecialPermissionsWithNeverAskAgain(list, clazz);
    }

    public static final void checkDuplicatedMethodName(@NotNull List<? extends ExecutableElement> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        Iterable $this$forEach$iv = items;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object v0;
            ExecutableElement item;
            block2: {
                item = (ExecutableElement)element$iv;
                boolean bl = false;
                Iterable $this$firstOrNull$iv = items;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv) {
                    ExecutableElement it = (ExecutableElement)element$iv2;
                    boolean bl2 = false;
                    if (!(!Intrinsics.areEqual((Object)it, (Object)item) && Intrinsics.areEqual((Object)it.getSimpleName(), (Object)item.getSimpleName()))) continue;
                    v0 = element$iv2;
                    break block2;
                }
                v0 = null;
            }
            ExecutableElement executableElement = v0;
            if (executableElement == null) continue;
            ExecutableElement executableElement2 = executableElement;
            boolean bl = false;
            boolean bl3 = false;
            ExecutableElement it = executableElement2;
            boolean bl4 = false;
            throw new DuplicatedMethodNameException(item);
        }
    }
}

