/*
 * Decompiled with CFR 0.152.
 */
package com.pepperonas.materialdialog.adapter;

import android.content.Context;
import android.graphics.Typeface;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.pepperonas.materialdialog.MaterialDialog;
import com.pepperonas.materialdialog.R;
import com.pepperonas.materialdialog.model.SelectionModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CustomMultipleSelectionArrayAdapter
extends ArrayAdapter<String> {
    private static final String TAG = "MultiSelectionAdapter";
    private LayoutInflater mInflater;
    private CharSequence[] mStrings;
    private List<SelectionModel> mSelectionList = new ArrayList<SelectionModel>();
    private MaterialDialog.ItemClickListener mItemClickListener;
    private MaterialDialog.ItemLongClickListener mItemLongClickListener;
    private Typeface mTypeface;

    public CustomMultipleSelectionArrayAdapter(Context context, String[] strings, Integer[] selectedPositions, MaterialDialog.ItemClickListener itemClickListener, MaterialDialog.ItemLongClickListener itemLongClickListener, Typeface typeface) {
        super(context, R.layout.custom_list_item_multiple_selection, (Object[])strings);
        this.init(context, strings, selectedPositions, itemClickListener, typeface);
    }

    private void init(Context context, String[] strings, Integer[] selectedPositions, MaterialDialog.ItemClickListener itemClickListener, Typeface typeface) {
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mStrings = strings;
        List<Integer> selected = Arrays.asList(selectedPositions);
        for (int i = 0; i < strings.length; ++i) {
            this.mSelectionList.add(new SelectionModel(i, selected.contains(i)));
        }
        for (SelectionModel sm : this.mSelectionList) {
            Log.i((String)TAG, (String)("init " + sm.getPosition() + " == " + sm.isChecked()));
        }
        this.mItemClickListener = itemClickListener;
        this.mTypeface = typeface;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder viewHolder;
        View row = convertView;
        if (row == null) {
            row = this.mInflater.inflate(R.layout.custom_list_item_multiple_selection, parent, false);
            LinearLayout linearLayout = (LinearLayout)row.findViewById(R.id.ll_simple_list_item_multiple_selection);
            CheckBox cbx = (CheckBox)row.findViewById(R.id.cbx_simple_list_item_multiple_selection);
            TextView tv = (TextView)row.findViewById(R.id.tv_simple_list_item_multiple_selection);
            if (this.mTypeface != null) {
                cbx.setTypeface(this.mTypeface);
                tv.setTypeface(this.mTypeface);
            }
            viewHolder = new ViewHolder();
            viewHolder.linearLayout = linearLayout;
            viewHolder.cbx = cbx;
            viewHolder.tv = tv;
            row.setTag((Object)viewHolder);
        } else {
            viewHolder = (ViewHolder)row.getTag();
        }
        final View finalRow = row;
        viewHolder.cbx.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                ((SelectionModel)CustomMultipleSelectionArrayAdapter.this.mSelectionList.get(position)).setChecked(isChecked);
                if (CustomMultipleSelectionArrayAdapter.this.mItemClickListener != null) {
                    CustomMultipleSelectionArrayAdapter.this.mItemClickListener.onClick(finalRow, position, finalRow.getId());
                }
                if (CustomMultipleSelectionArrayAdapter.this.mItemLongClickListener != null) {
                    CustomMultipleSelectionArrayAdapter.this.mItemLongClickListener.onLongClick(finalRow, position, finalRow.getId());
                }
            }
        });
        viewHolder.linearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                viewHolder.cbx.setChecked(!((SelectionModel)CustomMultipleSelectionArrayAdapter.this.mSelectionList.get(position)).isChecked());
                CustomMultipleSelectionArrayAdapter.this.notifyDataSetChanged();
            }
        });
        viewHolder.tv.setText(this.mStrings[position]);
        viewHolder.cbx.setTag((Object)position);
        viewHolder.tv.setTag((Object)position);
        viewHolder.cbx.setChecked(this.mSelectionList.get(position).isChecked());
        return row;
    }

    static class ViewHolder {
        LinearLayout linearLayout;
        CheckBox cbx;
        TextView tv;

        ViewHolder() {
        }
    }
}

