/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import com.github.pengrad.mapscaleview.Scale;

class MapScaleModel {
    private static final double TILE_SIZE_METERS_AT_0_ZOOM = 156543.03;
    private static final double TILE_SIZE_FT_AT_0_ZOOM = 513592.62;
    private static final int FT_IN_MILE = 5280;
    private static final float[] METERS = new float[]{0.2f, 0.5f, 1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 50.0f, 100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5000.0f, 10000.0f, 20000.0f, 50000.0f, 100000.0f, 200000.0f, 500000.0f, 1000000.0f, 2000000.0f};
    private static final float[] FT = new float[]{1.0f, 2.0f, 5.0f, 10.0f, 20.0f, 50.0f, 100.0f, 200.0f, 500.0f, 1000.0f, 2000.0f, 5280.0f, 10560.0f, 26400.0f, 52800.0f, 105600.0f, 264000.0f, 528000.0f, 1056000.0f, 2640000.0f, 5280000.0f, 1.056E7f};
    private final float density;
    private int maxWidth;
    private float lastZoom = -1.0f;
    private double lastLatitude = -100.0;

    MapScaleModel(float density) {
        this.density = density;
    }

    boolean updateMaxWidth(int width) {
        if (this.maxWidth != width) {
            this.maxWidth = width;
            return true;
        }
        return false;
    }

    void setPosition(float zoom, double latitude) {
        this.lastZoom = zoom;
        this.lastLatitude = latitude;
    }

    Scale update(boolean meters) {
        float zoom = this.lastZoom;
        double latitude = this.lastLatitude;
        if (zoom < 0.0f || Math.abs(latitude) > 90.0) {
            return null;
        }
        double tileSizeAtZoom0 = meters ? 156543.03 : 513592.62;
        float[] distances = meters ? METERS : FT;
        double resolution = tileSizeAtZoom0 / (double)this.density * Math.cos(latitude * Math.PI / 180.0) / Math.pow(2.0, zoom);
        float distance = 0.0f;
        int distanceIndex = distances.length;
        double screenDistance = this.maxWidth + 1;
        while (screenDistance > (double)this.maxWidth && distanceIndex > 0) {
            distance = distances[--distanceIndex];
            screenDistance = Math.abs((double)distance / resolution);
        }
        this.lastZoom = zoom;
        this.lastLatitude = latitude;
        return new Scale(this.text(distance, meters), (float)screenDistance);
    }

    private String text(float distance, boolean meters) {
        if (meters) {
            if (distance < 1.0f) {
                return (int)(distance * 100.0f) + " cm";
            }
            if (distance < 1000.0f) {
                return (int)distance + " m";
            }
            return (int)distance / 1000 + " km";
        }
        if (distance < 5280.0f) {
            return (int)distance + " ft";
        }
        return (int)distance / 5280 + " mi";
    }
}

