/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import com.github.pengrad.mapscaleview.Scale;
import com.github.pengrad.mapscaleview.Scales;

public class Drawer {
    private final Paint textPaint = new Paint();
    private final Paint strokePaint = new Paint();
    private final Path strokePath = new Path();
    private final Paint outlinePaint = new Paint();
    private final Path outlineDiffPath = new Path();
    private float outlineStrokeWidth = 2.0f;
    private float outlineStrokeDiff = this.outlineStrokeWidth / 2.0f / 2.0f;
    private float outlineTextStrokeWidth = 3.0f;
    private boolean outlineEnabled = true;
    private float textHeight;
    private float horizontalLineY;

    Drawer(int color, float textSize, float strokeWidth, float density, boolean outlineEnabled) {
        this.textPaint.setAntiAlias(true);
        this.textPaint.setColor(color);
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTextSize(textSize);
        this.strokePaint.setAntiAlias(true);
        this.strokePaint.setColor(color);
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.outlinePaint.set(this.strokePaint);
        this.outlinePaint.setARGB(255, 255, 255, 255);
        this.outlineStrokeWidth = strokeWidth * 2.0f;
        this.outlineStrokeDiff = strokeWidth / 2.0f;
        this.outlineTextStrokeWidth = density * 2.0f;
        this.outlineEnabled = outlineEnabled;
        this.update();
    }

    void update() {
        this.outlinePaint.setTextSize(this.textPaint.getTextSize());
        this.outlinePaint.setStrokeWidth(this.outlineTextStrokeWidth);
        Rect textRect = new Rect();
        if (this.outlineEnabled) {
            this.outlinePaint.getTextBounds("A", 0, 1, textRect);
        } else {
            this.textPaint.getTextBounds("A", 0, 1, textRect);
        }
        this.textHeight = textRect.height();
        this.horizontalLineY = this.textHeight + this.textHeight / 2.0f;
    }

    int getHeight() {
        return (int)(this.textPaint.getTextSize() * 3.0f + this.textPaint.getStrokeWidth());
    }

    void setColor(int color) {
        this.textPaint.setColor(color);
        this.strokePaint.setColor(color);
    }

    void setTextSize(float textSize) {
        this.textPaint.setTextSize(textSize);
        this.update();
    }

    void setStrokeWidth(float strokeWidth) {
        this.strokePaint.setStrokeWidth(strokeWidth);
        this.outlineStrokeWidth = strokeWidth * 2.0f;
        this.outlineStrokeDiff = strokeWidth / 2.0f;
        this.update();
    }

    void setOutlineEnabled(boolean enabled) {
        this.outlineEnabled = enabled;
        this.update();
    }

    void draw(Canvas canvas, Scales scales) {
        if (scales == null || scales.top() == null) {
            return;
        }
        Scale top = scales.top();
        if (this.outlineEnabled) {
            this.outlinePaint.setStrokeWidth(this.outlineTextStrokeWidth);
            canvas.drawText(top.text(), 0.0f, this.textHeight, this.outlinePaint);
        }
        canvas.drawText(top.text(), 0.0f, this.textHeight, this.textPaint);
        this.strokePath.rewind();
        this.strokePath.moveTo(this.outlineStrokeDiff, this.horizontalLineY);
        this.strokePath.lineTo(top.length(), this.horizontalLineY);
        if (this.outlineEnabled) {
            this.strokePath.lineTo(top.length(), this.textHeight + this.outlineStrokeDiff);
        } else {
            this.strokePath.lineTo(top.length(), this.textHeight);
        }
        Scale bottom = scales.bottom();
        if (bottom != null) {
            if (bottom.length() > top.length()) {
                this.strokePath.moveTo(top.length(), this.horizontalLineY);
                this.strokePath.lineTo(bottom.length(), this.horizontalLineY);
            } else {
                this.strokePath.moveTo(bottom.length(), this.horizontalLineY);
            }
            this.strokePath.lineTo(bottom.length(), this.textHeight * 2.0f);
            float bottomTextY = this.horizontalLineY + this.textHeight + this.textHeight / 2.0f;
            if (this.outlineEnabled) {
                canvas.drawText(bottom.text(), 0.0f, bottomTextY, this.outlinePaint);
            }
            canvas.drawText(bottom.text(), 0.0f, bottomTextY, this.textPaint);
        }
        if (this.outlineEnabled) {
            this.outlinePaint.setStrokeWidth(this.outlineStrokeWidth);
            this.outlineDiffPath.rewind();
            this.outlineDiffPath.moveTo(0.0f, this.horizontalLineY);
            this.outlineDiffPath.lineTo(this.outlineStrokeDiff, this.horizontalLineY);
            this.outlineDiffPath.moveTo(top.length(), this.textHeight + this.outlineStrokeDiff);
            this.outlineDiffPath.lineTo(top.length(), this.textHeight);
            if (bottom != null) {
                this.outlineDiffPath.moveTo(bottom.length(), this.textHeight * 2.0f);
                this.outlineDiffPath.lineTo(bottom.length(), this.textHeight * 2.0f + this.outlineStrokeDiff);
            }
            canvas.drawPath(this.outlineDiffPath, this.outlinePaint);
            canvas.drawPath(this.strokePath, this.outlinePaint);
        }
        canvas.drawPath(this.strokePath, this.strokePaint);
    }
}

