/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import com.github.pengrad.mapscaleview.Scale;

class MapScaleModel {
    private static final double TILE_SIZE_METERS_AT_0_ZOOM = 156543.03;
    private static final double TILE_SIZE_FT_AT_0_ZOOM = 513592.62;
    private static final int FT_IN_MILE = 5280;
    private static final int[] METERS = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000};
    private static final int[] FT = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5280, 10560, 26400, 52800, 105600, 264000, 528000, 0x101D00, 2640000, 5280000, 10560000};
    private final float density;
    private int maxWidth;
    private float lastZoom = -1.0f;
    private double lastLatitude = -100.0;

    MapScaleModel(float density) {
        this.density = density;
    }

    void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    void setPosition(float zoom, double latitude) {
        this.lastZoom = zoom;
        this.lastLatitude = latitude;
    }

    Scale update(boolean meters) {
        float zoom = this.lastZoom;
        double latitude = this.lastLatitude;
        if (zoom < 0.0f || Math.abs(latitude) > 90.0) {
            return null;
        }
        double tileSizeAtZoom0 = meters ? 156543.03 : 513592.62;
        int[] distances = meters ? METERS : FT;
        double resolution = tileSizeAtZoom0 / (double)this.density * Math.cos(latitude * Math.PI / 180.0) / Math.pow(2.0, zoom);
        int distance = 0;
        int distanceIndex = distances.length;
        double screenDistance = this.maxWidth + 1;
        while (screenDistance > (double)this.maxWidth && distanceIndex > 0) {
            distance = distances[--distanceIndex];
            screenDistance = Math.abs((double)distance / resolution);
        }
        this.lastZoom = zoom;
        this.lastLatitude = latitude;
        return new Scale(this.text(distance, meters), (float)screenDistance);
    }

    private String text(int distance, boolean meters) {
        if (meters) {
            if (distance < 1000) {
                return distance + " m";
            }
            return distance / 1000 + " km";
        }
        if (distance < 5280) {
            return distance + " ft";
        }
        return distance / 5280 + " mi";
    }
}

