/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.support.annotation.ColorInt;
import android.util.AttributeSet;
import android.view.View;
import com.github.pengrad.mapscaleview.MapScaleModel;
import com.github.pengrad.mapscaleview.Scale;
import com.github.pengrad.mapscaleview.ViewConfig;

public class MapScaleView
extends View {
    private final Paint paint;
    private final ViewConfig viewConfig;
    private final MapScaleModel mapScaleModel;
    private float textHeight;
    private float strokeWidth;
    private float horizontalLineY;
    private Scale scale;

    public MapScaleView(Context context) {
        this(context, null);
    }

    public MapScaleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapScaleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.viewConfig = new ViewConfig(context, attrs);
        this.mapScaleModel = new MapScaleModel();
        this.mapScaleModel.setIsMiles(this.viewConfig.isMiles);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(this.viewConfig.textSize);
        this.paint.setColor(this.viewConfig.color);
        this.paint.setStrokeWidth(this.viewConfig.strokeWidth);
        this.strokeWidth = this.viewConfig.strokeWidth;
        this.updateTextHeight();
    }

    private void updateTextHeight() {
        Rect textRect = new Rect();
        this.paint.getTextBounds("A", 0, 1, textRect);
        this.textHeight = textRect.height();
        this.horizontalLineY = this.textHeight + this.textHeight / 2.0f;
    }

    public void setColor(@ColorInt int color) {
        this.paint.setColor(color);
        this.invalidate();
    }

    public void setTextSize(float textSize) {
        this.paint.setTextSize(textSize);
        this.updateTextHeight();
        this.invalidate();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.paint.setStrokeWidth(strokeWidth);
        this.invalidate();
    }

    public void setIsMiles(boolean miles) {
        this.scale = this.mapScaleModel.setIsMiles(miles);
        this.invalidate();
    }

    public void update(float zoom, double latitude) {
        this.scale = this.mapScaleModel.update(zoom, latitude);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.desiredWidth(), widthMeasureSpec);
        int height = this.measureDimension(this.desiredHeight(), heightMeasureSpec);
        this.scale = this.mapScaleModel.setMaxWidth(width);
        this.setMeasuredDimension(width, height);
    }

    private int desiredWidth() {
        return this.viewConfig.desiredWidth;
    }

    private int desiredHeight() {
        return (int)((double)this.paint.getTextSize() * 1.5 + (double)this.paint.getStrokeWidth());
    }

    private int measureDimension(int desiredSize, int measureSpec) {
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            return size;
        }
        if (mode == Integer.MIN_VALUE) {
            return Math.min(desiredSize, size);
        }
        return desiredSize;
    }

    public void onDraw(Canvas canvas) {
        if (this.scale == null) {
            return;
        }
        String text = this.scale.text();
        float lineLength = this.scale.length();
        canvas.drawText(text, 0.0f, this.textHeight, this.paint);
        float verticalLineX = lineLength - this.strokeWidth / 2.0f;
        canvas.drawLine(0.0f, this.horizontalLineY, lineLength, this.horizontalLineY, this.paint);
        canvas.drawLine(verticalLineX, this.horizontalLineY, verticalLineX, this.textHeight, this.paint);
    }
}

