/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import com.github.pengrad.mapscaleview.Scale;

class MapScaleModel {
    private static final double TILE_SIZE_METERS_AT_0_ZOOM = 156543.03;
    private static final double TILE_SIZE_FT_AT_0_ZOOM = 513592.62;
    private static final int FT_IN_MILE = 5280;
    private static final int[] METERS = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000};
    private static final int[] FT = new int[]{1, 2, 5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5280, 10560, 26400, 52800, 105600, 264000, 528000, 0x101D00, 2640000, 5280000, 10560000};
    private int maxWidth;
    private boolean isMiles = false;
    private int[] distances = METERS;
    private double tileSizeAtZoom0 = 156543.03;
    private float lastZoom = -1.0f;
    private double lastLatitude = -1.0;

    MapScaleModel() {
    }

    Scale setMaxWidth(int width) {
        this.maxWidth = width;
        return this.update(this.lastZoom, this.lastLatitude);
    }

    Scale setIsMiles(boolean miles) {
        this.isMiles = miles;
        if (miles) {
            this.tileSizeAtZoom0 = 513592.62;
            this.distances = FT;
        } else {
            this.tileSizeAtZoom0 = 156543.03;
            this.distances = METERS;
        }
        return this.update(this.lastZoom, this.lastLatitude);
    }

    Scale update(float zoom, double latitude) {
        if (zoom < 0.0f || latitude < 0.0) {
            return null;
        }
        double resolution = this.tileSizeAtZoom0 * Math.cos(latitude * Math.PI / 180.0) / Math.pow(2.0, zoom);
        int distance = 0;
        int distanceIndex = this.distances.length;
        double screenDistance = this.maxWidth + 1;
        while (screenDistance > (double)this.maxWidth && distanceIndex > 0) {
            distance = this.distances[--distanceIndex];
            screenDistance = Math.abs((double)distance / resolution);
        }
        this.lastZoom = zoom;
        this.lastLatitude = latitude;
        return new Scale(this.text(distance), (float)screenDistance);
    }

    private String text(int distance) {
        if (this.isMiles) {
            if (distance < 5280) {
                return distance + " ft";
            }
            return distance / 5280 + " mi";
        }
        if (distance < 1000) {
            return distance + " m";
        }
        return distance / 1000 + " km";
    }
}

