/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import com.github.pengrad.mapscaleview.MapScaleModel;
import com.github.pengrad.mapscaleview.Scale;
import com.github.pengrad.mapscaleview.ViewConfig;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.model.CameraPosition;

public class MapScaleView
extends View {
    private final Paint paint;
    private final ViewConfig viewConfig;
    private final MapScaleModel mapScaleModel = new MapScaleModel();
    private final float textHeight;
    private final float strokeWidth;
    private final float horizontalLineY;
    private Scale scale;

    public MapScaleView(Context context) {
        this(context, null);
    }

    public MapScaleView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MapScaleView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.viewConfig = new ViewConfig(context, attrs);
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        this.paint.setTextSize(this.viewConfig.textSize);
        this.paint.setStrokeWidth(this.viewConfig.strokeWidth);
        this.paint.setColor(this.viewConfig.color);
        this.strokeWidth = this.viewConfig.strokeWidth;
        Rect textRect = new Rect();
        this.paint.getTextBounds("A", 0, 1, textRect);
        this.textHeight = textRect.height();
        this.horizontalLineY = this.textHeight + this.textHeight / 2.0f;
    }

    public void update(Projection projection, CameraPosition cameraPosition) {
        this.scale = this.mapScaleModel.setProjection(projection, cameraPosition);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.measureDimension(this.desiredWidth(), widthMeasureSpec);
        int height = this.measureDimension(this.desiredHeight(), heightMeasureSpec);
        this.mapScaleModel.setMaxWidth(width);
        this.setMeasuredDimension(width, height);
    }

    private int desiredWidth() {
        return this.viewConfig.desiredWidth;
    }

    private int desiredHeight() {
        return (int)((double)this.paint.getTextSize() * 1.5 + (double)this.paint.getStrokeWidth());
    }

    private int measureDimension(int desiredSize, int measureSpec) {
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        if (mode == 0x40000000) {
            return size;
        }
        if (mode == Integer.MIN_VALUE) {
            return Math.min(desiredSize, size);
        }
        return desiredSize;
    }

    public void onDraw(Canvas canvas) {
        canvas.save();
        this.drawView(canvas, this.paint);
        canvas.restore();
    }

    private void drawView(Canvas canvas, Paint paint) {
        if (this.scale == null) {
            return;
        }
        float lineLength = this.scale.length();
        String text = this.scale.text();
        canvas.drawText(text, 0.0f, this.textHeight, paint);
        float verticalLineX = lineLength - this.strokeWidth / 2.0f;
        canvas.drawLine(0.0f, this.horizontalLineY, lineLength, this.horizontalLineY, paint);
        canvas.drawLine(verticalLineX, this.horizontalLineY, verticalLineX, this.textHeight, paint);
    }
}

