/*
 * Decompiled with CFR 0.152.
 */
package com.github.pengrad.mapscaleview;

import android.graphics.Point;
import com.github.pengrad.mapscaleview.DistanceUtils;
import com.github.pengrad.mapscaleview.Scale;
import com.google.android.gms.maps.Projection;
import com.google.android.gms.maps.model.CameraPosition;
import com.google.android.gms.maps.model.LatLng;

class MapScaleModel {
    private final int[] meters = new int[]{5, 10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, 20000, 50000, 100000, 200000, 500000, 1000000, 2000000};
    private final LatLng src = new LatLng(23.0, 105.0);
    private int maxWidth;
    private float zoom = -1.0f;
    private Scale scale;

    MapScaleModel() {
    }

    void setMaxWidth(int width) {
        this.maxWidth = width;
    }

    Scale setProjection(Projection projection, CameraPosition cameraPosition) {
        if (this.zoom == cameraPosition.zoom) {
            return this.scale;
        }
        int distance = 0;
        int distanceIndex = this.meters.length;
        double screenDistance = this.maxWidth + 1;
        while (screenDistance > (double)this.maxWidth && distanceIndex > 0) {
            distance = this.meters[--distanceIndex];
            LatLng dest = DistanceUtils.translatePoint(this.src, distance, 120.0);
            Point pointSrc = projection.toScreenLocation(this.src);
            Point pointDest = projection.toScreenLocation(dest);
            screenDistance = Math.sqrt(Math.pow(pointSrc.x - pointDest.x, 2.0) + Math.pow(pointSrc.y - pointDest.y, 2.0));
        }
        this.zoom = cameraPosition.zoom;
        this.scale = new Scale(this.text(distance), (float)screenDistance);
        return this.scale;
    }

    private String text(int distance) {
        if (distance < 1000) {
            return distance + " m";
        }
        return distance / 1000 + " km";
    }
}

