/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.glide;

import android.graphics.drawable.Drawable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.Options;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.resource.drawable.DrawableResource;
import com.bumptech.glide.load.resource.transcode.ResourceTranscoder;
import com.github.penfeizhou.animation.apng.APNGDrawable;
import com.github.penfeizhou.animation.apng.decode.APNGDecoder;
import com.github.penfeizhou.animation.avif.AVIFDrawable;
import com.github.penfeizhou.animation.avif.decode.AVIFDecoder;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.gif.GifDrawable;
import com.github.penfeizhou.animation.gif.decode.GifDecoder;
import com.github.penfeizhou.animation.glide.AnimationDecoderOption;
import com.github.penfeizhou.animation.webp.WebPDrawable;
import com.github.penfeizhou.animation.webp.decode.WebPDecoder;

class FrameDrawableTranscoder
implements ResourceTranscoder<FrameSeqDecoder, Drawable> {
    FrameDrawableTranscoder() {
    }

    @Nullable
    public Resource<Drawable> transcode(@NonNull Resource<FrameSeqDecoder> toTranscode, @NonNull Options options) {
        FrameSeqDecoder frameSeqDecoder = (FrameSeqDecoder)toTranscode.get();
        boolean noMeasure = (Boolean)options.get(AnimationDecoderOption.NO_ANIMATION_BOUNDS_MEASURE);
        if (frameSeqDecoder instanceof APNGDecoder) {
            final APNGDrawable apngDrawable = new APNGDrawable((APNGDecoder)frameSeqDecoder);
            apngDrawable.setAutoPlay(false);
            apngDrawable.setNoMeasure(noMeasure);
            return new DrawableResource<Drawable>((Drawable)apngDrawable){

                @NonNull
                public Class<Drawable> getResourceClass() {
                    return Drawable.class;
                }

                public int getSize() {
                    return apngDrawable.getMemorySize();
                }

                public void recycle() {
                    apngDrawable.stop();
                }

                public void initialize() {
                    super.initialize();
                }
            };
        }
        if (frameSeqDecoder instanceof WebPDecoder) {
            final WebPDrawable webPDrawable = new WebPDrawable((WebPDecoder)frameSeqDecoder);
            webPDrawable.setAutoPlay(false);
            webPDrawable.setNoMeasure(noMeasure);
            return new DrawableResource<Drawable>((Drawable)webPDrawable){

                @NonNull
                public Class<Drawable> getResourceClass() {
                    return Drawable.class;
                }

                public int getSize() {
                    return webPDrawable.getMemorySize();
                }

                public void recycle() {
                    webPDrawable.stop();
                }

                public void initialize() {
                    super.initialize();
                }
            };
        }
        if (frameSeqDecoder instanceof GifDecoder) {
            final GifDrawable gifDrawable = new GifDrawable((GifDecoder)frameSeqDecoder);
            gifDrawable.setAutoPlay(false);
            gifDrawable.setNoMeasure(noMeasure);
            return new DrawableResource<Drawable>((Drawable)gifDrawable){

                @NonNull
                public Class<Drawable> getResourceClass() {
                    return Drawable.class;
                }

                public int getSize() {
                    return gifDrawable.getMemorySize();
                }

                public void recycle() {
                    gifDrawable.stop();
                }

                public void initialize() {
                    super.initialize();
                }
            };
        }
        if (frameSeqDecoder instanceof AVIFDecoder) {
            final AVIFDrawable avifDrawable = new AVIFDrawable((AVIFDecoder)frameSeqDecoder);
            avifDrawable.setAutoPlay(false);
            avifDrawable.setNoMeasure(noMeasure);
            return new DrawableResource<Drawable>((Drawable)avifDrawable){

                @NonNull
                public Class<Drawable> getResourceClass() {
                    return Drawable.class;
                }

                public int getSize() {
                    return avifDrawable.getMemorySize();
                }

                public void recycle() {
                    avifDrawable.stop();
                }

                public void initialize() {
                    super.initialize();
                }
            };
        }
        return null;
    }
}

