/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.io;

import com.github.penfeizhou.animation.io.Reader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferReader
implements Reader {
    private final ByteBuffer byteBuffer;

    public ByteBufferReader(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
        byteBuffer.position(0);
    }

    @Override
    public long skip(long total) throws IOException {
        this.byteBuffer.position((int)((long)this.byteBuffer.position() + total));
        return total;
    }

    @Override
    public byte peek() throws IOException {
        return this.byteBuffer.get();
    }

    @Override
    public void reset() throws IOException {
        this.byteBuffer.position(0);
    }

    @Override
    public int position() {
        return this.byteBuffer.position();
    }

    @Override
    public int read(byte[] buffer, int start, int byteCount) throws IOException {
        this.byteBuffer.get(buffer, start, byteCount);
        return byteCount;
    }

    @Override
    public int available() throws IOException {
        return this.byteBuffer.limit() - this.byteBuffer.position();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream toInputStream() throws IOException {
        return new ByteArrayInputStream(this.byteBuffer.array());
    }
}

