/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.webp.io;

import android.text.TextUtils;
import com.github.penfeizhou.animation.io.FilterReader;
import com.github.penfeizhou.animation.io.Reader;
import java.io.IOException;

public class WebPReader
extends FilterReader {
    private static ThreadLocal<byte[]> __intBytes = new ThreadLocal();

    protected static byte[] ensureBytes() {
        byte[] bytes = __intBytes.get();
        if (bytes == null) {
            bytes = new byte[4];
            __intBytes.set(bytes);
        }
        return bytes;
    }

    public WebPReader(Reader reader) {
        super(reader);
    }

    public int getUInt16() throws IOException {
        byte[] buf = WebPReader.ensureBytes();
        this.read(buf, 0, 2);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8;
    }

    public int getUInt24() throws IOException {
        byte[] buf = WebPReader.ensureBytes();
        this.read(buf, 0, 3);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16;
    }

    public int getUInt32() throws IOException {
        byte[] buf = WebPReader.ensureBytes();
        this.read(buf, 0, 4);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    public int getFourCC() throws IOException {
        byte[] buf = WebPReader.ensureBytes();
        this.read(buf, 0, 4);
        return buf[0] & 0xFF | (buf[1] & 0xFF) << 8 | (buf[2] & 0xFF) << 16 | (buf[3] & 0xFF) << 24;
    }

    public int get1Based() throws IOException {
        return this.getUInt24() + 1;
    }

    public boolean matchFourCC(String chars) throws IOException {
        if (TextUtils.isEmpty((CharSequence)chars) || chars.length() != 4) {
            return false;
        }
        int fourCC = this.getFourCC();
        for (int i = 0; i < 4; ++i) {
            if ((fourCC >> i * 8 & 0xFF) == chars.charAt(i)) continue;
            return false;
        }
        return true;
    }
}

