/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.webp.decode;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.Writer;
import com.github.penfeizhou.animation.loader.Loader;
import com.github.penfeizhou.animation.webp.decode.ANIMChunk;
import com.github.penfeizhou.animation.webp.decode.ANMFChunk;
import com.github.penfeizhou.animation.webp.decode.AnimationFrame;
import com.github.penfeizhou.animation.webp.decode.BaseChunk;
import com.github.penfeizhou.animation.webp.decode.StillFrame;
import com.github.penfeizhou.animation.webp.decode.VP8XChunk;
import com.github.penfeizhou.animation.webp.decode.WebPParser;
import com.github.penfeizhou.animation.webp.io.WebPReader;
import com.github.penfeizhou.animation.webp.io.WebPWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.util.List;

public class WebPDecoder
extends FrameSeqDecoder<WebPReader, WebPWriter> {
    private static final String TAG = WebPDecoder.class.getSimpleName();
    private final Paint mTransparentFillPaint = new Paint();
    private Paint paint;
    private int loopCount;
    private int canvasWidth;
    private int canvasHeight;
    private boolean alpha;
    private int backgroundColor;
    private WebPWriter mWriter;

    public WebPDecoder(Loader loader, FrameSeqDecoder.RenderListener renderListener) {
        super(loader, renderListener);
        this.mTransparentFillPaint.setColor(0);
        this.mTransparentFillPaint.setStyle(Paint.Style.FILL);
        this.mTransparentFillPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
    }

    protected WebPWriter getWriter() {
        if (this.mWriter == null) {
            this.mWriter = new WebPWriter();
        }
        return this.mWriter;
    }

    protected WebPReader getReader(Reader reader) {
        return new WebPReader(reader);
    }

    protected int getLoopCount() {
        return this.loopCount;
    }

    protected void release() {
    }

    protected Rect read(WebPReader reader) throws IOException {
        List<BaseChunk> chunks = WebPParser.parse(reader);
        boolean anim = false;
        boolean vp8x = false;
        for (BaseChunk chunk : chunks) {
            if (chunk instanceof VP8XChunk) {
                this.canvasWidth = ((VP8XChunk)chunk).canvasWidth;
                this.canvasHeight = ((VP8XChunk)chunk).canvasHeight;
                this.alpha = ((VP8XChunk)chunk).alpha();
                vp8x = true;
                continue;
            }
            if (chunk instanceof ANIMChunk) {
                anim = true;
                this.backgroundColor = ((ANIMChunk)chunk).backgroundColor;
                this.loopCount = ((ANIMChunk)chunk).loopCount;
                continue;
            }
            if (!(chunk instanceof ANMFChunk)) continue;
            this.frames.add(new AnimationFrame(reader, (ANMFChunk)chunk));
        }
        if (!anim) {
            if (!vp8x) {
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeStream((InputStream)reader.toInputStream(), null, (BitmapFactory.Options)options);
                this.canvasWidth = options.outWidth;
                this.canvasHeight = options.outHeight;
            }
            this.frames.add(new StillFrame((Reader)reader, this.canvasWidth, this.canvasHeight));
            this.loopCount = 1;
        }
        this.paint = new Paint();
        this.paint.setAntiAlias(true);
        if (!this.alpha) {
            this.mTransparentFillPaint.setColor(this.backgroundColor);
        }
        return new Rect(0, 0, this.canvasWidth, this.canvasHeight);
    }

    protected void renderFrame(Frame frame) {
        if (frame == null) {
            return;
        }
        Bitmap bitmap = this.obtainBitmap(this.fullRect.width() / this.sampleSize, this.fullRect.height() / this.sampleSize);
        Canvas canvas = (Canvas)this.cachedCanvas.get(bitmap);
        if (canvas == null) {
            canvas = new Canvas(bitmap);
            this.cachedCanvas.put(bitmap, canvas);
        }
        this.frameBuffer.rewind();
        bitmap.copyPixelsFromBuffer((Buffer)this.frameBuffer);
        if (this.frameIndex == 0) {
            if (this.alpha) {
                canvas.drawColor(0, PorterDuff.Mode.SRC);
            } else {
                canvas.drawColor(this.backgroundColor, PorterDuff.Mode.SRC);
            }
        } else {
            Frame preFrame = (Frame)this.frames.get(this.frameIndex - 1);
            if (preFrame instanceof AnimationFrame && ((AnimationFrame)preFrame).disposalMethod) {
                float left = (float)preFrame.frameX * 2.0f / (float)this.sampleSize;
                float top = (float)preFrame.frameY * 2.0f / (float)this.sampleSize;
                float right = (float)(preFrame.frameX * 2 + preFrame.frameWidth) / (float)this.sampleSize;
                float bottom = (float)(preFrame.frameY * 2 + preFrame.frameHeight) / (float)this.sampleSize;
                canvas.drawRect(left, top, right, bottom, this.mTransparentFillPaint);
            }
        }
        Bitmap inBitmap = this.obtainBitmap(frame.frameWidth / this.sampleSize, frame.frameHeight / this.sampleSize);
        this.recycleBitmap(frame.draw(canvas, this.paint, this.sampleSize, inBitmap, (Writer)this.getWriter()));
        this.recycleBitmap(inBitmap);
        this.frameBuffer.rewind();
        bitmap.copyPixelsToBuffer((Buffer)this.frameBuffer);
        this.recycleBitmap(bitmap);
    }
}

