/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.avif.decode;

import android.graphics.Bitmap;
import android.graphics.Rect;
import androidx.annotation.Nullable;
import com.github.penfeizhou.animation.avif.decode.AVIFFrame;
import com.github.penfeizhou.animation.avif.io.AVIFReader;
import com.github.penfeizhou.animation.avif.io.AVIFWriter;
import com.github.penfeizhou.animation.decode.Frame;
import com.github.penfeizhou.animation.decode.FrameSeqDecoder;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.loader.Loader;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.aomedia.avif.android.AvifDecoder;

public class AVIFDecoder
extends FrameSeqDecoder<AVIFReader, AVIFWriter> {
    private AvifDecoder avifDecoder = null;

    public AVIFDecoder(Loader loader, @Nullable FrameSeqDecoder.RenderListener renderListener) {
        super(loader, renderListener);
    }

    protected AVIFWriter getWriter() {
        return null;
    }

    protected AVIFReader getReader(Reader reader) {
        return new AVIFReader(reader);
    }

    protected int getLoopCount() {
        if (this.avifDecoder == null) {
            return 0;
        }
        if (this.avifDecoder.getFrameCount() == 1) {
            return 1;
        }
        return this.avifDecoder.getRepetitionCount();
    }

    protected void release() {
        if (this.avifDecoder != null) {
            this.avifDecoder.release();
            this.avifDecoder = null;
        }
    }

    protected Rect read(AVIFReader reader) throws IOException {
        ByteBuffer source = reader.toDirectByteBuffer();
        this.avifDecoder = AvifDecoder.create((ByteBuffer)source);
        return new Rect(0, 0, this.avifDecoder.getWidth(), this.avifDecoder.getHeight());
    }

    public int getFrameCount() {
        if (this.avifDecoder == null) {
            return 0;
        }
        return this.avifDecoder.getFrameCount();
    }

    public Bitmap getFrameBitmap(int index) throws IOException {
        if (this.avifDecoder == null) {
            return null;
        }
        Bitmap bitmap = Bitmap.createBitmap((int)(this.getBounds().width() / this.getSampleSize()), (int)(this.getBounds().height() / this.getSampleSize()), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.avifDecoder.nthFrame(index, bitmap);
        return bitmap;
    }

    public Frame<AVIFReader, AVIFWriter> getFrame(int index) {
        AVIFFrame avifFrame = new AVIFFrame(null);
        avifFrame.index = index;
        avifFrame.frameDuration = (int)(this.avifDecoder.getFrameDurations()[index] * 1000.0);
        return avifFrame;
    }

    protected void renderFrame(Frame<AVIFReader, AVIFWriter> frame) {
        Bitmap bitmap = this.obtainBitmap(this.avifDecoder.getWidth(), this.avifDecoder.getHeight());
        if (this.avifDecoder == null) {
            return;
        }
        if (this.frameIndex != ((AVIFFrame)frame).index) {
            this.avifDecoder.nthFrame(((AVIFFrame)frame).index, bitmap);
        } else if (this.frameIndex == 0) {
            this.avifDecoder.nthFrame(0, bitmap);
        } else {
            this.avifDecoder.nextFrame(bitmap);
        }
        this.frameBuffer.rewind();
        try {
            bitmap.copyPixelsToBuffer((Buffer)this.frameBuffer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.recycleBitmap(bitmap);
    }

    public int getSampleSize() {
        return 1;
    }
}

