/*
 * Decompiled with CFR 0.152.
 */
package com.github.penfeizhou.animation.apng.decode;

import android.content.Context;
import com.github.penfeizhou.animation.apng.decode.ACTLChunk;
import com.github.penfeizhou.animation.apng.decode.Chunk;
import com.github.penfeizhou.animation.apng.decode.FCTLChunk;
import com.github.penfeizhou.animation.apng.decode.FDATChunk;
import com.github.penfeizhou.animation.apng.decode.IDATChunk;
import com.github.penfeizhou.animation.apng.decode.IENDChunk;
import com.github.penfeizhou.animation.apng.decode.IHDRChunk;
import com.github.penfeizhou.animation.apng.io.APNGReader;
import com.github.penfeizhou.animation.io.Reader;
import com.github.penfeizhou.animation.io.StreamReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class APNGParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPNG(String filePath) {
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(filePath);
            boolean bl = APNGParser.isAPNG((Reader)new StreamReader((InputStream)inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPNG(Context context, String assetPath) {
        InputStream inputStream = null;
        try {
            inputStream = context.getAssets().open(assetPath);
            boolean bl = APNGParser.isAPNG((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAPNG(Context context, int resId) {
        InputStream inputStream = null;
        try {
            inputStream = context.getResources().openRawResource(resId);
            boolean bl = APNGParser.isAPNG((Reader)new StreamReader(inputStream));
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean isAPNG(Reader in) {
        block4: {
            APNGReader reader = in instanceof APNGReader ? (APNGReader)in : new APNGReader(in);
            try {
                if (!reader.matchFourCC("\u0089PNG") || !reader.matchFourCC("\r\n\u001a\n")) {
                    throw new FormatException();
                }
                while (reader.available() > 0) {
                    Chunk chunk = APNGParser.parseChunk(reader);
                    if (!(chunk instanceof ACTLChunk)) continue;
                    return true;
                }
            }
            catch (IOException e) {
                if (e instanceof FormatException) break block4;
                e.printStackTrace();
            }
        }
        return false;
    }

    public static List<Chunk> parse(APNGReader reader) throws IOException {
        if (!reader.matchFourCC("\u0089PNG") || !reader.matchFourCC("\r\n\u001a\n")) {
            throw new FormatException();
        }
        ArrayList<Chunk> chunks = new ArrayList<Chunk>();
        while (reader.available() > 0) {
            chunks.add(APNGParser.parseChunk(reader));
        }
        return chunks;
    }

    private static Chunk parseChunk(APNGReader reader) throws IOException {
        int offset = reader.position();
        int size = reader.readInt();
        int fourCC = reader.readFourCC();
        Chunk chunk = fourCC == ACTLChunk.ID ? new ACTLChunk() : (fourCC == FCTLChunk.ID ? new FCTLChunk() : (fourCC == FDATChunk.ID ? new FDATChunk() : (fourCC == IDATChunk.ID ? new IDATChunk() : (fourCC == IENDChunk.ID ? new IENDChunk() : (fourCC == IHDRChunk.ID ? new IHDRChunk() : new Chunk())))));
        chunk.offset = offset;
        chunk.fourcc = fourCC;
        chunk.length = size;
        chunk.parse(reader);
        chunk.crc = reader.readInt();
        return chunk;
    }

    static class FormatException
    extends IOException {
        FormatException() {
            super("APNG Format error");
        }
    }
}

