/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtp.packets.AccPacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtsp.Body;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.utils.AuthUtil;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import com.pedro.rtsp.utils.CreateSSLSocket;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RtspClient {
    private final String TAG = "RtspClient";
    private final long mTimestamp;
    private String host;
    private int port;
    private String path;
    private int sampleRate;
    private final int trackVideo = 1;
    private final int trackAudio = 0;
    private Protocol protocol = Protocol.UDP;
    private int mCSeq = 0;
    private String authorization = null;
    private String user;
    private String password;
    private String sessionId;
    private ConnectCheckerRtsp connectCheckerRtsp;
    private Socket connectionSocket;
    private BufferedReader reader;
    private BufferedWriter writer;
    private Thread thread;
    private String sps;
    private String pps;
    private int[] audioPorts = new int[]{5000, 5001};
    private int[] videoPorts = new int[]{5002, 5003};
    private OutputStream outputStream;
    private volatile boolean streaming = false;
    private InputStream inputStreamJks = null;
    private String passPhraseJks = null;
    private H264Packet h264Packet;
    private AccPacket accPacket;
    private Runnable connectionMonitor = new Runnable(){

        @Override
        public void run() {
            if (RtspClient.this.streaming) {
                try {
                    RtspClient.this.writer.write(RtspClient.this.sendOptions());
                    RtspClient.this.writer.flush();
                    RtspClient.this.getResponse(false);
                    Thread.sleep(6000L);
                    new Thread(RtspClient.this.connectionMonitor).start();
                }
                catch (IOException | InterruptedException e) {
                    e.printStackTrace();
                    RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp();
                    RtspClient.this.streaming = false;
                }
            }
        }
    };

    public RtspClient(ConnectCheckerRtsp connectCheckerRtsp, Protocol protocol) {
        this.protocol = protocol;
        this.connectCheckerRtsp = connectCheckerRtsp;
        long uptime = System.currentTimeMillis();
        this.mTimestamp = uptime / 1000L << 32 & (uptime - uptime / 1000L * 1000L >> 32) / 1000L;
    }

    public void setAuthorization(String user, String password) {
        this.user = user;
        this.password = password;
    }

    public void setJksData(InputStream inputStreamJks, String passPhraseJks) {
        this.inputStreamJks = inputStreamJks;
        this.passPhraseJks = passPhraseJks;
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public void setUrl(String url) {
        if (url.startsWith("rtsp://")) {
            try {
                String[] data = url.split("/");
                this.host = data[2].split(":")[0];
                this.port = Integer.parseInt(data[2].split(":")[1]);
                this.path = "";
                for (int i = 3; i < data.length; ++i) {
                    this.path = this.path + "/" + data[i];
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Log.e((String)"RtspClient", (String)"Error parse endPoint");
                e.printStackTrace();
                this.connectCheckerRtsp.onConnectionFailedRtsp();
                this.streaming = false;
            }
        } else {
            this.connectCheckerRtsp.onConnectionFailedRtsp();
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setSampleRate(int sampleRate) {
        this.sampleRate = sampleRate;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public void setSPSandPPS(String sps, String pps) {
        this.sps = sps;
        this.pps = pps;
    }

    public void connect() {
        if (!this.streaming) {
            this.h264Packet = new H264Packet(this, this.protocol);
            this.accPacket = new AccPacket(this, this.protocol);
            this.accPacket.setSampleRate(this.sampleRate);
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (RtspClient.this.inputStreamJks == null | RtspClient.this.passPhraseJks == null) {
                            RtspClient.this.connectionSocket = new Socket(RtspClient.this.host, RtspClient.this.port);
                        } else {
                            RtspClient.this.connectionSocket = CreateSSLSocket.createSSlSocket(CreateSSLSocket.createKeyStore(RtspClient.this.inputStreamJks, RtspClient.this.passPhraseJks), RtspClient.this.host, RtspClient.this.port);
                        }
                        RtspClient.this.reader = new BufferedReader(new InputStreamReader(RtspClient.this.connectionSocket.getInputStream()));
                        RtspClient.this.outputStream = RtspClient.this.connectionSocket.getOutputStream();
                        RtspClient.this.writer = new BufferedWriter(new OutputStreamWriter(RtspClient.this.outputStream));
                        RtspClient.this.writer.write(RtspClient.this.sendAnnounce());
                        RtspClient.this.writer.flush();
                        String response = RtspClient.this.getResponse(false);
                        int status = RtspClient.this.getResponseStatus(response);
                        if (status == 403) {
                            RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp();
                            Log.e((String)"RtspClient", (String)"Response 403, access denied");
                            return;
                        }
                        if (status == 401) {
                            if (RtspClient.this.user == null || RtspClient.this.password == null) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            RtspClient.this.writer.write(RtspClient.this.sendAnnounceWithAuth(response));
                            RtspClient.this.writer.flush();
                            if (RtspClient.this.getResponseStatus(RtspClient.this.getResponse(false)) == 401) {
                                RtspClient.this.connectCheckerRtsp.onAuthErrorRtsp();
                                return;
                            }
                            RtspClient.this.connectCheckerRtsp.onAuthSuccessRtsp();
                        }
                        RtspClient.this.writer.write(RtspClient.this.sendSetup(0, RtspClient.this.protocol));
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(true);
                        RtspClient.this.writer.write(RtspClient.this.sendSetup(1, RtspClient.this.protocol));
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(false);
                        RtspClient.this.writer.write(RtspClient.this.sendRecord());
                        RtspClient.this.writer.flush();
                        RtspClient.this.getResponse(false);
                        RtspClient.this.h264Packet.updateDestinationVideo();
                        RtspClient.this.accPacket.updateDestinationAudio();
                        RtspClient.this.streaming = true;
                        RtspClient.this.connectCheckerRtsp.onConnectionSuccessRtsp();
                        new Thread(RtspClient.this.connectionMonitor).start();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        RtspClient.this.connectCheckerRtsp.onConnectionFailedRtsp();
                        RtspClient.this.streaming = false;
                    }
                }
            });
            this.thread.start();
        }
    }

    public void disconnect() {
        if (this.streaming) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        RtspClient.this.writer.write(RtspClient.this.sendTearDown());
                        RtspClient.this.connectionSocket.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    RtspClient.this.connectCheckerRtsp.onDisconnectRtsp();
                    RtspClient.this.streaming = false;
                }
            });
            this.thread.start();
            if (this.h264Packet != null && this.accPacket != null) {
                this.h264Packet.close();
                this.accPacket.close();
            }
        }
    }

    private String sendAnnounce() {
        String body = this.createBody();
        String request = this.authorization == null ? "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nContent-Type: application/sdp\r\n\r\n" + body : "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nAuthorization: " + this.authorization + "\r\nContent-Type: application/sdp\r\n\r\n" + body;
        return request;
    }

    private String createBody() {
        return "v=0\r\no=- " + this.mTimestamp + " " + this.mTimestamp + " IN IP4 127.0.0.1\r\ns=Unnamed\r\ni=N/A\r\nc=IN IP4 " + this.host + "\r\nthread=0 0\r\na=recvonly\r\n" + Body.createAudioBody(0, this.sampleRate) + Body.createVideoBody(1, this.sps, this.pps);
    }

    private String sendSetup(int track, Protocol protocol) {
        String params = protocol == Protocol.UDP ? "UDP;unicast;client_port=" + (5000 + 2 * track) + "-" + (5000 + 2 * track + 1) + ";mode=receive" : "TCP;interleaved=" + 2 * track + "-" + (2 * track + 1);
        return "SETUP rtsp://" + this.host + ":" + this.port + this.path + "/trackID=" + track + " RTSP/1.0\r\nTransport: RTP/AVP/" + params + "\r\n" + this.addHeaders(this.authorization);
    }

    private String sendOptions() {
        return "OPTIONS rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders(this.authorization);
    }

    private String sendRecord() {
        return "RECORD rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nRange: npt=0.000-\r\n" + this.addHeaders(this.authorization);
    }

    private String sendTearDown() {
        return "TEARDOWN rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\n" + this.addHeaders(this.authorization);
    }

    private String addHeaders(String authorization) {
        return "CSeq: " + ++this.mCSeq + "\r\nContent-Length: 0\r\nSession: " + this.sessionId + "\r\n" + (authorization != null ? "Authorization: " + authorization + "\r\n" : "") + "\r\n";
    }

    private String getResponse(boolean isAudio) {
        try {
            String line;
            String response = "";
            while ((line = this.reader.readLine()) != null) {
                if (line.contains("Session")) {
                    this.sessionId = line.split(";")[0].split(":")[1].trim();
                }
                if (line.contains("server_port")) {
                    String[] s = line.split("server_port=")[1].split("-");
                    for (int i = 0; i < s.length; ++i) {
                        if (isAudio) {
                            this.audioPorts[i] = Integer.parseInt(s[i]);
                            continue;
                        }
                        Log.i((String)"Ports", (String)s[i]);
                        this.videoPorts[i] = Integer.parseInt(s[i]);
                    }
                }
                response = response + line + "\n";
                if (line.length() >= 3) continue;
            }
            Log.i((String)"RtspClient", (String)response);
            return response;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String sendAnnounceWithAuth(String authResponse) {
        this.authorization = this.createAuth(authResponse);
        Log.i((String)"Auth", (String)this.authorization);
        String body = this.createBody();
        String request = "ANNOUNCE rtsp://" + this.host + ":" + this.port + this.path + " RTSP/1.0\r\nCSeq: " + ++this.mCSeq + "\r\nContent-Length: " + body.length() + "\r\nAuthorization: " + this.authorization + "\r\nContent-Type: application/sdp\r\n\r\n" + body;
        return request;
    }

    private String createAuth(String authResponse) {
        Pattern authPattern = Pattern.compile("realm=\"(.+)\",\\s+nonce=\"(\\w+)\"", 2);
        Matcher matcher = authPattern.matcher(authResponse);
        matcher.find();
        String realm = matcher.group(1);
        String nonce = matcher.group(2);
        String hash1 = AuthUtil.getMd5Hash(this.user + ":" + realm + ":" + this.password);
        String hash2 = AuthUtil.getMd5Hash("ANNOUNCE:rtsp://" + this.host + ":" + this.port + this.path);
        String hash3 = AuthUtil.getMd5Hash(hash1 + ":" + nonce + ":" + hash2);
        return "Digest username=\"" + this.user + "\",realm=\"" + realm + "\",nonce=\"" + nonce + "\",uri=\"rtsp://" + this.host + ":" + this.port + this.path + "\",response=\"" + hash3 + "\"";
    }

    private int getResponseStatus(String response) {
        Matcher matcher = Pattern.compile("RTSP/\\d.\\d (\\d+) (\\w+)", 2).matcher(response);
        matcher.find();
        return Integer.parseInt(matcher.group(1));
    }

    public int[] getAudioPorts() {
        return this.audioPorts;
    }

    public int[] getVideoPorts() {
        return this.videoPorts;
    }

    public void sendVideo(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.h264Packet.createAndSendPacket(h264Buffer, info);
        }
    }

    public void sendAudio(ByteBuffer accBuffer, MediaCodec.BufferInfo info) {
        if (this.isStreaming()) {
            this.accPacket.createAndSendPacket(accBuffer, info);
        }
    }
}

