/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtcp;

import android.os.SystemClock;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class SenderReportUdp
extends BaseSenderReport {
    private MulticastSocket socket;
    private DatagramPacket datagramPacket;

    public SenderReportUdp() {
        try {
            this.socket = new MulticastSocket();
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.datagramPacket = new DatagramPacket(this.mBuffer, 1);
    }

    public void close() {
        this.socket.close();
    }

    public void update(int length, long rtpts, int port) {
        ++this.mPacketCount;
        this.mOctetCount += length;
        this.setLong(this.mPacketCount, 20, 24);
        this.setLong(this.mOctetCount, 24, 28);
        this.now = SystemClock.elapsedRealtime();
        this.delta += this.old != 0L ? this.now - this.old : 0L;
        this.old = this.now;
        if (this.interval > 0L && this.delta >= this.interval) {
            this.send(System.nanoTime(), rtpts, port);
            this.delta = 0L;
        }
    }

    public void setDestination(InetAddress dest, int dport) {
        this.datagramPacket.setPort(dport);
        this.datagramPacket.setAddress(dest);
    }

    private void send(final long ntpts, final long rtpts, final int port) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                long hb = ntpts / 1000000000L;
                long lb = (ntpts - hb * 1000000000L) * 0x100000000L / 1000000000L;
                SenderReportUdp.this.setLong(hb, 8, 12);
                SenderReportUdp.this.setLong(lb, 12, 16);
                SenderReportUdp.this.setLong(rtpts, 16, 20);
                SenderReportUdp.this.datagramPacket.setLength(28);
                SenderReportUdp.this.datagramPacket.setPort(port);
                Log.i((String)"SenderReport", (String)("send report, " + SenderReportUdp.this.datagramPacket.getPort() + " Port"));
                try {
                    SenderReportUdp.this.socket.send(SenderReportUdp.this.datagramPacket);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }
}

