/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

public class Body {
    private static final int[] AUDIO_SAMPLING_RATES = new int[]{96000, 88200, 64000, 48000, 44100, 32000, 24000, 22050, 16000, 12000, 11025, 8000, 7350, -1, -1, -1};

    public static String createAudioBody(int trackAudio, int sampleRate) {
        int sampleRateNum = -1;
        for (int i = 0; i < AUDIO_SAMPLING_RATES.length; ++i) {
            if (AUDIO_SAMPLING_RATES[i] != sampleRate) continue;
            sampleRateNum = i;
            break;
        }
        int config = 0x1000 | (sampleRateNum & 0xF) << 7 | 8;
        return "m=audio " + (5000 + 2 * trackAudio) + " RTP/AVP" + 96 + "\r\na=rtpmap:" + 96 + " mpeg4-generic/" + sampleRate + "\r\na=fmtp:" + 96 + " streamtype=5; profile-level-id=15; mode=AAC-hbr; config=" + Integer.toHexString(config) + "; SizeLength=13; IndexLength=3; IndexDeltaLength=3;\r\na=control:trackID=" + trackAudio + "\r\n";
    }

    public static String createVideoBody(int trackVideo, String sps, String pps) {
        return "m=video " + (5000 + 2 * trackVideo) + " RTP/AVP" + 96 + "\r\na=rtpmap:" + 96 + " H264/" + 90000 + "\r\na=fmtp:" + 96 + " packetization-mode=1;profile-level-id=42c029;sprop-parameter-sets=" + sps + "," + pps + ";\r\na=control:trackID=" + trackVideo + "\r\n";
    }
}

