/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtcp.SenderReportTcp;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;

public class RtpSocketTcp
extends BaseRtpSocket
implements Runnable {
    private SenderReportTcp senderReportTcp;
    private byte[] mTcpHeader;
    private int[] lengths = new int[this.mBufferCount];
    private OutputStream mOutputStream = null;

    public RtpSocketTcp() {
        this.senderReportTcp = new SenderReportTcp();
        this.senderReportTcp.reset();
        this.mTcpHeader = new byte[]{36, 0, 0, 0};
    }

    @Override
    public void setSSRC(int ssrc) {
        for (int i = 0; i < this.mBufferCount; ++i) {
            this.setLong(this.mBuffers[i], ssrc, 8, 12);
        }
        this.senderReportTcp.setSSRC(ssrc);
    }

    public void setOutputStream(OutputStream outputStream, byte channelIdentifier) {
        if (outputStream != null) {
            this.mOutputStream = outputStream;
            this.mTcpHeader[1] = channelIdentifier;
            this.senderReportTcp.setOutputStream(outputStream, (byte)(channelIdentifier + 1));
        }
    }

    @Override
    public void commitBuffer(int length) throws IOException {
        this.updateSequence();
        this.lengths[this.mBufferIn] = length;
        if (++this.mBufferIn >= this.mBufferCount) {
            this.mBufferIn = 0;
        }
        this.mBufferCommitted.release();
        if (this.mThread == null) {
            this.mThread = new Thread(this);
            this.mThread.start();
        }
    }

    @Override
    public void run() {
        try {
            while (this.mBufferCommitted.tryAcquire(4L, TimeUnit.SECONDS)) {
                this.senderReportTcp.update(this.lengths[this.mBufferOut], this.mTimestamps[this.mBufferOut] / 100L * (this.mClock / 1000L) / 10000L);
                if (this.mCount++ > 30) {
                    Log.i((String)"RtpSocket", (String)("send packet, " + this.lengths[this.mBufferOut] + " Size"));
                    this.sendTCP();
                }
                if (++this.mBufferOut >= this.mBufferCount) {
                    this.mBufferOut = 0;
                }
                this.mBufferRequested.release();
            }
        }
        catch (Exception e) {
            Log.e((String)"RtpSocket", (String)"tcp send error: ", (Throwable)e);
        }
        this.mThread = null;
        this.resetFifo();
        this.senderReportTcp.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendTCP() throws Exception {
        OutputStream outputStream = this.mOutputStream;
        synchronized (outputStream) {
            int len = this.lengths[this.mBufferOut];
            this.mTcpHeader[2] = (byte)(len >> 8);
            this.mTcpHeader[3] = (byte)(len & 0xFF);
            this.mOutputStream.write(this.mTcpHeader);
            this.mOutputStream.write(this.mBuffers[this.mBufferOut], 0, len);
            this.mOutputStream.flush();
            Log.d((String)"RtpSocket", (String)("send " + len));
        }
    }
}

