/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import com.pedro.common.frame.MediaFrame;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.ExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\t\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J@\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182(\u0010\u0019\u001a$\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001c0\u001b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u001d\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001aH\u00a6@\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u000e\u0010 \u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00020\u0003J\u0010\u0010!\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u0003H\u0004J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0005H\u0004J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020\u0003H\u0004J\u0010\u0010(\u001a\u00020\u00162\u0006\u0010&\u001a\u00020#H\u0004J\u0010\u0010)\u001a\u00020\u00162\u0006\u0010&\u001a\u00020#H\u0004J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010&\u001a\u00020#2\u0006\u0010\u000e\u001a\u00020\u0003H\u0002J\u0010\u0010+\u001a\u00020\u00162\u0006\u0010&\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u00020\u0005X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\nR\u0014\u0010\u0011\u001a\u00020\u0012X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006,"}, d2={"Lcom/pedro/rtsp/rtp/packets/BasePacket;", "", "clock", "", "payloadType", "", "<init>", "(JI)V", "channelIdentifier", "getChannelIdentifier", "()I", "setChannelIdentifier", "(I)V", "seq", "ssrc", "maxPacketSize", "getMaxPacketSize", "TAG", "", "getTAG", "()Ljava/lang/String;", "createAndSendPacket", "", "mediaFrame", "Lcom/pedro/common/frame/MediaFrame;", "callback", "Lkotlin/Function2;", "", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "Lkotlin/coroutines/Continuation;", "(Lcom/pedro/common/frame/MediaFrame;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "setSSRC", "setClock", "getBuffer", "", "size", "updateTimeStamp", "buffer", "timestamp", "updateSeq", "markPacket", "setLongSSRC", "requestBuffer", "rtsp_release"})
public abstract class BasePacket {
    private long clock;
    private final int payloadType;
    private int channelIdentifier;
    private long seq;
    private long ssrc;
    private final int maxPacketSize;
    @NotNull
    private final String TAG;

    public BasePacket(long clock, int payloadType) {
        this.clock = clock;
        this.payloadType = payloadType;
        this.maxPacketSize = 1472;
        this.TAG = "BasePacket";
    }

    protected final int getChannelIdentifier() {
        return this.channelIdentifier;
    }

    protected final void setChannelIdentifier(int n) {
        this.channelIdentifier = n;
    }

    protected final int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    @NotNull
    protected final String getTAG() {
        return this.TAG;
    }

    @Nullable
    public abstract Object createAndSendPacket(@NotNull MediaFrame var1, @NotNull Function2<? super List<RtpFrame>, ? super Continuation<? super Unit>, ? extends Object> var2, @NotNull Continuation<? super Unit> var3);

    public void reset() {
        this.seq = 0L;
        this.ssrc = 0L;
    }

    public final void setSSRC(long ssrc) {
        this.ssrc = ssrc;
    }

    protected final void setClock(long clock) {
        this.clock = clock;
    }

    @NotNull
    protected final byte[] getBuffer(int size) {
        byte[] buffer = new byte[size];
        buffer[0] = -128;
        buffer[1] = (byte)this.payloadType;
        this.setLongSSRC(buffer, this.ssrc);
        this.requestBuffer(buffer);
        return buffer;
    }

    protected final long updateTimeStamp(@NotNull byte[] buffer, long timestamp) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        long ts = timestamp * this.clock / 1000000000L;
        ExtensionsKt.setLong(buffer, ts, 4, 8);
        return ts;
    }

    protected final void updateSeq(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        ++this.seq;
        ExtensionsKt.setLong(buffer, this.seq, 2, 4);
    }

    protected final void markPacket(@NotNull byte[] buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        buffer[1] = (byte)(buffer[1] | 0xFFFFFF80);
    }

    private final void setLongSSRC(byte[] buffer, long ssrc) {
        ExtensionsKt.setLong(buffer, ssrc, 8, 12);
    }

    private final void requestBuffer(byte[] buffer) {
        buffer[1] = (byte)(buffer[1] & 0x7F);
    }
}

