/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.rtsp.RtspSender;
import com.pedro.rtsp.utils.BitrateManager;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\u0018\u0000 X2\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010'\u001a\u00020(J\u0006\u0010)\u001a\u00020\u000eJ\u0006\u0010*\u001a\u00020\u000eJ\u0006\u0010+\u001a\u00020\bJ\u0006\u0010,\u001a\u00020\bJ\u0010\u0010-\u001a\u00020\u00192\b\b\u0002\u0010.\u001a\u00020/J\u0006\u00100\u001a\u00020(J\u0006\u00101\u001a\u00020(J\u0006\u00102\u001a\u00020(J\u0006\u00103\u001a\u00020(J\u000e\u00104\u001a\u00020(2\u0006\u00105\u001a\u00020\u000eJ\u0016\u00106\u001a\u00020(2\u0006\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:J\u0016\u0010;\u001a\u00020(2\u0006\u0010<\u001a\u0002082\u0006\u00109\u001a\u00020:J\u000e\u0010=\u001a\u00020(2\u0006\u0010>\u001a\u00020\u000eJ\u0016\u0010?\u001a\u00020(2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eJ\u0016\u0010B\u001a\u00020(2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u000e\u0010G\u001a\u00020(2\u0006\u0010H\u001a\u00020\u0019J\u001e\u0010I\u001a\u00020(2\u0006\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020M2\u0006\u0010N\u001a\u00020MJ \u0010O\u001a\u00020(2\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\b\u0010S\u001a\u0004\u0018\u00010QJ\u0016\u0010T\u001a\u00020(2\u0006\u0010@\u001a\u00020\u000e2\u0006\u0010A\u001a\u00020\u000eJ\u0006\u0010U\u001a\u00020(J\u0011\u0010V\u001a\u00020(H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010WR\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u0004\u0018\u00010 X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u0004\u0018\u00010&X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006Y"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender;", "", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "aacPacket", "Lcom/pedro/rtsp/rtp/packets/AacPacket;", "audioFramesSent", "", "baseSenderReport", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "bitrateManager", "Lcom/pedro/rtsp/utils/BitrateManager;", "cacheSize", "", "defaultCacheSize", "getDefaultCacheSize", "()I", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "isEnableLogs", "", "job", "Lkotlinx/coroutines/Job;", "queue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "rtpSocket", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "running", "scope", "Lkotlinx/coroutines/CoroutineScope;", "videoFramesSent", "videoPacket", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "clearCache", "", "getCacheSize", "getItemsInCache", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "percentUsed", "", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "setAudioPorts", "rtpPort", "rtcpPort", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "setLogs", "enable", "setSocketsInfo", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "videoSourcePorts", "", "audioSourcePorts", "setVideoInfo", "sps", "", "pps", "vps", "setVideoPorts", "start", "stop", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "rtsp_release"})
public final class RtspSender {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConnectCheckerRtsp connectCheckerRtsp;
    @Nullable
    private BasePacket videoPacket;
    @Nullable
    private AacPacket aacPacket;
    @Nullable
    private BaseRtpSocket rtpSocket;
    @Nullable
    private BaseSenderReport baseSenderReport;
    private int cacheSize;
    private volatile boolean running;
    @Nullable
    private Job job;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private volatile BlockingQueue<RtpFrame> queue;
    private long audioFramesSent;
    private long videoFramesSent;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    @NotNull
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    @NotNull
    private static final String TAG = "RtspSender";

    public RtspSender(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.cacheSize = this.getDefaultCacheSize();
        this.scope = CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO()));
        this.queue = new LinkedBlockingQueue(this.cacheSize);
        this.bitrateManager = new BitrateManager(this.connectCheckerRtsp);
        this.isEnableLogs = true;
    }

    private final int getDefaultCacheSize() {
        return 6990;
    }

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setSocketsInfo(@NotNull Protocol protocol, @NotNull int[] videoSourcePorts, @NotNull int[] audioSourcePorts) throws IOException {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)videoSourcePorts, (String)"videoSourcePorts");
        Intrinsics.checkNotNullParameter((Object)audioSourcePorts, (String)"audioSourcePorts");
        this.rtpSocket = BaseRtpSocket.Companion.getInstance(protocol, videoSourcePorts[0], audioSourcePorts[0]);
        this.baseSenderReport = BaseSenderReport.Companion.getInstance(protocol, videoSourcePorts[1], audioSourcePorts[1]);
    }

    public final void setVideoInfo(@NotNull byte[] sps, @NotNull byte[] pps, @Nullable byte[] vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.videoPacket = vps == null ? (BasePacket)new H264Packet(sps, pps) : (BasePacket)new H265Packet(sps, pps, vps);
    }

    public final void setAudioInfo(int sampleRate) {
        this.aacPacket = new AacPacket(sampleRate);
    }

    public final void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) throws IOException {
        block1: {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            BaseRtpSocket baseRtpSocket = this.rtpSocket;
            if (baseRtpSocket != null) {
                baseRtpSocket.setDataStream(outputStream, host);
            }
            BaseSenderReport baseSenderReport = this.baseSenderReport;
            if (baseSenderReport == null) break block1;
            baseSenderReport.setDataStream(outputStream, host);
        }
    }

    public final void setVideoPorts(int rtpPort, int rtcpPort) {
        block0: {
            BasePacket basePacket = this.videoPacket;
            if (basePacket == null) break block0;
            basePacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void setAudioPorts(int rtpPort, int rtcpPort) {
        block0: {
            AacPacket aacPacket = this.aacPacket;
            if (aacPacket == null) break block0;
            aacPacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            BasePacket basePacket = this.videoPacket;
            if (basePacket != null) {
                basePacket.createAndSendPacket(h264Buffer, info, (Function1<? super RtpFrame, Unit>)((Function1)new Function1<RtpFrame, Unit>(this){
                    final /* synthetic */ RtspSender this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull RtpFrame rtpFrame2) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)rtpFrame2, (String)"rtpFrame");
                        BlockingQueue $this$trySend$iv = RtspSender.access$getQueue$p(this.this$0);
                        boolean $i$f$trySend = false;
                        try {
                            $this$trySend$iv.add(rtpFrame2);
                            bl = true;
                        }
                        catch (IllegalStateException e$iv) {
                            bl = false;
                        }
                        boolean result = bl;
                        if (!result) {
                            Log.i((String)"RtspSender", (String)"Video frame discarded");
                            RtspSender rtspSender = this.this$0;
                            long l = rtspSender.getDroppedVideoFrames();
                            RtspSender.access$setDroppedVideoFrames$p(rtspSender, l + 1L);
                        }
                    }
                }));
            }
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            AacPacket aacPacket = this.aacPacket;
            if (aacPacket != null) {
                aacPacket.createAndSendPacket(aacBuffer, info, (Function1<? super RtpFrame, Unit>)((Function1)new Function1<RtpFrame, Unit>(this){
                    final /* synthetic */ RtspSender this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull RtpFrame rtpFrame2) {
                        boolean bl;
                        Intrinsics.checkNotNullParameter((Object)rtpFrame2, (String)"rtpFrame");
                        BlockingQueue $this$trySend$iv = RtspSender.access$getQueue$p(this.this$0);
                        boolean $i$f$trySend = false;
                        try {
                            $this$trySend$iv.add(rtpFrame2);
                            bl = true;
                        }
                        catch (IllegalStateException e$iv) {
                            bl = false;
                        }
                        boolean result = bl;
                        if (!result) {
                            Log.i((String)"RtspSender", (String)"Audio frame discarded");
                            RtspSender rtspSender = this.this$0;
                            long l = rtspSender.getDroppedAudioFrames();
                            RtspSender.access$setDroppedAudioFrames$p(rtspSender, l + 1L);
                        }
                    }
                }));
            }
        }
    }

    public final void start() {
        this.queue.clear();
        this.running = true;
        this.job = BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int I$0;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ RtspSender this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.dump(StructuredAssignment.java:69)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object stop(@NotNull Continuation<? super Unit> var1_1) {
        if (!(var1_1 instanceof stop.1)) ** GOTO lbl-1000
        var3_2 = var1_1;
        if ((var3_2.label & -2147483648) != 0) {
            var3_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var1_1){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ RtspSender this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.stop((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var4_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.running = false;
                v0 = this.baseSenderReport;
                if (v0 != null) {
                    v0.reset();
                }
                v1 = this.baseSenderReport;
                if (v1 != null) {
                    v1.close();
                }
                v2 = this.rtpSocket;
                if (v2 != null) {
                    v2.close();
                }
                v3 = this.aacPacket;
                if (v3 != null) {
                    v3.reset();
                }
                v4 = this.videoPacket;
                if (v4 != null) {
                    v4.reset();
                }
                this.resetSentAudioFrames();
                this.resetSentVideoFrames();
                this.resetDroppedAudioFrames();
                this.resetDroppedVideoFrames();
                v5 = this.job;
                if (v5 == null) break;
                $continuation.L$0 = this;
                $continuation.label = 1;
                v6 = JobKt.cancelAndJoin((Job)v5, (Continuation)$continuation);
                if (v6 == var4_4) {
                    return var4_4;
                }
                break;
            }
            case 1: {
                this = (RtspSender)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v6 = $result;
                break;
            }
        }
        this.job = null;
        this.queue.clear();
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public final boolean hasCongestion(float percentUsed) throws IllegalArgumentException {
        float remaining;
        float capacity;
        if (percentUsed < 0.0f || percentUsed > 100.0f) {
            throw new IllegalArgumentException("the value must be in range 0 to 100");
        }
        float size = this.queue.size();
        return size >= (capacity = size + (remaining = (float)this.queue.remainingCapacity())) * (percentUsed / 100.0f);
    }

    public static /* synthetic */ boolean hasCongestion$default(RtspSender rtspSender, float f, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            f = 20.0f;
        }
        return rtspSender.hasCongestion(f);
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.queue.size() - this.queue.remainingCapacity()) {
            throw new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.queue.drainTo(tempQueue);
        this.queue = tempQueue;
    }

    public final int getCacheSize() {
        return this.cacheSize;
    }

    public final int getItemsInCache() {
        return this.queue.size();
    }

    public final void clearCache() {
        this.queue.clear();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public static final /* synthetic */ BlockingQueue access$getQueue$p(RtspSender $this) {
        return $this.queue;
    }

    public static final /* synthetic */ void access$setDroppedVideoFrames$p(RtspSender $this, long l) {
        $this.droppedVideoFrames = l;
    }

    public static final /* synthetic */ void access$setDroppedAudioFrames$p(RtspSender $this, long l) {
        $this.droppedAudioFrames = l;
    }

    public static final /* synthetic */ BaseSenderReport access$getBaseSenderReport$p(RtspSender $this) {
        return $this.baseSenderReport;
    }

    public static final /* synthetic */ BasePacket access$getVideoPacket$p(RtspSender $this) {
        return $this.videoPacket;
    }

    public static final /* synthetic */ AacPacket access$getAacPacket$p(RtspSender $this) {
        return $this.aacPacket;
    }

    public static final /* synthetic */ BaseRtpSocket access$getRtpSocket$p(RtspSender $this) {
        return $this.rtpSocket;
    }

    public static final /* synthetic */ CoroutineScope access$getScope$p(RtspSender $this) {
        return $this.scope;
    }

    public static final /* synthetic */ boolean access$getRunning$p(RtspSender $this) {
        return $this.running;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(RtspSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ ConnectCheckerRtsp access$getConnectCheckerRtsp$p(RtspSender $this) {
        return $this.connectCheckerRtsp;
    }

    public static final /* synthetic */ boolean access$isEnableLogs$p(RtspSender $this) {
        return $this.isEnableLogs;
    }

    public static final /* synthetic */ long access$getVideoFramesSent$p(RtspSender $this) {
        return $this.videoFramesSent;
    }

    public static final /* synthetic */ void access$setVideoFramesSent$p(RtspSender $this, long l) {
        $this.videoFramesSent = l;
    }

    public static final /* synthetic */ long access$getAudioFramesSent$p(RtspSender $this) {
        return $this.audioFramesSent;
    }

    public static final /* synthetic */ void access$setAudioFramesSent$p(RtspSender $this, long l) {
        $this.audioFramesSent = l;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender$Companion;", "", "()V", "TAG", "", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

