/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/pedro/rtsp/rtp/packets/AacPacket;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "sampleRate", "", "audioPacketCallback", "Lcom/pedro/rtsp/rtp/packets/AudioPacketCallback;", "(ILcom/pedro/rtsp/rtp/packets/AudioPacketCallback;)V", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "rtsp_release"})
public class AacPacket
extends BasePacket {
    @NotNull
    private final AudioPacketCallback audioPacketCallback;

    public AacPacket(int sampleRate, @NotNull AudioPacketCallback audioPacketCallback) {
        Intrinsics.checkNotNullParameter((Object)audioPacketCallback, (String)"audioPacketCallback");
        super(sampleRate, 96 + RtpConstants.INSTANCE.getTrackAudio());
        this.audioPacketCallback = audioPacketCallback;
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackAudio());
    }

    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        int length = bufferInfo.size - byteBuffer.position();
        if (length > 0) {
            byte[] buffer = this.getBuffer(length + 12 + 4);
            byteBuffer.get(buffer, 16, length);
            long ts = bufferInfo.presentationTimeUs * (long)1000;
            this.markPacket(buffer);
            long rtpTs = this.updateTimeStamp(buffer, ts);
            buffer[12] = 0;
            buffer[13] = 16;
            buffer[14] = (byte)(length >> 5);
            buffer[15] = (byte)(length << 3);
            buffer[15] = (byte)(buffer[15] & 0xFFFFFFF8);
            buffer[15] = (byte)(buffer[15] | 0);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, rtpTs, 12 + length + 4, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
            this.audioPacketCallback.onAudioFrameCreated(rtpFrame);
        }
    }
}

