/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import android.util.Log;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.RtpConstants;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u000eH\u0016J \u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0003H\u0002R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/pedro/rtsp/rtp/packets/H265Packet;", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "sps", "", "pps", "vps", "videoPacketCallback", "Lcom/pedro/rtsp/rtp/packets/VideoPacketCallback;", "([B[B[BLcom/pedro/rtsp/rtp/packets/VideoPacketCallback;)V", "header", "sendKeyFrame", "", "stapA", "createAndSendPacket", "", "byteBuffer", "Ljava/nio/ByteBuffer;", "bufferInfo", "Landroid/media/MediaCodec$BufferInfo;", "reset", "setSpsPpsVps", "rtsp_release"})
public class H265Packet
extends BasePacket {
    private final byte[] header;
    private byte[] stapA;
    private boolean sendKeyFrame;
    private final VideoPacketCallback videoPacketCallback;

    @Override
    public void createAndSendPacket(@NotNull ByteBuffer byteBuffer, @NotNull MediaCodec.BufferInfo bufferInfo) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
        Intrinsics.checkNotNullParameter((Object)bufferInfo, (String)"bufferInfo");
        byteBuffer.rewind();
        byteBuffer.get(this.header, 0, 6);
        long ts = bufferInfo.presentationTimeUs * 1000L;
        int naluLength = bufferInfo.size - byteBuffer.position() + 1;
        int type = this.header[4] >> 1;
        if (type == 20 || type == 19 || bufferInfo.flags == 1) {
            boolean bl;
            boolean bl2;
            Object object;
            if (this.stapA != null) {
                object = this.stapA;
                bl2 = false;
                bl = false;
                Object it = object;
                boolean bl3 = false;
                byte[] buffer = this.getBuffer(((byte[])it).length + 12);
                long rtpts = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                System.arraycopy(it, 0, buffer, 12, ((byte[])it).length);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpts, ((byte[])it).length + 12, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                this.sendKeyFrame = true;
            } else {
                object = this;
                bl2 = false;
                bl = false;
                H265Packet $this$run = (H265Packet)object;
                boolean bl4 = false;
                Log.i((String)$this$run.getTAG(), (String)"can't create key frame because setSpsPps was not called");
            }
        }
        if (this.sendKeyFrame) {
            if (naluLength <= this.getMaxPacketSize() - 12 - 3) {
                int cont = naluLength - 1;
                int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                byte[] buffer = this.getBuffer(length + 12 + 2);
                buffer[12] = this.header[4];
                buffer[13] = this.header[5];
                byteBuffer.get(buffer, 14, length);
                long rtpts = this.updateTimeStamp(buffer, ts);
                this.markPacket(buffer);
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, rtpts, naluLength + 12, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
            } else {
                this.header[0] = 98;
                this.header[1] = 1;
                this.header[2] = (byte)type;
                this.header[2] = (byte)(this.header[2] + 128);
                int sum = 1;
                while (sum < naluLength) {
                    int cont = naluLength - sum > this.getMaxPacketSize() - 12 - 3 ? this.getMaxPacketSize() - 12 - 3 : naluLength - sum;
                    int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                    byte[] buffer = this.getBuffer(length + 12 + 3);
                    buffer[12] = this.header[0];
                    buffer[13] = this.header[1];
                    buffer[14] = this.header[2];
                    long rtpts = this.updateTimeStamp(buffer, ts);
                    byteBuffer.get(buffer, 15, length);
                    if ((sum += length) >= naluLength) {
                        buffer[14] = (byte)(buffer[14] + 64);
                        this.markPacket(buffer);
                    }
                    this.updateSeq(buffer);
                    RtpFrame rtpFrame = new RtpFrame(buffer, rtpts, length + 12 + 3, this.getRtpPort(), this.getRtcpPort(), this.getChannelIdentifier());
                    this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                    byte by = this.header[2];
                    int n = 127;
                    boolean bl = false;
                    this.header[2] = (byte)(by & n);
                }
            }
        }
    }

    private final void setSpsPpsVps(byte[] sps, byte[] pps, byte[] vps) {
        block0: {
            if (this.stapA == null) break block0;
            byte[] byArray = this.stapA = new byte[sps.length + pps.length + 6];
            boolean bl = false;
            boolean bl2 = false;
            byte[] it = byArray;
            boolean bl3 = false;
            it[0] = 96;
            it[1] = 1;
            it[2] = (byte)(sps.length >> 8);
            it[3] = (byte)(sps.length & 0xFF);
            it[sps.length + 4] = (byte)(pps.length >> 8);
            it[sps.length + 5] = (byte)(pps.length & 0xFF);
            System.arraycopy(sps, 0, it, 4, sps.length);
            System.arraycopy(pps, 0, it, 6 + sps.length, pps.length);
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.sendKeyFrame = false;
    }

    public H265Packet(@NotNull byte[] sps, @NotNull byte[] pps, @NotNull byte[] vps, @NotNull VideoPacketCallback videoPacketCallback) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        Intrinsics.checkNotNullParameter((Object)vps, (String)"vps");
        Intrinsics.checkNotNullParameter((Object)videoPacketCallback, (String)"videoPacketCallback");
        super(90000L, 96 + RtpConstants.INSTANCE.getTrackVideo());
        this.videoPacketCallback = videoPacketCallback;
        this.header = new byte[6];
        this.setChannelIdentifier(RtpConstants.INSTANCE.getTrackVideo());
        this.setSpsPpsVps(sps, pps, vps);
    }
}

