/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtsp;

import android.media.MediaCodec;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import com.pedro.rtsp.rtcp.BaseSenderReport;
import com.pedro.rtsp.rtp.packets.AacPacket;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.H264Packet;
import com.pedro.rtsp.rtp.packets.H265Packet;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.BitrateManager;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 T2\u00020\u00012\u00020\u0002:\u0001TB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010%\u001a\u00020\u000fJ\u0006\u0010&\u001a\u00020\tJ\u0006\u0010'\u001a\u00020\tJ\u0006\u0010(\u001a\u00020\u0019J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001cH\u0016J\u0006\u0010-\u001a\u00020*J\u0006\u0010.\u001a\u00020*J\u0006\u0010/\u001a\u00020*J\u0006\u00100\u001a\u00020*J\u000e\u00101\u001a\u00020*2\u0006\u00102\u001a\u00020\u000fJ\u0016\u00103\u001a\u00020*2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u000207J\u0016\u00108\u001a\u00020*2\u0006\u00109\u001a\u0002052\u0006\u00106\u001a\u000207J\u000e\u0010:\u001a\u00020*2\u0006\u0010;\u001a\u00020\u000fJ\u0016\u0010<\u001a\u00020*2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fJ\u0016\u0010?\u001a\u00020*2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CJ\u000e\u0010D\u001a\u00020*2\u0006\u0010E\u001a\u00020\u0019J\u001e\u0010F\u001a\u00020*2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020J2\u0006\u0010K\u001a\u00020JJ \u0010L\u001a\u00020*2\u0006\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020N2\b\u0010P\u001a\u0004\u0018\u00010NJ\u0016\u0010Q\u001a\u00020*2\u0006\u0010=\u001a\u00020\u000f2\u0006\u0010>\u001a\u00020\u000fJ\u0006\u0010R\u001a\u00020*J\u0006\u0010S\u001a\u00020*R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u001e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u0004\u0018\u00010!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006U"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender;", "Lcom/pedro/rtsp/rtp/packets/VideoPacketCallback;", "Lcom/pedro/rtsp/rtp/packets/AudioPacketCallback;", "connectCheckerRtsp", "Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;", "(Lcom/pedro/rtsp/utils/ConnectCheckerRtsp;)V", "aacPacket", "Lcom/pedro/rtsp/rtp/packets/AacPacket;", "audioFramesSent", "", "baseSenderReport", "Lcom/pedro/rtsp/rtcp/BaseSenderReport;", "bitrateManager", "Lcom/pedro/rtsp/utils/BitrateManager;", "defaultCacheSize", "", "getDefaultCacheSize", "()I", "<set-?>", "droppedAudioFrames", "getDroppedAudioFrames", "()J", "droppedVideoFrames", "getDroppedVideoFrames", "isEnableLogs", "", "rtpFrameBlockingQueue", "Ljava/util/concurrent/BlockingQueue;", "Lcom/pedro/rtsp/rtsp/RtpFrame;", "rtpSocket", "Lcom/pedro/rtsp/rtp/sockets/BaseRtpSocket;", "running", "thread", "Landroid/os/HandlerThread;", "videoFramesSent", "videoPacket", "Lcom/pedro/rtsp/rtp/packets/BasePacket;", "getCacheSize", "getSentAudioFrames", "getSentVideoFrames", "hasCongestion", "onAudioFrameCreated", "", "rtpFrame", "onVideoFrameCreated", "resetDroppedAudioFrames", "resetDroppedVideoFrames", "resetSentAudioFrames", "resetSentVideoFrames", "resizeCache", "newSize", "sendAudioFrame", "aacBuffer", "Ljava/nio/ByteBuffer;", "info", "Landroid/media/MediaCodec$BufferInfo;", "sendVideoFrame", "h264Buffer", "setAudioInfo", "sampleRate", "setAudioPorts", "rtpPort", "rtcpPort", "setDataStream", "outputStream", "Ljava/io/OutputStream;", "host", "", "setLogs", "enable", "setSocketsInfo", "protocol", "Lcom/pedro/rtsp/rtsp/Protocol;", "videoSourcePorts", "", "audioSourcePorts", "setVideoInfo", "sps", "", "pps", "vps", "setVideoPorts", "start", "stop", "Companion", "rtsp_release"})
public final class RtspSender
implements VideoPacketCallback,
AudioPacketCallback {
    private BasePacket videoPacket;
    private AacPacket aacPacket;
    private BaseRtpSocket rtpSocket;
    private BaseSenderReport baseSenderReport;
    private boolean running;
    private volatile BlockingQueue<RtpFrame> rtpFrameBlockingQueue;
    private HandlerThread thread;
    private long audioFramesSent;
    private long videoFramesSent;
    private long droppedAudioFrames;
    private long droppedVideoFrames;
    private final BitrateManager bitrateManager;
    private boolean isEnableLogs;
    private final ConnectCheckerRtsp connectCheckerRtsp;
    private static final String TAG = "RtspSender";
    public static final Companion Companion = new Companion(null);

    public final long getDroppedAudioFrames() {
        return this.droppedAudioFrames;
    }

    public final long getDroppedVideoFrames() {
        return this.droppedVideoFrames;
    }

    public final void setSocketsInfo(@NotNull Protocol protocol, @NotNull int[] videoSourcePorts, @NotNull int[] audioSourcePorts) {
        Intrinsics.checkNotNullParameter((Object)((Object)protocol), (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)videoSourcePorts, (String)"videoSourcePorts");
        Intrinsics.checkNotNullParameter((Object)audioSourcePorts, (String)"audioSourcePorts");
        this.rtpSocket = BaseRtpSocket.Companion.getInstance(protocol, videoSourcePorts[0], audioSourcePorts[0]);
        this.baseSenderReport = BaseSenderReport.Companion.getInstance(protocol, videoSourcePorts[1], audioSourcePorts[1]);
    }

    public final void setVideoInfo(@NotNull byte[] sps, @NotNull byte[] pps, @Nullable byte[] vps) {
        Intrinsics.checkNotNullParameter((Object)sps, (String)"sps");
        Intrinsics.checkNotNullParameter((Object)pps, (String)"pps");
        this.videoPacket = vps == null ? (BasePacket)new H264Packet(sps, pps, this) : (BasePacket)new H265Packet(sps, pps, vps, this);
    }

    public final void setAudioInfo(int sampleRate) {
        this.aacPacket = new AacPacket(sampleRate, this);
    }

    private final int getDefaultCacheSize() {
        return 8065;
    }

    public final void setDataStream(@NotNull OutputStream outputStream, @NotNull String host) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)outputStream, (String)"outputStream");
            Intrinsics.checkNotNullParameter((Object)host, (String)"host");
            BaseRtpSocket baseRtpSocket = this.rtpSocket;
            if (baseRtpSocket != null) {
                baseRtpSocket.setDataStream(outputStream, host);
            }
            BaseSenderReport baseSenderReport = this.baseSenderReport;
            if (baseSenderReport == null) break block1;
            baseSenderReport.setDataStream(outputStream, host);
        }
    }

    public final void setVideoPorts(int rtpPort, int rtcpPort) {
        block0: {
            BasePacket basePacket = this.videoPacket;
            if (basePacket == null) break block0;
            basePacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void setAudioPorts(int rtpPort, int rtcpPort) {
        block0: {
            AacPacket aacPacket = this.aacPacket;
            if (aacPacket == null) break block0;
            aacPacket.setPorts(rtpPort, rtcpPort);
        }
    }

    public final void sendVideoFrame(@NotNull ByteBuffer h264Buffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)h264Buffer, (String)"h264Buffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            BasePacket basePacket = this.videoPacket;
            if (basePacket != null) {
                basePacket.createAndSendPacket(h264Buffer, info);
            }
        }
    }

    public final void sendAudioFrame(@NotNull ByteBuffer aacBuffer, @NotNull MediaCodec.BufferInfo info) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)aacBuffer, (String)"aacBuffer");
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            if (!this.running) break block1;
            AacPacket aacPacket = this.aacPacket;
            if (aacPacket != null) {
                aacPacket.createAndSendPacket(aacBuffer, info);
            }
        }
    }

    @Override
    public void onVideoFrameCreated(@NotNull RtpFrame rtpFrame) {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Video frame discarded");
            long l = this.droppedVideoFrames;
            this.droppedVideoFrames = l + 1L;
        }
    }

    @Override
    public void onAudioFrameCreated(@NotNull RtpFrame rtpFrame) {
        Intrinsics.checkNotNullParameter((Object)rtpFrame, (String)"rtpFrame");
        try {
            this.rtpFrameBlockingQueue.add(rtpFrame);
        }
        catch (IllegalStateException e) {
            Log.i((String)TAG, (String)"Audio frame discarded");
            long l = this.droppedAudioFrames;
            this.droppedAudioFrames = l + 1L;
        }
    }

    public final void start() {
        block1: {
            HandlerThread handlerThread = this.thread = new HandlerThread(TAG);
            if (handlerThread != null) {
                handlerThread.start();
            }
            HandlerThread handlerThread2 = this.thread;
            if (handlerThread2 == null) break block1;
            HandlerThread handlerThread3 = handlerThread2;
            boolean bl = false;
            boolean bl2 = false;
            HandlerThread it = handlerThread3;
            boolean bl3 = false;
            Handler h = new Handler(it.getLooper());
            this.running = true;
            h.post(new Runnable(this){
                final /* synthetic */ RtspSender this$0;
                {
                    this.this$0 = rtspSender;
                }

                public final void run() {
                    while (!Thread.interrupted()) {
                        try {
                            long l;
                            RtpFrame rtpFrame = (RtpFrame)RtspSender.access$getRtpFrameBlockingQueue$p(this.this$0).poll(1L, TimeUnit.SECONDS);
                            if (rtpFrame == null) {
                                Log.i((String)"RtspSender", (String)"Skipping iteration, frame null");
                                continue;
                            }
                            BaseRtpSocket baseRtpSocket = RtspSender.access$getRtpSocket$p(this.this$0);
                            if (baseRtpSocket != null) {
                                baseRtpSocket.sendFrame(rtpFrame, RtspSender.access$isEnableLogs$p(this.this$0));
                            }
                            RtspSender.access$getBitrateManager$p(this.this$0).calculateBitrate((long)rtpFrame.getLength() * (long)8);
                            if (rtpFrame.isVideoFrame()) {
                                RtspSender rtspSender = this.this$0;
                                l = RtspSender.access$getVideoFramesSent$p(rtspSender);
                                RtspSender.access$setVideoFramesSent$p(rtspSender, l + 1L);
                            } else {
                                RtspSender rtspSender = this.this$0;
                                l = RtspSender.access$getAudioFramesSent$p(rtspSender);
                                RtspSender.access$setAudioFramesSent$p(rtspSender, l + 1L);
                            }
                            BaseSenderReport baseSenderReport = RtspSender.access$getBaseSenderReport$p(this.this$0);
                            if (baseSenderReport == null) continue;
                            baseSenderReport.update(rtpFrame, RtspSender.access$isEnableLogs$p(this.this$0));
                        }
                        catch (Exception e) {
                            if (!(e instanceof InterruptedException)) {
                                RtspSender.access$getConnectCheckerRtsp$p(this.this$0).onConnectionFailedRtsp("Error send packet, " + e.getMessage());
                            }
                            Log.e((String)"RtspSender", (String)"send error: ", (Throwable)e);
                            return;
                        }
                    }
                }
            });
        }
    }

    public final void stop() {
        HandlerThread handlerThread;
        this.running = false;
        Object object = this.thread;
        if (object != null && (object = object.getLooper()) != null && (object = object.getThread()) != null) {
            ((Thread)object).interrupt();
        }
        if ((handlerThread = this.thread) != null && (handlerThread = handlerThread.getLooper()) != null) {
            handlerThread.quit();
        }
        HandlerThread handlerThread2 = this.thread;
        if (handlerThread2 != null) {
            handlerThread2.quit();
        }
        try {
            HandlerThread handlerThread3 = this.thread;
            if (handlerThread3 != null) {
                handlerThread3.join(100L);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.thread = null;
        this.rtpFrameBlockingQueue.clear();
        BaseSenderReport baseSenderReport = this.baseSenderReport;
        if (baseSenderReport != null) {
            baseSenderReport.reset();
        }
        BaseSenderReport baseSenderReport2 = this.baseSenderReport;
        if (baseSenderReport2 != null) {
            baseSenderReport2.close();
        }
        BaseRtpSocket baseRtpSocket = this.rtpSocket;
        if (baseRtpSocket != null) {
            baseRtpSocket.close();
        }
        AacPacket aacPacket = this.aacPacket;
        if (aacPacket != null) {
            aacPacket.reset();
        }
        BasePacket basePacket = this.videoPacket;
        if (basePacket != null) {
            basePacket.reset();
        }
        this.resetSentAudioFrames();
        this.resetSentVideoFrames();
        this.resetDroppedAudioFrames();
        this.resetDroppedVideoFrames();
    }

    public final boolean hasCongestion() {
        float remaining;
        float capacity;
        float size = this.rtpFrameBlockingQueue.size();
        return size >= (capacity = size + (remaining = (float)this.rtpFrameBlockingQueue.remainingCapacity())) * 0.2f;
    }

    public final void resizeCache(int newSize) {
        if (newSize < this.rtpFrameBlockingQueue.size() - this.rtpFrameBlockingQueue.remainingCapacity()) {
            throw (Throwable)new RuntimeException("Can't fit current cache inside new cache size");
        }
        BlockingQueue tempQueue = new LinkedBlockingQueue(newSize);
        this.rtpFrameBlockingQueue.drainTo(tempQueue);
        this.rtpFrameBlockingQueue = tempQueue;
    }

    public final int getCacheSize() {
        return this.rtpFrameBlockingQueue.size();
    }

    public final long getSentAudioFrames() {
        return this.audioFramesSent;
    }

    public final long getSentVideoFrames() {
        return this.videoFramesSent;
    }

    public final void resetSentAudioFrames() {
        this.audioFramesSent = 0L;
    }

    public final void resetSentVideoFrames() {
        this.videoFramesSent = 0L;
    }

    public final void resetDroppedAudioFrames() {
        this.droppedAudioFrames = 0L;
    }

    public final void resetDroppedVideoFrames() {
        this.droppedVideoFrames = 0L;
    }

    public final void setLogs(boolean enable) {
        this.isEnableLogs = enable;
    }

    public RtspSender(@NotNull ConnectCheckerRtsp connectCheckerRtsp) {
        Intrinsics.checkNotNullParameter((Object)connectCheckerRtsp, (String)"connectCheckerRtsp");
        this.connectCheckerRtsp = connectCheckerRtsp;
        this.rtpFrameBlockingQueue = new LinkedBlockingQueue(this.getDefaultCacheSize());
        this.bitrateManager = new BitrateManager(this.connectCheckerRtsp);
        this.isEnableLogs = true;
    }

    public static final /* synthetic */ BlockingQueue access$getRtpFrameBlockingQueue$p(RtspSender $this) {
        return $this.rtpFrameBlockingQueue;
    }

    public static final /* synthetic */ void access$setRtpFrameBlockingQueue$p(RtspSender $this, BlockingQueue blockingQueue) {
        $this.rtpFrameBlockingQueue = blockingQueue;
    }

    public static final /* synthetic */ BaseRtpSocket access$getRtpSocket$p(RtspSender $this) {
        return $this.rtpSocket;
    }

    public static final /* synthetic */ void access$setRtpSocket$p(RtspSender $this, BaseRtpSocket baseRtpSocket) {
        $this.rtpSocket = baseRtpSocket;
    }

    public static final /* synthetic */ boolean access$isEnableLogs$p(RtspSender $this) {
        return $this.isEnableLogs;
    }

    public static final /* synthetic */ void access$setEnableLogs$p(RtspSender $this, boolean bl) {
        $this.isEnableLogs = bl;
    }

    public static final /* synthetic */ BitrateManager access$getBitrateManager$p(RtspSender $this) {
        return $this.bitrateManager;
    }

    public static final /* synthetic */ long access$getVideoFramesSent$p(RtspSender $this) {
        return $this.videoFramesSent;
    }

    public static final /* synthetic */ void access$setVideoFramesSent$p(RtspSender $this, long l) {
        $this.videoFramesSent = l;
    }

    public static final /* synthetic */ long access$getAudioFramesSent$p(RtspSender $this) {
        return $this.audioFramesSent;
    }

    public static final /* synthetic */ void access$setAudioFramesSent$p(RtspSender $this, long l) {
        $this.audioFramesSent = l;
    }

    public static final /* synthetic */ BaseSenderReport access$getBaseSenderReport$p(RtspSender $this) {
        return $this.baseSenderReport;
    }

    public static final /* synthetic */ void access$setBaseSenderReport$p(RtspSender $this, BaseSenderReport baseSenderReport) {
        $this.baseSenderReport = baseSenderReport;
    }

    public static final /* synthetic */ ConnectCheckerRtsp access$getConnectCheckerRtsp$p(RtspSender $this) {
        return $this.connectCheckerRtsp;
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/pedro/rtsp/rtsp/RtspSender$Companion;", "", "()V", "TAG", "", "rtsp_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

