/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.AudioPacketCallback;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.nio.ByteBuffer;

public class AacPacket
extends BasePacket {
    private AudioPacketCallback audioPacketCallback;

    public AacPacket(int sampleRate, AudioPacketCallback audioPacketCallback) {
        super(sampleRate);
        this.audioPacketCallback = audioPacketCallback;
        this.channelIdentifier = 0;
    }

    @Override
    public void createAndSendPacket(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        int length = bufferInfo.size - byteBuffer.position();
        if (length > 0) {
            byte[] buffer = this.getBuffer(length + 12 + 4);
            byteBuffer.get(buffer, 16, length);
            long ts = bufferInfo.presentationTimeUs * 1000L;
            this.markPacket(buffer);
            this.updateTimeStamp(buffer, ts);
            buffer[12] = 0;
            buffer[13] = 16;
            buffer[14] = (byte)(length >> 5);
            buffer[15] = (byte)(length << 3);
            buffer[15] = (byte)(buffer[15] & 0xF8);
            buffer[15] = (byte)(buffer[15] | 0);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, ts, 12 + length + 4, this.rtpPort, this.rtcpPort, this.channelIdentifier);
            this.audioPacketCallback.onAudioFrameCreated(rtpFrame);
        }
    }
}

