/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.packets;

import android.media.MediaCodec;
import com.pedro.rtsp.rtp.packets.BasePacket;
import com.pedro.rtsp.rtp.packets.VideoPacketCallback;
import com.pedro.rtsp.rtsp.RtpFrame;
import java.nio.ByteBuffer;

public class H265Packet
extends BasePacket {
    private byte[] header = new byte[6];
    private byte[] stapA;
    private VideoPacketCallback videoPacketCallback;

    public H265Packet(byte[] sps, byte[] pps, byte[] vps, VideoPacketCallback videoPacketCallback) {
        super(90000L);
        this.videoPacketCallback = videoPacketCallback;
        this.channelIdentifier = (byte)2;
        this.setSpsPpsVps(sps, pps, vps);
    }

    @Override
    public void createAndSendPacket(ByteBuffer byteBuffer, MediaCodec.BufferInfo bufferInfo) {
        byteBuffer.rewind();
        byteBuffer.get(this.header, 0, 6);
        long ts = bufferInfo.presentationTimeUs * 1000L;
        int naluLength = bufferInfo.size - byteBuffer.position() + 1;
        int type = this.header[4] >> 1 & 0x3F;
        if (type == 20 || type == 19) {
            byte[] buffer = this.getBuffer(this.stapA.length + 12);
            this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            System.arraycopy(this.stapA, 0, buffer, 12, this.stapA.length);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, ts, this.stapA.length + 12, this.rtpPort, this.rtcpPort, this.channelIdentifier);
            this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
        }
        if (naluLength <= 1257) {
            int cont = naluLength - 1;
            int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
            byte[] buffer = this.getBuffer(length + 12 + 2);
            buffer[12] = this.header[4];
            buffer[13] = this.header[5];
            byteBuffer.get(buffer, 14, length);
            this.updateTimeStamp(buffer, ts);
            this.markPacket(buffer);
            this.updateSeq(buffer);
            RtpFrame rtpFrame = new RtpFrame(buffer, ts, naluLength + 12, this.rtpPort, this.rtcpPort, this.channelIdentifier);
            this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
        } else {
            this.header[0] = 98;
            this.header[1] = 1;
            this.header[2] = (byte)type;
            this.header[2] = (byte)(this.header[2] + 128);
            int sum = 1;
            while (sum < naluLength) {
                int cont = naluLength - sum > 1257 ? 1257 : naluLength - sum;
                int length = cont < bufferInfo.size - byteBuffer.position() ? cont : bufferInfo.size - byteBuffer.position();
                byte[] buffer = this.getBuffer(length + 12 + 3);
                buffer[12] = this.header[0];
                buffer[13] = this.header[1];
                buffer[14] = this.header[2];
                this.updateTimeStamp(buffer, ts);
                byteBuffer.get(buffer, 15, length);
                if ((sum += length) >= naluLength) {
                    buffer[14] = (byte)(buffer[14] + 64);
                    this.markPacket(buffer);
                }
                this.updateSeq(buffer);
                RtpFrame rtpFrame = new RtpFrame(buffer, ts, length + 12 + 3, this.rtpPort, this.rtcpPort, this.channelIdentifier);
                this.videoPacketCallback.onVideoFrameCreated(rtpFrame);
                this.header[2] = (byte)(this.header[2] & 0x7F);
            }
        }
    }

    private void setSpsPpsVps(byte[] sps, byte[] pps, byte[] vps) {
        this.stapA = new byte[sps.length + pps.length + 6];
        this.stapA[0] = 96;
        this.stapA[1] = 1;
        this.stapA[2] = (byte)(sps.length >> 8);
        this.stapA[3] = (byte)(sps.length & 0xFF);
        this.stapA[sps.length + 4] = (byte)(pps.length >> 8);
        this.stapA[sps.length + 5] = (byte)(pps.length & 0xFF);
        System.arraycopy(sps, 0, this.stapA, 4, sps.length);
        System.arraycopy(pps, 0, this.stapA, 6 + sps.length, pps.length);
    }
}

