/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtsp.rtp.sockets;

import android.util.Log;
import com.pedro.rtsp.rtp.sockets.BaseRtpSocket;
import com.pedro.rtsp.rtsp.RtpFrame;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.UnknownHostException;

public class RtpSocketUdp
extends BaseRtpSocket {
    private MulticastSocket multicastSocket;
    private DatagramPacket datagramPacket = new DatagramPacket(new byte[]{0}, 1);

    public RtpSocketUdp(ConnectCheckerRtsp connectCheckerRtsp) {
        super(connectCheckerRtsp);
        try {
            this.multicastSocket = new MulticastSocket();
            this.multicastSocket.setTimeToLive(64);
        }
        catch (IOException e) {
            Log.e((String)"BaseRtpSocket", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void setDataStream(OutputStream outputStream, String host) {
        try {
            this.datagramPacket.setAddress(InetAddress.getByName(host));
        }
        catch (UnknownHostException e) {
            Log.e((String)"BaseRtpSocket", (String)"Error", (Throwable)e);
        }
    }

    @Override
    public void sendFrame(RtpFrame rtpFrame) {
        try {
            this.sendFrameUDP(rtpFrame);
        }
        catch (IOException e) {
            Log.e((String)"BaseRtpSocket", (String)"TCP send error: ", (Throwable)e);
            this.connectCheckerRtsp.onConnectionFailedRtsp("Error send packet, " + e.getMessage());
        }
    }

    @Override
    public void close() {
        this.multicastSocket.close();
    }

    private void sendFrameUDP(RtpFrame rtpFrame) throws IOException {
        this.datagramPacket.setData(rtpFrame.getBuffer());
        this.datagramPacket.setPort(rtpFrame.getRtpPort());
        this.datagramPacket.setLength(rtpFrame.getLength());
        this.multicastSocket.send(this.datagramPacket);
        Log.i((String)"BaseRtpSocket", (String)("wrote packet: " + (rtpFrame.getChannelIdentifier() == 2 ? "Video" : "Audio") + ", size: " + rtpFrame.getLength() + ", port: " + rtpFrame.getRtpPort()));
    }
}

