/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util.sources;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.display.VirtualDisplay;
import android.media.projection.MediaProjection;
import android.util.Range;
import android.util.Size;
import android.view.MotionEvent;
import android.view.Surface;
import androidx.annotation.RequiresApi;
import com.pedro.encoder.input.video.Camera1ApiManager;
import com.pedro.encoder.input.video.Camera2ApiManager;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtplibrary.util.sources.NoSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001:\u0001<B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u001c\u001a\u00020\u001aJ \u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001e\u0010\u001f\u001a\u00020\u001e2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010 \u001a\u00020\u001aJ\u0006\u0010!\u001a\u00020\u001aJ\u0006\u0010\"\u001a\u00020\u001aJ\u0006\u0010#\u001a\u00020\u001aJ\u0006\u0010$\u001a\u00020\fJ\u001c\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fJ\u0006\u0010(\u001a\u00020\u000eJ\u0006\u0010)\u001a\u00020*J\f\u0010+\u001a\b\u0012\u0004\u0012\u00020*0,J\u0006\u0010-\u001a\u00020\u001eJ\u0006\u0010.\u001a\u00020\u001eJ\u0006\u0010/\u001a\u00020\u001eJ \u00100\u001a\b\u0012\u0004\u0012\u00020'0&2\u0010\u00101\u001a\f\u0012\b\u0012\u000602R\u0002030&H\u0002J\u000e\u00104\u001a\u00020\u001a2\u0006\u00105\u001a\u00020\u000eJ\u000e\u00106\u001a\u00020\u001a2\u0006\u00107\u001a\u000208J\u000e\u00106\u001a\u00020\u001a2\u0006\u00105\u001a\u00020*J\u000e\u00109\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010:\u001a\u00020\u001aJ\u0006\u0010;\u001a\u00020\u001aR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/pedro/rtplibrary/util/sources/VideoManager;", "", "context", "Landroid/content/Context;", "source", "Lcom/pedro/rtplibrary/util/sources/VideoManager$Source;", "(Landroid/content/Context;Lcom/pedro/rtplibrary/util/sources/VideoManager$Source;)V", "camera1", "Lcom/pedro/encoder/input/video/Camera1ApiManager;", "camera2", "Lcom/pedro/encoder/input/video/Camera2ApiManager;", "facing", "Lcom/pedro/encoder/input/video/CameraHelper$Facing;", "fps", "", "height", "mediaProjection", "Landroid/media/projection/MediaProjection;", "noSource", "Lcom/pedro/rtplibrary/util/sources/NoSource;", "surfaceTexture", "Landroid/graphics/SurfaceTexture;", "virtualDisplay", "Landroid/hardware/display/VirtualDisplay;", "width", "changeSourceCamera", "", "changeSourceScreen", "changeVideoSourceDisabled", "checkResolutionSupported", "", "createVideoManager", "disableAutoFocus", "disableLantern", "enableAutoFocus", "enableLantern", "getCameraFacing", "getCameraResolutions", "", "Landroid/util/Size;", "getExposure", "getZoom", "", "getZoomRange", "Landroid/util/Range;", "isAutoFocusEnabled", "isLanternEnabled", "isRunning", "mapCamera1Resolutions", "resolutions", "Landroid/hardware/Camera$Size;", "Landroid/hardware/Camera;", "setExposure", "level", "setZoom", "event", "Landroid/view/MotionEvent;", "start", "stop", "switchCamera", "Source", "rtplibrary_release"})
@RequiresApi(value=21)
@SourceDebugExtension(value={"SMAP\nVideoManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoManager.kt\ncom/pedro/rtplibrary/util/sources/VideoManager\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,411:1\n11335#2:412\n11670#2,3:413\n11335#2:416\n11670#2,3:417\n1549#3:420\n1620#3,3:421\n*S KotlinDebug\n*F\n+ 1 VideoManager.kt\ncom/pedro/rtplibrary/util/sources/VideoManager\n*L\n394#1:412\n394#1:413,3\n395#1:416\n395#1:417,3\n410#1:420\n410#1:421,3\n*E\n"})
public final class VideoManager {
    @NotNull
    private final Context context;
    @NotNull
    private Source source;
    @NotNull
    private CameraHelper.Facing facing;
    @NotNull
    private final Camera1ApiManager camera1;
    @NotNull
    private final Camera2ApiManager camera2;
    @Nullable
    private MediaProjection mediaProjection;
    @Nullable
    private VirtualDisplay virtualDisplay;
    @NotNull
    private final NoSource noSource;
    @Nullable
    private SurfaceTexture surfaceTexture;
    private int width;
    private int height;
    private int fps;

    public VideoManager(@NotNull Context context, @NotNull Source source) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        this.context = context;
        this.source = source;
        this.facing = CameraHelper.Facing.BACK;
        this.camera1 = new Camera1ApiManager(null, this.context);
        this.camera2 = new Camera2ApiManager(this.context);
        this.noSource = new NoSource();
    }

    public final boolean createVideoManager(int width, int height, int fps) {
        this.width = width;
        this.height = height;
        this.fps = fps;
        return this.checkResolutionSupported(width, height, this.source);
    }

    public final void changeSourceCamera(@NotNull Source source) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
            if (source == Source.SCREEN || source == Source.DISABLED) {
                throw new IllegalArgumentException("Invalid " + source.name() + ". Only CAMERA1 or CAMERA2 is accepted.");
            }
            if (this.source == source) break block5;
            if (!this.checkResolutionSupported(this.width, this.height, source)) {
                throw new IllegalArgumentException("Resolution " + this.width + 'x' + this.height + " is not supported for " + source.name() + '.');
            }
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = source;
            MediaProjection mediaProjection = this.mediaProjection;
            if (mediaProjection != null) {
                mediaProjection.stop();
            }
            this.mediaProjection = null;
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                if (wasRunning) {
                    this.start(it);
                }
            }
        }
    }

    public final void changeSourceScreen(@NotNull MediaProjection mediaProjection) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)mediaProjection, (String)"mediaProjection");
            if (this.source == Source.SCREEN && this.mediaProjection != null) break block2;
            this.mediaProjection = mediaProjection;
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = Source.SCREEN;
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                if (wasRunning) {
                    this.start(it);
                }
            }
        }
    }

    public final void changeVideoSourceDisabled() {
        block3: {
            if (this.source == Source.DISABLED) break block3;
            boolean wasRunning = this.isRunning();
            this.stop();
            this.source = Source.DISABLED;
            MediaProjection mediaProjection = this.mediaProjection;
            if (mediaProjection != null) {
                mediaProjection.stop();
            }
            this.mediaProjection = null;
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                if (wasRunning) {
                    this.start(it);
                }
            }
        }
    }

    public final void start(@NotNull SurfaceTexture surfaceTexture) {
        Intrinsics.checkNotNullParameter((Object)surfaceTexture, (String)"surfaceTexture");
        this.surfaceTexture = surfaceTexture;
        if (!this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    surfaceTexture.setDefaultBufferSize(this.width, this.height);
                    this.camera1.setSurfaceTexture(surfaceTexture);
                    this.camera1.start(this.facing, this.width, this.height, this.fps);
                    this.camera1.setPreviewOrientation(90);
                    break;
                }
                case 2: {
                    surfaceTexture.setDefaultBufferSize(this.width, this.height);
                    this.camera2.prepareCamera(surfaceTexture, this.width, this.height, this.fps, this.facing);
                    this.camera2.openCameraFacing(this.facing);
                    break;
                }
                case 3: {
                    int displayHeight;
                    int dpi = this.context.getResources().getDisplayMetrics().densityDpi;
                    int flags = 16;
                    int VIRTUAL_DISPLAY_FLAG_ROTATES_WITH_CONTENT = 128;
                    flags += VIRTUAL_DISPLAY_FLAG_ROTATES_WITH_CONTENT;
                    boolean shouldRotate = this.width > this.height;
                    int displayWidth = shouldRotate ? this.height : this.width;
                    int n = displayHeight = shouldRotate ? this.width : this.height;
                    if (shouldRotate) {
                        surfaceTexture.setDefaultBufferSize(this.height, this.width);
                    }
                    MediaProjection mediaProjection = this.mediaProjection;
                    this.virtualDisplay = mediaProjection != null ? mediaProjection.createVirtualDisplay("VideoManagerScreen", displayWidth, displayHeight, dpi, flags, new Surface(surfaceTexture), null, null) : null;
                    break;
                }
                case 4: {
                    this.noSource.start();
                }
            }
        }
    }

    public final void stop() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.stop();
                    break;
                }
                case 2: {
                    this.camera2.closeCamera();
                    break;
                }
                case 3: {
                    VirtualDisplay virtualDisplay = this.virtualDisplay;
                    if (virtualDisplay != null) {
                        virtualDisplay.release();
                    }
                    this.virtualDisplay = null;
                    break;
                }
                case 4: {
                    this.noSource.stop();
                }
            }
        }
    }

    public final void setExposure(int level) {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.setExposure(level);
                    break;
                }
                case 2: {
                    this.camera2.setExposure(level);
                }
            }
        }
    }

    public final int getExposure() {
        if (this.isRunning()) {
            int n;
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    n = this.camera1.getExposure();
                    break;
                }
                case 2: {
                    n = this.camera2.getExposure();
                    break;
                }
                default: {
                    n = 0;
                }
            }
            return n;
        }
        return 0;
    }

    public final void enableLantern() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.enableLantern();
                    break;
                }
                case 2: {
                    this.camera2.enableLantern();
                }
            }
        }
    }

    public final void disableLantern() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.disableLantern();
                    break;
                }
                case 2: {
                    this.camera2.disableLantern();
                }
            }
        }
    }

    public final boolean isLanternEnabled() {
        if (this.isRunning()) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    bl = this.camera1.isLanternEnabled();
                    break;
                }
                case 2: {
                    bl = this.camera2.isLanternEnabled();
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    public final void enableAutoFocus() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.enableAutoFocus();
                    break;
                }
                case 2: {
                    this.camera2.enableAutoFocus();
                }
            }
        }
    }

    public final void disableAutoFocus() {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.disableAutoFocus();
                    break;
                }
                case 2: {
                    this.camera2.disableAutoFocus();
                }
            }
        }
    }

    public final boolean isAutoFocusEnabled() {
        if (this.isRunning()) {
            boolean bl;
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    bl = this.camera1.isAutoFocusEnabled();
                    break;
                }
                case 2: {
                    bl = this.camera2.isAutoFocusEnabled();
                    break;
                }
                default: {
                    bl = false;
                }
            }
            return bl;
        }
        return false;
    }

    public final void setZoom(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.setZoom(event);
                    break;
                }
                case 2: {
                    this.camera2.setZoom(event);
                }
            }
        }
    }

    public final void setZoom(float level) {
        if (this.isRunning()) {
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    this.camera1.setZoom((int)level);
                    break;
                }
                case 2: {
                    this.camera2.setZoom(level);
                }
            }
        }
    }

    @NotNull
    public final Range<Float> getZoomRange() {
        if (this.isRunning()) {
            Range range;
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    range = new Range((Comparable)Float.valueOf(this.camera1.getMinZoom()), (Comparable)Float.valueOf(this.camera1.getMaxZoom()));
                    break;
                }
                case 2: {
                    Range range2 = this.camera2.getZoomRange();
                    range = range2;
                    Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"{\n          camera2.zoomRange\n        }");
                    break;
                }
                default: {
                    range = new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
                }
            }
            return range;
        }
        return new Range((Comparable)Float.valueOf(0.0f), (Comparable)Float.valueOf(0.0f));
    }

    public final float getZoom() {
        if (this.isRunning()) {
            float f;
            switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
                case 1: {
                    f = this.camera1.getZoom();
                    break;
                }
                case 2: {
                    Float f2 = this.camera2.getZoom();
                    Intrinsics.checkNotNullExpressionValue((Object)f2, (String)"{\n          camera2.zoom\n        }");
                    f = ((Number)f2).floatValue();
                    break;
                }
                default: {
                    f = 0.0f;
                }
            }
            return f;
        }
        return 0.0f;
    }

    public final void switchCamera() {
        block2: {
            if (this.source == Source.SCREEN || this.source == Source.DISABLED) {
                return;
            }
            CameraHelper.Facing facing = this.facing = this.facing == CameraHelper.Facing.BACK ? CameraHelper.Facing.FRONT : CameraHelper.Facing.BACK;
            if (!this.isRunning()) break block2;
            this.stop();
            SurfaceTexture surfaceTexture = this.surfaceTexture;
            if (surfaceTexture != null) {
                SurfaceTexture it = surfaceTexture;
                boolean bl = false;
                this.start(it);
            }
        }
    }

    @NotNull
    public final CameraHelper.Facing getCameraFacing() {
        return this.facing;
    }

    public final boolean isRunning() {
        boolean bl;
        switch (WhenMappings.$EnumSwitchMapping$0[this.source.ordinal()]) {
            case 1: {
                bl = this.camera1.isRunning();
                break;
            }
            case 2: {
                bl = this.camera2.isRunning();
                break;
            }
            case 3: {
                if (this.virtualDisplay != null) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case 4: {
                bl = this.noSource.isRunning();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public final List<Size> getCameraResolutions(@NotNull Source source, @NotNull CameraHelper.Facing facing) {
        List<Size> list;
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Intrinsics.checkNotNullParameter((Object)facing, (String)"facing");
        switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
            case 1: {
                List resolutions = facing == CameraHelper.Facing.FRONT ? this.camera1.getPreviewSizeFront() : this.camera1.getPreviewSizeBack();
                Intrinsics.checkNotNullExpressionValue((Object)resolutions, (String)"resolutions");
                list = this.mapCamera1Resolutions(resolutions);
                break;
            }
            case 2: {
                Object[] resolutions = facing == CameraHelper.Facing.FRONT ? this.camera2.getCameraResolutionsFront() : this.camera2.getCameraResolutionsBack();
                Intrinsics.checkNotNullExpressionValue((Object)resolutions, (String)"resolutions");
                list = ArraysKt.toList((Object[])resolutions);
                break;
            }
            default: {
                list = CollectionsKt.emptyList();
            }
        }
        return list;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkResolutionSupported(int width, int height, Source source) {
        if (width % 2 != 0) throw new IllegalArgumentException("width and height values must be divisible by 2");
        if (height % 2 != 0) {
            throw new IllegalArgumentException("width and height values must be divisible by 2");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[source.ordinal()]) {
            case 1: {
                boolean shouldRotate = width > height;
                int w = shouldRotate ? height : width;
                int h = shouldRotate ? width : height;
                Size size = new Size(w, h);
                List resolutions = this.facing == CameraHelper.Facing.BACK ? this.camera1.getPreviewSizeBack() : this.camera1.getPreviewSizeFront();
                Intrinsics.checkNotNullExpressionValue((Object)resolutions, (String)"resolutions");
                return this.mapCamera1Resolutions(resolutions).contains(size);
            }
            case 2: {
                Object[] resolutions;
                Size size = new Size(width, height);
                Object[] objectArray = resolutions = this.facing == CameraHelper.Facing.BACK ? this.camera2.getCameraResolutionsBack() : this.camera2.getCameraResolutionsFront();
                if (this.camera2.getLevelSupported() != 2) {
                    void $this$mapTo$iv$iv;
                    Object object;
                    int n;
                    void $this$mapTo$iv$iv2;
                    Intrinsics.checkNotNullExpressionValue((Object)resolutions, (String)"resolutions");
                    Object[] $this$map$iv = resolutions;
                    boolean $i$f$map = false;
                    Object[] objectArray2 = $this$map$iv;
                    Object[] destination$iv$iv = (Object[])new ArrayList($this$map$iv.length);
                    boolean $i$f$mapTo = false;
                    int n2 = ((void)$this$mapTo$iv$iv2).length;
                    for (n = 0; n < n2; ++n) {
                        void item$iv$iv;
                        void var15_27 = item$iv$iv = $this$mapTo$iv$iv2[n];
                        object = destination$iv$iv;
                        boolean bl = false;
                        object.add(size.getWidth());
                    }
                    List widthList = (List)destination$iv$iv;
                    Object[] $this$map$iv2 = resolutions;
                    boolean $i$f$map2 = false;
                    destination$iv$iv = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList($this$map$iv2.length);
                    boolean $i$f$mapTo2 = false;
                    int n3 = ((void)$this$mapTo$iv$iv).length;
                    for (n2 = 0; n2 < n3; ++n2) {
                        void item$iv$iv;
                        void bl = item$iv$iv = $this$mapTo$iv$iv[n2];
                        object = destination$iv$iv2;
                        boolean bl2 = false;
                        object.add(size.getHeight());
                    }
                    List heightList = (List)destination$iv$iv2;
                    Integer n4 = (Integer)CollectionsKt.maxOrNull((Iterable)widthList);
                    int maxWidth = n4 != null ? n4 : 0;
                    Integer n5 = (Integer)CollectionsKt.maxOrNull((Iterable)heightList);
                    int maxHeight = n5 != null ? n5 : 0;
                    Integer n6 = (Integer)CollectionsKt.minOrNull((Iterable)widthList);
                    int minWidth = n6 != null ? n6 : 0;
                    Integer n7 = (Integer)CollectionsKt.minOrNull((Iterable)heightList);
                    int minHeight = n7 != null ? n7 : 0;
                    n = size.getWidth();
                    if (minWidth > n) return false;
                    if (n > maxWidth) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    n = size.getHeight();
                    if (minHeight > n) return false;
                    if (n > maxHeight) return false;
                    return true;
                }
                Intrinsics.checkNotNullExpressionValue((Object)resolutions, (String)"resolutions");
                boolean bl = ArraysKt.contains((Object[])resolutions, (Object)size);
                return bl;
            }
            case 3: 
            case 4: {
                return true;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private final List<Size> mapCamera1Resolutions(List<? extends Camera.Size> resolutions) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = resolutions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Camera.Size size = (Camera.Size)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Size(it.width, it.height));
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/pedro/rtplibrary/util/sources/VideoManager$Source;", "", "(Ljava/lang/String;I)V", "CAMERA1", "CAMERA2", "SCREEN", "DISABLED", "rtplibrary_release"})
    public static final class Source
    extends Enum<Source> {
        public static final /* enum */ Source CAMERA1 = new Source();
        public static final /* enum */ Source CAMERA2 = new Source();
        public static final /* enum */ Source SCREEN = new Source();
        public static final /* enum */ Source DISABLED = new Source();
        private static final /* synthetic */ Source[] $VALUES;

        public static Source[] values() {
            return (Source[])$VALUES.clone();
        }

        public static Source valueOf(String value) {
            return Enum.valueOf(Source.class, value);
        }

        static {
            $VALUES = sourceArray = new Source[]{Source.CAMERA1, Source.CAMERA2, Source.SCREEN, Source.DISABLED};
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Source.values().length];
            try {
                nArray[Source.CAMERA1.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Source.CAMERA2.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Source.SCREEN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Source.DISABLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

