/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.util;

public class BitrateAdapter {
    private int maxBitrate;
    private int oldBitrate;
    private int averageBitrate;
    private int cont;
    private Listener listener;

    public BitrateAdapter(Listener listener) {
        this.listener = listener;
        this.reset();
    }

    public void setMaxBitrate(int bitrate) {
        this.maxBitrate = bitrate;
        this.oldBitrate = bitrate;
        this.reset();
    }

    public void adaptBitrate(long actualBitrate) {
        this.averageBitrate = (int)((long)this.averageBitrate + actualBitrate);
        this.averageBitrate /= 2;
        ++this.cont;
        if (this.cont >= 5 && this.listener != null && this.maxBitrate != 0) {
            this.listener.onBitrateAdapted(this.getBitrateAdapted(this.averageBitrate));
            this.reset();
        }
    }

    private int getBitrateAdapted(int bitrate) {
        if ((double)bitrate < (double)this.oldBitrate * 0.65) {
            this.oldBitrate = (int)((double)this.oldBitrate - (double)this.maxBitrate * 0.1);
            if ((double)this.oldBitrate < (double)this.maxBitrate * 0.1) {
                this.oldBitrate = (int)((double)this.maxBitrate * 0.1);
            }
            return this.oldBitrate;
        }
        this.oldBitrate = (int)((double)this.oldBitrate + (double)this.maxBitrate * 0.1);
        if (this.oldBitrate > this.maxBitrate) {
            this.oldBitrate = this.maxBitrate;
        }
        return this.oldBitrate;
    }

    public void reset() {
        this.averageBitrate = 0;
        this.cont = 0;
    }

    public static interface Listener {
        public void onBitrateAdapted(int var1);
    }
}

