/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.rtsp;

import android.content.Context;
import android.media.MediaCodec;
import android.support.annotation.RequiresApi;
import com.pedro.rtplibrary.base.DisplayBase;
import com.pedro.rtsp.rtsp.Protocol;
import com.pedro.rtsp.rtsp.RtspClient;
import com.pedro.rtsp.rtsp.VideoCodec;
import com.pedro.rtsp.utils.ConnectCheckerRtsp;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public class RtspDisplay
extends DisplayBase {
    private RtspClient rtspClient;

    public RtspDisplay(Context context, boolean useOpengl, ConnectCheckerRtsp connectCheckerRtsp) {
        super(context, useOpengl);
        this.rtspClient = new RtspClient(connectCheckerRtsp);
    }

    public void setProtocol(Protocol protocol) {
        this.rtspClient.setProtocol(protocol);
    }

    public void setVideoCodec(VideoCodec videoCodec) {
        this.videoEncoder.setType(videoCodec == VideoCodec.H265 ? "video/hevc" : "video/avc");
    }

    @Override
    public void setAuthorization(String user, String password) {
        this.rtspClient.setAuthorization(user, password);
    }

    @Override
    protected void prepareAudioRtp(boolean isStereo, int sampleRate) {
        this.rtspClient.setIsStereo(isStereo);
        this.rtspClient.setSampleRate(sampleRate);
    }

    @Override
    protected void startStreamRtp(String url) {
        this.rtspClient.setUrl(url);
    }

    @Override
    protected void stopStreamRtp() {
        this.rtspClient.disconnect();
    }

    @Override
    protected void getAacDataRtp(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendAudio(aacBuffer, info);
    }

    @Override
    protected void onSpsPpsVpsRtp(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        ByteBuffer newSps = sps.duplicate();
        ByteBuffer newPps = pps.duplicate();
        ByteBuffer newVps = vps != null ? vps.duplicate() : null;
        this.rtspClient.setSPSandPPS(newSps, newPps, newVps);
        this.rtspClient.connect();
    }

    @Override
    protected void getH264DataRtp(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        this.rtspClient.sendVideo(h264Buffer, info);
    }
}

