/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import java.nio.ByteBuffer;

public abstract class OnlyAudioBase
implements GetAacData,
GetMicrophoneData {
    private MicrophoneManager microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
    private AudioEncoder audioEncoder = new AudioEncoder((GetAacData)this);
    private boolean streaming = false;

    public abstract void setAuthorization(String var1, String var2);

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    protected abstract void startStreamRtp(String var1);

    public void startStream(String url) {
        this.streaming = true;
        this.audioEncoder.start();
        this.microphoneManager.start();
        this.startStreamRtp(url);
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        this.streaming = false;
        this.stopStreamRtp();
        this.microphoneManager.stop();
        this.audioEncoder.stop();
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        this.getAacDataRtp(aacBuffer, info);
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
    }
}

