/*
 * Decompiled with CFR 0.152.
 */
package com.pedro.rtplibrary.base;

import android.content.Context;
import android.content.Intent;
import android.hardware.display.VirtualDisplay;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.media.MediaMuxer;
import android.media.projection.MediaProjection;
import android.media.projection.MediaProjectionManager;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.view.Surface;
import android.view.SurfaceView;
import com.pedro.encoder.audio.AudioEncoder;
import com.pedro.encoder.audio.GetAacData;
import com.pedro.encoder.input.audio.GetMicrophoneData;
import com.pedro.encoder.input.audio.MicrophoneManager;
import com.pedro.encoder.utils.CodecUtil;
import com.pedro.encoder.video.FormatVideoEncoder;
import com.pedro.encoder.video.GetVideoData;
import com.pedro.encoder.video.VideoEncoder;
import com.pedro.rtplibrary.view.GlInterface;
import com.pedro.rtplibrary.view.OffScreenGlThread;
import java.io.IOException;
import java.nio.ByteBuffer;

@RequiresApi(api=21)
public abstract class DisplayBase
implements GetAacData,
GetVideoData,
GetMicrophoneData {
    private OffScreenGlThread glInterface;
    protected Context context;
    private MediaProjection mediaProjection;
    private MediaProjectionManager mediaProjectionManager;
    protected VideoEncoder videoEncoder;
    private MicrophoneManager microphoneManager;
    private AudioEncoder audioEncoder;
    private boolean streaming = false;
    protected SurfaceView surfaceView;
    private boolean videoEnabled = true;
    private MediaMuxer mediaMuxer;
    private int videoTrack = -1;
    private int audioTrack = -1;
    private boolean recording = false;
    private boolean canRecord = false;
    private MediaFormat videoFormat;
    private MediaFormat audioFormat;
    private int dpi = 320;
    private VirtualDisplay virtualDisplay;
    private int resultCode = -1;
    private Intent data;

    public DisplayBase(Context context, boolean useOpengl) {
        this.context = context;
        if (useOpengl) {
            this.glInterface = new OffScreenGlThread(context);
            this.glInterface.init();
        }
        this.mediaProjectionManager = (MediaProjectionManager)context.getSystemService("media_projection");
        this.surfaceView = null;
        this.videoEncoder = new VideoEncoder((GetVideoData)this);
        this.microphoneManager = new MicrophoneManager((GetMicrophoneData)this);
        this.audioEncoder = new AudioEncoder((GetAacData)this);
    }

    public abstract void setAuthorization(String var1, String var2);

    public boolean prepareVideo(int width, int height, int fps, int bitrate, int rotation, int dpi) {
        this.dpi = dpi;
        boolean result = this.videoEncoder.prepareVideoEncoder(width, height, fps, bitrate, rotation, true, 2, FormatVideoEncoder.SURFACE);
        if (this.glInterface != null) {
            this.glInterface = new OffScreenGlThread(this.context);
            this.glInterface.init();
            this.glInterface.setEncoderSize(this.videoEncoder.getWidth(), this.videoEncoder.getHeight());
        }
        return result;
    }

    protected abstract void prepareAudioRtp(boolean var1, int var2);

    public boolean prepareAudio(int bitrate, int sampleRate, boolean isStereo, boolean echoCanceler, boolean noiseSuppressor) {
        this.microphoneManager.createMicrophone(sampleRate, isStereo, echoCanceler, noiseSuppressor);
        this.prepareAudioRtp(isStereo, sampleRate);
        return this.audioEncoder.prepareAudioEncoder(bitrate, sampleRate, isStereo);
    }

    public boolean prepareVideo() {
        return this.prepareVideo(640, 480, 30, 1228800, 0, 320);
    }

    public boolean prepareAudio() {
        return this.prepareAudio(65536, 32000, true, false, false);
    }

    public void setForce(CodecUtil.Force forceVideo, CodecUtil.Force forceAudio) {
        this.videoEncoder.setForce(forceVideo);
        this.audioEncoder.setForce(forceAudio);
    }

    public void startRecord(String path) throws IOException {
        this.mediaMuxer = new MediaMuxer(path, 0);
        this.recording = true;
        if (!this.streaming) {
            this.startEncoders(this.resultCode, this.data);
        } else if (this.videoEncoder.isRunning()) {
            this.resetVideoEncoder();
        }
    }

    public void stopRecord() {
        this.recording = false;
        if (this.mediaMuxer != null) {
            if (this.canRecord) {
                this.mediaMuxer.stop();
                this.mediaMuxer.release();
                this.canRecord = false;
            }
            this.mediaMuxer = null;
        }
        this.videoTrack = -1;
        this.audioTrack = -1;
        if (!this.streaming) {
            this.stopStream();
        }
    }

    protected abstract void startStreamRtp(String var1);

    public Intent sendIntent() {
        return this.mediaProjectionManager.createScreenCaptureIntent();
    }

    public void setIntentResult(int resultCode, Intent data) {
        this.resultCode = resultCode;
        this.data = data;
    }

    public void startStream(String url) {
        this.streaming = true;
        if (!this.recording) {
            this.startEncoders(this.resultCode, this.data);
        } else {
            this.resetVideoEncoder();
        }
        this.startStreamRtp(url);
    }

    private void startEncoders(int resultCode, Intent data) {
        if (data == null) {
            throw new RuntimeException("You need send intent data before startRecord or startStream");
        }
        this.videoEncoder.start();
        this.audioEncoder.start();
        if (this.glInterface != null) {
            this.glInterface.setFps(this.videoEncoder.getFps());
            this.glInterface.start();
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        Surface surface = this.glInterface != null ? this.glInterface.getSurface() : this.videoEncoder.getInputSurface();
        this.mediaProjection = this.mediaProjectionManager.getMediaProjection(resultCode, data);
        this.virtualDisplay = this.mediaProjection.createVirtualDisplay("Stream Display", this.videoEncoder.getWidth(), this.videoEncoder.getHeight(), this.dpi, 0, surface, null, null);
        this.microphoneManager.start();
    }

    private void resetVideoEncoder() {
        this.virtualDisplay.setSurface(null);
        if (this.glInterface != null) {
            this.glInterface.removeMediaCodecSurface();
        }
        this.videoEncoder.reset();
        if (this.glInterface != null) {
            this.glInterface.addMediaCodecSurface(this.videoEncoder.getInputSurface());
        }
        this.virtualDisplay.setSurface(this.glInterface != null ? this.glInterface.getSurface() : this.videoEncoder.getInputSurface());
    }

    protected abstract void stopStreamRtp();

    public void stopStream() {
        if (this.streaming) {
            this.streaming = false;
            this.stopStreamRtp();
        }
        if (!this.recording) {
            this.microphoneManager.stop();
            if (this.mediaProjection != null) {
                this.mediaProjection.stop();
            }
            if (this.glInterface != null) {
                this.glInterface.removeMediaCodecSurface();
                this.glInterface.stop();
            }
            this.videoEncoder.stop();
            this.audioEncoder.stop();
            this.videoFormat = null;
            this.audioFormat = null;
            this.data = null;
        }
    }

    public GlInterface getGlInterface() {
        if (this.glInterface != null) {
            return this.glInterface;
        }
        throw new RuntimeException("You can't do it. You are not using Opengl");
    }

    public void disableAudio() {
        this.microphoneManager.mute();
    }

    public void enableAudio() {
        this.microphoneManager.unMute();
    }

    public boolean isAudioMuted() {
        return this.microphoneManager.isMuted();
    }

    public boolean isVideoEnabled() {
        return this.videoEnabled;
    }

    public void disableVideo() {
        this.videoEncoder.startSendBlackImage();
        this.videoEnabled = false;
    }

    public void enableVideo() {
        this.videoEncoder.stopSendBlackImage();
        this.videoEnabled = true;
    }

    public int getBitrate() {
        return this.videoEncoder.getBitRate();
    }

    public int getResolutionValue() {
        return this.videoEncoder.getWidth() * this.videoEncoder.getHeight();
    }

    public int getStreamWidth() {
        return this.videoEncoder.getWidth();
    }

    public int getStreamHeight() {
        return this.videoEncoder.getHeight();
    }

    public void setVideoBitrateOnFly(int bitrate) {
        if (Build.VERSION.SDK_INT >= 19) {
            this.videoEncoder.setVideoBitrateOnFly(bitrate);
        }
    }

    public void setLimitFPSOnFly(int fps) {
        this.videoEncoder.setFps(fps);
    }

    public boolean isStreaming() {
        return this.streaming;
    }

    public boolean isRecording() {
        return this.recording;
    }

    protected abstract void getAacDataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getAacData(ByteBuffer aacBuffer, MediaCodec.BufferInfo info) {
        if (this.recording && this.canRecord) {
            this.mediaMuxer.writeSampleData(this.audioTrack, aacBuffer, info);
        }
        if (this.streaming) {
            this.getAacDataRtp(aacBuffer, info);
        }
    }

    protected abstract void onSpsPpsVpsRtp(ByteBuffer var1, ByteBuffer var2, ByteBuffer var3);

    public void onSpsPps(ByteBuffer sps, ByteBuffer pps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, null);
        }
    }

    public void onSpsPpsVps(ByteBuffer sps, ByteBuffer pps, ByteBuffer vps) {
        if (this.streaming) {
            this.onSpsPpsVpsRtp(sps, pps, vps);
        }
    }

    protected abstract void getH264DataRtp(ByteBuffer var1, MediaCodec.BufferInfo var2);

    public void getVideoData(ByteBuffer h264Buffer, MediaCodec.BufferInfo info) {
        if (this.recording) {
            if (info.flags == 1 && !this.canRecord && this.videoFormat != null && this.audioFormat != null) {
                this.videoTrack = this.mediaMuxer.addTrack(this.videoFormat);
                this.audioTrack = this.mediaMuxer.addTrack(this.audioFormat);
                this.mediaMuxer.start();
                this.canRecord = true;
            }
            if (this.canRecord) {
                this.mediaMuxer.writeSampleData(this.videoTrack, h264Buffer, info);
            }
        }
        if (this.streaming) {
            this.getH264DataRtp(h264Buffer, info);
        }
    }

    public void inputPCMData(byte[] buffer, int size) {
        this.audioEncoder.inputPCMData(buffer, size);
    }

    public void onVideoFormat(MediaFormat mediaFormat) {
        this.videoFormat = mediaFormat;
    }

    public void onAudioFormat(MediaFormat mediaFormat) {
        this.audioFormat = mediaFormat;
    }
}

